/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.controllers;

import io.netty.buffer.ByteBufInputStream;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import noppes.npcs.CustomNpcs;
import noppes.npcs.controllers.RecipeCarpentry;
import noppes.npcs.controllers.RecipesDefault;

public class RecipeController {
    private static Collection<RecipeCarpentry> prevRecipes;
    public HashMap<Integer, RecipeCarpentry> globalRecipes = new HashMap();
    public HashMap<Integer, RecipeCarpentry> anvilRecipes = new HashMap();
    public static RecipeController instance;

    public RecipeController() {
        instance = this;
        this.loadCategories();
        RecipeController.reloadGlobalRecipes(this.globalRecipes);
    }

    public static void reloadGlobalRecipes(HashMap<Integer, RecipeCarpentry> globalRecipes) {
        List list = CraftingManager.func_77594_a().func_77592_b();
        if (prevRecipes != null) {
            list.removeAll(prevRecipes);
        }
        prevRecipes = new HashSet<RecipeCarpentry>(globalRecipes.values());
        list.addAll(prevRecipes);
    }

    private void loadCategories() {
        File saveDir = CustomNpcs.getWorldSaveDirectory();
        try {
            File file = new File(saveDir, "recipes.dat");
            if (file.exists()) {
                this.loadCategories(file);
            } else {
                this.loadDefaultRecipes();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                File file = new File(saveDir, "recipes.dat_old");
                if (file.exists()) {
                    this.loadCategories(file);
                }
            }
            catch (Exception ee) {
                e.printStackTrace();
            }
        }
    }

    private void loadDefaultRecipes() {
        new RecipesDefault(this);
        this.saveCategories();
    }

    private void loadCategories(File file) throws Exception {
        NBTTagCompound nbttagcompound1 = CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(file));
        NBTTagList list = nbttagcompound1.func_150295_c("Data", 10);
        HashMap<Integer, RecipeCarpentry> globalRecipes = new HashMap<Integer, RecipeCarpentry>();
        HashMap<Integer, RecipeCarpentry> anvilRecipes = new HashMap<Integer, RecipeCarpentry>();
        if (list != null) {
            for (int i = 0; i < list.func_74745_c(); ++i) {
                RecipeCarpentry recipe = new RecipeCarpentry();
                recipe.readNBT(list.func_150305_b(i));
                if (recipe.isGlobal) {
                    globalRecipes.put(recipe.id, recipe);
                    continue;
                }
                anvilRecipes.put(recipe.id, recipe);
            }
        }
        this.anvilRecipes = anvilRecipes;
        this.globalRecipes = globalRecipes;
    }

    private void saveCategories() {
        try {
            File saveDir = CustomNpcs.getWorldSaveDirectory();
            NBTTagList list = new NBTTagList();
            for (RecipeCarpentry recipe : this.globalRecipes.values()) {
                list.func_74742_a((NBTBase)recipe.writeNBT());
            }
            for (RecipeCarpentry recipe : this.anvilRecipes.values()) {
                list.func_74742_a((NBTBase)recipe.writeNBT());
            }
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74782_a("Data", (NBTBase)list);
            File file = new File(saveDir, "recipes.dat_new");
            File file1 = new File(saveDir, "recipes.dat_old");
            File file2 = new File(saveDir, "recipes.dat");
            CompressedStreamTools.func_74799_a((NBTTagCompound)nbttagcompound, (OutputStream)new FileOutputStream(file));
            if (file1.exists()) {
                file1.delete();
            }
            file2.renameTo(file1);
            if (file2.exists()) {
                file2.delete();
            }
            file.renameTo(file2);
            if (file.exists()) {
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RecipeCarpentry findMatchingRecipe(InventoryCrafting par1InventoryCrafting) {
        for (RecipeCarpentry recipe : this.anvilRecipes.values()) {
            if (!recipe.func_77569_a(par1InventoryCrafting, null)) continue;
            return recipe;
        }
        return null;
    }

    public RecipeCarpentry getRecipe(int id) {
        if (this.globalRecipes.containsKey(id)) {
            return this.globalRecipes.get(id);
        }
        if (this.anvilRecipes.containsKey(id)) {
            return this.anvilRecipes.get(id);
        }
        return null;
    }

    public RecipeCarpentry saveRecipe(ByteBufInputStream dis) throws IOException {
        RecipeCarpentry recipe = new RecipeCarpentry();
        recipe.readNBT(CompressedStreamTools.func_74794_a((DataInput)dis));
        RecipeCarpentry current = this.getRecipe(recipe.id);
        if (current != null && !current.name.equals(recipe.name)) {
            while (this.containsRecipeName(recipe.name)) {
                recipe.name = recipe.name + "_";
            }
        }
        if (recipe.id == -1) {
            recipe.id = this.getUniqueId();
            while (this.containsRecipeName(recipe.name)) {
                recipe.name = recipe.name + "_";
            }
        }
        if (recipe.isGlobal) {
            this.anvilRecipes.remove(recipe.id);
            this.globalRecipes.put(recipe.id, recipe);
        } else {
            this.globalRecipes.remove(recipe.id);
            this.anvilRecipes.put(recipe.id, recipe);
        }
        this.saveCategories();
        RecipeController.reloadGlobalRecipes(this.globalRecipes);
        return recipe;
    }

    private int getUniqueId() {
        int id = 0;
        for (int key : this.globalRecipes.keySet()) {
            if (key <= id) continue;
            id = key;
        }
        for (int key : this.anvilRecipes.keySet()) {
            if (key <= id) continue;
            id = key;
        }
        return ++id;
    }

    private boolean containsRecipeName(String name) {
        name = name.toLowerCase();
        for (RecipeCarpentry recipe : this.globalRecipes.values()) {
            if (!recipe.name.toLowerCase().equals(name)) continue;
            return true;
        }
        for (RecipeCarpentry recipe : this.anvilRecipes.values()) {
            if (!recipe.name.toLowerCase().equals(name)) continue;
            return true;
        }
        return false;
    }

    public RecipeCarpentry removeRecipe(int id) {
        RecipeCarpentry recipe = this.getRecipe(id);
        this.globalRecipes.remove(recipe.id);
        this.anvilRecipes.remove(recipe.id);
        this.saveCategories();
        RecipeController.reloadGlobalRecipes(this.globalRecipes);
        return recipe;
    }
}

