/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.items;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import noppes.npcs.CustomItems;
import noppes.npcs.entity.EntityProjectile;
import noppes.npcs.items.EnumNpcToolMaterial;
import noppes.npcs.items.ItemBullet;
import noppes.npcs.items.ItemNpcInterface;
import org.lwjgl.opengl.GL11;

public class ItemGun
extends ItemNpcInterface {
    private EnumNpcToolMaterial material;

    public ItemGun(int par1, EnumNpcToolMaterial material) {
        super(par1);
        this.field_77777_bU = 1;
        this.material = material;
        this.func_77656_e(material.getMaxUses());
        this.func_77637_a(CustomItems.tabWeapon);
    }

    public void func_77615_a(ItemStack par1ItemStack, World worldObj, EntityPlayer player, int par4) {
        if (worldObj.field_72995_K) {
            return;
        }
        if (!this.hasBullet(player)) {
            worldObj.func_72956_a((Entity)player, "customnpcs:gun.empty", 1.0f, 1.0f);
            return;
        }
        int ticks = this.func_77626_a(par1ItemStack) - par4;
        if (ticks < 10) {
            return;
        }
        par1ItemStack.func_77972_a(1, (EntityLivingBase)player);
        ItemBullet bullet = (ItemBullet)this.getBullet(player);
        int damage = (bullet.getBulletDamage() + this.material.getDamageVsEntity() + 1) / 2 + 5;
        EntityProjectile projectile = new EntityProjectile(worldObj, (EntityLivingBase)player, new ItemStack(this.getBullet(player)), false);
        projectile.damage = damage;
        projectile.setSpeed(40);
        projectile.shoot(this.material.getDamageVsEntity() + 1);
        if (!player.field_71075_bZ.field_75098_d) {
            this.consumeItem(player, this.getBullet(player));
        }
        worldObj.func_72956_a((Entity)player, "customnpcs:gun.pistol.shot", 1.0f, field_77697_d.nextFloat() * 0.3f + 0.8f);
        worldObj.func_72838_d((Entity)projectile);
    }

    public void onUsingTick(ItemStack stack, EntityPlayer player, int count) {
        int ticks = this.func_77626_a(stack) - count;
        if (ticks == 8 && !player.field_70170_p.field_72995_K) {
            player.field_70170_p.func_72956_a((Entity)player, "customnpcs:gun.pistol.trigger", 1.0f, 1.0f / (player.field_70170_p.field_73012_v.nextFloat() * 0.4f + 0.8f));
        }
    }

    @Override
    public void renderSpecial() {
        GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
        GL11.glTranslatef((float)0.0f, (float)0.3f, (float)0.0f);
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    private boolean hasBullet(EntityPlayer par3EntityPlayer) {
        Item bullet = this.getBullet(par3EntityPlayer);
        return bullet != null;
    }

    private Item getBullet(EntityPlayer player) {
        switch (this.material) {
            case EMERALD: {
                if (this.hasItem(player, CustomItems.bulletEmerald)) {
                    return CustomItems.bulletEmerald;
                }
            }
            case DIA: {
                if (this.hasItem(player, CustomItems.bulletDiamond)) {
                    return CustomItems.bulletDiamond;
                }
            }
            case IRON: {
                if (this.hasItem(player, CustomItems.bulletIron)) {
                    return CustomItems.bulletIron;
                }
            }
            case BRONZE: {
                if (this.hasItem(player, CustomItems.bulletBronze)) {
                    return CustomItems.bulletBronze;
                }
            }
            case GOLD: {
                if (this.hasItem(player, CustomItems.bulletGold)) {
                    return CustomItems.bulletGold;
                }
            }
            case STONE: {
                if (this.hasItem(player, CustomItems.bulletStone)) {
                    return CustomItems.bulletStone;
                }
            }
            case WOOD: {
                if (!this.hasItem(player, CustomItems.bulletWood)) break;
                return CustomItems.bulletWood;
            }
        }
        if (this.hasItem(player, CustomItems.bulletBlack) || player.field_71075_bZ.field_75098_d) {
            return CustomItems.bulletBlack;
        }
        return null;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }
}

