/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.HashMap;
import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.quests.QuestInterface;

public class QuestItem
extends QuestInterface {
    public NpcMiscInventory items = new NpcMiscInventory(3);

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        this.items.setFromNBT(compound.func_74775_l("Items"));
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.func_74782_a("Items", (NBTBase)this.items.getToNBT());
    }

    @Override
    public boolean isCompleted(EntityPlayer player) {
        HashMap<Integer, ItemStack> map = this.getProcessSet(player);
        for (ItemStack reqItem : this.items.items.values()) {
            boolean done = false;
            for (ItemStack item : map.values()) {
                if (!NoppesUtilPlayer.compareItems(reqItem, item, false) || item.field_77994_a < reqItem.field_77994_a) continue;
                done = true;
                break;
            }
            if (done) continue;
            return false;
        }
        return true;
    }

    public HashMap<Integer, ItemStack> getProcessSet(EntityPlayer player) {
        HashMap<Integer, ItemStack> map = new HashMap<Integer, ItemStack>();
        for (int slot : this.items.items.keySet()) {
            ItemStack item = this.items.items.get(slot);
            if (item == null) continue;
            ItemStack is = item.func_77946_l();
            is.field_77994_a = 0;
            map.put(slot, is);
        }
        for (ItemStack item : player.field_71071_by.field_70462_a) {
            if (item == null) continue;
            for (ItemStack questItem : map.values()) {
                if (!NoppesUtilPlayer.compareItems(questItem, item, false)) continue;
                questItem.field_77994_a += item.field_77994_a;
            }
        }
        return map;
    }

    @Override
    public void handleComplete(EntityPlayer player) {
        block0: for (ItemStack questitem : this.items.items.values()) {
            int stacksize = questitem.field_77994_a;
            for (int i = 0; i < player.field_71071_by.field_70462_a.length; ++i) {
                ItemStack item = player.field_71071_by.field_70462_a[i];
                if (item == null || !NoppesUtilPlayer.compareItems(item, questitem, false)) continue;
                int size = item.field_77994_a;
                if (stacksize - size >= 0) {
                    player.field_71071_by.func_70299_a(i, null);
                    item.func_77979_a(size);
                } else {
                    item.func_77979_a(stacksize);
                }
                if ((stacksize -= size) <= 0) continue block0;
            }
        }
    }

    @Override
    public Vector<String> getQuestLogStatus(EntityPlayer player) {
        Vector<String> vec = new Vector<String>();
        HashMap<Integer, ItemStack> map = this.getProcessSet(player);
        for (int slot : map.keySet()) {
            ItemStack item = map.get(slot);
            ItemStack quest = this.items.items.get(slot);
            if (item == null) continue;
            String process = item.field_77994_a + "";
            if (item.field_77994_a > quest.field_77994_a) {
                process = quest.field_77994_a + "";
            }
            process = process + "/" + quest.field_77994_a + "";
            vec.add(item.func_82833_r() + ": " + process);
        }
        return vec;
    }
}

