/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.quests;

import java.util.Vector;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerQuestData;
import noppes.npcs.controllers.QuestData;
import noppes.npcs.quests.QuestInterface;

public class QuestLocation
extends QuestInterface {
    public String location = "";
    public String location2 = "";
    public String location3 = "";

    @Override
    public void readEntityFromNBT(NBTTagCompound compound) {
        this.location = compound.func_74779_i("QuestLocation");
        this.location2 = compound.func_74779_i("QuestLocation2");
        this.location3 = compound.func_74779_i("QuestLocation3");
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound compound) {
        compound.func_74778_a("QuestLocation", this.location);
        compound.func_74778_a("QuestLocation2", this.location2);
        compound.func_74778_a("QuestLocation3", this.location3);
    }

    @Override
    public boolean isCompleted(EntityPlayer player) {
        PlayerQuestData playerdata = PlayerDataController.instance.getQuestData(player);
        QuestData data = playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return false;
        }
        return this.getFound(data, 0);
    }

    @Override
    public void handleComplete(EntityPlayer player) {
    }

    @Override
    public Vector<String> getQuestLogStatus(EntityPlayer player) {
        Vector<String> vec = new Vector<String>();
        PlayerQuestData playerdata = PlayerDataController.instance.getQuestData(player);
        QuestData data = playerdata.activeQuests.get(this.questId);
        if (data == null) {
            return vec;
        }
        String found = StatCollector.func_74838_a((String)"quest.found");
        String notfound = StatCollector.func_74838_a((String)"quest.notfound");
        if (!this.location.isEmpty()) {
            vec.add(this.location + ": " + (this.getFound(data, 1) ? found : notfound));
        }
        if (!this.location2.isEmpty()) {
            vec.add(this.location2 + ": " + (this.getFound(data, 2) ? found : notfound));
        }
        if (!this.location3.isEmpty()) {
            vec.add(this.location3 + ": " + (this.getFound(data, 3) ? found : notfound));
        }
        return vec;
    }

    public boolean getFound(QuestData data, int i) {
        if (i == 1) {
            return data.extraData.func_74767_n("LocationFound");
        }
        if (i == 2) {
            return data.extraData.func_74767_n("Location2Found");
        }
        if (i == 3) {
            return data.extraData.func_74767_n("Location3Found");
        }
        if (!this.location.isEmpty() && !data.extraData.func_74767_n("LocationFound")) {
            return false;
        }
        if (!this.location2.isEmpty() && !data.extraData.func_74767_n("Location2Found")) {
            return false;
        }
        return this.location3.isEmpty() || data.extraData.func_74767_n("Location3Found");
    }

    public void setFound(QuestData data, String location) {
        if (location.equalsIgnoreCase(this.location)) {
            data.extraData.func_74757_a("LocationFound", true);
        }
        if (location.equalsIgnoreCase(this.location2)) {
            data.extraData.func_74757_a("Location2Found", true);
        }
        if (location.equalsIgnoreCase(this.location3)) {
            data.extraData.func_74757_a("Location3Found", true);
        }
    }
}

