/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.CustomItems;
import noppes.npcs.CustomNpcs;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.client.controllers.MusicController;
import noppes.npcs.constants.EnumBardInstrument;
import noppes.npcs.roles.JobInterface;

public class JobBard
extends JobInterface {
    public int minRange = 2;
    public int maxRange = 64;
    public boolean isStreamer = true;
    public boolean hasOffRange = true;
    public String song = "";
    public String song2 = "";
    public String song3 = "";
    public String song4 = "";
    private EnumBardInstrument instrument = EnumBardInstrument.Banjo;
    private long ticks = 0L;

    public JobBard(EntityNPCInterface npc) {
        super(npc);
        if (CustomItems.banjo != null) {
            this.mainhand = new ItemStack(CustomItems.banjo);
            this.overrideOffHand = true;
            this.overrideMainHand = true;
        }
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("BardSong", this.song);
        nbttagcompound.func_74768_a("BardMinRange", this.minRange);
        nbttagcompound.func_74768_a("BardMaxRange", this.maxRange);
        nbttagcompound.func_74768_a("BardInstrument", this.instrument.ordinal());
        nbttagcompound.func_74757_a("BardStreamer", this.isStreamer);
        nbttagcompound.func_74757_a("BardHasOff", this.hasOffRange);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.song = nbttagcompound.func_74779_i("BardSong");
        this.minRange = nbttagcompound.func_74762_e("BardMinRange");
        this.maxRange = nbttagcompound.func_74762_e("BardMaxRange");
        this.setInstrument(nbttagcompound.func_74762_e("BardInstrument"));
        this.isStreamer = nbttagcompound.func_74767_n("BardStreamer");
        this.hasOffRange = nbttagcompound.func_74767_n("BardHasOff");
    }

    public void setInstrument(int i) {
        if (CustomItems.banjo == null) {
            return;
        }
        this.instrument = EnumBardInstrument.values()[i];
        this.overrideOffHand = this.instrument != EnumBardInstrument.None;
        this.overrideMainHand = this.overrideOffHand;
        switch (this.instrument) {
            case None: {
                this.mainhand = null;
                this.offhand = null;
                break;
            }
            case Banjo: {
                this.mainhand = new ItemStack(CustomItems.banjo);
                this.offhand = null;
                break;
            }
            case Violin: {
                this.mainhand = new ItemStack(CustomItems.violin);
                this.offhand = new ItemStack(CustomItems.violinbow);
                break;
            }
            case Guitar: {
                this.mainhand = new ItemStack(CustomItems.guitar);
                this.offhand = null;
                break;
            }
            case Harp: {
                this.mainhand = new ItemStack(CustomItems.harp);
                this.offhand = null;
            }
        }
    }

    public EnumBardInstrument getInstrument() {
        return this.instrument;
    }

    public void onLivingUpdate() {
        List list;
        if (!this.npc.field_70170_p.field_72995_K) {
            return;
        }
        ++this.ticks;
        if (this.ticks % 10L != 0L) {
            return;
        }
        if (this.song.isEmpty()) {
            return;
        }
        if (!MusicController.Instance.isPlaying(this.song)) {
            List list2 = this.npc.field_70170_p.func_72872_a(EntityPlayer.class, this.npc.field_70121_D.func_72314_b((double)this.minRange, (double)(this.minRange / 2), (double)this.minRange));
            if (!list2.contains(CustomNpcs.proxy.getPlayer())) {
                return;
            }
            if (this.isStreamer) {
                MusicController.Instance.playStreaming(this.song, (Entity)this.npc);
            } else {
                MusicController.Instance.playMusic(this.song, (Entity)this.npc);
            }
        } else if (MusicController.Instance.playingEntity != this.npc) {
            EntityPlayer player = CustomNpcs.proxy.getPlayer();
            if (this.npc.func_70068_e((Entity)player) < MusicController.Instance.playingEntity.func_70068_e((Entity)player)) {
                MusicController.Instance.playingEntity = this.npc;
            }
        } else if (this.hasOffRange && !(list = this.npc.field_70170_p.func_72872_a(EntityPlayer.class, this.npc.field_70121_D.func_72314_b((double)this.maxRange, (double)(this.maxRange / 2), (double)this.maxRange))).contains(CustomNpcs.proxy.getPlayer())) {
            MusicController.Instance.stopMusic();
        }
    }

    @Override
    public void killed() {
        this.delete();
    }

    @Override
    public void delete() {
        if (this.npc.field_70170_p.field_72995_K && MusicController.Instance.isPlaying(this.song)) {
            MusicController.Instance.stopMusic();
        }
    }
}

