/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.HashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.roles.RoleInterface;

public class RoleFollower
extends RoleInterface {
    private String owner;
    public boolean isFollowing = true;
    public HashMap<Integer, Integer> rates;
    public NpcMiscInventory inventory;
    public String dialogHire = StatCollector.func_74838_a((String)"follower.hireText") + " {days} " + StatCollector.func_74838_a((String)"follower.days");
    public String dialogFarewell = StatCollector.func_74838_a((String)"follower.farewellText") + " {player}";
    public int daysHired;
    public long hiredTime;
    public int updateTick = 0;

    public RoleFollower(EntityNPCInterface npc) {
        super(npc);
        this.inventory = new NpcMiscInventory(3);
        this.rates = new HashMap();
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("MercenaryDaysHired", this.daysHired);
        nbttagcompound.func_74772_a("MercenaryHiredTime", this.hiredTime);
        nbttagcompound.func_74778_a("MercenaryDialogHired", this.dialogHire);
        nbttagcompound.func_74778_a("MercenaryDialogFarewell", this.dialogFarewell);
        if (this.owner != null && !this.owner.isEmpty()) {
            nbttagcompound.func_74778_a("MercenaryOwner", this.owner);
        }
        nbttagcompound.func_74782_a("MercenaryDayRates", (NBTBase)NBTTags.nbtIntegerIntegerMap(this.rates));
        nbttagcompound.func_74782_a("MercenaryInv", (NBTBase)this.inventory.getToNBT());
        nbttagcompound.func_74757_a("MercenaryIsFollowing", this.isFollowing);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.owner = nbttagcompound.func_74779_i("MercenaryOwner");
        this.daysHired = nbttagcompound.func_74762_e("MercenaryDaysHired");
        this.hiredTime = nbttagcompound.func_74763_f("MercenaryHiredTime");
        this.dialogHire = nbttagcompound.func_74779_i("MercenaryDialogHired");
        this.dialogFarewell = nbttagcompound.func_74779_i("MercenaryDialogFarewell");
        this.rates = NBTTags.getIntegerIntegerMap(nbttagcompound.func_150295_c("MercenaryDayRates", 10));
        this.inventory.setFromNBT(nbttagcompound.func_74775_l("MercenaryInv"));
        this.isFollowing = nbttagcompound.func_74767_n("MercenaryIsFollowing");
    }

    @Override
    public boolean aiShouldExecute() {
        if (!this.hasOwner() || !this.isFollowing) {
            return false;
        }
        if (this.getDaysLeft() <= 0) {
            EntityPlayer player = this.getOwner();
            if (player != null) {
                player.func_145747_a((IChatComponent)new ChatComponentTranslation(this.dialogFarewell.replaceAll("\\{player\\}", player.func_70005_c_()), new Object[0]));
            }
            this.killed();
            return false;
        }
        return !(this.npc.func_70032_d((Entity)this.getOwner()) < 10.0f);
    }

    @Override
    public void aiUpdateTask() {
        ++this.updateTick;
        if (this.updateTick < 10) {
            return;
        }
        EntityPlayer theOwner = this.getOwner();
        this.npc.func_70671_ap().func_75651_a((Entity)theOwner, 10.0f, (float)this.npc.func_70646_bf());
        if (!this.npc.func_70661_as().func_75497_a((Entity)theOwner, 1.0) && this.npc.func_70068_e((Entity)theOwner) >= 144.0) {
            int var1 = MathHelper.func_76128_c((double)theOwner.field_70165_t) - 2;
            int var2 = MathHelper.func_76128_c((double)theOwner.field_70161_v) - 2;
            int var3 = MathHelper.func_76128_c((double)theOwner.field_70121_D.field_72338_b);
            for (int var4 = 0; var4 <= 4; ++var4) {
                for (int var5 = 0; var5 <= 4; ++var5) {
                    if (var4 >= 1 && var5 >= 1 && var4 <= 3 && var5 <= 3 || !World.func_147466_a((IBlockAccess)this.npc.field_70170_p, (int)(var1 + var4), (int)(var3 - 1), (int)(var2 + var5)) || this.npc.field_70170_p.func_147439_a(var1 + var4, var3, var2 + var5).func_149637_q() || this.npc.field_70170_p.func_147439_a(var1 + var4, var3 + 1, var2 + var5).func_149637_q()) continue;
                    this.npc.func_70012_b((float)(var1 + var4) + 0.5f, var3, (float)(var2 + var5) + 0.5f, this.npc.field_70177_z, this.npc.field_70125_A);
                    this.npc.func_70661_as().func_75499_g();
                    return;
                }
            }
        }
        this.updateTick = 0;
    }

    @Override
    public void aiStartExecuting() {
        this.updateTick = 10;
    }

    @Override
    public boolean aiContinueExecute() {
        EntityPlayer owner = this.getOwner();
        return owner != null && !this.npc.func_70661_as().func_75500_f() && this.npc.func_70032_d((Entity)owner) > 2.0f && this.isFollowing;
    }

    public boolean isFollowing() {
        if (!this.isFollowing) {
            return false;
        }
        return this.getOwner() != null;
    }

    public EntityPlayer getOwner() {
        if (this.owner == null || this.owner.isEmpty()) {
            return null;
        }
        return this.npc.field_70170_p.func_72924_a(this.owner);
    }

    public boolean hasOwner() {
        if (this.daysHired <= 0) {
            return false;
        }
        return this.getOwner() != null;
    }

    @Override
    public void killed() {
        this.owner = null;
        this.daysHired = 0;
        this.hiredTime = 0L;
    }

    public int getDaysLeft() {
        if (this.daysHired <= 0) {
            return 0;
        }
        int days = (int)((this.npc.field_70170_p.func_72820_D() - this.hiredTime) / 24000L);
        return this.daysHired - days;
    }

    public void addDays(int days) {
        this.daysHired += days + this.getDaysLeft();
        this.hiredTime = this.npc.field_70170_p.func_72820_D();
    }

    @Override
    public boolean interact(EntityPlayer player) {
        if (this.owner == null || this.owner.isEmpty()) {
            this.npc.say(player, this.npc.advanced.getInteractLine());
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerFollowerHire, this.npc);
        } else if (player == this.getOwner()) {
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerFollower, this.npc);
        }
        return false;
    }

    @Override
    public void delete() {
    }

    public void setOwner(String username) {
        if (this.owner == null || !this.owner.equals(username)) {
            this.killed();
        }
        this.owner = username;
    }
}

