/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.NpcMiscInventory;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.roles.RoleInterface;

public class RoleTrader
extends RoleInterface {
    public NpcMiscInventory inventoryCurrency = new NpcMiscInventory(18);
    public NpcMiscInventory inventorySold = new NpcMiscInventory(18);

    public RoleTrader(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74782_a("TraderCurrency", (NBTBase)this.inventoryCurrency.getToNBT());
        nbttagcompound.func_74782_a("TraderSold", (NBTBase)this.inventorySold.getToNBT());
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.inventoryCurrency.setFromNBT(nbttagcompound.func_74775_l("TraderCurrency"));
        this.inventorySold.setFromNBT(nbttagcompound.func_74775_l("TraderSold"));
    }

    @Override
    public boolean interact(EntityPlayer player) {
        this.npc.say(player, this.npc.advanced.getInteractLine());
        NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerTrader, this.npc);
        return false;
    }

    public boolean hasCurrency(ItemStack itemstack) {
        if (itemstack == null) {
            return false;
        }
        for (ItemStack item : this.inventoryCurrency.items.values()) {
            if (item == null || !NoppesUtilPlayer.compareItems(item, itemstack, false)) continue;
            return true;
        }
        return false;
    }
}

