/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.roles;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import noppes.npcs.EntityNPCInterface;
import noppes.npcs.NoppesUtilServer;
import noppes.npcs.Server;
import noppes.npcs.constants.EnumGuiType;
import noppes.npcs.constants.EnumPackets;
import noppes.npcs.controllers.PlayerDataController;
import noppes.npcs.controllers.PlayerTransportData;
import noppes.npcs.controllers.TransportController;
import noppes.npcs.controllers.TransportLocation;
import noppes.npcs.roles.RoleInterface;

public class RoleTransporter
extends RoleInterface {
    public int transportId = -1;
    public String name;
    private int ticks = 10;

    public RoleTransporter(EntityNPCInterface npc) {
        super(npc);
    }

    @Override
    public void writeEntityToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74768_a("TransporterId", this.transportId);
    }

    @Override
    public void readEntityFromNBT(NBTTagCompound nbttagcompound) {
        this.transportId = nbttagcompound.func_74762_e("TransporterId");
        TransportLocation loc = this.getLocation();
        if (loc != null) {
            this.name = loc.name;
        }
        if (loc == null) {
            this.transportId = -1;
            this.name = "";
        }
    }

    @Override
    public boolean aiShouldExecute() {
        --this.ticks;
        if (this.ticks > 0) {
            return false;
        }
        this.ticks = 10;
        if (!this.hasTransport()) {
            return false;
        }
        TransportLocation loc = this.getLocation();
        if (loc.type != 0) {
            return false;
        }
        List inRange = this.npc.field_70170_p.func_72872_a(EntityPlayer.class, this.npc.field_70121_D.func_72314_b(6.0, 6.0, 6.0));
        for (EntityPlayer player : inRange) {
            if (!this.npc.func_70685_l((Entity)player)) continue;
            PlayerTransportData data = PlayerDataController.instance.getTransportData(player);
            if (data.transports.contains(this.transportId)) continue;
            PlayerDataController.instance.addTransport(this.transportId, player);
            Server.sendData((EntityPlayerMP)player, EnumPackets.Chat, "transporter.unlock1", " " + loc.name + " ", "transporter.unlock2");
        }
        return false;
    }

    @Override
    public void aiStartExecuting() {
    }

    @Override
    public boolean interact(EntityPlayer player) {
        if (this.hasTransport()) {
            TransportLocation loc = this.getLocation();
            if (loc.type == 2) {
                PlayerTransportData data = PlayerDataController.instance.getTransportData(player);
                if (!data.transports.contains(this.transportId)) {
                    PlayerDataController.instance.addTransport(this.transportId, player);
                    Server.sendData((EntityPlayerMP)player, EnumPackets.Chat, "transporter.unlock1", " " + loc.name + " ", "transporter.unlock2");
                }
            }
            NoppesUtilServer.sendOpenGui(player, EnumGuiType.PlayerTransporter, this.npc);
        }
        return false;
    }

    public TransportLocation getLocation() {
        if (this.npc.field_70170_p.field_72995_K) {
            return null;
        }
        return TransportController.getInstance().getTransport(this.transportId);
    }

    public boolean hasTransport() {
        TransportLocation loc = this.getLocation();
        return loc != null && loc.isNpc(this.npc);
    }

    public void setTransport(TransportLocation location) {
        this.transportId = location.id;
        this.name = location.name;
    }
}

