/*
 * Decompiled with CFR 0.152.
 */
package com.github.dayzminecraft.dayzminecraft.common.thirst;

import com.github.dayzminecraft.dayzminecraft.common.misc.ChatHandler;
import com.github.dayzminecraft.dayzminecraft.common.misc.Config;
import com.github.dayzminecraft.dayzminecraft.common.misc.DamageType;
import cpw.mods.fml.common.FMLCommonHandler;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.IExtendedEntityProperties;

public class PlayerData
implements IExtendedEntityProperties {
    public static final String EXT_PROP_NAME = "DayZPlayerData";
    private final EntityPlayer player;
    private int thirst;

    public PlayerData(EntityPlayer player) {
        this.player = player;
        this.thirst = 0;
    }

    public static void register(EntityPlayer player) {
        player.registerExtendedProperties(EXT_PROP_NAME, (IExtendedEntityProperties)new PlayerData(player));
    }

    public static PlayerData get(EntityPlayer player) {
        return (PlayerData)player.getExtendedProperties(EXT_PROP_NAME);
    }

    public void saveNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = new NBTTagCompound();
        properties.func_74768_a("thirstLevel", this.thirst);
        compound.func_74782_a(EXT_PROP_NAME, (NBTBase)properties);
    }

    public void loadNBTData(NBTTagCompound compound) {
        NBTTagCompound properties = (NBTTagCompound)compound.func_74781_a(EXT_PROP_NAME);
        this.thirst = properties.func_74762_e("thirstLevel");
    }

    public void init(Entity entity, World world) {
    }

    public void drink(int amount) {
        this.thirst -= amount;
        if (this.thirst < 0) {
            this.thirst = 0;
        }
    }

    public void handleThirst() {
        if (!Config.thirstEnabled) {
            return;
        }
        if (this.player == null || this.player.field_70128_L || this.player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (this.thirst == 20000) {
            ChatHandler.chatWarning(this.player, StatCollector.func_74838_a((String)"thirst.thirdwarning"));
            ++this.thirst;
        } else if (this.thirst == 18000) {
            ChatHandler.chatWarning(this.player, StatCollector.func_74838_a((String)"thirst.secondwarning"));
            ++this.thirst;
        } else if (this.thirst == 16000) {
            ChatHandler.chatWarning(this.player, StatCollector.func_74838_a((String)"thirst.firstwarning"));
            ++this.thirst;
        } else if (this.thirst >= 24000 && FMLCommonHandler.instance().getMinecraftServerInstance().func_71259_af() % 40 == 0) {
            this.player.func_70097_a(DamageType.thirstDeath, 1.0f);
        } else {
            this.thirst = this.player.func_70051_ag() || this.player.field_70160_al ? (this.thirst += 2) : ++this.thirst;
        }
        ChatHandler.logDebug(this.player.getDisplayName() + " - " + String.valueOf(this.thirst));
    }

    public int getThirst() {
        return this.thirst;
    }
}

