/*
 * Decompiled with CFR 0.152.
 */
package com.github.dayzminecraft.dayzminecraft.common.world;

import com.github.dayzminecraft.dayzminecraft.common.world.biomes.Biomes;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderGenerate;
import net.minecraft.world.gen.layer.GenLayer;

public class WorldTypes
extends WorldType {
    public static WorldType DAYZ;
    public static WorldType SNOW;

    public WorldTypes(String name) {
        super(name);
    }

    public static void loadWorldTypes() {
        DAYZ = new WorldTypes("DAYZBASE");
        SNOW = new WorldTypes("DAYZSNOW");
    }

    public WorldChunkManager getChunkManager(World world) {
        return new WorldChunkManager(world);
    }

    public IChunkProvider getChunkGenerator(World world, String generatorOptions) {
        return new ChunkProviderGenerate(world, world.func_72905_C(), world.func_72912_H().func_76089_r());
    }

    public BiomeGenBase[] setMajorBiomes() {
        if (this == DAYZ) {
            return new BiomeGenBase[]{Biomes.biomeForest};
        }
        if (this == SNOW) {
            return new BiomeGenBase[]{Biomes.biomeSnowPlains};
        }
        return null;
    }

    public BiomeGenBase setMinorBiomes(BiomeGenBase biome, GenLayer genLayer) {
        if (this == DAYZ) {
            return Biomes.biomePlains;
        }
        if (this == SNOW) {
            return Biomes.biomeSnowMountains;
        }
        return null;
    }

    public BiomeGenBase setOceanBiomes(BiomeGenBase biome, GenLayer genLayer) {
        return null;
    }

    public BiomeGenBase setRiverBiomes(BiomeGenBase biome, GenLayer genLayer) {
        if (this == DAYZ) {
            return Biomes.biomeRiver;
        }
        if (this == SNOW) {
            return Biomes.biomeRiver;
        }
        return null;
    }

    public BiomeGenBase setBorderBiomes(BiomeGenBase biome1, BiomeGenBase biome2, GenLayer genLayer) {
        return null;
    }

    public BiomeGenBase setMiscellaneousBiomes(GenLayer genLayer) {
        return null;
    }

    public int getSpawnFuzz() {
        return 100;
    }
}

