/*
 * Decompiled with CFR 0.152.
 */
package shadersmodcore.transform;

import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import shadersmodcore.transform.Names;
import shadersmodcore.transform.SMCLog;

public class SMCCTItemRenderer
implements IClassTransformer {
    public byte[] transform(String par1, String par2, byte[] par3) {
        SMCLog.fine("transforming %s %s", par1, par2);
        ClassReader cr = new ClassReader(par3);
        ClassWriter cw = new ClassWriter(cr, 1);
        CVTransform cv = new CVTransform((ClassVisitor)cw);
        cr.accept((ClassVisitor)cv, 0);
        return cw.toByteArray();
    }

    private static class MVrenderItem
    extends MethodVisitor {
        int state = 0;

        public MVrenderItem(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitInsn(int opcode) {
            if (this.state == 1 && opcode == 3) {
                ++this.state;
                opcode = 4;
            }
            this.mv.visitInsn(opcode);
        }

        public void visitIntInsn(int opcode, int operand) {
            if (this.state == 0 && opcode == 17 && operand == 3042) {
                ++this.state;
            }
            this.mv.visitIntInsn(opcode, operand);
        }
    }

    private static class MVupdate
    extends MethodVisitor {
        public MVupdate(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
            if (opcode == 181 && Names.itemRenderer_itemToRender.equals(owner, name, desc)) {
                this.mv.visitInsn(89);
                this.mv.visitFieldInsn(179, "shadersmodcore/client/Shaders", "itemToRender", Names.itemStack_.desc);
            }
            this.mv.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    private static class CVTransform
    extends ClassVisitor {
        String classname;
        Names.Meth renderItemIrt;

        public CVTransform(ClassVisitor cv) {
            super(262144, cv);
            this.renderItemIrt = new Names.Meth(Names.itemRenderer_, "renderItem", "(" + Names.entityLivingBase_.desc + Names.itemStack_.desc + "ILnet/minecraftforge/client/IItemRenderer$ItemRenderType;)V");
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.classname = name;
            this.cv.visit(version, access, name, signature, superName, interfaces);
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (Names.itemRenderer_updateEquipped.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVupdate(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (Names.itemRenderer_renderItem.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVrenderItem(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            if (this.renderItemIrt.equalsNameDesc(name, desc)) {
                SMCLog.finer("  patch method %s.%s%s", this.classname, name, desc);
                return new MVrenderItem(this.cv.visitMethod(access, name, desc, signature, exceptions));
            }
            return this.cv.visitMethod(access, name, desc, signature, exceptions);
        }
    }
}

