#version 120
#extension GL_ARB_shader_texture_lod : enable 

/* DRAWBUFFERS:0124 */

#define POM
#define POM_MAP_RES 128.0
#define POM_DEPTH (1.0/16.0)

/* Here, intervalMult might need to be tweaked per texture pack.  
   The first two numbers determine how many samples are taken per fragment.  They should always be the equal to eachother.
   The third number divided by one of the first two numbers is inversely proportional to the range of the height-map. */
const vec3 intervalMult = vec3(1.0, 1.0, 1.0/POM_DEPTH)/POM_MAP_RES * 1.0; 
const float MAX_OCCLUSION_DISTANCE = 32.0;
const float MIX_OCCLUSION_DISTANCE = 28.0;
const int   MAX_OCCLUSION_POINTS   = 16;

uniform sampler2D texture;
uniform sampler2D lightmap;
uniform sampler2D normals;
uniform sampler2D specular;

varying vec4 color;
varying vec4 lmcoord;

varying vec4 vtexcoordam; // .st for add, .pq for mul
varying vec4 vtexcoord;

varying vec4 viewVector;
varying vec4 normal;
varying vec4 tangent;
varying vec4 binormal;

varying float distance;

const int FOGMODE_LINEAR = 9729;
const int FOGMODE_EXP = 2048;

uniform int fogMode;
uniform float wetness;

const float mincoord = 1.0/4096.0;
const float maxcoord = 1.0-mincoord;

vec2 dcdx = dFdx(vtexcoord.st*vtexcoordam.pq);
vec2 dcdy = dFdy(vtexcoord.st*vtexcoordam.pq);

vec4 readTexture(in vec2 coord)
{
	return texture2DGradARB(texture,fract(coord)*vtexcoordam.pq+vtexcoordam.st,dcdx,dcdy);
}

vec4 readNormal(in vec2 coord)
{
	return texture2DGradARB(normals,fract(coord)*vtexcoordam.pq+vtexcoordam.st,dcdx,dcdy);
}

void main() {
	//gl_FragData[1] = vec4(vec3(gl_FragCoord.z), 1.0);

	vec3 ambient = texture2D(lightmap, vec2(lmcoord.s,0.5/16.)).rgb + texture2D(lightmap, vec2(0.5/16., lmcoord.t)).rgb * 0.6;

	vec2 adjustedTexCoord;
#ifdef POM
	if (distance <= MAX_OCCLUSION_DISTANCE && viewVector.z < 0.0) 
	{
		vec3 interval = viewVector.xyz * intervalMult;
		vec3 coord = vec3(vtexcoord.st, 1.0);
		for (int loopCount = 0; 
				(loopCount < MAX_OCCLUSION_POINTS) && (readNormal(coord.st).a < coord.p);
				++loopCount) {
			coord = coord+interval;
		}
		// Don't wrap around
		coord.st = clamp(coord.st, mincoord, maxcoord);





		coord.st = mix(coord.st, vtexcoord.st, max(distance-MIX_OCCLUSION_DISTANCE,0.0)/(MAX_OCCLUSION_DISTANCE-MIX_OCCLUSION_DISTANCE));
		adjustedTexCoord = fract(coord.st)*vtexcoordam.pq+vtexcoordam.st;
	}
	else
	{
		adjustedTexCoord = vtexcoord.st*vtexcoordam.pq+vtexcoordam.st;
	}
#else
		adjustedTexCoord = vtexcoord.st*vtexcoordam.pq+vtexcoordam.st;
#endif

	vec4 diffuse = texture2DGradARB(texture, adjustedTexCoord.st, dcdx, dcdy) * color;
	
	vec4 texSpecular = texture2DGradARB(specular, adjustedTexCoord.st, dcdx, dcdy);
	vec3 bump = texture2DGradARB(normals, adjustedTexCoord.st, dcdx, dcdy).xyz * 2.0 - 1.0;

	gl_FragData[0] = diffuse;
	gl_FragData[3] = vec4(texSpecular.b*diffuse.rgb + vec3(texSpecular.r) + vec3(texSpecular.g)*wetness*max(lmcoord.t-(14.5/16.0),0.0), texSpecular.a);

	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
                          tangent.y, binormal.y, normal.y,
                          tangent.z, binormal.z, normal.z);

	gl_FragData[2] = vec4(bump * tbnMatrix * 0.5 + 0.5, 1.0);


	float fogFactor; // 0.0 = full fog.  1.0 = no fog.
	if (fogMode == FOGMODE_EXP) {
		fogFactor = clamp(exp(-gl_Fog.density * gl_FogFragCoord), 0.0, 1.0);
	} else if (fogMode == FOGMODE_LINEAR) {
		fogFactor = 1.0 - clamp((gl_FogFragCoord - gl_Fog.start) * gl_Fog.scale, 0.0, 1.0);
	} else {
		fogFactor = 1.0;
	}
	gl_FragData[1] = vec4(ambient, fogFactor);
}
