#version 120

const bool gdepthMipmapEnabled = true;

#define MAX_COLOR_RANGE 48.0
/*
Read my terms of mofification/sharing before changing something below please!
Chocapic13' shaders, derived from SonicEther v10 rc6.
Place two leading Slashes in front of the following '#define' lines in order to disable an option.
*/

//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES
//////////////////////////////ADJUSTABLE VARIABLES

	#define GODRAYS
		const float exposure = 15.00;			//godrays intensity 1.2 is default
		const float density = 0.5;			
		const int NUM_SAMPLES = 7;			//increase this for better quality at the cost of performance /8 is default
		const float grnoise = 0.0;		//amount of noise /0.0 is default
		
	#define WATER_REFLECTIONS			
		#define REFLECTION_STRENGTH 1.0

//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES
//////////////////////////////END OF ADJUSTABLE VARIABLES



//don't touch these lines if you don't know what you do!
const int maxf = 7;				//number of refinements
const float stp = 1.0;			//size of one step for raytracing algorithm
const float ref = 0.1;			//refinement multiplier
const float inc = 2.0;			//increasement factor at each step

//ground constants (lower quality)
const int Gmaxf = 4;			//number of refinements
const float Gstp = 1.0;			//size of one step for raytracing algorithm
const float Gref = 0.1;			//refinement multiplier
const float Ginc = 2.4;			//increasement factor at each step

varying vec4 texcoord;
varying vec3 sunlight;
varying vec3 lightVector;
varying vec3 ambient_color;


uniform sampler2D composite;
uniform sampler2D gaux4;
uniform sampler2D gaux1;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D gnormal;
uniform sampler2D gdepth;
uniform sampler2D noisetex;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 cameraPosition;
uniform vec3 skyColor;
uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform int isEyeInWater;
uniform int worldTime;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float viewWidth;
uniform float viewHeight;
uniform float rainStrength;
uniform float wetness;
uniform float frameTimeCounter;
uniform int fogMode;

float pw = 1.0/ viewWidth;
float ph = 1.0/ viewHeight;
float matflag = texture2D(gaux1,texcoord.xy).g;

vec3 fogclr = pow(mix(vec3(0.5,0.5,1.0),vec3(0.3,0.3,0.3),rainStrength)*ambient_color,vec3(2.2));
vec3 fragpos = vec3(texcoord.st, texture2D(depthtex0, texcoord.st).r);
vec3 normal = texture2D(gnormal, texcoord.st).rgb * 2.0 - 1.0;

float time = float(worldTime);
float night = clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-22800.0)/200.0,0.0,1.0);

float sky_lightmap = texture2D(gaux1,texcoord.xy).r;
float iswet = wetness*pow(sky_lightmap,5.0)*sqrt(0.5+max(dot(normal,normalize(upPosition)),0.0));

vec4 color = texture2D(composite,texcoord.xy);

float ld(float depth) {
    return (2.0 * near) / (far + near - depth * (far - near));
}

vec3 nvec3(vec4 pos) {
    return pos.xyz/pos.w;
}

vec4 nvec4(vec3 pos) {
    return vec4(pos.xyz, 1.0);
}

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

float luma(vec3 color) {
return dot(color.rgb,vec3(0.299, 0.587, 0.114));
}



/*
vec4 raytraceGround(vec3 fragpos, vec3 normal) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = Gstp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
    for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = distance(fragpos.xyz,spos.xyz);
        if(err < pow(length(vector)*pow(length(tvector),0.11),1.1)*1.1){
                sr++;
                if(sr >= Gmaxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 3.0), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=Gref;
}
        vector *= Ginc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}
*/

float getnoise(vec2 pos) {
	return abs(fract(sin(dot(pos ,vec2(18.9898f,28.633f))) * 4378.5453f));
}

vec3 getSkyColor(vec3 fposition) {

vec3 sky_color = pow(ambient_color,vec3(2.2));
vec3 sVector = normalize(fposition);
vec3 upVector = normalize(upPosition);

sky_color = mix(sky_color,vec3(0.25,0.3,0.4)*length(ambient_color),rainStrength);

float Lz = 1.0;
float T = acos(max(dot(sVector,upVector),0.0));
float S = acos(dot(lightVector,upVector));
float Y = acos(dot(lightVector,sVector));


float L =  pow(((0.91+10*exp(-3*Y)+0.45*pow(cos(Y),2.0))*(1.0-exp(-0.32/cos(T))))/((0.91+10*exp(-3*S)+0.45*pow(cos(S),2.0))*(1.0-exp(-0.32))),1.0-rainStrength*0.8);

sky_color = mix(sky_color,pow(sunlight,vec3(2.2)),1-exp(-0.3*L*(1-rainStrength*0.8)));



return vec3(L*Lz)*sky_color;

}

vec3 getFogColor(vec3 fposition) {

vec3 sky_color = pow(ambient_color,vec3(2.2));
vec3 sVector = normalize(fposition);
vec3 upVector = normalize(upPosition);

float Lz = 1.0;
float T = acos(max(dot(sVector,upVector),0.0));
float S = acos(dot(lightVector,upVector));
float Y = acos(dot(lightVector,sVector));

sky_color = mix(sky_color,vec3(0.25,0.3,0.4)*length(ambient_color),rainStrength);

float L =  pow(sqrt((((0.91+10*exp(-3*Y)+0.45*pow(cos(Y),2.0))*(1.0-exp(-0.32/cos(T))))/((0.91+10*exp(-3*S)+0.45*pow(cos(S),2.0))*(1.0-exp(-0.32))))),1.0-rainStrength*0.8);

sky_color = mix(sky_color,sunlight,1-exp(-0.3*L*(1-rainStrength*0.8)));



return vec3(L*Lz)*sky_color;

}


vec3 drawSun(vec3 fposition,vec3 color,int land) {
vec3 sVector = normalize(fposition);
float sun = max(pow(clamp(dot(sVector,lightVector)+0.002,0.0,1.0),1000.0)-0.002,0.0)*land*(1-night);
vec3 sunlight_color = mix(sunlight,vec3(0.25,0.3,0.4)*length(ambient_color),rainStrength*0.8);

return mix(color,sunlight_color*MAX_COLOR_RANGE,sun);

}

vec3 calcFog(vec3 fposition, vec3 color) {
	

	float fog = exp(-pow(length(fposition)/far,4.0-(2.7*rainStrength))*4.0);

	float fogfactor =  clamp(fog,0.0,1.0);
	
	fogclr = getFogColor(fposition.xyz);
	

	return mix((fogclr+color.rgb*2.0*(1-rainStrength*0.995))/(1+2.0*(1-rainStrength*0.995)),color.rgb,fogfactor);
	}
	
vec4 raytrace(vec3 fragpos, vec3 normal) {
    vec4 color = vec4(0.0);
    vec3 start = fragpos;
    vec3 rvector = normalize(reflect(normalize(fragpos), normalize(normal)));
    vec3 vector = stp * rvector;
    vec3 oldpos = fragpos;
    fragpos += vector;
	vec3 tvector = vector;
    int sr = 0;
    for(int i=0;i<30;i++){
        vec3 pos = nvec3(gbufferProjection * nvec4(fragpos)) * 0.5 + 0.5;
        if(pos.x < 0 || pos.x > 1 || pos.y < 0 || pos.y > 1 || pos.z < 0 || pos.z > 1.0) break;
        vec3 spos = vec3(pos.st, texture2D(depthtex1, pos.st).r);
        spos = nvec3(gbufferProjectionInverse * nvec4(spos * 2.0 - 1.0));
        float err = distance(fragpos.xyz,spos.xyz);
if(err < pow(length(vector)*pow(length(tvector),0.15),1.15)*1.15){

                sr++;
                if(sr >= maxf){
                    float border = clamp(1.0 - pow(cdist(pos.st), 20.0), 0.0, 1.0);
                    color = texture2D(composite, pos.st);
					color.rgb = calcFog(spos,pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE);
					color.a = 1.0;
                    color.a *= border;
                    break;
                }
				tvector -=vector;
                vector *=ref;
				
        
}
        vector *= inc;
        oldpos = fragpos;
        tvector += vector;
		fragpos = start + tvector;
    }
    return color;
}

//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////
//////////////////////////////VOID MAIN//////////////////////////////

void main() {
	color.rgb = pow(color.rgb,vec3(2.2))*MAX_COLOR_RANGE;
	int land = int(matflag < 0.03);
	int iswater = int(matflag > 0.04 && matflag < 0.07);
	int hand  = int(matflag > 0.75 && matflag < 0.85);
	
	fragpos = nvec3(gbufferProjectionInverse * nvec4(fragpos * 2.0 - 1.0));
	color.rgb = drawSun(fragpos,color.rgb,land);
	
	float fresnel_pow = mix(1.0,5.0,float(iswater));
		float normalDotEye = dot(normal, normalize(fragpos));
		float fresnel = clamp(pow(1.0 + normalDotEye, fresnel_pow),0.0,1.0);
		float fmult = 0.3;
		//fresnel = fresnel + (1-fresnel)*fresnel;
		vec4 reflection;
		
	if (iswater > 0.9) {
#ifdef WATER_REFLECTIONS
		vec3 npos = normalize(fragpos);
		vec3 reflectedVector = reflect(normalize(fragpos), normalize(normal));
		reflectedVector = fragpos + reflectedVector * (far-length(fragpos));
		vec3 sky_color = calcFog(reflectedVector,getSkyColor(reflectedVector));
		reflection = raytrace(fragpos, normal);
		reflection.rgb = mix(sky_color, reflection.rgb, reflection.a);			//fake sky reflection, avoid empty spaces
		reflection.a = min(reflection.a,1.0);
		color.rgb = reflection.rgb *fresnel * REFLECTION_STRENGTH + (1-fresnel)*color.rgb;
		//color.rgb += (color.a/MAX_COLOR_RANGE)*sunlight*(1.0-rainStrength)*15.0;
#endif
    }

	//color.rgb += fresnel*torchcolor*torch_lightmap*specmap;
	
	vec3 colmult = mix(vec3(1.0),vec3(0.1,0.25,0.45),isEyeInWater);
	float depth_diff = clamp(pow(ld(texture2D(depthtex0, texcoord.st).r)*3.4,2.0),0.0,1.0);
	color.rgb = mix(color.rgb*colmult,vec3(0.05,0.1,0.15),depth_diff*isEyeInWater);
	
	color.rgb = calcFog(fragpos.xyz,color.rgb);


	float transition_fading = 1.0-(clamp((time-12000.0)/300.0,0.0,1.0)-clamp((time-13500.0)/300.0,0.0,1.0) + clamp((time-22500.0)/300.0,0.0,1.0)-clamp((time-23400.0)/300.0,0.0,1.0));	//fading between sun/moon shadows
		
/* DRAWBUFFERS:5 */
	
	//draw rain
	//color.rgb = texture2D(gaux4,texcoord.xy).rgb*texture2D(gaux4,texcoord.xy).a;
	
	vec4 tpos = vec4(sunPosition,1.0)*gbufferProjection;
	tpos = vec4(tpos.xyz/tpos.w,1.0);
	vec2 pos1 = tpos.xy/tpos.z;
	vec2 lightPos = pos1*0.5+0.5;
	
#ifdef GODRAYS
	float truepos = pow(clamp(dot(-lightVector,tpos.xyz)/length(tpos.xyz),0.0,1.0),0.25);
	if (truepos > 0.05) {
		vec2 deltaTextCoord = vec2( texcoord.st - lightPos.xy );
		vec2 textCoord = texcoord.st;
		deltaTextCoord *= 1.0 /  float(NUM_SAMPLES) * density;
		float illuminationDecay = 1.0;
		vec2 noise = vec2(getnoise(textCoord),getnoise(-textCoord.yx+0.05));
		float gr = 0.0;
		float avgdecay = 0.0;
		float distx = abs(texcoord.x*aspectRatio-lightPos.x*aspectRatio);
		float disty = abs(texcoord.y-lightPos.y);
		illuminationDecay = pow(max(1.0-sqrt(distx*distx+disty*disty),0.0),5.0);
				float fallof = 1.0;
		for(int i=0; i < NUM_SAMPLES ; i++) {
		fallof *= 0.85;
				textCoord -= deltaTextCoord;
				float sample = texture2DLod(gdepth, textCoord + noise*grnoise,3).r;
				gr += sample*fallof;
		}
		color.rgb += mix(sunlight,getFogColor(fragpos.xyz),rainStrength)*exposure*(gr/NUM_SAMPLES)*(1.0 - rainStrength*0.8)*illuminationDecay*truepos*transition_fading;
	}
#endif
	
	float visiblesun = 0.0;
	float temp;
	float nb = 0;
	
//calculate sun occlusion (only on one pixel) 
	if (texcoord.x < pw && texcoord.x < ph) {
		for (int i = 0; i < 10;i++) {
			for (int j = 0; j < 10 ;j++) {
			temp = texture2D(gaux1,lightPos + vec2(pw*(i-5.0),ph*(j-5.0))*10.0).g;
			visiblesun +=  1.0-float(temp > 0.04) ;
			nb += 1.0;
		}
	}
	visiblesun /= nb;
}

/*
if (texcoord.x > 1.0-pw && texcoord.x > 1.0-ph) {
	float avglum = 0.0;
	for (int i = 0; i < 5;i++) {
		for (int j = 0; j < 5 ;j++) {
		float distFallof = 1.0-sqrt(max(i*1.0,j*1.0)+1.0f)/9.0;
		avglum += luma(texture2DLod(composite,vec2(0.5) + vec2(pw*(i-2.0),ph*(j-2.0))*vec2(1.0,aspectRatio)*150.0,7).rgb);
		nb += distFallof;
		}
	}
	visiblesun = avglum/nb;
}
*/	
	color.rgb = clamp(pow(color.rgb/MAX_COLOR_RANGE,vec3(1.0/2.2)),0.0,1.0);
	//color.rgb = vec3(luma(texture2DLod(composite,texcoord.xy,5).rgb));

	gl_FragData[0] = vec4(color.rgb,visiblesun);
}