/*
 * Decompiled with CFR 0.152.
 */
package com.hd.advancedcapes;

import com.hd.advancedcapes.handlers.ClientHandler;
import com.hd.advancedcapes.handlers.ConfigHandler;
import com.hd.advancedcapes.handlers.GuiHandler;
import com.hd.advancedcapes.handlers.JoinEvent;
import com.hd.advancedcapes.packet.capes.capeJoinSignal;
import com.hd.advancedcapes.packet.capes.capeReceiveUser;
import com.hd.advancedcapes.packet.capes.capeSendUser;
import com.hd.advancedcapes.packet.skins.skinJoinSignal;
import com.hd.advancedcapes.packet.skins.skinReceiveUser;
import com.hd.advancedcapes.packet.skins.skinSendUser;
import com.hd.advancedcapes.proxy.CommonProxy;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.io.File;
import java.util.HashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;

@Mod(modid="advcapes", version="1.2", name="Advanced Capes", guiFactory="com.hd.advancedcapes.config.IngameGui")
public class Main {
    @Mod.Instance(value="advcapes")
    public static Main instance;
    @SidedProxy(clientSide="com.hd.advancedcapes.proxy.ClientProxy", serverSide="com.hd.advancedcapes.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static HashMap<String, Object[]> capeList;
    public static HashMap<String, Object[]> skinList;
    public static SimpleNetworkWrapper channel;
    public static Configuration config;
    public static String capeUrl;
    public static boolean showCustomCapes;
    public static boolean useSeasonalCape;
    public static boolean showCustomSkins;
    public static String skinUrl;
    public static boolean hasSkin;
    public static ResourceLocation CapeLocation;
    public static ResourceLocation SkinLocation;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        config = new Configuration(new File(event.getModConfigurationDirectory() + "/advcapes/advcapes.cfg"));
        this.syncConfig();
        channel.registerMessage(capeReceiveUser.class, capeReceiveUser.class, 0, Side.CLIENT);
        channel.registerMessage(capeJoinSignal.class, capeJoinSignal.class, 1, Side.CLIENT);
        channel.registerMessage(capeSendUser.class, capeSendUser.class, 2, Side.SERVER);
        channel.registerMessage(skinReceiveUser.class, skinReceiveUser.class, 3, Side.CLIENT);
        channel.registerMessage(skinJoinSignal.class, skinJoinSignal.class, 4, Side.CLIENT);
        channel.registerMessage(skinSendUser.class, skinSendUser.class, 5, Side.SERVER);
        CapeLocation = new ResourceLocation(event.getModConfigurationDirectory() + "/advcapes/capes/");
        SkinLocation = new ResourceLocation(event.getModConfigurationDirectory() + "/advcapes/skins/");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new JoinEvent());
        FMLCommonHandler.instance().bus().register((Object)new ClientHandler());
        FMLCommonHandler.instance().bus().register((Object)new ConfigHandler());
        proxy.InitHandlers();
        proxy.setSkin();
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void clientLoaded(FMLLoadCompleteEvent event) {
        if (!hasSkin) {
            this.setSkinUrl("http://skins.minecraft.net/MinecraftSkins/" + Minecraft.func_71410_x().func_110432_I().func_111285_a() + ".png");
            config.load();
            config.get("donottouch", "hasSkin", false).set(true);
            config.save();
        }
    }

    public void syncConfig() {
        capeUrl = config.getString("capeUrl", "general", "http://i.imgur.com/0tFH4di.png", "Url for your cape");
        showCustomCapes = config.getBoolean("showCustomCapes", "general", true, "Show custom capes?");
        useSeasonalCape = config.getBoolean("useSeasonalCape", "general", false, "Use seasonal capes?");
        showCustomSkins = config.getBoolean("showCustomSkins", "general", true, "Show custom skins?");
        skinUrl = config.getString("skinUrl", "general", "http://i.imgur.com/9BgWS0Y.png", "Url for your skin");
        hasSkin = config.getBoolean("hasSkin", "donottouch", false, "Do not change!");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public void setHasSkin(boolean bool) {
        config.load();
        config.get("donottouch", "hasSkin", false).set(bool);
        config.save();
    }

    public void setCapeUrl(String url) {
        config.load();
        config.get("general", "capeUrl", "http://i.imgur.com/0tFH4di.png").set(url);
        config.save();
    }

    public void setSkinUrl(String url) {
        config.load();
        config.get("general", "skinUrl", "http://i.imgur.com/9BgWS0Y.png").set(url);
        config.save();
    }

    public void addCape(String username, String url) {
        Object[] sTemp = new Object[]{url, null};
        capeList.put(username, sTemp);
    }

    public void addSkin(String username, String url) {
        Object[] sTemp = new Object[]{url, null};
        skinList.put(username, sTemp);
    }

    static {
        capeList = new HashMap();
        skinList = new HashMap();
        channel = NetworkRegistry.INSTANCE.newSimpleChannel("advcapes");
    }
}

