/*
 * Decompiled with CFR 0.152.
 */
package com.hd.advancedcapes;

import com.hd.advancedcapes.handlers.ClientHandler;
import com.hd.advancedcapes.handlers.ConfigHandler;
import com.hd.advancedcapes.handlers.GuiHandler;
import com.hd.advancedcapes.handlers.JoinEvent;
import com.hd.advancedcapes.packet.capes.capeJoinSignal;
import com.hd.advancedcapes.packet.capes.capeReceiveUser;
import com.hd.advancedcapes.packet.capes.capeSendUser;
import com.hd.advancedcapes.proxy.ClientProxy;
import com.hd.advancedcapes.proxy.CommonProxy;
import java.io.File;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLLoadCompleteEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod(modid="advcapes", version="2.4", name="Advanced Capes", guiFactory="com.hd.advancedcapes.config.IngameGui", acceptedMinecraftVersions="[1.8]")
public class Main {
    @Mod.Instance(value="advcapes")
    public static Main instance;
    @SidedProxy(clientSide="com.hd.advancedcapes.proxy.ClientProxy", serverSide="com.hd.advancedcapes.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static HashMap<String, Object[]> capeList;
    public static SimpleNetworkWrapper channel;
    public static Configuration config;
    public static String capeUrl;
    public static boolean showCustomCapes;
    public static ResourceLocation CapeLocation;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientProxy());
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
        config = new Configuration(new File(event.getModConfigurationDirectory() + "/advcapes/advcapes.cfg"));
        this.syncConfig();
        channel.registerMessage(capeReceiveUser.class, capeReceiveUser.class, 0, Side.CLIENT);
        channel.registerMessage(capeJoinSignal.class, capeJoinSignal.class, 1, Side.CLIENT);
        channel.registerMessage(capeSendUser.class, capeSendUser.class, 2, Side.SERVER);
        CapeLocation = new ResourceLocation(event.getModConfigurationDirectory() + "/advcapes/capes/");
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLCommonHandler.instance().bus().register((Object)new JoinEvent());
        FMLCommonHandler.instance().bus().register((Object)new ClientHandler());
        FMLCommonHandler.instance().bus().register((Object)new ConfigHandler());
        proxy.InitHandlers();
    }

    @Mod.EventHandler
    @SideOnly(value=Side.CLIENT)
    public void clientLoaded(FMLLoadCompleteEvent event) {
        this.syncConfig();
    }

    public void syncConfig() {
        capeUrl = config.getString("capeUrl", "settings", "http://i.imgur.com/0tFH4di.png", "Url for your cape");
        showCustomCapes = config.getBoolean("showCustomCapes", "settings", true, "Show custom capes?");
        if (config.hasChanged()) {
            config.save();
        }
    }

    public void setCapeUrl(String url) {
        config.load();
        config.get("settings", "capeUrl", "http://i.imgur.com/0tFH4di.png").set(url);
        config.save();
    }

    public void addCape(String username, String url) {
        Object[] sTemp = new Object[]{url, null};
        capeList.put(username, sTemp);
    }

    static {
        capeList = new HashMap();
        channel = NetworkRegistry.INSTANCE.newSimpleChannel("advcapes");
    }
}

