/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;

public class Loc {
    public final double x;
    public final double y;
    public final double z;

    public Loc() {
        this(0, 0, 0);
    }

    public Loc(int i2, int j2) {
        this(i2, 0, j2);
    }

    public Loc(int i2, int j2, int k2) {
        this((double)i2, (double)j2, (double)k2);
    }

    public Loc(double d2, double d1) {
        this(d2, 0.0, d1);
    }

    public Loc(xd world) {
        this(world.x().a, world.x().b, world.x().c);
    }

    public Loc(Loc loc) {
        this(loc.x, loc.y, loc.z);
    }

    public Loc(double d2, double d1, double d22) {
        this.x = d2;
        this.y = d1;
        this.z = d22;
    }

    public int x() {
        return (int)this.x;
    }

    public int y() {
        return (int)this.y;
    }

    public int z() {
        return (int)this.z;
    }

    public Loc add(int i2, int j2, int k2) {
        return new Loc(this.x + (double)i2, this.y + (double)j2, this.z + (double)k2);
    }

    public Loc add(double d2, double d1, double d22) {
        return new Loc(this.x + d2, this.y + d1, this.z + d22);
    }

    public Loc add(Loc loc) {
        return new Loc(this.x + loc.x, this.y + loc.y, this.z + loc.z);
    }

    public Loc subtract(int i2, int j2, int k2) {
        return new Loc(this.x - (double)i2, this.y - (double)j2, this.z - (double)k2);
    }

    public Loc subtract(double d2, double d1, double d22) {
        return new Loc(this.x - d2, this.y - d1, this.z - d22);
    }

    public Loc subtract(Loc loc) {
        return new Loc(this.x - loc.x, this.y - loc.y, this.z - loc.z);
    }

    public Loc multiply(double d2, double d1, double d22) {
        return new Loc(this.x * d2, this.y * d1, this.z * d22);
    }

    public Loc getSide(int i2) {
        switch (i2) {
            case 0: {
                return new Loc(this.x, this.y - 1.0, this.z);
            }
            case 1: {
                return new Loc(this.x, this.y + 1.0, this.z);
            }
            case 2: {
                return new Loc(this.x, this.y, this.z - 1.0);
            }
            case 3: {
                return new Loc(this.x, this.y, this.z + 1.0);
            }
            case 4: {
                return new Loc(this.x - 1.0, this.y, this.z);
            }
            case 5: {
                return new Loc(this.x + 1.0, this.y, this.z);
            }
        }
        return new Loc(this.x, this.y, this.z);
    }

    public boolean equals(Object obj) {
        if (obj instanceof Loc) {
            Loc loc = (Loc)obj;
            return this.x == loc.x && this.y == loc.y && this.z == loc.z;
        }
        return false;
    }

    public String toString() {
        return "(" + this.x + "," + this.y + "," + this.z + ")";
    }

    public int distSimple(Loc loc) {
        return (int)(Math.abs(this.x - loc.x) + Math.abs(this.y - loc.y) + Math.abs(this.z - loc.z));
    }

    public double distAdv(Loc loc) {
        return Math.sqrt(Math.pow(this.x - loc.x, 2.0) + Math.pow(this.y - loc.y, 2.0) + Math.pow(this.z - loc.z, 2.0));
    }

    public static Loc[] vecAdjacent() {
        Loc[] aloc = new Loc[]{new Loc(0, 0, 1), new Loc(0, 0, -1), new Loc(0, 1, 0), new Loc(0, -1, 0), new Loc(1, 0, 0), new Loc(-1, 0, 0)};
        return aloc;
    }

    public Loc[] adjacent() {
        Loc[] aloc = Loc.vecAdjacent();
        for (int i2 = 0; i2 < aloc.length; ++i2) {
            aloc[i2] = this.add(aloc[i2]);
        }
        return aloc;
    }

    public static Loc[] vecAdjacent2D() {
        Loc[] aloc = new Loc[]{new Loc(0, 1), new Loc(0, -1), new Loc(1, 0), new Loc(-1, 0)};
        return aloc;
    }

    public Loc[] adjacent2D() {
        Loc[] aloc = Loc.vecAdjacent();
        for (int i2 = 0; i2 < aloc.length; ++i2) {
            aloc[i2] = this.add(aloc[i2]);
        }
        return aloc;
    }

    public static ArrayList vecInRadius(int i2, boolean flag) {
        ArrayList<Loc> arraylist = new ArrayList<Loc>();
        Loc loc = new Loc();
        for (int j2 = -i2; j2 <= i2; ++j2) {
            for (int k2 = -i2; k2 <= i2; ++k2) {
                for (int l2 = -i2; l2 <= i2; ++l2) {
                    double d2;
                    Loc loc1 = new Loc(j2, l2, k2);
                    double d3 = d2 = flag ? loc.distAdv(loc1) : (double)loc.distSimple(loc1);
                    if (!(d2 <= (double)i2)) continue;
                    arraylist.add(loc1);
                }
            }
        }
        return arraylist;
    }

    public ArrayList inRadius(int i2, boolean flag) {
        ArrayList<Loc> arraylist = new ArrayList<Loc>();
        for (int j2 = -i2; j2 <= i2; ++j2) {
            for (int k2 = -i2; k2 <= i2; ++k2) {
                for (int l2 = -i2; l2 <= i2; ++l2) {
                    double d2;
                    Loc loc = new Loc(j2, l2, k2).add(this);
                    double d3 = d2 = flag ? this.distAdv(loc) : (double)this.distSimple(loc);
                    if (!(d2 <= (double)i2)) continue;
                    arraylist.add(loc);
                }
            }
        }
        return arraylist;
    }

    public static ArrayList vecInRadius2D(int i2, boolean flag) {
        ArrayList<Loc> arraylist = new ArrayList<Loc>();
        Loc loc = new Loc();
        for (int j2 = -i2; j2 <= i2; ++j2) {
            for (int k2 = -i2; k2 <= i2; ++k2) {
                double d2;
                Loc loc1 = new Loc(j2, k2);
                double d3 = d2 = flag ? loc.distAdv(loc1) : (double)loc.distSimple(loc1);
                if (!(d2 <= (double)i2)) continue;
                arraylist.add(loc1);
            }
        }
        return arraylist;
    }

    public ArrayList inRadius2D(int i2, boolean flag) {
        ArrayList<Loc> arraylist = new ArrayList<Loc>();
        for (int j2 = -i2; j2 <= i2; ++j2) {
            for (int k2 = -i2; k2 <= i2; ++k2) {
                double d2;
                Loc loc = new Loc(j2, k2).add(this);
                double d3 = d2 = flag ? this.distAdv(loc) : (double)this.distSimple(loc);
                if (!(d2 <= (double)i2)) continue;
                arraylist.add(loc);
            }
        }
        return arraylist;
    }

    public int getBlock(ali iblockaccess) {
        return iblockaccess.a(this.x(), this.y(), this.z());
    }

    public Loc setBlockNotify(xd world, int i2) {
        world.g(this.x(), this.y(), this.z(), i2);
        return this;
    }

    public Loc setBlock(xd world, int i2) {
        world.d(this.x(), this.y(), this.z(), i2);
        return this;
    }

    public int getMeta(ali iblockaccess) {
        return iblockaccess.e(this.x(), this.y(), this.z());
    }

    public Loc setMeta(xd world, int i2) {
        world.c(this.x(), this.y(), this.z(), i2);
        return this;
    }

    public Loc setMetaNotify(xd world, int i2) {
        world.f(this.x(), this.y(), this.z(), i2);
        return this;
    }

    public Loc setBlockAndMeta(xd world, int i2, int j2) {
        world.b(this.x(), this.y(), this.z(), i2, j2);
        return this;
    }

    public Loc setBlockAndMetaNotify(xd world, int i2, int j2) {
        world.d(this.x(), this.y(), this.z(), i2, j2);
        return this;
    }

    public kw getTileEntity(ali iblockaccess) {
        return iblockaccess.b(this.x(), this.y(), this.z());
    }

    public Loc setTileEntity(xd world, kw tileentity) {
        world.a(this.x(), this.y(), this.z(), tileentity);
        return this;
    }

    public Loc removeTileEntity(xd world) {
        world.q(this.x(), this.y(), this.z());
        return this;
    }

    public int getLight(xd world) {
        return world.n(this.x(), this.y(), this.z());
    }

    public Loc notify(xd world) {
        world.j(this.x(), this.y(), this.z(), this.getBlock(world));
        return this;
    }

    public Loc setSpawnPoint(xd world) {
        world.a(new uh(this.x(), this.y(), this.z()));
        return this;
    }
}

