/*
 * Decompiled with CFR 0.152.
 */
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class Reflector {
    private static Class[] classes = new Class[16];
    private static boolean[] classesChecked = new boolean[16];
    private static Map classNameMap = null;
    private static Method[] methods = new Method[256];
    private static boolean[] methodsChecked = new boolean[256];
    private static Map methodNameMap = null;
    private static Field[] fields = new Field[256];
    private static boolean[] fieldsChecked = new boolean[256];
    private static Map fieldNameMap = null;
    public static final int ModLoader = 0;
    public static final int ForgeHooksClient = 1;
    public static final int MinecraftForgeClient = 2;
    public static final int LightCache = 3;
    public static final int BlockCoord = 4;
    public static final int ForgeBlock = 5;
    public static final int ItemRenderType = 6;
    public static final int FMLRender = 7;
    public static final int ForgeEffectRenderer = 8;
    public static final int ModLoader_renderWorldBlock = 0;
    public static final int ModLoader_renderInvBlock = 1;
    public static final int ModLoader_renderBlockIsItemFull3D = 2;
    public static final int ForgeHooksClient_onBlockHighlight = 10;
    public static final int ForgeHooksClient_canRenderInPass = 11;
    public static final int ForgeHooksClient_getTexture = 12;
    public static final int ForgeHooksClient_beforeRenderPass = 13;
    public static final int ForgeHooksClient_afterRenderPass = 14;
    public static final int ForgeHooksClient_beforeBlockRender = 15;
    public static final int ForgeHooksClient_afterBlockRender = 16;
    public static final int ForgeHooksClient_onRenderWorldLast = 17;
    public static final int ForgeHooksClient_onTextureLoadPre = 18;
    public static final int ForgeHooksClient_onTextureLoad = 19;
    public static final int MinecraftForgeClient_getItemRenderer = 20;
    public static final int LightCache_clear = 30;
    public static final int BlockCoord_resetPool = 40;
    public static final int ForgeBlock_isLadder = 50;
    public static final int ForgeBlock_isBed = 51;
    public static final int FMLRender_setTextureDimensions = 70;
    public static final int FMLRender_preRegisterEffect = 71;
    public static final int FMLRender_onUpdateTextureEffect = 72;
    public static final int FMLRender_onTexturePackChange = 73;
    public static final int ForgeEffectRenderer_addEffect = 80;
    public static final int LightCache_cache = 30;
    public static final int ItemRenderType_EQUIPPED = 60;
    public static final Class[] NO_PARAMETERS = new Class[0];

    private static Map getClassNameMap() {
        if (classNameMap == null) {
            classNameMap = new HashMap();
            classNameMap.put(0, "ModLoader");
            classNameMap.put(1, "forge.ForgeHooksClient");
            classNameMap.put(2, "forge.MinecraftForgeClient");
            classNameMap.put(3, "LightCache");
            classNameMap.put(4, "BlockCoord");
            classNameMap.put(5, pb.class);
            classNameMap.put(6, "forge.IItemRenderer$ItemRenderType");
            classNameMap.put(7, "FMLRenderAccessLibrary");
            classNameMap.put(8, cw.class);
        }
        return classNameMap;
    }

    private static Map getMethodNameMap() {
        if (methodNameMap == null) {
            methodNameMap = new HashMap();
            methodNameMap.put(0, "renderWorldBlock");
            methodNameMap.put(1, "renderInvBlock");
            methodNameMap.put(2, "renderBlockIsItemFull3D");
            methodNameMap.put(10, "onBlockHighlight");
            methodNameMap.put(11, "canRenderInPass");
            methodNameMap.put(12, "getTexture");
            methodNameMap.put(13, "beforeRenderPass");
            methodNameMap.put(14, "afterRenderPass");
            methodNameMap.put(15, "beforeBlockRender");
            methodNameMap.put(16, "afterBlockRender");
            methodNameMap.put(17, "onRenderWorldLast");
            methodNameMap.put(18, "onTextureLoadPre");
            methodNameMap.put(19, "onTextureLoad");
            methodNameMap.put(20, "getItemRenderer");
            methodNameMap.put(30, "clear");
            methodNameMap.put(40, "resetPool");
            methodNameMap.put(50, "isLadder");
            methodNameMap.put(51, "isBed");
            methodNameMap.put(70, "setTextureDimensions");
            methodNameMap.put(71, "preRegisterEffect");
            methodNameMap.put(72, "onUpdateTextureEffect");
            methodNameMap.put(73, "onTexturePackChange");
            methodNameMap.put(80, "addEffect");
        }
        return methodNameMap;
    }

    private static Map getFieldNameMap() {
        if (fieldNameMap == null) {
            fieldNameMap = new HashMap();
            fieldNameMap.put(30, "cache");
            fieldNameMap.put(60, "EQUIPPED");
        }
        return fieldNameMap;
    }

    public static void callVoid(int methodId, Object[] params) {
        try {
            Method m2 = Reflector.getMethod(methodId);
            if (m2 == null) {
                return;
            }
            m2.invoke(null, params);
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public static int callInt(int methodId, Object[] params) {
        Integer val = (Integer)Reflector.call(methodId, params);
        return val;
    }

    public static String callString(int methodId, Object[] params) {
        return (String)Reflector.call(methodId, params);
    }

    public static boolean callBoolean(int methodId, Object[] params) {
        try {
            Method method = Reflector.getMethod(methodId);
            if (method == null) {
                return false;
            }
            Boolean retVal = (Boolean)method.invoke(null, params);
            return retVal;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static boolean callBoolean(Object obj, int methodId, Object[] params) {
        try {
            Method method = Reflector.getMethod(methodId);
            if (method == null) {
                return false;
            }
            Boolean retVal = (Boolean)method.invoke(obj, params);
            return retVal;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return false;
        }
    }

    public static Object call(int methodId, Object[] params) {
        try {
            Method method = Reflector.getMethod(methodId);
            if (method == null) {
                return false;
            }
            Object retVal = method.invoke(null, params);
            return retVal;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public static void callVoid(Object obj, int methodId, Object[] params) {
        try {
            if (obj == null) {
                return;
            }
            Method method = Reflector.getMethod(methodId);
            if (method == null) {
                return;
            }
            method.invoke(obj, params);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
        }
    }

    private static Method getMethod(int methodId) {
        Method m2 = methods[methodId];
        if (m2 == null) {
            if (methodsChecked[methodId]) {
                return null;
            }
            Reflector.methodsChecked[methodId] = true;
            Reflector.methods[methodId] = m2 = Reflector.findMethod(methodId);
        }
        return m2;
    }

    private static Method findMethod(int methodId) {
        int classId = methodId / 10;
        Class cls = Reflector.getClass(classId);
        if (cls == null) {
            return null;
        }
        String methodName = (String)Reflector.getMethodNameMap().get(methodId);
        if (methodName == null) {
            Config.log("Method name not found for id: " + methodId);
            return null;
        }
        Method[] ms2 = cls.getMethods();
        for (int i2 = 0; i2 < ms2.length; ++i2) {
            Method m2 = ms2[i2];
            if (!m2.getName().equals(methodName)) continue;
            return m2;
        }
        Config.log("Method not found: " + cls.getName() + "." + methodName);
        return null;
    }

    private static Field getField(int fieldId) {
        Field f2 = fields[fieldId];
        if (f2 == null) {
            if (fieldsChecked[fieldId]) {
                return null;
            }
            Reflector.fieldsChecked[fieldId] = true;
            Reflector.fields[fieldId] = f2 = Reflector.findField(fieldId);
        }
        return f2;
    }

    private static Field findField(int fieldId) {
        int classId = fieldId / 10;
        Class cls = Reflector.getClass(classId);
        if (cls == null) {
            return null;
        }
        String fieldName = (String)Reflector.getFieldNameMap().get(fieldId);
        if (fieldName == null) {
            Config.log("Field name not found for id: " + fieldId);
            return null;
        }
        try {
            Field f2 = cls.getDeclaredField(fieldName);
            return f2;
        }
        catch (SecurityException e2) {
            e2.printStackTrace();
        }
        catch (NoSuchFieldException e3) {
            Config.log("Field not found: " + cls.getName() + "." + fieldName);
        }
        return null;
    }

    private static Class getClass(int classId) {
        Class<?> cls = classes[classId];
        if (cls == null) {
            if (classesChecked[classId]) {
                return null;
            }
            Reflector.classesChecked[classId] = true;
            Object classValue = Reflector.getClassNameMap().get(classId);
            if (classValue instanceof Class) {
                cls = (Class)classValue;
                Reflector.classes[classId] = cls;
                return cls;
            }
            String className = (String)classValue;
            if (className == null) {
                Config.log("Class name not found for id: " + classId);
                return null;
            }
            try {
                Reflector.classes[classId] = cls = Class.forName(className);
            }
            catch (ClassNotFoundException e2) {
                Config.log("Class not present: " + className);
            }
            catch (Throwable e3) {
                e3.printStackTrace();
            }
        }
        return cls;
    }

    public static boolean hasClass(int classId) {
        Class cls = Reflector.getClass(classId);
        return cls != null;
    }

    public static boolean hasMethod(int methodId) {
        Method m2 = Reflector.getMethod(methodId);
        return m2 != null;
    }

    public static Object getFieldValue(int fieldId) {
        try {
            Field field = Reflector.getField(fieldId);
            if (field == null) {
                return null;
            }
            Object value = field.get(null);
            return value;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            return null;
        }
    }
}

