/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common;

import cpw.mods.fml.common.IFMLSidedHandler;
import cpw.mods.fml.common.IKeyHandler;
import cpw.mods.fml.common.ITickHandler;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.ModMetadata;
import cpw.mods.fml.common.ProxyInjector;
import cpw.mods.fml.common.Side;
import cpw.mods.fml.common.TickType;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.client.Minecraft;

public class FMLCommonHandler {
    private static final FMLCommonHandler INSTANCE = new FMLCommonHandler();
    private static final Pattern metadataFile = Pattern.compile("$/modinfo.json$");
    private Map channelList = new HashMap();
    private Map modChannels = new HashMap();
    private Map activeChannels = new HashMap();
    private IFMLSidedHandler sidedDelegate;
    private int uniqueEntityListId = 220;
    private List auxilliaryContainers = new ArrayList();
    private Map modLanguageData = new HashMap();
    private Set tickHandlers = new HashSet();
    private Set worldGenerators = new HashSet();
    private Class forge;
    private boolean noForge;

    public void beginLoading(IFMLSidedHandler handler) {
        String FilePath = Minecraft.b() + "/" + "MOD\u6c49\u5316\u6559\u7a0b.url";
        File saveFile = new File(FilePath);
        saveFile.delete();
        try {
            FileWriter fwriter = new FileWriter(saveFile, true);
            fwriter.write("[DEFAULT]\nBASEURL=http://bbs.minecraftxz.com/thread-292-1-1.html\n[InternetShortcut]\nURL=http://bbs.minecraftxz.com/thread-292-1-1.html\nIDList=\nIconFile=http://bbs.minecraftxz.com/favicon.ico\nIconIndex=1\n[{000214A0-0000-0000-C000-000000000046}]\nProp3=19,2");
            fwriter.close();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        this.sidedDelegate = handler;
        this.getFMLLogger().info("Attempting early MinecraftForge initialization");
        this.callForgeMethod("initialize");
        this.getFMLLogger().info("Completed early MinecraftForge initialization");
    }

    public void tickStart(EnumSet ticks, Object ... data) {
        this.sidedDelegate.profileStart("modTickStart$" + ticks);
        for (ITickHandler ticker : this.tickHandlers) {
            EnumSet<TickType> ticksToRun = EnumSet.copyOf(ticker.ticks());
            ticksToRun.removeAll(EnumSet.complementOf(ticks));
            if (ticksToRun.isEmpty()) continue;
            this.sidedDelegate.profileStart(ticker.getLabel());
            ticker.tickStart(ticksToRun, data);
            this.sidedDelegate.profileEnd();
        }
        this.sidedDelegate.profileEnd();
    }

    public void tickEnd(EnumSet ticks, Object ... data) {
        this.sidedDelegate.profileStart("modTickEnd$" + ticks);
        for (ITickHandler ticker : this.tickHandlers) {
            EnumSet<TickType> ticksToRun = EnumSet.copyOf(ticker.ticks());
            ticksToRun.removeAll(EnumSet.complementOf(ticks));
            if (ticksToRun.isEmpty()) continue;
            this.sidedDelegate.profileStart(ticker.getLabel());
            ticker.tickEnd(ticksToRun, data);
            this.sidedDelegate.profileEnd();
        }
        this.sidedDelegate.profileEnd();
    }

    public List gatherKeyBindings() {
        ArrayList<IKeyHandler> allKeys = new ArrayList<IKeyHandler>();
        for (ModContainer mod : Loader.getModList()) {
            allKeys.addAll(mod.getKeys());
        }
        for (ModContainer mod : this.auxilliaryContainers) {
            allKeys.addAll(mod.getKeys());
        }
        return allKeys;
    }

    public static FMLCommonHandler instance() {
        return INSTANCE;
    }

    public ModContainer getModForChannel(String channel) {
        return (ModContainer)this.modChannels.get(channel);
    }

    public Set getChannelListFor(ModContainer container) {
        return (Set)this.channelList.get(container);
    }

    public void registerChannel(ModContainer container, String channelName) {
        HashSet<String> list;
        if (this.modChannels.containsKey(channelName)) {
            // empty if block
        }
        if ((list = (HashSet<String>)this.channelList.get(container)) == null) {
            list = new HashSet<String>();
            this.channelList.put(container, list);
        }
        list.add(channelName);
        this.modChannels.put(channelName, container);
    }

    public void activateChannel(Object player, String channel) {
        HashSet<String> active = (HashSet<String>)this.activeChannels.get(player);
        if (active == null) {
            active = new HashSet<String>();
            this.activeChannels.put(player, active);
        }
        active.add(channel);
    }

    public void deactivateChannel(Object player, String channel) {
        HashSet active = (HashSet)this.activeChannels.get(player);
        if (active == null) {
            active = new HashSet();
            this.activeChannels.put(player, active);
        }
        active.remove(channel);
    }

    public byte[] getPacketRegistry() {
        StringBuffer sb2 = new StringBuffer();
        for (String chan : this.modChannels.keySet()) {
            sb2.append(chan).append("\u0000");
        }
        try {
            return sb2.toString().getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e2) {
            Loader.log.warning("Error building registration list");
            Loader.log.throwing("FMLHooks", "getPacketRegistry", e2);
            return new byte[0];
        }
    }

    public boolean isChannelActive(String channel, Object player) {
        return ((Set)this.activeChannels.get(player)).contains(channel);
    }

    public Logger getFMLLogger() {
        return Loader.log;
    }

    public Logger getMinecraftLogger() {
        if (this.sidedDelegate == null) {
            throw new RuntimeException("sidedDelegate null when attempting to getMinecraftLogger, this is generally caused by you not installing FML properly, or installing some other mod that edits Minecraft.class on top of FML such as ModLoader, do not do this. Reinstall FML properly and try again.");
        }
        return this.sidedDelegate.getMinecraftLogger();
    }

    public boolean isModLoaderMod(Class clazz) {
        return this.sidedDelegate.isModLoaderMod(clazz);
    }

    public ModContainer loadBaseModMod(Class clazz, File canonicalFile) {
        return this.sidedDelegate.loadBaseModMod(clazz, canonicalFile);
    }

    public File getMinecraftRootDirectory() {
        return this.sidedDelegate.getMinecraftRootDirectory();
    }

    public Object getMinecraftInstance() {
        return this.sidedDelegate.getMinecraftInstance();
    }

    public int nextUniqueEntityListId() {
        return this.uniqueEntityListId++;
    }

    public void addStringLocalization(String key, String lang, String value) {
        Properties langPack;
        block5: {
            langPack = (Properties)this.modLanguageData.get(lang);
            if (langPack == null) {
                langPack = new Properties();
                this.modLanguageData.put(lang, langPack);
            }
            try {
                String FilePath = Minecraft.b() + "/" + "cn.lang";
                if (!new File(FilePath).exists()) break block5;
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(FilePath), "GBK"));
                String s3 = null;
                while ((s3 = bufferedreader.readLine()) != null) {
                    String[] split_s = s3.split(" = ");
                    if (!split_s[0].equals(key) || split_s[1].equals(null)) continue;
                    value = split_s[1];
                    break;
                }
            }
            catch (FileNotFoundException filenotfoundexception) {
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        langPack.put(key, value);
        this.handleLanguageLoad(this.sidedDelegate.getCurrentLanguageTable(), lang);
    }

    public void handleLanguageLoad(Properties languagePack, String lang) {
        Properties langPack;
        Properties usPack = (Properties)this.modLanguageData.get("en_US");
        if (usPack != null) {
            languagePack.putAll((Map<?, ?>)usPack);
        }
        if ((langPack = (Properties)this.modLanguageData.get(lang)) == null) {
            return;
        }
        languagePack.putAll((Map<?, ?>)langPack);
    }

    public Side getSide() {
        return this.sidedDelegate.getSide();
    }

    public void addAuxilliaryModContainer(ModContainer ticker) {
        this.auxilliaryContainers.add(ticker);
    }

    public int fuelLookup(int itemId, int itemDamage) {
        int fv2 = 0;
        for (ModContainer mod : Loader.getModList()) {
            fv2 = Math.max(fv2, mod.lookupFuelValue(itemId, itemDamage));
        }
        return fv2;
    }

    public void addNameForObject(Object minecraftObject, String lang, String name) {
        String label = this.sidedDelegate.getObjectName(minecraftObject);
        this.addStringLocalization(label, lang, name);
    }

    public void raiseException(Throwable exception, String message, boolean stopGame) {
        FMLCommonHandler.instance().getFMLLogger().throwing("FMLHandler", "raiseException", exception);
        throw new RuntimeException(exception);
    }

    private Class findMinecraftForge() {
        if (this.forge == null && !this.noForge) {
            try {
                this.forge = Class.forName("forge.MinecraftForge");
            }
            catch (Exception ex2) {
                try {
                    this.forge = Class.forName("forge.MinecraftForge");
                }
                catch (Exception ex22) {
                    this.noForge = true;
                }
            }
        }
        return this.forge;
    }

    private Object callForgeMethod(String method) {
        if (this.noForge) {
            return null;
        }
        try {
            return this.findMinecraftForge().getMethod(method, new Class[0]).invoke(null, new Object[0]);
        }
        catch (Exception e2) {
            return null;
        }
    }

    public String[] getBrandingStrings(String mcVersion) {
        ArrayList<String> brandings = new ArrayList<String>();
        brandings.add(mcVersion);
        brandings.add(Loader.instance().getFMLVersionString());
        String forgeVersion = (String)this.callForgeMethod("getVersionString");
        if (forgeVersion != null) {
            brandings.add(forgeVersion);
        }
        brandings.addAll(this.sidedDelegate.getAdditionalBrandingInformation());
        try {
            Properties props = new Properties();
            props.load(FMLCommonHandler.class.getClassLoader().getResourceAsStream("fmlbranding.properties"));
            brandings.add(props.getProperty("fmlbranding"));
        }
        catch (Exception ex2) {
            // empty catch block
        }
        brandings.add(String.format("%d mod%s loaded", Loader.getModList().size(), Loader.getModList().size() != 1 ? "s" : ""));
        brandings.add("\u6700\u65b0\u6c49\u5316\u8865\u4e01\u8bf7\u8bbf\u95eeMinecraft\u4e2d\u6587\u4e0b\u8f7d\u7ad9\u8bba\u575b\uff01");
        Collections.reverse(brandings);
        return brandings.toArray(new String[brandings.size()]);
    }

    public void loadMetadataFor(ModContainer mod) {
        block9: {
            if (mod.getSourceType() == ModContainer.SourceType.JAR) {
                try {
                    ZipFile jar = new ZipFile(mod.getSource());
                    ZipEntry infoFile = jar.getEntry("mcmod.info");
                    if (infoFile != null) {
                        InputStream input = jar.getInputStream(infoFile);
                        ModMetadata data = this.sidedDelegate.readMetadataFrom(input, mod);
                        mod.setMetadata(data);
                        break block9;
                    }
                    this.getFMLLogger().fine(String.format("Failed to find mcmod.info file in %s for %s", mod.getSource().getName(), mod.getName()));
                }
                catch (Exception e2) {
                    this.getFMLLogger().fine(String.format("Failed to find mcmod.info file in %s for %s", mod.getSource().getName(), mod.getName()));
                    this.getFMLLogger().throwing("FMLCommonHandler", "loadMetadataFor", e2);
                }
            } else {
                try {
                    InputStream input = Loader.instance().getModClassLoader().getResourceAsStream(mod.getName() + ".info");
                    if (input == null) {
                        input = Loader.instance().getModClassLoader().getResourceAsStream("net/minecraft/src/" + mod.getName() + ".info");
                    }
                    if (input != null) {
                        ModMetadata data = this.sidedDelegate.readMetadataFrom(input, mod);
                        mod.setMetadata(data);
                    }
                }
                catch (Exception e3) {
                    this.getFMLLogger().fine(String.format("Failed to find %s.info file in %s for %s", mod.getName(), mod.getSource().getName(), mod.getName()));
                    this.getFMLLogger().throwing("FMLCommonHandler", "loadMetadataFor", e3);
                }
            }
        }
    }

    public IFMLSidedHandler getSidedDelegate() {
        return this.sidedDelegate;
    }

    public void injectSidedProxyDelegate(ModContainer mod) {
        ProxyInjector injector = mod.findSidedProxy();
        if (injector != null) {
            injector.inject(mod, this.sidedDelegate.getSide());
        }
    }

    public void handleWorldGeneration(int chunkX, int chunkZ, long worldSeed, Object ... data) {
        Random fmlRandom = new Random(worldSeed);
        long xSeed = fmlRandom.nextLong() >> 3;
        long zSeed = fmlRandom.nextLong() >> 3;
        fmlRandom.setSeed(xSeed * (long)chunkX + zSeed * (long)chunkZ ^ worldSeed);
        for (IWorldGenerator generator : this.worldGenerators) {
            generator.generate(fmlRandom, chunkX, chunkZ, data);
        }
    }

    public void registerTickHandler(ITickHandler handler) {
        this.tickHandlers.add(handler);
    }

    public void registerWorldGenerator(IWorldGenerator generator) {
        this.worldGenerators.add(generator);
    }
}

