/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.fml.common.modloader;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.TickType;
import cpw.mods.fml.common.modloader.BaseMod;
import cpw.mods.fml.common.modloader.BaseModTicker;
import cpw.mods.fml.common.modloader.ModLoaderModContainer;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;

public class ModLoaderHelper {
    private static Map<BaseMod, ModLoaderModContainer> notModCallbacks = new HashMap<BaseMod, ModLoaderModContainer>();

    public static void updateStandardTicks(BaseMod mod, boolean enable, boolean useClock) {
        ModLoaderModContainer mlmc = ModLoaderHelper.findOrBuildModContainer(mod);
        BaseModTicker ticker = mlmc.getTickHandler();
        EnumSet<TickType> ticks = ticker.ticks();
        if (enable && !useClock) {
            ticks.add(TickType.RENDER);
        } else {
            ticks.remove((Object)TickType.RENDER);
        }
        if (enable && (useClock || FMLCommonHandler.instance().getSide().isServer())) {
            ticks.add(TickType.GAME);
        } else {
            ticks.remove((Object)TickType.GAME);
        }
    }

    public static void updateGUITicks(BaseMod mod, boolean enable, boolean useClock) {
        ModLoaderModContainer mlmc = ModLoaderHelper.findOrBuildModContainer(mod);
        EnumSet<TickType> ticks = mlmc.getTickHandler().ticks();
        if (enable && !useClock) {
            ticks.add(TickType.GUI);
        } else {
            ticks.remove((Object)TickType.GUI);
        }
        if (enable && (useClock || FMLCommonHandler.instance().getSide().isServer())) {
            ticks.add(TickType.WORLDGUI);
        } else {
            ticks.remove((Object)TickType.WORLDGUI);
        }
    }

    private static ModLoaderModContainer findOrBuildModContainer(BaseMod mod) {
        ModLoaderModContainer mlmc = (ModLoaderModContainer)ModLoaderModContainer.findContainerFor(mod);
        if (mlmc == null && (mlmc = notModCallbacks.get(mod)) == null) {
            mlmc = new ModLoaderModContainer(mod);
            notModCallbacks.put(mod, mlmc);
        }
        return mlmc;
    }

    public static ModLoaderModContainer registerRenderHelper(BaseMod mod) {
        ModLoaderModContainer mlmc = ModLoaderHelper.findOrBuildModContainer(mod);
        return mlmc;
    }

    public static ModLoaderModContainer registerKeyHelper(BaseMod mod) {
        ModLoaderModContainer mlmc = ModLoaderHelper.findOrBuildModContainer(mod);
        return mlmc;
    }
}

