/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import micdoodle8.mods.galacticraft.api.entity.ICargoEntity;
import micdoodle8.mods.galacticraft.api.entity.IEntityNoisy;
import micdoodle8.mods.galacticraft.api.entity.ILandable;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntitySpaceshipBase;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityTieredRocket;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.IOrbitDimension;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockLandingPadFull;
import micdoodle8.mods.galacticraft.core.client.sounds.SoundUpdaterRocket;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventLandingPadRemoval;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.tile.TileEntityLandingPad;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.block.Block;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ClassInheritanceMultiMap;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class EntityAutoRocket
extends EntitySpaceshipBase
implements ILandable,
IInventoryDefaults,
IEntityNoisy {
    public int destinationFrequency = -1;
    public BlockPos targetVec;
    public int targetDimension;
    protected NonNullList<ItemStack> stacks;
    private IFuelDock landingPad;
    public boolean landing;
    public EnumAutoLaunch autoLaunchSetting;
    public int autoLaunchCountdown;
    private BlockVec3 activeLaunchController;
    public String statusMessage;
    public String statusColour;
    public int statusMessageCooldown;
    public int lastStatusMessageCooldown;
    public boolean statusValid;
    protected double lastMotionY;
    protected double lastLastMotionY;
    private boolean waitForPlayer;
    protected ITickable rocketSoundUpdater;
    private boolean rocketSoundToStop = false;
    private static Class<?> controllerClass = null;

    public EntityAutoRocket(World world) {
        super(world);
        if (world != null && world.field_72995_K) {
            GalacticraftCore.packetPipeline.sendToServer(new PacketDynamic(this));
        }
    }

    public EntityAutoRocket(World world, double posX, double posY, double posZ) {
        this(world);
        this.func_70105_a(0.98f, 2.0f);
        this.func_70107_b(posX, posY, posZ);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = posX;
        this.field_70167_r = posY;
        this.field_70166_s = posZ;
    }

    public boolean checkLaunchValidity() {
        this.statusMessageCooldown = 40;
        if (this.hasValidFuel()) {
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal() && !this.field_70170_p.field_72995_K) {
                if (!this.setFrequency()) {
                    this.destinationFrequency = -1;
                    this.statusMessage = I18n.func_74838_a((String)"gui.message.frequency.name") + "#" + I18n.func_74838_a((String)"gui.message.not_set.name");
                    this.statusColour = "\u00a7c";
                    return false;
                }
                this.statusMessage = I18n.func_74838_a((String)"gui.message.success.name");
                this.statusColour = "\u00a7a";
                return true;
            }
        } else {
            this.destinationFrequency = -1;
            this.statusMessage = I18n.func_74838_a((String)"gui.message.not_enough.name") + "#" + I18n.func_74838_a((String)"gui.message.fuel.name");
            this.statusColour = "\u00a7c";
            return false;
        }
        this.destinationFrequency = -1;
        return false;
    }

    public boolean setFrequency() {
        TileEntity launchController;
        if (!GalacticraftCore.isPlanetsLoaded || controllerClass == null) {
            return false;
        }
        if (this.activeLaunchController != null && controllerClass.isInstance(launchController = this.activeLaunchController.getTileEntity((IBlockAccess)this.field_70170_p))) {
            try {
                int controllerFrequency;
                boolean foundPad;
                Boolean b = (Boolean)controllerClass.getMethod("validFrequency", new Class[0]).invoke((Object)launchController, new Object[0]);
                if (b != null && b.booleanValue() && (foundPad = this.setTarget(false, controllerFrequency = controllerClass.getField("destFrequency").getInt(launchController)))) {
                    this.destinationFrequency = controllerFrequency;
                    GCLog.debug("Rocket under launch control: going to target frequency " + controllerFrequency);
                    return true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.destinationFrequency = -1;
        return false;
    }

    protected boolean setTarget(boolean doSet, int destFreq) {
        if (FMLCommonHandler.instance().getMinecraftServerInstance() == null || FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c == null || !GalacticraftCore.isPlanetsLoaded || controllerClass == null) {
            return false;
        }
        WorldServer[] servers = FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c;
        for (int i = 0; i < servers.length; ++i) {
            WorldServer world = servers[i];
            try {
                for (TileEntity tile : new ArrayList(world.field_147482_g)) {
                    int controllerFrequency;
                    if (!controllerClass.isInstance(tile) || !controllerClass.isInstance(tile = world.func_175625_s(tile.func_174877_v())) || destFreq != (controllerFrequency = controllerClass.getField("frequency").getInt(tile))) continue;
                    boolean targetSet = false;
                    block4: for (int x = -2; x <= 2; ++x) {
                        for (int z = -2; z <= 2; ++z) {
                            BlockPos pos = new BlockPos((Vec3i)tile.func_174877_v().func_177982_a(x, 0, z));
                            Block block = world.func_180495_p(pos).func_177230_c();
                            if (!(block instanceof BlockLandingPadFull)) continue;
                            if (doSet) {
                                this.targetVec = pos;
                            }
                            targetSet = true;
                            break block4;
                        }
                    }
                    if (doSet) {
                        this.targetDimension = tile.func_145831_w().field_73011_w.getDimension();
                    }
                    if (!targetSet) {
                        if (doSet) {
                            this.targetVec = null;
                        }
                        return false;
                    }
                    return true;
                }
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    @Override
    public int getScaledFuelLevel(int scale) {
        if (this.getFuelTankCapacity() <= 0) {
            return 0;
        }
        return this.fuelTank.getFluidAmount() * scale / this.getFuelTankCapacity() / ConfigManagerCore.rocketFuelFactor;
    }

    @Override
    public void func_70071_h_() {
        if (this.field_70170_p.field_72995_K && this.field_70175_ag) {
            Chunk chunk = this.field_70170_p.func_72964_e(this.field_70176_ah, this.field_70164_aj);
            int cx = MathHelper.func_76128_c((double)this.field_70165_t) >> 4;
            int cz = MathHelper.func_76128_c((double)this.field_70161_v) >> 4;
            if (chunk.func_177410_o() && this.field_70176_ah == cx && this.field_70164_aj == cz) {
                boolean thisfound = false;
                ClassInheritanceMultiMap mapEntities = chunk.func_177429_s()[this.field_70162_ai];
                for (Entity ent : mapEntities) {
                    if (ent != this) continue;
                    thisfound = true;
                    break;
                }
                if (!thisfound) {
                    chunk.func_76612_a((Entity)this);
                }
            }
        }
        if (this.landing && this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal() && this.hasValidFuel() && this.targetVec != null) {
            double yDiff = this.field_70163_u - this.getOnPadYOffset() - (double)this.targetVec.func_177956_o();
            this.field_70181_x = Math.max(-2.0, (yDiff - 0.04) / -70.0);
            double diff = this.field_70165_t - (double)this.targetVec.func_177958_n() - 0.5;
            double motX = diff > 0.0 ? Math.max(-0.1, diff / -100.0) : (diff < 0.0 ? Math.min(0.1, diff / -100.0) : 0.0);
            diff = this.field_70161_v - (double)this.targetVec.func_177952_p() - 0.5;
            double motZ = diff > 0.0 ? Math.max(-0.1, diff / -100.0) : (diff < 0.0 ? Math.min(0.1, diff / -100.0) : 0.0);
            if (motZ != 0.0 || motX != 0.0) {
                double angleYaw = Math.atan(motZ / motX);
                double signed = motX < 0.0 ? 50.0 : -50.0;
                double anglePitch = Math.atan(Math.sqrt(motZ * motZ + motX * motX) / signed) * 100.0;
                this.field_70177_z = (float)angleYaw * 57.295776f;
                this.field_70125_A = (float)anglePitch * 57.295776f;
            } else {
                this.field_70125_A = 0.0f;
            }
            if (yDiff > 1.0 && yDiff < 4.0) {
                for (Object o : this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72317_d(0.0, -3.0, 0.0), EntitySpaceshipBase.rocketSelector)) {
                    if (!(o instanceof EntitySpaceshipBase)) continue;
                    ((EntitySpaceshipBase)o).dropShipAsItem();
                    ((EntitySpaceshipBase)o).func_70106_y();
                }
            }
            if (yDiff < 0.04) {
                int yMin = MathHelper.func_76128_c((double)(this.func_174813_aQ().field_72338_b - this.getOnPadYOffset() - 0.45)) - 2;
                int yMax = MathHelper.func_76128_c((double)this.func_174813_aQ().field_72337_e) + 1;
                int zMin = MathHelper.func_76128_c((double)this.field_70161_v) - 1;
                int zMax = MathHelper.func_76128_c((double)this.field_70161_v) + 1;
                for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                    for (int z = zMin; z <= zMax; ++z) {
                        for (int y = yMin; y <= yMax; ++y) {
                            if (!(this.field_70170_p.func_175625_s(new BlockPos(x, y, z)) instanceof IFuelDock)) continue;
                            this.field_70125_A = 0.0f;
                            this.failRocket();
                        }
                    }
                }
            }
        }
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            if (this.statusMessageCooldown > 0) {
                --this.statusMessageCooldown;
            }
            if (this.statusMessageCooldown == 0 && this.lastStatusMessageCooldown > 0 && this.statusValid) {
                this.autoLaunch();
            }
            if (!(this.autoLaunchCountdown <= 0 || this instanceof EntityTieredRocket && this.func_184188_bt().isEmpty() || --this.autoLaunchCountdown > 0)) {
                this.autoLaunch();
            }
            if (!(this.autoLaunchSetting != EnumAutoLaunch.ROCKET_IS_FUELED || this.fuelTank.getFluidAmount() != this.fuelTank.getCapacity() || this instanceof EntityTieredRocket && this.func_184188_bt().isEmpty())) {
                this.autoLaunch();
            }
            if (!(this.autoLaunchSetting != EnumAutoLaunch.INSTANT || this.autoLaunchCountdown != 0 || this instanceof EntityTieredRocket && this.func_184188_bt().isEmpty())) {
                this.autoLaunch();
            }
            if (this.autoLaunchSetting == EnumAutoLaunch.REDSTONE_SIGNAL && this.ticks % 11L == 0L && this.activeLaunchController != null && RedstoneUtil.isBlockReceivingRedstone(this.field_70170_p, this.activeLaunchController.toBlockPos())) {
                this.autoLaunch();
            }
            if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
                this.setPad(null);
            } else if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED.ordinal() && this.landingPad != null && this.ticks % 17L == 0L) {
                this.updateControllerSettings(this.landingPad);
            }
            this.lastStatusMessageCooldown = this.statusMessageCooldown;
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal() || this.getLaunched()) {
            if (this.rocketSoundUpdater != null) {
                this.rocketSoundUpdater.func_73660_a();
                this.rocketSoundToStop = true;
            }
        } else if (this.rocketSoundToStop) {
            this.stopRocketSound();
        }
    }

    @Override
    protected boolean shouldMoveClientSide() {
        return false;
    }

    private void autoLaunch() {
        if (this.autoLaunchSetting != null) {
            TileEntity tile;
            if (this.activeLaunchController != null && controllerClass.isInstance(tile = this.activeLaunchController.getTileEntity((IBlockAccess)this.field_70170_p))) {
                Boolean autoLaunchEnabled = null;
                try {
                    autoLaunchEnabled = controllerClass.getField("controlEnabled").getBoolean(tile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (autoLaunchEnabled != null && autoLaunchEnabled.booleanValue()) {
                    if (this.fuelTank.getFluidAmount() > this.fuelTank.getCapacity() * 2 / 5) {
                        this.ignite();
                    } else {
                        this.failMessageInsufficientFuel();
                    }
                } else {
                    this.failMessageLaunchController();
                }
            }
            this.autoLaunchSetting = null;
            return;
        }
        this.ignite();
    }

    public boolean igniteWithResult() {
        if (this.setFrequency()) {
            super.ignite();
            this.activeLaunchController = null;
            return true;
        }
        if (this.isPlayerRocket()) {
            super.ignite();
            this.activeLaunchController = null;
            return true;
        }
        this.activeLaunchController = null;
        return false;
    }

    @Override
    public void ignite() {
        this.igniteWithResult();
    }

    public abstract boolean isPlayerRocket();

    @Override
    public void landEntity(BlockPos pos) {
        IFuelDock dock;
        TileEntity tile = this.field_70170_p.func_175625_s(pos);
        if (tile instanceof IFuelDock && this.isDockValid(dock = (IFuelDock)tile)) {
            if (!this.field_70170_p.field_72995_K) {
                if (dock.getDockedEntity() instanceof EntitySpaceshipBase && dock.getDockedEntity() != this) {
                    ((EntitySpaceshipBase)((Object)dock.getDockedEntity())).dropShipAsItem();
                    ((EntitySpaceshipBase)((Object)dock.getDockedEntity())).func_70106_y();
                }
                this.setPad(dock);
            }
            this.onRocketLand(pos);
        }
    }

    public void updateControllerSettings(IFuelDock dock) {
        HashSet<ILandingPadAttachable> connectedTiles = dock.getConnectedTiles();
        try {
            block8: for (ILandingPadAttachable updatedTile : connectedTiles) {
                if (!controllerClass.isInstance(updatedTile)) continue;
                Boolean autoLaunchEnabled = controllerClass.getField("controlEnabled").getBoolean(updatedTile);
                this.activeLaunchController = new BlockVec3((TileEntity)updatedTile);
                if (autoLaunchEnabled.booleanValue()) {
                    this.autoLaunchSetting = EnumAutoLaunch.values()[controllerClass.getField("launchDropdownSelection").getInt(updatedTile)];
                    switch (this.autoLaunchSetting) {
                        case INSTANT: {
                            if (this.autoLaunchCountdown > 0 && this.autoLaunchCountdown <= 12) continue block8;
                            this.autoLaunchCountdown = 12;
                            continue block8;
                        }
                        case TIME_10_SECONDS: {
                            if (this.autoLaunchCountdown > 0 && this.autoLaunchCountdown <= 200) continue block8;
                            this.autoLaunchCountdown = 200;
                            continue block8;
                        }
                        case TIME_30_SECONDS: {
                            if (this.autoLaunchCountdown > 0 && this.autoLaunchCountdown <= 600) continue block8;
                            this.autoLaunchCountdown = 600;
                            continue block8;
                        }
                        case TIME_1_MINUTE: {
                            if (this.autoLaunchCountdown > 0 && this.autoLaunchCountdown <= 1200) continue block8;
                            this.autoLaunchCountdown = 1200;
                            continue block8;
                        }
                    }
                    continue;
                }
                this.autoLaunchSetting = null;
                this.autoLaunchCountdown = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void onRocketLand(BlockPos pos) {
        this.func_70080_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.4 + this.getOnPadYOffset(), (double)pos.func_177952_p() + 0.5, this.field_70177_z, 0.0f);
        this.stopRocketSound();
    }

    public void stopRocketSound() {
        if (this.rocketSoundUpdater != null) {
            ((SoundUpdaterRocket)this.rocketSoundUpdater).stopRocketSound();
        }
        this.rocketSoundToStop = false;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.rocketSoundUpdater != null) {
            this.rocketSoundUpdater.func_73660_a();
        }
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        super.decodePacketdata(buffer);
        this.fuelTank.setFluid(new FluidStack(GCFluids.fluidFuel, buffer.readInt()));
        this.landing = buffer.readBoolean();
        this.destinationFrequency = buffer.readInt();
        if (buffer.readBoolean()) {
            this.targetVec = new BlockPos(buffer.readInt(), buffer.readInt(), buffer.readInt());
        }
        this.field_70159_w = buffer.readDouble() / 8000.0;
        this.field_70181_x = buffer.readDouble() / 8000.0;
        this.field_70179_y = buffer.readDouble() / 8000.0;
        this.lastMotionY = buffer.readDouble() / 8000.0;
        this.lastLastMotionY = buffer.readDouble() / 8000.0;
        if (this.stacks == null) {
            this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        }
        this.setWaitForPlayer(buffer.readBoolean());
        this.statusMessage = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        this.statusMessage = this.statusMessage.equals("") ? null : this.statusMessage;
        this.statusMessageCooldown = buffer.readInt();
        this.lastStatusMessageCooldown = buffer.readInt();
        this.statusValid = buffer.readBoolean();
        if (this.field_70170_p.field_72995_K) {
            int shouldBeMountedId = buffer.readInt();
            if (this.func_184188_bt().isEmpty()) {
                Entity e;
                if (shouldBeMountedId > -1 && (e = FMLClientHandler.instance().getWorldClient().func_73045_a(shouldBeMountedId)) != null) {
                    if (e.field_71093_bK != this.field_71093_bK) {
                        if (e instanceof EntityPlayer) {
                            e = WorldUtil.forceRespawnClient(this.field_71093_bK, e.field_70170_p.func_175659_aa().func_151525_a(), e.field_70170_p.func_72912_H().func_76067_t().func_77127_a(), ((EntityPlayerMP)e).field_71134_c.func_73081_b().func_77148_a());
                            e.func_184220_m((Entity)this);
                        }
                    } else {
                        e.func_184220_m((Entity)this);
                    }
                }
            } else if (((Entity)this.func_184188_bt().get(0)).func_145782_y() != shouldBeMountedId) {
                if (shouldBeMountedId == -1) {
                    this.func_184226_ay();
                } else {
                    Entity e = FMLClientHandler.instance().getWorldClient().func_73045_a(shouldBeMountedId);
                    if (e != null) {
                        if (e.field_71093_bK != this.field_71093_bK) {
                            if (e instanceof EntityPlayer) {
                                e = WorldUtil.forceRespawnClient(this.field_71093_bK, e.field_70170_p.func_175659_aa().func_151525_a(), e.field_70170_p.func_72912_H().func_76067_t().func_77127_a(), ((EntityPlayerMP)e).field_71134_c.func_73081_b().func_77148_a());
                                e.func_184220_m((Entity)this);
                            }
                        } else {
                            e.func_184220_m((Entity)this);
                        }
                    }
                }
            }
        }
        this.statusColour = ByteBufUtils.readUTF8String((ByteBuf)buffer);
        if (this.statusColour.equals("")) {
            this.statusColour = null;
        }
    }

    @Override
    public void getNetworkedData(ArrayList<Object> list) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        super.getNetworkedData(list);
        list.add(this.fuelTank.getFluidAmount());
        list.add(this.landing);
        list.add(this.destinationFrequency);
        list.add(this.targetVec != null);
        if (this.targetVec != null) {
            list.add(this.targetVec.func_177958_n());
            list.add(this.targetVec.func_177956_o());
            list.add(this.targetVec.func_177952_p());
        }
        list.add(this.field_70159_w * 8000.0);
        list.add(this.field_70181_x * 8000.0);
        list.add(this.field_70179_y * 8000.0);
        list.add(this.lastMotionY * 8000.0);
        list.add(this.lastLastMotionY * 8000.0);
        list.add(this.getWaitForPlayer());
        list.add(this.statusMessage != null ? this.statusMessage : "");
        list.add(this.statusMessageCooldown);
        list.add(this.lastStatusMessageCooldown);
        list.add(this.statusValid);
        if (!this.field_70170_p.field_72995_K) {
            list.add(this.func_184188_bt().isEmpty() ? -1 : ((Entity)this.func_184188_bt().get(0)).func_145782_y());
        }
        list.add(this.statusColour != null ? this.statusColour : "");
    }

    @Override
    protected void failRocket() {
        if (this.shouldCancelExplosion()) {
            for (int i = -3; i <= 3; ++i) {
                BlockPos pos = new BlockPos((int)Math.floor(this.field_70165_t), (int)Math.floor(this.field_70163_u + (double)i), (int)Math.floor(this.field_70161_v));
                if (!this.landing || this.targetVec == null || !(this.field_70170_p.func_175625_s(pos) instanceof IFuelDock) || !(this.field_70163_u - (double)this.targetVec.func_177956_o() < 5.0)) continue;
                for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                    for (int y = MathHelper.func_76128_c((double)(this.field_70163_u - 3.0)); y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                        for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                            BlockPos pos1 = new BlockPos(x, y, z);
                            TileEntity tile = this.field_70170_p.func_175625_s(pos1);
                            if (!(tile instanceof IFuelDock)) continue;
                            this.landEntity(pos1);
                            return;
                        }
                    }
                }
            }
        }
        if (this.launchPhase == EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            super.failRocket();
        }
    }

    protected boolean shouldCancelExplosion() {
        return this.hasValidFuel();
    }

    public boolean hasValidFuel() {
        return this.fuelTank.getFluidAmount() > 0;
    }

    public void cancelLaunch() {
        this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED);
        this.timeUntilLaunch = 0;
        if (!this.field_70170_p.field_72995_K && !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityPlayerMP) {
            ((Entity)this.func_184188_bt().get(0)).func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate("gui.rocket.warning.nogyroscope")));
        }
    }

    public void failMessageLaunchController() {
        if (!this.field_70170_p.field_72995_K && !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.func_184188_bt().get(0)).func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate("gui.rocket.warning.launchcontroller")));
        }
    }

    public void failMessageInsufficientFuel() {
        if (!this.field_70170_p.field_72995_K && !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.func_184188_bt().get(0)).func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translate("gui.rocket.warning.fuelinsufficient")));
        }
    }

    @Override
    public void onLaunch() {
        if (this.field_70170_p.field_73011_w.getDimension() != GalacticraftCore.planetOverworld.getDimensionID() && !(this.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider)) {
            if (ConfigManagerCore.disableRocketLaunchAllNonGC) {
                this.cancelLaunch();
                return;
            }
            for (int i = ConfigManagerCore.disableRocketLaunchDimensions.length - 1; i >= 0; --i) {
                if (ConfigManagerCore.disableRocketLaunchDimensions[i] != this.field_70170_p.field_73011_w.getDimension()) continue;
                this.cancelLaunch();
                return;
            }
        }
        super.onLaunch();
        if (!this.field_70170_p.field_72995_K) {
            GCPlayerStats stats = null;
            if (!(this.field_70170_p.field_73011_w instanceof IOrbitDimension)) {
                for (Entity player : this.func_184188_bt()) {
                    if (!(player instanceof EntityPlayerMP)) continue;
                    stats = GCPlayerStats.get(player);
                    stats.setCoordsTeleportedFromX(player.field_70165_t);
                    stats.setCoordsTeleportedFromZ(player.field_70161_v);
                }
            }
            int amountRemoved = 0;
            block2: for (int x = MathHelper.func_76128_c((double)this.field_70165_t) - 1; x <= MathHelper.func_76128_c((double)this.field_70165_t) + 1; ++x) {
                for (int y = MathHelper.func_76128_c((double)this.field_70163_u) - 3; y <= MathHelper.func_76128_c((double)this.field_70163_u) + 1; ++y) {
                    for (int z = MathHelper.func_76128_c((double)this.field_70161_v) - 1; z <= MathHelper.func_76128_c((double)this.field_70161_v) + 1; ++z) {
                        BlockPos pos = new BlockPos(x, y, z);
                        Block block = this.field_70170_p.func_180495_p(pos).func_177230_c();
                        if (block == null || !(block instanceof BlockLandingPadFull) || amountRemoved >= 9) continue;
                        EventLandingPadRemoval event = new EventLandingPadRemoval(this.field_70170_p, pos);
                        MinecraftForge.EVENT_BUS.post((Event)event);
                        if (!event.allow) break block2;
                        this.field_70170_p.func_175698_g(pos);
                        amountRemoved = 9;
                        break block2;
                    }
                }
            }
            if (stats != null) {
                stats.setLaunchpadStack(amountRemoved == 9 ? new ItemStack(GCBlocks.landingPad, 9, 0) : null);
            }
            this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        if (this.fuelTank.getFluid() != null) {
            nbt.func_74782_a("fuelTank", (NBTBase)this.fuelTank.writeToNBT(new NBTTagCompound()));
        }
        if (this.func_70302_i_() > 0) {
            ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
        }
        nbt.func_74757_a("TargetValid", this.targetVec != null);
        if (this.targetVec != null) {
            nbt.func_74780_a("targetTileX", (double)this.targetVec.func_177958_n());
            nbt.func_74780_a("targetTileY", (double)this.targetVec.func_177956_o());
            nbt.func_74780_a("targetTileZ", (double)this.targetVec.func_177952_p());
        }
        nbt.func_74757_a("WaitingForPlayer", this.getWaitForPlayer());
        nbt.func_74757_a("Landing", this.landing);
        nbt.func_74768_a("AutoLaunchSetting", this.autoLaunchSetting != null ? this.autoLaunchSetting.getIndex() : -1);
        nbt.func_74768_a("TimeUntilAutoLaunch", this.autoLaunchCountdown);
        nbt.func_74768_a("DestinationFrequency", this.destinationFrequency);
        if (this.activeLaunchController != null) {
            this.activeLaunchController.writeToNBT(nbt, "ALCat");
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        if (nbt.func_74764_b("fuelTank")) {
            this.fuelTank.readFromNBT(nbt.func_74775_l("fuelTank"));
        }
        if (this.func_70302_i_() > 0) {
            this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks);
        }
        if (nbt.func_74767_n("TargetValid") && nbt.func_74764_b("targetTileX")) {
            this.targetVec = new BlockPos(MathHelper.func_76128_c((double)nbt.func_74769_h("targetTileX")), MathHelper.func_76128_c((double)nbt.func_74769_h("targetTileY")), MathHelper.func_76128_c((double)nbt.func_74769_h("targetTileZ")));
        }
        this.setWaitForPlayer(nbt.func_74767_n("WaitingForPlayer"));
        this.landing = nbt.func_74767_n("Landing");
        int autoLaunchValue = nbt.func_74762_e("AutoLaunchSetting");
        this.autoLaunchSetting = autoLaunchValue == -1 ? null : EnumAutoLaunch.values()[autoLaunchValue];
        this.autoLaunchCountdown = nbt.func_74762_e("TimeUntilAutoLaunch");
        this.destinationFrequency = nbt.func_74762_e("DestinationFrequency");
        this.activeLaunchController = BlockVec3.readFromNBT(nbt, "ALCat");
    }

    @Override
    public int addFuel(FluidStack liquid, boolean doFill) {
        return FluidUtil.fillWithGCFuel(this.fuelTank, liquid, doFill);
    }

    @Override
    public FluidStack removeFuel(int amount) {
        return this.fuelTank.drain(amount * ConfigManagerCore.rocketFuelFactor, true);
    }

    @Override
    public void setPad(IFuelDock pad) {
        this.landingPad = pad;
        if (pad != null) {
            pad.dockEntity(this);
            if (this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.IGNITED.ordinal()) {
                this.setLaunchPhase(EntitySpaceshipBase.EnumLaunchPhase.UNIGNITED);
                this.targetVec = null;
                if (GalacticraftCore.isPlanetsLoaded) {
                    this.updateControllerSettings(pad);
                }
            }
            this.landing = false;
        }
    }

    @Override
    public IFuelDock getLandingPad() {
        return this.landingPad;
    }

    @Override
    public int getMaxFuel() {
        return this.fuelTank.getCapacity();
    }

    @Override
    public boolean isDockValid(IFuelDock dock) {
        return dock instanceof TileEntityLandingPad;
    }

    @Override
    public ICargoEntity.EnumCargoLoadingState addCargo(ItemStack stack, boolean doAdd) {
        ItemStack stackAt;
        if (this.func_70302_i_() <= 3) {
            if (this.autoLaunchSetting == EnumAutoLaunch.CARGO_IS_FULL) {
                this.autoLaunch();
            }
            return ICargoEntity.EnumCargoLoadingState.NOINVENTORY;
        }
        int count = 0;
        for (count = 0; count < this.stacks.size() - 2; ++count) {
            stackAt = (ItemStack)this.stacks.get(count);
            if (stackAt.func_190926_b() || stackAt.func_77973_b() != stack.func_77973_b() || stackAt.func_77952_i() != stack.func_77952_i() || stackAt.func_190916_E() >= stackAt.func_77976_d()) continue;
            if (stackAt.func_190916_E() + stack.func_190916_E() <= stackAt.func_77976_d()) {
                if (doAdd) {
                    stackAt.func_190917_f(stack.func_190916_E());
                    this.func_70296_d();
                }
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            int origSize = stackAt.func_190916_E();
            int surplus = origSize + stack.func_190916_E() - stackAt.func_77976_d();
            if (doAdd) {
                stackAt.func_190920_e(stackAt.func_77976_d());
                this.func_70296_d();
            }
            stack.func_190920_e(surplus);
            if (this.addCargo(stack, doAdd) == ICargoEntity.EnumCargoLoadingState.SUCCESS) {
                return ICargoEntity.EnumCargoLoadingState.SUCCESS;
            }
            stackAt.func_190920_e(origSize);
            if (this.autoLaunchSetting == EnumAutoLaunch.CARGO_IS_FULL) {
                this.autoLaunch();
            }
            return ICargoEntity.EnumCargoLoadingState.FULL;
        }
        for (count = 0; count < this.stacks.size() - 2; ++count) {
            stackAt = (ItemStack)this.stacks.get(count);
            if (!stackAt.func_190926_b()) continue;
            if (doAdd) {
                this.stacks.set(count, (Object)stack);
                this.func_70296_d();
            }
            return ICargoEntity.EnumCargoLoadingState.SUCCESS;
        }
        if (this.autoLaunchSetting == EnumAutoLaunch.CARGO_IS_FULL) {
            this.autoLaunch();
        }
        return ICargoEntity.EnumCargoLoadingState.FULL;
    }

    @Override
    public ICargoEntity.RemovalResult removeCargo(boolean doRemove) {
        for (int i = 0; i < this.stacks.size() - 2; ++i) {
            ItemStack stackAt = (ItemStack)this.stacks.get(i);
            if (stackAt.func_190926_b()) continue;
            ItemStack resultStack = stackAt.func_77946_l();
            resultStack.func_190920_e(1);
            if (doRemove) {
                stackAt.func_190918_g(1);
            }
            if (doRemove) {
                this.func_70296_d();
            }
            return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.SUCCESS, resultStack);
        }
        if (this.autoLaunchSetting == EnumAutoLaunch.CARGO_IS_UNLOADED) {
            this.autoLaunch();
        }
        return new ICargoEntity.RemovalResult(ICargoEntity.EnumCargoLoadingState.EMPTY, ItemStack.field_190927_a);
    }

    public ItemStack func_70301_a(int index) {
        if (this.stacks == null) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.stacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        return ItemStackHelper.func_188383_a(this.stacks, (int)index);
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("container.spaceship.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return !this.field_70128_L && entityplayer.func_70068_e((Entity)this) <= 64.0;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return false;
    }

    public void func_70296_d() {
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public void onPadDestroyed() {
        if (!this.field_70128_L && this.launchPhase != EntitySpaceshipBase.EnumLaunchPhase.LAUNCHED.ordinal()) {
            this.dropShipAsItem();
            this.func_70106_y();
        }
    }

    @Override
    public List<ItemStack> getItemsDropped(List<ItemStack> droppedItemList) {
        if (this.stacks != null) {
            for (ItemStack item : this.stacks) {
                if (item == null || item.func_190926_b()) continue;
                droppedItemList.add(item);
            }
        }
        return droppedItemList;
    }

    public boolean getWaitForPlayer() {
        return this.waitForPlayer;
    }

    public void setWaitForPlayer(boolean waitForPlayer) {
        this.waitForPlayer = waitForPlayer;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ITickable getSoundUpdater() {
        return this.rocketSoundUpdater;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISound setSoundUpdater(EntityPlayerSP player) {
        this.rocketSoundUpdater = new SoundUpdaterRocket(player, this);
        return (ISound)this.rocketSoundUpdater;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_145770_h(double x, double y, double z) {
        double d0 = this.field_70165_t - x;
        double d1 = this.field_70163_u - y;
        double d2 = this.field_70161_v - z;
        double d3 = d0 * d0 + d1 * d1 + d2 * d2;
        return d3 < 262144.0;
    }

    static {
        try {
            controllerClass = Class.forName("micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController");
        }
        catch (ClassNotFoundException e) {
            GCLog.info("Galacticraft-Planets' LaunchController not present, rockets will not be launch controlled.");
        }
    }

    public static enum EnumAutoLaunch {
        CARGO_IS_UNLOADED(0, "cargo_unloaded"),
        CARGO_IS_FULL(1, "cargo_full"),
        ROCKET_IS_FUELED(2, "fully_fueled"),
        INSTANT(3, "instant"),
        TIME_10_SECONDS(4, "ten_sec"),
        TIME_30_SECONDS(5, "thirty_sec"),
        TIME_1_MINUTE(6, "one_min"),
        REDSTONE_SIGNAL(7, "redstone_sig");

        private final int index;
        private String title;

        private EnumAutoLaunch(int index, String title) {
            this.index = index;
            this.title = title;
        }

        public int getIndex() {
            return this.index;
        }

        public String getTitle() {
            return GCCoreUtil.translate("gui.message." + this.title + ".name");
        }
    }
}

