/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.prefab.world.gen;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.Arrays;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.village.VillageCollection;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.biome.BiomeProvider;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkGenerator;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class WorldProviderSpace
extends WorldProvider
implements IGalacticraftWorldProvider {
    long timeCurrentOffset = 0L;
    long preTickTime = Long.MIN_VALUE;
    static Field tickCounter;

    public abstract Vector3 getFogColor();

    public abstract Vector3 getSkyColor();

    @Deprecated
    public boolean canRainOrSnow() {
        return false;
    }

    public abstract boolean hasSunset();

    public abstract long getDayLength();

    public abstract Class<? extends IChunkGenerator> getChunkProviderClass();

    public abstract Class<? extends BiomeProvider> getBiomeProviderClass();

    public void setDimension(int var1) {
        super.setDimension(var1);
    }

    public void updateWeather() {
        if (!this.field_76579_a.field_72995_K) {
            long newTime = this.field_76579_a.func_72912_H().func_76073_f();
            if (this.preTickTime == Long.MIN_VALUE) {
                int savedTick = 0;
                try {
                    tickCounter.setAccessible(true);
                    savedTick = tickCounter.getInt(this.field_76579_a.field_72982_D);
                    if (savedTick < 0) {
                        savedTick = 0;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.timeCurrentOffset = (long)savedTick - newTime;
            } else {
                long diff = newTime - this.preTickTime;
                if (diff > 1L) {
                    this.timeCurrentOffset -= diff - 1L;
                    this.saveTime();
                }
            }
            this.preTickTime = newTime;
        }
        if (this.shouldDisablePrecipitation()) {
            this.field_76579_a.func_72912_H().func_76080_g(0);
            this.field_76579_a.func_72912_H().func_76084_b(false);
            this.field_76579_a.func_72912_H().func_76090_f(0);
            this.field_76579_a.func_72912_H().func_76069_a(false);
            this.field_76579_a.field_73004_o = 0.0f;
            this.field_76579_a.field_73017_q = 0.0f;
        } else {
            super.updateWeather();
        }
    }

    public String getSaveFolder() {
        return "DIM" + this.getCelestialBody().getDimensionID();
    }

    public String getWelcomeMessage() {
        return "Entering " + this.getCelestialBody().getLocalizedName();
    }

    public String getDepartMessage() {
        return "Leaving " + this.getCelestialBody().getLocalizedName();
    }

    @Override
    public boolean isGasPresent(IAtmosphericGas gas) {
        return this.getCelestialBody().atmosphere.isGasPresent(gas);
    }

    @Override
    public boolean hasNoAtmosphere() {
        return this.getCelestialBody().atmosphere.hasNoGases();
    }

    @Override
    public boolean hasBreathableAtmosphere() {
        return this.getCelestialBody().atmosphere.isBreathable();
    }

    @Override
    public boolean shouldDisablePrecipitation() {
        return !this.getCelestialBody().atmosphere.hasPrecipitation();
    }

    @Override
    public float getSoundVolReductionAmount() {
        float d = this.getCelestialBody().atmosphere.relativeDensity();
        if (d <= 0.0f) {
            return 20.0f;
        }
        if (d > 5.0f) {
            return 0.2f;
        }
        return 1.0f / d;
    }

    @Override
    public float getThermalLevelModifier() {
        return this.getCelestialBody().atmosphere.thermalLevel();
    }

    @Override
    public float getWindLevel() {
        return this.getCelestialBody().atmosphere.windLevel();
    }

    @Override
    public boolean shouldCorrodeArmor() {
        return this.getCelestialBody().atmosphere.isCorrosive();
    }

    public boolean canBlockFreeze(BlockPos pos, boolean byWater) {
        return !this.shouldDisablePrecipitation();
    }

    public boolean canDoLightning(Chunk chunk) {
        return !this.shouldDisablePrecipitation();
    }

    public boolean canDoRainSnowIce(Chunk chunk) {
        return !this.shouldDisablePrecipitation();
    }

    @Override
    public float getSolarSize() {
        return 1.0f / this.getCelestialBody().getRelativeDistanceFromCenter().unScaledDistance;
    }

    public float[] func_76560_a(float var1, float var2) {
        return this.hasSunset() ? super.func_76560_a(var1, var2) : null;
    }

    public float func_76563_a(long par1, float par3) {
        par1 = this.getWorldTime();
        int j = (int)(par1 % this.getDayLength());
        float f1 = ((float)j + par3) / (float)this.getDayLength() - 0.25f;
        if (f1 < 0.0f) {
            f1 += 1.0f;
        }
        if (f1 > 1.0f) {
            f1 -= 1.0f;
        }
        float f2 = f1;
        f1 = 0.5f - MathHelper.func_76134_b((float)(f1 * (float)Math.PI)) / 2.0f;
        return f2 + (f1 - f2) / 3.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public Vec3d func_76562_b(float var1, float var2) {
        Vector3 fogColor = this.getFogColor();
        return new Vec3d((double)fogColor.floatX(), (double)fogColor.floatY(), (double)fogColor.floatZ());
    }

    public Vec3d getSkyColor(Entity cameraEntity, float partialTicks) {
        Vector3 skyColor = this.getSkyColor();
        return new Vec3d((double)skyColor.floatX(), (double)skyColor.floatY(), (double)skyColor.floatZ());
    }

    public boolean func_76561_g() {
        return true;
    }

    public boolean func_76569_d() {
        return this.field_76579_a == null ? false : this.field_76579_a.field_72995_K;
    }

    public boolean func_76567_e() {
        return false;
    }

    public int getRespawnDimension(EntityPlayerMP player) {
        return this.shouldForceRespawn() ? this.getDimension() : 0;
    }

    public boolean shouldForceRespawn() {
        return !ConfigManagerCore.forceOverworldRespawn;
    }

    @Override
    public boolean netherPortalsOperational() {
        return false;
    }

    @Override
    public float getArrowGravity() {
        return 0.005f;
    }

    public IChunkGenerator func_186060_c() {
        try {
            Class<? extends IChunkGenerator> chunkProviderClass = this.getChunkProviderClass();
            Constructor<?>[] constructors = chunkProviderClass.getConstructors();
            for (int i = 0; i < constructors.length; ++i) {
                Constructor<?> constr = constructors[i];
                if (Arrays.equals(constr.getParameterTypes(), new Object[]{World.class, Long.TYPE, Boolean.TYPE})) {
                    return (IChunkGenerator)constr.newInstance(this.field_76579_a, this.field_76579_a.func_72905_C(), this.field_76579_a.func_72912_H().func_76089_r());
                }
                if (constr.getParameterTypes().length != 0) continue;
                return (IChunkGenerator)constr.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    protected void func_76572_b() {
        super.func_76572_b();
        if (this.getBiomeProviderClass() != null) {
            try {
                Constructor<?>[] constructors;
                Class<? extends BiomeProvider> chunkManagerClass = this.getBiomeProviderClass();
                for (Constructor<?> constr : constructors = chunkManagerClass.getConstructors()) {
                    if (Arrays.equals(constr.getParameterTypes(), new Object[]{World.class})) {
                        this.field_76578_c = (BiomeProvider)constr.newInstance(this.field_76579_a);
                        continue;
                    }
                    if (constr.getParameterTypes().length != 0) continue;
                    this.field_76578_c = (BiomeProvider)constr.newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean shouldMapSpin(String entity, double x, double y, double z) {
        return false;
    }

    public void setWorldTime(long time) {
        this.field_76579_a.func_72912_H().func_76068_b(time);
        long diff = -this.timeCurrentOffset;
        this.timeCurrentOffset = time - this.field_76579_a.func_72912_H().func_76073_f();
        this.preTickTime += (diff += this.timeCurrentOffset);
        if (diff != 0L) {
            this.saveTime();
        }
    }

    public long getWorldTime() {
        return this.field_76579_a.func_72912_H().func_76073_f() + this.timeCurrentOffset;
    }

    public void adjustTimeOffset(long diff) {
        this.timeCurrentOffset -= diff;
        this.preTickTime += diff;
        if (diff != 0L) {
            this.saveTime();
        }
    }

    private void saveTime() {
        try {
            VillageCollection vc = this.field_76579_a.field_72982_D;
            tickCounter.setAccessible(true);
            tickCounter.setInt(vc, (int)this.getWorldTime());
            vc.func_76185_a();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            tickCounter = VillageCollection.class.getDeclaredField(GCCoreUtil.isDeobfuscated() ? "tickCounter" : "field_75553_e");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

