/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.api.world;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.world.IAtmosphericGas;

public class AtmosphereInfo {
    private final Boolean isBreathable;
    private final boolean hasPrecipitation;
    private final boolean isCorrosive;
    private final float thermalLevel;
    private final float windLevel;
    private final float density;
    public ArrayList<IAtmosphericGas> composition = new ArrayList();

    public AtmosphereInfo(Boolean breathable, boolean precipitation, boolean corrosive, float relativeTemperature, float windLevel, float density) {
        this.isBreathable = breathable;
        this.hasPrecipitation = precipitation;
        this.isCorrosive = corrosive;
        this.thermalLevel = relativeTemperature;
        this.windLevel = windLevel;
        this.density = density;
    }

    public boolean isBreathable() {
        if (this.isBreathable == null) {
            return this.isGasPresent(IAtmosphericGas.OXYGEN) && !this.isGasPresent(IAtmosphericGas.CO2);
        }
        return this.isBreathable;
    }

    public boolean hasPrecipitation() {
        return this.hasPrecipitation;
    }

    public boolean isCorrosive() {
        return this.isCorrosive;
    }

    public float thermalLevel() {
        return this.thermalLevel;
    }

    public float windLevel() {
        return this.windLevel;
    }

    public float relativeDensity() {
        return this.density;
    }

    public boolean isGasPresent(IAtmosphericGas gas) {
        return this.composition.contains((Object)gas);
    }

    public boolean hasNoGases() {
        return this.composition.isEmpty();
    }
}

