/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.blocks;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.tile.IColorable;
import micdoodle8.mods.galacticraft.api.transmission.NetworkType;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockTransmitter;
import micdoodle8.mods.galacticraft.core.blocks.ISortableBlock;
import micdoodle8.mods.galacticraft.core.items.IShiftDescription;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tile.TileEntityFluidPipe;
import micdoodle8.mods.galacticraft.core.util.EnumSortCategoryBlock;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockFluidPipe
extends BlockTransmitter
implements ITileEntityProvider,
IShiftDescription,
ISortableBlock {
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    public static boolean ignoreDrop = false;
    private EnumPipeMode mode;
    private static final float MIN = 0.35f;
    private static final float MAX = 0.65f;
    protected static final AxisAlignedBB[] BOUNDING_BOXES = new AxisAlignedBB[]{new AxisAlignedBB((double)0.35f, (double)0.35f, (double)0.35f, (double)0.65f, (double)0.65f, (double)0.65f), new AxisAlignedBB((double)0.35f, (double)0.35f, (double)0.35f, (double)0.65f, (double)0.65f, 1.0), new AxisAlignedBB(0.0, (double)0.35f, (double)0.35f, (double)0.65f, (double)0.65f, (double)0.65f), new AxisAlignedBB(0.0, (double)0.35f, (double)0.35f, (double)0.65f, (double)0.65f, 1.0), new AxisAlignedBB((double)0.35f, (double)0.35f, 0.0, (double)0.65f, (double)0.65f, (double)0.65f), new AxisAlignedBB((double)0.35f, (double)0.35f, 0.0, (double)0.65f, (double)0.65f, 1.0), new AxisAlignedBB(0.0, (double)0.35f, 0.0, (double)0.65f, (double)0.65f, (double)0.65f), new AxisAlignedBB(0.0, (double)0.35f, 0.0, (double)0.65f, (double)0.65f, 1.0), new AxisAlignedBB((double)0.35f, (double)0.35f, (double)0.35f, 1.0, (double)0.65f, (double)0.65f), new AxisAlignedBB((double)0.35f, (double)0.35f, (double)0.35f, 1.0, (double)0.65f, 1.0), new AxisAlignedBB(0.0, (double)0.35f, (double)0.35f, 1.0, (double)0.65f, (double)0.65f), new AxisAlignedBB(0.0, (double)0.35f, (double)0.35f, 1.0, (double)0.65f, 1.0), new AxisAlignedBB((double)0.35f, (double)0.35f, 0.0, 1.0, (double)0.65f, (double)0.65f), new AxisAlignedBB((double)0.35f, (double)0.35f, 0.0, 1.0, (double)0.65f, 1.0), new AxisAlignedBB(0.0, (double)0.35f, 0.0, 1.0, (double)0.65f, (double)0.65f), new AxisAlignedBB(0.0, (double)0.35f, 0.0, 1.0, (double)0.65f, 1.0), new AxisAlignedBB((double)0.35f, 0.0, (double)0.35f, (double)0.65f, (double)0.65f, (double)0.65f), new AxisAlignedBB((double)0.35f, 0.0, (double)0.35f, (double)0.65f, (double)0.65f, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.35f, (double)0.65f, (double)0.65f, (double)0.65f), new AxisAlignedBB(0.0, 0.0, (double)0.35f, (double)0.65f, (double)0.65f, 1.0), new AxisAlignedBB((double)0.35f, 0.0, 0.0, (double)0.65f, (double)0.65f, (double)0.65f), new AxisAlignedBB((double)0.35f, 0.0, 0.0, (double)0.65f, (double)0.65f, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.65f, (double)0.65f, (double)0.65f), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.65f, (double)0.65f, 1.0), new AxisAlignedBB((double)0.35f, 0.0, (double)0.35f, 1.0, (double)0.65f, (double)0.65f), new AxisAlignedBB((double)0.35f, 0.0, (double)0.35f, 1.0, (double)0.65f, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.35f, 1.0, (double)0.65f, (double)0.65f), new AxisAlignedBB(0.0, 0.0, (double)0.35f, 1.0, (double)0.65f, 1.0), new AxisAlignedBB((double)0.35f, 0.0, 0.0, 1.0, (double)0.65f, (double)0.65f), new AxisAlignedBB((double)0.35f, 0.0, 0.0, 1.0, (double)0.65f, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.65f, (double)0.65f), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)0.65f, 1.0), new AxisAlignedBB((double)0.35f, (double)0.35f, (double)0.35f, (double)0.65f, 1.0, (double)0.65f), new AxisAlignedBB((double)0.35f, (double)0.35f, (double)0.35f, (double)0.65f, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.35f, (double)0.35f, (double)0.65f, 1.0, (double)0.65f), new AxisAlignedBB(0.0, (double)0.35f, (double)0.35f, (double)0.65f, 1.0, 1.0), new AxisAlignedBB((double)0.35f, (double)0.35f, 0.0, (double)0.65f, 1.0, (double)0.65f), new AxisAlignedBB((double)0.35f, (double)0.35f, 0.0, (double)0.65f, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.35f, 0.0, (double)0.65f, 1.0, (double)0.65f), new AxisAlignedBB(0.0, (double)0.35f, 0.0, (double)0.65f, 1.0, 1.0), new AxisAlignedBB((double)0.35f, (double)0.35f, (double)0.35f, 1.0, 1.0, (double)0.65f), new AxisAlignedBB((double)0.35f, (double)0.35f, (double)0.35f, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.35f, (double)0.35f, 1.0, 1.0, (double)0.65f), new AxisAlignedBB(0.0, (double)0.35f, (double)0.35f, 1.0, 1.0, 1.0), new AxisAlignedBB((double)0.35f, (double)0.35f, 0.0, 1.0, 1.0, (double)0.65f), new AxisAlignedBB((double)0.35f, (double)0.35f, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, (double)0.35f, 0.0, 1.0, 1.0, (double)0.65f), new AxisAlignedBB(0.0, (double)0.35f, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB((double)0.35f, 0.0, (double)0.35f, (double)0.65f, 1.0, (double)0.65f), new AxisAlignedBB((double)0.35f, 0.0, (double)0.35f, (double)0.65f, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.35f, (double)0.65f, 1.0, (double)0.65f), new AxisAlignedBB(0.0, 0.0, (double)0.35f, (double)0.65f, 1.0, 1.0), new AxisAlignedBB((double)0.35f, 0.0, 0.0, (double)0.65f, 1.0, (double)0.65f), new AxisAlignedBB((double)0.35f, 0.0, 0.0, (double)0.65f, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.65f, 1.0, (double)0.65f), new AxisAlignedBB(0.0, 0.0, 0.0, (double)0.65f, 1.0, 1.0), new AxisAlignedBB((double)0.35f, 0.0, (double)0.35f, 1.0, 1.0, (double)0.65f), new AxisAlignedBB((double)0.35f, 0.0, (double)0.35f, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, (double)0.35f, 1.0, 1.0, (double)0.65f), new AxisAlignedBB(0.0, 0.0, (double)0.35f, 1.0, 1.0, 1.0), new AxisAlignedBB((double)0.35f, 0.0, 0.0, 1.0, 1.0, (double)0.65f), new AxisAlignedBB((double)0.35f, 0.0, 0.0, 1.0, 1.0, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, (double)0.65f), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    public BlockFluidPipe(String assetName, EnumPipeMode mode) {
        super(Material.field_151592_s);
        this.func_149711_c(0.3f);
        this.func_149672_a(SoundType.field_185853_f);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)EnumDyeColor.WHITE));
        this.func_149663_c(assetName);
        this.mode = mode;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        state = this.func_176221_a(state, source, pos);
        return BOUNDING_BOXES[BlockFluidPipe.getBoundingBoxIdx(state)];
    }

    private static int getBoundingBoxIdx(IBlockState state) {
        int i = 0;
        if (((Boolean)state.func_177229_b((IProperty)NORTH)).booleanValue()) {
            i |= 1 << EnumFacing.NORTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)EAST)).booleanValue()) {
            i |= 1 << EnumFacing.EAST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)SOUTH)).booleanValue()) {
            i |= 1 << EnumFacing.SOUTH.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)WEST)).booleanValue()) {
            i |= 1 << EnumFacing.WEST.func_176736_b();
        }
        if (((Boolean)state.func_177229_b((IProperty)DOWN)).booleanValue()) {
            i |= 0x10;
        }
        if (((Boolean)state.func_177229_b((IProperty)UP)).booleanValue()) {
            i |= 0x20;
        }
        return i;
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        TileEntityFluidPipe tile = (TileEntityFluidPipe)worldIn.func_175625_s(pos);
        int pipeColor = ((EnumDyeColor)state.func_177229_b(COLOR)).func_176767_b();
        if (!ignoreDrop && tile != null && pipeColor != 15) {
            this.spawnItem(worldIn, pos, pipeColor);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)GCBlocks.oxygenPipe);
    }

    @Override
    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, blockIn, fromPos);
        worldIn.func_175679_n(pos);
    }

    public CreativeTabs func_149708_J() {
        if (this.mode == EnumPipeMode.NORMAL) {
            return GalacticraftCore.galacticraftBlocksTab;
        }
        return null;
    }

    @Override
    public boolean onUseWrench(World world, BlockPos pos, EntityPlayer entityPlayer, EnumHand hand, ItemStack heldItem, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileEntityFluidPipe tile = (TileEntityFluidPipe)world.func_175625_s(pos);
            tile.switchType();
        }
        return true;
    }

    @Override
    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        TileEntityFluidPipe tileEntity = (TileEntityFluidPipe)worldIn.func_175625_s(pos);
        if (super.func_180639_a(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ)) {
            return true;
        }
        if (!worldIn.field_72995_K && (stack = playerIn.field_71071_by.func_70448_g()) != null && stack.func_77973_b() instanceof ItemDye) {
            int dyeColor = playerIn.field_71071_by.func_70448_g().func_77952_i();
            byte colorBefore = tileEntity.getColor(state);
            tileEntity.onColorUpdate();
            worldIn.func_175656_a(pos, state.func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176766_a((int)dyeColor)));
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_RECOLOR_PIPE, GCCoreUtil.getDimensionID(worldIn), new Object[]{pos}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(worldIn), (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 40.0));
            if (colorBefore != (byte)dyeColor && !playerIn.field_71075_bZ.field_75098_d) {
                playerIn.field_71071_by.func_70448_g().func_190918_g(1);
            }
            if (colorBefore != (byte)dyeColor && colorBefore != 15) {
                this.spawnItem(worldIn, pos, colorBefore);
            }
            BlockPos tileVec = tileEntity.func_174877_v();
            for (EnumFacing dir : EnumFacing.values()) {
                TileEntity tileAt = worldIn.func_175625_s(tileVec.func_177972_a(dir));
                if (tileAt == null || !(tileAt instanceof IColorable)) continue;
                ((IColorable)tileAt).onAdjacentColorChanged(dir);
            }
            return true;
        }
        return false;
    }

    private void spawnItem(World worldIn, BlockPos pos, int colorBefore) {
        float f = 0.7f;
        Random syncRandom = GCCoreUtil.getRandom(pos);
        double d0 = (double)(syncRandom.nextFloat() * 0.7f) + (double)0.15f;
        double d1 = (double)(syncRandom.nextFloat() * 0.7f) + 0.06000000238418579 + 0.6;
        double d2 = (double)(syncRandom.nextFloat() * 0.7f) + (double)0.15f;
        EntityItem entityitem = new EntityItem(worldIn, (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, new ItemStack(Items.field_151100_aR, 1, colorBefore));
        entityitem.func_174869_p();
        worldIn.func_72838_d((Entity)entityitem);
    }

    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityFluidPipe();
    }

    @Override
    public NetworkType getNetworkType(IBlockState state) {
        return NetworkType.FLUID;
    }

    @Override
    public String getShiftDescription(int meta) {
        return GCCoreUtil.translate(this.func_149739_a() + ".description");
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR, UP, DOWN, NORTH, EAST, SOUTH, WEST});
    }

    @Override
    public boolean showDescription(int meta) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }

    @Override
    public EnumSortCategoryBlock getCategory(int meta) {
        return EnumSortCategoryBlock.TRANSMITTER;
    }

    public EnumPipeMode getMode() {
        return this.mode;
    }

    public static enum EnumPipeMode implements IStringSerializable
    {
        NORMAL(0, "normal"),
        PULL(1, "pull");

        private final int meta;
        private final String name;

        private EnumPipeMode(int meta, String name) {
            this.meta = meta;
            this.name = name;
        }

        public int getMeta() {
            return this.meta;
        }

        public static EnumPipeMode byMetadata(int ordinal) {
            return EnumPipeMode.values()[ordinal];
        }

        public String func_176610_l() {
            return this.name;
        }
    }
}

