/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.dimension;

import java.util.ArrayList;
import micdoodle8.mods.galacticraft.api.galaxies.GalaxyRegistry;
import micdoodle8.mods.galacticraft.api.galaxies.Satellite;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import net.minecraft.world.WorldSavedData;
import net.minecraftforge.common.DimensionManager;

public class SpaceStationWorldData
extends WorldSavedData {
    private String spaceStationName = "NoName";
    private String owner = "NoOwner";
    private ArrayList<String> allowedPlayers = new ArrayList<String>(){

        @Override
        public boolean contains(Object o) {
            if (o instanceof String) {
                String paramStr = (String)o;
                for (String s : this) {
                    if (!paramStr.equalsIgnoreCase(s)) continue;
                    return true;
                }
            }
            return false;
        }
    };
    private boolean allowAllPlayers;
    private int homePlanet;
    private int dimensionIdDynamic;
    private int dimensionIdStatic;
    private NBTTagCompound dataCompound;

    public SpaceStationWorldData(String par1Str) {
        super(par1Str);
    }

    public ArrayList<String> getAllowedPlayers() {
        return this.allowedPlayers;
    }

    public boolean getAllowedAll() {
        return this.allowAllPlayers;
    }

    public void setAllowedAll(boolean b) {
        this.allowAllPlayers = b;
        this.func_76185_a();
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String name) {
        this.owner = name.replace(".", "");
        this.func_76185_a();
    }

    public String getSpaceStationName() {
        return this.spaceStationName;
    }

    public int getHomePlanet() {
        return this.homePlanet;
    }

    public void setSpaceStationName(String string) {
        this.spaceStationName = string;
    }

    public int getDimensionIdStatic() {
        return this.dimensionIdStatic;
    }

    public void setDimensionIdStatic(int dimensionIdStatic) {
        this.dimensionIdStatic = dimensionIdStatic;
    }

    public int getDimensionIdDynamic() {
        return this.dimensionIdDynamic;
    }

    public void setDimensionIdDynamic(int dimensionIdDynamic) {
        this.dimensionIdDynamic = dimensionIdDynamic;
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        this.owner = nbttagcompound.func_74779_i("owner").replace(".", "");
        this.spaceStationName = nbttagcompound.func_74779_i("spaceStationName");
        this.dataCompound = nbttagcompound.func_74764_b("dataCompound") ? nbttagcompound.func_74775_l("dataCompound") : new NBTTagCompound();
        if (nbttagcompound.func_74764_b("homePlanet")) {
            this.homePlanet = nbttagcompound.func_74762_e("homePlanet");
        } else {
            GCLog.info("Home planet data not found in space station save file for \"" + this.spaceStationName + "\". Using default overworld.");
            this.homePlanet = 0;
        }
        if (nbttagcompound.func_74764_b("dimensionIdStatic")) {
            this.dimensionIdStatic = nbttagcompound.func_74762_e("dimensionIdStatic");
        } else {
            GCLog.info("Static dimension ID not found in space station save file for \"" + this.spaceStationName + "\". Using default overworld.");
            this.dimensionIdStatic = ConfigManagerCore.idDimensionOverworldOrbitStatic;
        }
        if (nbttagcompound.func_74764_b("dimensionIdDynamic")) {
            this.dimensionIdDynamic = nbttagcompound.func_74762_e("dimensionIdDynamic");
        } else {
            GCLog.info("Dynamic dimension ID not found in space station save file for \"" + this.spaceStationName + "\". Using default overworld.");
            this.dimensionIdDynamic = ConfigManagerCore.idDimensionOverworldOrbit;
        }
        this.allowAllPlayers = nbttagcompound.func_74767_n("allowedAll");
        NBTTagList var2 = nbttagcompound.func_150295_c("allowedPlayers", 10);
        this.allowedPlayers.clear();
        for (int var3 = 0; var3 < var2.func_74745_c(); ++var3) {
            NBTTagCompound var4 = var2.func_150305_b(var3);
            String var5 = var4.func_74779_i("allowedPlayer");
            if (this.allowedPlayers.contains(var5)) continue;
            this.allowedPlayers.add(var5);
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74778_a("owner", this.owner);
        nbttagcompound.func_74778_a("spaceStationName", this.spaceStationName);
        nbttagcompound.func_74768_a("homePlanet", this.homePlanet);
        nbttagcompound.func_74768_a("dimensionIdDynamic", this.dimensionIdDynamic);
        nbttagcompound.func_74768_a("dimensionIdStatic", this.dimensionIdStatic);
        nbttagcompound.func_74782_a("dataCompound", (NBTBase)this.dataCompound);
        nbttagcompound.func_74757_a("allowedAll", this.allowAllPlayers);
        NBTTagList var2 = new NBTTagList();
        for (int var3 = 0; var3 < this.allowedPlayers.size(); ++var3) {
            String player = this.allowedPlayers.get(var3);
            if (player == null) continue;
            NBTTagCompound var4 = new NBTTagCompound();
            var4.func_74778_a("allowedPlayer", player);
            var2.func_74742_a((NBTBase)var4);
        }
        nbttagcompound.func_74782_a("allowedPlayers", (NBTBase)var2);
        return nbttagcompound;
    }

    public static SpaceStationWorldData getStationData(World world, int stationID, EntityPlayer player) {
        return SpaceStationWorldData.getStationData(world, stationID, -1, -1, -1, player);
    }

    public static SpaceStationWorldData getStationData(World world, int stationID, int homeID, int providerIdDynamic, int providerIdStatic, EntityPlayer owner) {
        DimensionType providerType = DimensionManager.getProviderType((int)stationID);
        boolean foundMatch = false;
        for (Satellite satellite : GalaxyRegistry.getRegisteredSatellites().values()) {
            if (satellite.getDimensionIdStatic() != providerType.func_186068_a() && satellite.getDimensionID() != providerType.func_186068_a()) continue;
            foundMatch = true;
            break;
        }
        if (!foundMatch) {
            return null;
        }
        String stationIdentifier = SpaceStationWorldData.getSpaceStationID(stationID);
        SpaceStationWorldData stationData = (SpaceStationWorldData)world.func_72943_a(SpaceStationWorldData.class, stationIdentifier);
        if (stationData == null) {
            stationData = new SpaceStationWorldData(stationIdentifier);
            world.func_72823_a(stationIdentifier, (WorldSavedData)stationData);
            stationData.dataCompound = new NBTTagCompound();
            if (owner != null) {
                stationData.owner = owner.func_146103_bH().getName().replace(".", "");
            }
            stationData.spaceStationName = "Station: " + stationData.owner;
            if (owner != null) {
                stationData.allowedPlayers.add(owner.func_146103_bH().getName());
            }
            if (homeID == -1) {
                throw new RuntimeException("Space station being created on bad home planet ID!");
            }
            stationData.homePlanet = homeID;
            if (providerIdDynamic == -1 || providerIdStatic == -1) {
                throw new RuntimeException("Space station being created on bad provider IDs!");
            }
            stationData.dimensionIdDynamic = providerIdDynamic;
            stationData.dimensionIdStatic = providerIdStatic;
            stationData.func_76185_a();
        }
        if (stationData.getSpaceStationName().replace(" ", "").isEmpty()) {
            stationData.setSpaceStationName("Station: " + stationData.owner);
            stationData.func_76185_a();
        }
        return stationData;
    }

    public static SpaceStationWorldData getMPSpaceStationData(World var0, int var1, EntityPlayer player) {
        String var2 = SpaceStationWorldData.getSpaceStationID(var1);
        if (var0 == null) {
            var0 = GalacticraftCore.proxy.getWorldForID(0);
        }
        SpaceStationWorldData var3 = null;
        if (var0 != null) {
            var3 = (SpaceStationWorldData)var0.func_72943_a(SpaceStationWorldData.class, var2);
        } else {
            GCLog.severe("No world for dimension 0?  That should be unpossible!  Please report at https://github.com/micdoodle8/Galacticraft/issues/2617");
        }
        if (var3 == null) {
            var3 = new SpaceStationWorldData(var2);
            var0.func_72823_a(var2, (WorldSavedData)var3);
            var3.dataCompound = new NBTTagCompound();
            if (player != null) {
                var3.owner = player.func_146103_bH().getName().replace(".", "");
            }
            var3.spaceStationName = "Station: " + var3.owner;
            if (player != null) {
                var3.allowedPlayers.add(player.func_146103_bH().getName());
            }
            var3.func_76185_a();
        }
        if (var3.getSpaceStationName().replace(" ", "").isEmpty()) {
            var3.setSpaceStationName("Station: " + var3.owner);
            var3.func_76185_a();
        }
        return var3;
    }

    public static String getSpaceStationID(int dimID) {
        return "spacestation_" + dimID;
    }

    public static void updateSSOwnership(EntityPlayerMP player, String playerName, GCPlayerStats stats, int stationID, SpaceStationWorldData stationData) {
        if (stationData == null) {
            stationData = SpaceStationWorldData.getMPSpaceStationData(null, stationID, null);
        }
        if (stationData.owner.equals(playerName)) {
            if (!stats.getSpaceStationDimensionData().values().contains(stationID)) {
                GCLog.debug("Player owns station: " + stationData.getSpaceStationName() + " with home planet " + stationData.getHomePlanet());
                stats.getSpaceStationDimensionData().put(stationData.getHomePlanet(), stationID);
            }
        } else {
            Integer savedOwned = stats.getSpaceStationDimensionData().get(stationData.getHomePlanet());
            if (savedOwned != null && savedOwned == stationID) {
                GCLog.debug("Player does not own station: " + stationData.getSpaceStationName() + " with home planet " + stationData.getHomePlanet());
                stats.getSpaceStationDimensionData().remove(savedOwned);
            }
        }
    }

    public static void checkAllStations(EntityPlayerMP thePlayer, GCPlayerStats stats) {
        String name = thePlayer.func_146103_bH().getName().replace(".", "");
        for (int id : WorldUtil.registeredSpaceStations.keySet()) {
            SpaceStationWorldData.updateSSOwnership(thePlayer, name, stats, id, null);
        }
    }
}

