/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.GalacticraftRegistry;
import micdoodle8.mods.galacticraft.api.event.oxygen.GCCoreOxygenSuffocationEvent;
import micdoodle8.mods.galacticraft.api.item.EnumExtendedInventorySlot;
import micdoodle8.mods.galacticraft.api.item.IHoldableItem;
import micdoodle8.mods.galacticraft.api.item.IItemThermal;
import micdoodle8.mods.galacticraft.api.prefab.entity.EntityAutoRocket;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.api.world.ITeleportType;
import micdoodle8.mods.galacticraft.api.world.IZeroGDimension;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockUnlitTorch;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRace;
import micdoodle8.mods.galacticraft.core.dimension.SpaceRaceManager;
import micdoodle8.mods.galacticraft.core.dimension.WorldProviderSpaceStation;
import micdoodle8.mods.galacticraft.core.entities.EntityCelestialFake;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.entities.EntityMeteor;
import micdoodle8.mods.galacticraft.core.entities.EntityParachest;
import micdoodle8.mods.galacticraft.core.entities.player.CapabilityProviderStats;
import micdoodle8.mods.galacticraft.core.entities.player.CapabilityProviderStatsClient;
import micdoodle8.mods.galacticraft.core.entities.player.GCCapabilities;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.items.ItemParaChute;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import micdoodle8.mods.galacticraft.core.tick.TickHandlerServer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityTelemetry;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.DamageSourceGC;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.OxygenUtil;
import micdoodle8.mods.galacticraft.core.util.PlayerUtil;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.core.wrappers.Footprint;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.WorldProviderAsteroids;
import micdoodle8.mods.galacticraft.planets.venus.VenusItems;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketRespawn;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GCPlayerHandler {
    private static final int OXYGENHEIGHTLIMIT = 450;
    private HashMap<Item, Item> torchItems = new HashMap();

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.player instanceof EntityPlayerMP) {
            this.onPlayerLogin((EntityPlayerMP)event.player);
        }
    }

    @SubscribeEvent
    public void onPlayerCloned(PlayerEvent.Clone event) {
        if (event.isWasDeath()) {
            GCPlayerStats oldStats = GCPlayerStats.get((Entity)event.getOriginal());
            GCPlayerStats newStats = GCPlayerStats.get((Entity)event.getEntityPlayer());
            newStats.copyFrom(oldStats, false);
        }
    }

    @SubscribeEvent
    public void onAttachCapability(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerMP) {
            event.addCapability(GCCapabilities.GC_PLAYER_PROP, (ICapabilityProvider)new CapabilityProviderStats((EntityPlayerMP)event.getObject()));
        } else if (event.getObject() instanceof EntityPlayer && ((EntityPlayer)event.getObject()).field_70170_p.field_72995_K) {
            this.onAttachCapabilityClient(event);
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void onAttachCapabilityClient(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof EntityPlayerSP) {
            event.addCapability(GCCapabilities.GC_PLAYER_CLIENT_PROP, (ICapabilityProvider)new CapabilityProviderStatsClient((EntityPlayerSP)event.getObject()));
        }
    }

    private void onPlayerLogin(EntityPlayerMP player) {
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_GET_CELESTIAL_BODY_LIST, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[0]), player);
        int repeatCount = stats.getBuildFlags() >> 9;
        if (repeatCount < 3) {
            stats.setBuildFlags(stats.getBuildFlags() & 0x600);
        }
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATS, GCCoreUtil.getDimensionID(player.field_70170_p), stats.getMiscNetworkedStats()), player);
        ColorUtil.sendUpdatedColorsToPlayer(stats);
    }

    public static void checkGear(EntityPlayerMP player, GCPlayerStats stats, boolean forceSend) {
        int gearID;
        int gearID2;
        stats.setMaskInSlot(stats.getExtendedInventory().func_70301_a(0));
        stats.setGearInSlot(stats.getExtendedInventory().func_70301_a(1));
        stats.setTankInSlot1(stats.getExtendedInventory().func_70301_a(2));
        stats.setTankInSlot2(stats.getExtendedInventory().func_70301_a(3));
        stats.setParachuteInSlot(stats.getExtendedInventory().func_70301_a(4));
        stats.setFrequencyModuleInSlot(stats.getExtendedInventory().func_70301_a(5));
        stats.setThermalHelmetInSlot(stats.getExtendedInventory().func_70301_a(6));
        stats.setThermalChestplateInSlot(stats.getExtendedInventory().func_70301_a(7));
        stats.setThermalLeggingsInSlot(stats.getExtendedInventory().func_70301_a(8));
        stats.setThermalBootsInSlot(stats.getExtendedInventory().func_70301_a(9));
        stats.setShieldControllerInSlot(stats.getExtendedInventory().func_70301_a(10));
        if (stats.getFrequencyModuleInSlot() != stats.getLastFrequencyModuleInSlot() || forceSend) {
            if (FMLCommonHandler.instance().getMinecraftServerInstance() != null) {
                if (stats.getFrequencyModuleInSlot().func_190926_b()) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.FREQUENCY_MODULE);
                    TileEntityTelemetry.frequencyModulePlayer(stats.getLastFrequencyModuleInSlot(), null);
                } else if (stats.getLastFrequencyModuleInSlot().func_190926_b() && (gearID2 = GalacticraftRegistry.findMatchingGearID(stats.getFrequencyModuleInSlot(), EnumExtendedInventorySlot.FREQUENCY_MODULE)) >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.FREQUENCY_MODULE, gearID2);
                    TileEntityTelemetry.frequencyModulePlayer(stats.getFrequencyModuleInSlot(), player);
                }
            }
            stats.setLastFrequencyModuleInSlot(stats.getFrequencyModuleInSlot());
        }
        if (stats.getMaskInSlot() != stats.getLastMaskInSlot() || forceSend) {
            if (stats.getMaskInSlot().func_190926_b()) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.MASK);
            } else if ((stats.getLastMaskInSlot().func_190926_b() || forceSend) && (gearID2 = GalacticraftRegistry.findMatchingGearID(stats.getMaskInSlot(), EnumExtendedInventorySlot.MASK)) >= 0) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.MASK, gearID2);
            }
            stats.setLastMaskInSlot(stats.getMaskInSlot());
        }
        if (stats.getGearInSlot() != stats.getLastGearInSlot() || forceSend) {
            if (stats.getGearInSlot().func_190926_b()) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.GEAR);
            } else if (stats.getGearInSlot().func_77973_b() == GCItems.oxygenGear && (stats.getLastGearInSlot().func_190926_b() || forceSend) && (gearID2 = GalacticraftRegistry.findMatchingGearID(stats.getGearInSlot(), EnumExtendedInventorySlot.GEAR)) >= 0) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.GEAR, gearID2);
            }
            stats.setLastGearInSlot(stats.getGearInSlot());
        }
        if (stats.getTankInSlot1() != stats.getLastTankInSlot1() || forceSend) {
            if (stats.getTankInSlot1().func_190926_b()) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.LEFT_TANK);
                stats.setAirRemaining(0);
                GCPlayerHandler.sendAirRemainingPacket(player, stats);
            } else if (stats.getLastTankInSlot1().func_190926_b() || forceSend) {
                gearID2 = GalacticraftRegistry.findMatchingGearID(stats.getTankInSlot1(), EnumExtendedInventorySlot.LEFT_TANK);
                if (gearID2 >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.LEFT_TANK, gearID2);
                }
                stats.setAirRemaining(stats.getTankInSlot1().func_77958_k() - stats.getTankInSlot1().func_77952_i());
                GCPlayerHandler.sendAirRemainingPacket(player, stats);
            } else if (stats.getTankInSlot1().func_77973_b() != stats.getLastTankInSlot1().func_77973_b()) {
                gearID2 = GalacticraftRegistry.findMatchingGearID(stats.getTankInSlot1(), EnumExtendedInventorySlot.LEFT_TANK);
                if (gearID2 >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.LEFT_TANK, gearID2);
                }
                stats.setAirRemaining(stats.getTankInSlot1().func_77958_k() - stats.getTankInSlot1().func_77952_i());
                GCPlayerHandler.sendAirRemainingPacket(player, stats);
            }
            stats.setLastTankInSlot1(stats.getTankInSlot1());
        }
        if (stats.getTankInSlot2() != stats.getLastTankInSlot2() || forceSend) {
            if (stats.getTankInSlot2().func_190926_b()) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.RIGHT_TANK);
                stats.setAirRemaining2(0);
                GCPlayerHandler.sendAirRemainingPacket(player, stats);
            } else if (stats.getLastTankInSlot2().func_190926_b() || forceSend) {
                gearID2 = GalacticraftRegistry.findMatchingGearID(stats.getTankInSlot2(), EnumExtendedInventorySlot.RIGHT_TANK);
                if (gearID2 >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.RIGHT_TANK, gearID2);
                }
                stats.setAirRemaining2(stats.getTankInSlot2().func_77958_k() - stats.getTankInSlot2().func_77952_i());
                GCPlayerHandler.sendAirRemainingPacket(player, stats);
            } else if (stats.getTankInSlot2().func_77973_b() != stats.getLastTankInSlot2().func_77973_b()) {
                gearID2 = GalacticraftRegistry.findMatchingGearID(stats.getTankInSlot2(), EnumExtendedInventorySlot.RIGHT_TANK);
                if (gearID2 >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.RIGHT_TANK, gearID2);
                }
                stats.setAirRemaining2(stats.getTankInSlot2().func_77958_k() - stats.getTankInSlot2().func_77952_i());
                GCPlayerHandler.sendAirRemainingPacket(player, stats);
            }
            stats.setLastTankInSlot2(stats.getTankInSlot2());
        }
        if (stats.getParachuteInSlot() != stats.getLastParachuteInSlot() || forceSend) {
            if (stats.getParachuteInSlot().func_190926_b()) {
                if (stats.isUsingParachute()) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.PARACHUTE);
                }
            } else if (stats.getLastParachuteInSlot().func_190926_b() || forceSend) {
                if (stats.isUsingParachute() && (gearID2 = GalacticraftRegistry.findMatchingGearID(stats.getParachuteInSlot(), EnumExtendedInventorySlot.PARACHUTE)) >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.PARACHUTE, stats.getParachuteInSlot().func_77952_i());
                }
            } else if (stats.getParachuteInSlot().func_77952_i() != stats.getLastParachuteInSlot().func_77952_i() && (gearID2 = GalacticraftRegistry.findMatchingGearID(stats.getParachuteInSlot(), EnumExtendedInventorySlot.PARACHUTE)) >= 0) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.PARACHUTE, stats.getParachuteInSlot().func_77952_i());
            }
            stats.setLastParachuteInSlot(stats.getParachuteInSlot());
        }
        if (stats.getThermalHelmetInSlot() != stats.getLastThermalHelmetInSlot() || forceSend) {
            ThermalArmorEvent armorEvent = new ThermalArmorEvent(0, stats.getThermalHelmetInSlot());
            MinecraftForge.EVENT_BUS.post((Event)armorEvent);
            if (armorEvent.armorResult != ThermalArmorEvent.ArmorAddResult.NOTHING) {
                if (stats.getThermalHelmetInSlot().func_190926_b() || armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.REMOVE) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.THERMAL_HELMET);
                } else if (armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.ADD && (stats.getLastThermalHelmetInSlot().func_190926_b() || forceSend) && (gearID = GalacticraftRegistry.findMatchingGearID(stats.getThermalHelmetInSlot(), EnumExtendedInventorySlot.THERMAL_HELMET)) >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.THERMAL_HELMET, gearID);
                }
            }
            stats.setLastThermalHelmetInSlot(stats.getThermalHelmetInSlot());
        }
        if (stats.getThermalChestplateInSlot() != stats.getLastThermalChestplateInSlot() || forceSend) {
            ThermalArmorEvent armorEvent = new ThermalArmorEvent(1, stats.getThermalChestplateInSlot());
            MinecraftForge.EVENT_BUS.post((Event)armorEvent);
            if (armorEvent.armorResult != ThermalArmorEvent.ArmorAddResult.NOTHING) {
                if (stats.getThermalChestplateInSlot().func_190926_b() || armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.REMOVE) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.THERMAL_CHESTPLATE);
                } else if (armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.ADD && (stats.getLastThermalChestplateInSlot().func_190926_b() || forceSend) && (gearID = GalacticraftRegistry.findMatchingGearID(stats.getThermalChestplateInSlot(), EnumExtendedInventorySlot.THERMAL_CHESTPLATE)) >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.THERMAL_CHESTPLATE, gearID);
                }
            }
            stats.setLastThermalChestplateInSlot(stats.getThermalChestplateInSlot());
        }
        if (stats.getThermalLeggingsInSlot() != stats.getLastThermalLeggingsInSlot() || forceSend) {
            ThermalArmorEvent armorEvent = new ThermalArmorEvent(2, stats.getThermalLeggingsInSlot());
            MinecraftForge.EVENT_BUS.post((Event)armorEvent);
            if (armorEvent.armorResult != ThermalArmorEvent.ArmorAddResult.NOTHING) {
                if (stats.getThermalLeggingsInSlot().func_190926_b() || armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.REMOVE) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.THERMAL_LEGGINGS);
                } else if (armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.ADD && (stats.getLastThermalLeggingsInSlot().func_190926_b() || forceSend) && (gearID = GalacticraftRegistry.findMatchingGearID(stats.getThermalLeggingsInSlot(), EnumExtendedInventorySlot.THERMAL_LEGGINGS)) >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.THERMAL_LEGGINGS, gearID);
                }
            }
            stats.setLastThermalLeggingsInSlot(stats.getThermalLeggingsInSlot());
        }
        if (stats.getThermalBootsInSlot() != stats.getLastThermalBootsInSlot() || forceSend) {
            ThermalArmorEvent armorEvent = new ThermalArmorEvent(3, stats.getThermalBootsInSlot());
            MinecraftForge.EVENT_BUS.post((Event)armorEvent);
            if (armorEvent.armorResult != ThermalArmorEvent.ArmorAddResult.NOTHING) {
                if (stats.getThermalBootsInSlot().func_190926_b() || armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.REMOVE) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.THERMAL_BOOTS);
                } else if (armorEvent.armorResult == ThermalArmorEvent.ArmorAddResult.ADD && (stats.getLastThermalBootsInSlot().func_190926_b() || forceSend) && (gearID = GalacticraftRegistry.findMatchingGearID(stats.getThermalBootsInSlot(), EnumExtendedInventorySlot.THERMAL_BOOTS)) >= 0) {
                    GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.THERMAL_BOOTS, gearID);
                }
            }
            stats.setLastThermalBootsInSlot(stats.getThermalBootsInSlot());
        }
        if ((stats.getShieldControllerInSlot() != stats.getLastShieldControllerInSlot() || forceSend) && GalacticraftCore.isPlanetsLoaded) {
            int gearID3;
            if (stats.getShieldControllerInSlot().func_190926_b()) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.SHIELD_CONTROLLER);
            } else if (stats.getShieldControllerInSlot().func_77973_b() == VenusItems.basicItem && (stats.getLastShieldControllerInSlot().func_190926_b() || forceSend) && (gearID3 = GalacticraftRegistry.findMatchingGearID(stats.getShieldControllerInSlot(), EnumExtendedInventorySlot.SHIELD_CONTROLLER)) >= 0) {
                GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.SHIELD_CONTROLLER, gearID3);
            }
            stats.setLastShieldControllerInSlot(stats.getShieldControllerInSlot());
        }
    }

    protected void checkThermalStatus(EntityPlayerMP player, GCPlayerStats playerStats) {
        if (player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && !player.field_71075_bZ.field_75098_d) {
            IGalacticraftWorldProvider provider;
            float thermalLevelMod;
            float absThermalLevelMod;
            ItemStack thermalPaddingHelm = playerStats.getExtendedInventory().func_70301_a(6);
            ItemStack thermalPaddingChestplate = playerStats.getExtendedInventory().func_70301_a(7);
            ItemStack thermalPaddingLeggings = playerStats.getExtendedInventory().func_70301_a(8);
            ItemStack thermalPaddingBoots = playerStats.getExtendedInventory().func_70301_a(9);
            float lowestThermalStrength = 0.0f;
            if (!(thermalPaddingHelm.func_190926_b() || thermalPaddingChestplate.func_190926_b() || thermalPaddingLeggings.func_190926_b() || thermalPaddingBoots.func_190926_b())) {
                if (thermalPaddingHelm.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingHelm.func_77973_b()).getThermalStrength();
                }
                if (thermalPaddingChestplate.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingChestplate.func_77973_b()).getThermalStrength();
                }
                if (thermalPaddingLeggings.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingLeggings.func_77973_b()).getThermalStrength();
                }
                if (thermalPaddingBoots.func_77973_b() instanceof IItemThermal) {
                    lowestThermalStrength += (float)((IItemThermal)thermalPaddingBoots.func_77973_b()).getThermalStrength();
                }
                lowestThermalStrength /= 4.0f;
                lowestThermalStrength = Math.abs(lowestThermalStrength);
            }
            if ((double)(absThermalLevelMod = Math.abs(thermalLevelMod = (provider = (IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getThermalLevelModifier())) > 0.0) {
                int thermalLevelTickCooldownSingle;
                int thermalLevelCooldownBase = Math.abs(MathHelper.func_76141_d((float)(200.0f / thermalLevelMod)));
                int normaliseCooldown = MathHelper.func_76141_d((float)(150.0f / lowestThermalStrength));
                int thermalLevelTickCooldown = thermalLevelCooldownBase;
                if (thermalLevelTickCooldown < 1) {
                    thermalLevelTickCooldown = 1;
                }
                if (!(thermalPaddingHelm.func_190926_b() || thermalPaddingChestplate.func_190926_b() || thermalPaddingLeggings.func_190926_b() || thermalPaddingBoots.func_190926_b())) {
                    float relativeFactor = Math.max(1.0f, absThermalLevelMod / lowestThermalStrength) / 1.5f;
                    if ((normaliseCooldown = MathHelper.func_76141_d((float)((float)normaliseCooldown / absThermalLevelMod * relativeFactor))) < 1) {
                        normaliseCooldown = 1;
                    }
                    if ((player.field_70173_aa - 1) % normaliseCooldown == 0) {
                        this.normaliseThermalLevel(player, playerStats, 1);
                    }
                    absThermalLevelMod = Math.abs(thermalLevelMod /= Math.max(1.0f, lowestThermalStrength / 2.0f));
                }
                if (OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player, true)) {
                    playerStats.setThermalLevelNormalising(true);
                    this.normaliseThermalLevel(player, playerStats, 1);
                    return;
                }
                if (!thermalPaddingHelm.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (!thermalPaddingChestplate.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (!thermalPaddingLeggings.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if (!thermalPaddingBoots.func_190926_b()) {
                    thermalLevelTickCooldown += thermalLevelCooldownBase;
                }
                if ((thermalLevelTickCooldownSingle = MathHelper.func_76141_d((float)((float)thermalLevelTickCooldown / absThermalLevelMod))) < 1) {
                    thermalLevelTickCooldownSingle = 1;
                }
                if ((player.field_70173_aa - 1) % thermalLevelTickCooldownSingle == 0) {
                    int last = playerStats.getThermalLevel();
                    playerStats.setThermalLevel(Math.min(Math.max(last + (thermalLevelMod < 0.0f ? -1 : 1), -22), 22));
                    if (playerStats.getThermalLevel() != last) {
                        this.sendThermalLevelPacket(player, playerStats);
                    }
                }
                playerStats.setThermalLevelNormalising(thermalLevelTickCooldownSingle > normaliseCooldown && !thermalPaddingHelm.func_190926_b() && !thermalPaddingChestplate.func_190926_b() && !thermalPaddingLeggings.func_190926_b() && !thermalPaddingBoots.func_190926_b());
                if (!playerStats.isThermalLevelNormalising()) {
                    if ((player.field_70173_aa - 1) % thermalLevelTickCooldown == 0 && Math.abs(playerStats.getThermalLevel()) >= 22) {
                        player.func_70097_a((DamageSource)DamageSourceGC.thermal, 1.5f);
                    }
                    if (playerStats.getThermalLevel() < -15) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 5, 2, true, true));
                    }
                    if (playerStats.getThermalLevel() > 15) {
                        player.func_70690_d(new PotionEffect(MobEffects.field_76431_k, 5, 2, true, true));
                    }
                }
            } else {
                playerStats.setThermalLevelNormalising(true);
                this.normaliseThermalLevel(player, playerStats, 2);
            }
        } else {
            playerStats.setThermalLevelNormalising(true);
            this.normaliseThermalLevel(player, playerStats, 3);
        }
    }

    public void normaliseThermalLevel(EntityPlayerMP player, GCPlayerStats stats, int increment) {
        int last = stats.getThermalLevel();
        if (stats.getThermalLevel() < 0) {
            stats.setThermalLevel(stats.getThermalLevel() + Math.min(increment, -stats.getThermalLevel()));
        } else if (stats.getThermalLevel() > 0) {
            stats.setThermalLevel(stats.getThermalLevel() - Math.min(increment, stats.getThermalLevel()));
        }
        if (stats.getThermalLevel() != last) {
            this.sendThermalLevelPacket(player, stats);
        }
    }

    protected void checkShield(EntityPlayerMP playerMP, GCPlayerStats playerStats) {
        if (playerMP.field_70173_aa % 20 == 0 && playerMP.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider && ((IGalacticraftWorldProvider)playerMP.field_70170_p.field_73011_w).shouldCorrodeArmor()) {
            int gearID;
            ItemStack shieldController = playerStats.getExtendedInventory().func_70301_a(10);
            boolean valid = false;
            if (!shieldController.func_190926_b() && (gearID = GalacticraftRegistry.findMatchingGearID(shieldController, EnumExtendedInventorySlot.SHIELD_CONTROLLER)) != -1) {
                valid = true;
            }
            if (!valid) {
                for (ItemStack armor : playerMP.func_184193_aE()) {
                    if (armor.func_190926_b() || !(armor.func_77973_b() instanceof ItemArmor)) continue;
                    armor.func_77972_a(1, (EntityLivingBase)playerMP);
                }
            }
        }
    }

    protected void checkOxygen(EntityPlayerMP player, GCPlayerStats stats) {
        if (!(player.field_71093_bK != 0 && !(player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider) || (player.field_71093_bK == 0 || ((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).hasBreathableAtmosphere()) && !(player.field_70163_u > 450.0) || player.field_71075_bZ.field_75098_d || player.func_184187_bx() instanceof EntityLanderBase || player.func_184187_bx() instanceof EntityAutoRocket || player.func_184187_bx() instanceof EntityCelestialFake)) {
            boolean airEmpty;
            ItemStack tankInSlot = stats.getExtendedInventory().func_70301_a(2);
            ItemStack tankInSlot2 = stats.getExtendedInventory().func_70301_a(3);
            int drainSpacing = OxygenUtil.getDrainSpacing(tankInSlot, tankInSlot2);
            if (tankInSlot.func_190926_b()) {
                stats.setAirRemaining(0);
            } else {
                stats.setAirRemaining(tankInSlot.func_77958_k() - tankInSlot.func_77952_i());
            }
            if (tankInSlot2.func_190926_b()) {
                stats.setAirRemaining2(0);
            } else {
                stats.setAirRemaining2(tankInSlot2.func_77958_k() - tankInSlot2.func_77952_i());
            }
            if (drainSpacing > 0) {
                if ((player.field_70173_aa - 1) % drainSpacing == 0 && !OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player) && !stats.isUsingPlanetSelectionGui()) {
                    int toTake = 1;
                    if (stats.getAirRemaining() > 0) {
                        tankInSlot.func_77972_a(1, (EntityLivingBase)player);
                        stats.setAirRemaining(stats.getAirRemaining() - 1);
                        toTake = 0;
                    }
                    if (toTake > 0 && stats.getAirRemaining2() > 0) {
                        tankInSlot2.func_77972_a(1, (EntityLivingBase)player);
                        stats.setAirRemaining2(stats.getAirRemaining2() - 1);
                        toTake = 0;
                    }
                }
            } else if ((player.field_70173_aa - 1) % 60 == 0) {
                if (OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player)) {
                    if (stats.getAirRemaining() < 90 && !tankInSlot.func_190926_b()) {
                        stats.setAirRemaining(Math.min(stats.getAirRemaining() + 1, tankInSlot.func_77958_k() - tankInSlot.func_77952_i()));
                    }
                    if (stats.getAirRemaining2() < 90 && !tankInSlot2.func_190926_b()) {
                        stats.setAirRemaining2(Math.min(stats.getAirRemaining2() + 1, tankInSlot2.func_77958_k() - tankInSlot2.func_77952_i()));
                    }
                } else {
                    if (stats.getAirRemaining() > 0) {
                        stats.setAirRemaining(stats.getAirRemaining() - 1);
                    }
                    if (stats.getAirRemaining2() > 0) {
                        stats.setAirRemaining2(stats.getAirRemaining2() - 1);
                    }
                }
            }
            boolean bl = airEmpty = stats.getAirRemaining() <= 0 && stats.getAirRemaining2() <= 0;
            if (player.func_70617_f_()) {
                stats.setOxygenSetupValid(stats.isLastOxygenSetupValid());
            } else {
                stats.setOxygenSetupValid(OxygenUtil.hasValidOxygenSetup(player) && !airEmpty || OxygenUtil.isAABBInBreathableAirBlock((EntityLivingBase)player));
            }
            if (!player.field_70170_p.field_72995_K && player.func_70089_S()) {
                if (!stats.isOxygenSetupValid()) {
                    GCCoreOxygenSuffocationEvent.Pre suffocationEvent = new GCCoreOxygenSuffocationEvent.Pre((EntityLivingBase)player);
                    MinecraftForge.EVENT_BUS.post((Event)suffocationEvent);
                    if (!suffocationEvent.isCanceled()) {
                        if (stats.getDamageCounter() == 0) {
                            stats.setDamageCounter(ConfigManagerCore.suffocationCooldown);
                            player.func_70097_a((DamageSource)DamageSourceGC.oxygenSuffocation, (float)(ConfigManagerCore.suffocationDamage * (2 + stats.getIncrementalDamage()) / 2));
                            if (ConfigManagerCore.hardMode) {
                                stats.setIncrementalDamage(stats.getIncrementalDamage() + 1);
                            }
                            GCCoreOxygenSuffocationEvent.Post suffocationEventPost = new GCCoreOxygenSuffocationEvent.Post((EntityLivingBase)player);
                            MinecraftForge.EVENT_BUS.post((Event)suffocationEventPost);
                        }
                    } else {
                        stats.setOxygenSetupValid(true);
                    }
                } else {
                    stats.setIncrementalDamage(0);
                }
            }
        } else if ((player.field_70173_aa - 1) % 20 == 0 && !player.field_71075_bZ.field_75098_d && stats.getAirRemaining() < 90) {
            stats.setAirRemaining(stats.getAirRemaining() + 1);
            stats.setAirRemaining2(stats.getAirRemaining2() + 1);
        } else if (player.field_71075_bZ.field_75098_d) {
            stats.setAirRemaining(90);
            stats.setAirRemaining2(90);
        } else {
            stats.setOxygenSetupValid(true);
        }
    }

    protected void throwMeteors(EntityPlayerMP player) {
        World world = player.field_70170_p;
        if (world.field_73011_w instanceof IGalacticraftWorldProvider && !world.field_72995_K && ((IGalacticraftWorldProvider)world.field_73011_w).getMeteorFrequency() > 0.0 && ConfigManagerCore.meteorSpawnMod > 0.0) {
            EntityMeteor meteor;
            double motZ;
            double motX;
            int z;
            int y;
            int x;
            EntityPlayer closestPlayer;
            int f = (int)(((IGalacticraftWorldProvider)world.field_73011_w).getMeteorFrequency() * 1000.0 * (1.0 / ConfigManagerCore.meteorSpawnMod));
            if (world.field_73012_v.nextInt(f) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                x = world.field_73012_v.nextInt(20) - 10;
                y = world.field_73012_v.nextInt(20) + 200;
                z = world.field_73012_v.nextInt(20) - 10;
                motX = world.field_73012_v.nextDouble() * 5.0;
                motZ = world.field_73012_v.nextDouble() * 5.0;
                meteor = new EntityMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 1);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)meteor);
                }
            }
            if (world.field_73012_v.nextInt(f * 3) == 0 && ((closestPlayer = world.func_72890_a((Entity)player, 100.0)) == null || closestPlayer.func_145782_y() <= player.func_145782_y())) {
                x = world.field_73012_v.nextInt(20) - 10;
                y = world.field_73012_v.nextInt(20) + 200;
                z = world.field_73012_v.nextInt(20) - 10;
                motX = world.field_73012_v.nextDouble() * 5.0;
                motZ = world.field_73012_v.nextDouble() * 5.0;
                meteor = new EntityMeteor(world, player.field_70165_t + (double)x, player.field_70163_u + (double)y, player.field_70161_v + (double)z, motX - 2.5, 0.0, motZ - 2.5, 6);
                if (!world.field_72995_K) {
                    world.func_72838_d((Entity)meteor);
                }
            }
        }
    }

    protected void checkCurrentItem(EntityPlayerMP player) {
        ItemStack theCurrentItem = player.field_71071_by.func_70448_g();
        ItemStack offHandItem = player.func_184592_cb();
        if (!theCurrentItem.func_190926_b()) {
            Item torchItem;
            if (OxygenUtil.noAtmosphericCombustion(player.field_70170_p.field_73011_w)) {
                if (this.torchItems.containsValue(theCurrentItem.func_77973_b())) {
                    torchItem = null;
                    for (Item i : this.torchItems.keySet()) {
                        if (this.torchItems.get(i) != theCurrentItem.func_77973_b()) continue;
                        torchItem = i;
                        break;
                    }
                    if (torchItem != null) {
                        player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)new ItemStack(torchItem, theCurrentItem.func_190916_E(), 0));
                    }
                }
            } else if (this.torchItems.containsKey(theCurrentItem.func_77973_b()) && (torchItem = this.torchItems.get(theCurrentItem.func_77973_b())) != null) {
                player.field_71071_by.field_70462_a.set(player.field_71071_by.field_70461_c, (Object)new ItemStack(torchItem, theCurrentItem.func_190916_E(), 0));
            }
            if (!offHandItem.func_190926_b() && theCurrentItem.func_77973_b() instanceof IHoldableItem && offHandItem.func_77973_b() instanceof IHoldableItem) {
                int emptyStack = player.field_71071_by.func_70447_i();
                if (emptyStack >= 0) {
                    ItemStack copyOffHandItem = offHandItem.func_77946_l();
                    copyOffHandItem.func_190915_d(5);
                    player.field_71071_by.field_70462_a.set(emptyStack, (Object)copyOffHandItem);
                } else {
                    player.func_71019_a(offHandItem, false);
                }
                player.func_184201_a(EntityEquipmentSlot.OFFHAND, ItemStack.field_190927_a);
            }
        }
    }

    public void registerTorchType(BlockUnlitTorch spaceTorch, Block vanillaTorch) {
        Item itemSpaceTorch = Item.func_150898_a((Block)spaceTorch);
        Item itemVanillaTorch = Item.func_150898_a((Block)vanillaTorch);
        this.torchItems.put(itemSpaceTorch, itemVanillaTorch);
    }

    public static void setUsingParachute(EntityPlayerMP player, GCPlayerStats playerStats, boolean tf) {
        playerStats.setUsingParachute(tf);
        if (tf) {
            int subtype = -1;
            if (!playerStats.getParachuteInSlot().func_190926_b()) {
                subtype = playerStats.getParachuteInSlot().func_77952_i();
            }
            GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.ADD, EnumExtendedInventorySlot.PARACHUTE, subtype);
        } else {
            GCPlayerHandler.sendGearUpdatePacket(player, EnumModelPacketType.REMOVE, EnumExtendedInventorySlot.PARACHUTE);
        }
    }

    protected static void updateFeet(EntityPlayerMP player, double motionX, double motionZ) {
        int iPosZ;
        int iPosY;
        int iPosX;
        IBlockState state;
        double motionSqrd = motionX * motionX + motionZ * motionZ;
        if (motionSqrd > 0.001 && !player.field_71075_bZ.field_75100_b && (state = player.field_70170_p.func_180495_p(new BlockPos(iPosX = MathHelper.func_76128_c((double)player.field_70165_t), iPosY = MathHelper.func_76128_c((double)player.field_70163_u) - 1, iPosZ = MathHelper.func_76128_c((double)player.field_70161_v)))).func_177230_c() == GCBlocks.blockMoon && state.func_177230_c().func_176201_c(state) == 5) {
            GCPlayerStats stats = GCPlayerStats.get((Entity)player);
            if (stats.getDistanceSinceLastStep() > 0.35) {
                Vector3 pos = new Vector3((Entity)player);
                pos.y = (float)MathHelper.func_76128_c((double)(player.field_70163_u - 1.0)) + player.field_70170_p.field_73012_v.nextFloat() / 100.0f;
                switch (stats.getLastStep()) {
                    case 0: {
                        float a = (-player.field_70177_z + 90.0f) / 57.295776f;
                        pos.translate(new Vector3(MathHelper.func_76126_a((float)a) * 0.25f, 0.0, MathHelper.func_76134_b((float)a) * 0.25f));
                        break;
                    }
                    case 1: {
                        float a = (-player.field_70177_z - 90.0f) / 57.295776f;
                        pos.translate(new Vector3((double)MathHelper.func_76126_a((float)a) * 0.25, 0.0, (double)MathHelper.func_76134_b((float)a) * 0.25));
                    }
                }
                float rotation = player.field_70177_z - 180.0f;
                pos = WorldUtil.getFootprintPosition(player.field_70170_p, rotation, pos, new BlockVec3((Entity)player));
                long chunkKey = ChunkPos.func_77272_a((int)(pos.intX() >> 4), (int)(pos.intZ() >> 4));
                TickHandlerServer.addFootprint(chunkKey, new Footprint(GCCoreUtil.getDimensionID(player.field_70170_p), pos, rotation, player.func_70005_c_()), GCCoreUtil.getDimensionID(player.field_70170_p));
                stats.setLastStep((stats.getLastStep() + 1) % 2);
                stats.setDistanceSinceLastStep(0.0);
            } else {
                stats.setDistanceSinceLastStep(stats.getDistanceSinceLastStep() + motionSqrd);
            }
        }
    }

    protected void updateSchematics(EntityPlayerMP player, GCPlayerStats stats) {
        SchematicRegistry.addUnlockedPage(player, SchematicRegistry.getMatchingRecipeForID(0));
        SchematicRegistry.addUnlockedPage(player, SchematicRegistry.getMatchingRecipeForID(Integer.MAX_VALUE));
        Collections.sort(stats.getUnlockedSchematics());
        if (player.field_71135_a != null && (stats.getUnlockedSchematics().size() != stats.getLastUnlockedSchematics().size() || (player.field_70173_aa - 1) % 100 == 0)) {
            Integer[] iArray = new Integer[stats.getUnlockedSchematics().size()];
            for (int i = 0; i < iArray.length; ++i) {
                ISchematicPage page = stats.getUnlockedSchematics().get(i);
                iArray[i] = page == null ? -2 : page.getPageID();
            }
            ArrayList<Object> objList = new ArrayList<Object>();
            objList.add(iArray);
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_SCHEMATIC_LIST, GCCoreUtil.getDimensionID(player.field_70170_p), objList), player);
        }
    }

    protected void sendPlanetList(EntityPlayerMP player, GCPlayerStats stats) {
        HashMap<String, Integer> map = player.field_70173_aa % 50 == 0 ? WorldUtil.getArrayOfPossibleDimensions(stats.getSpaceshipTier(), player) : WorldUtil.getArrayOfPossibleDimensionsAgain(stats.getSpaceshipTier(), player);
        String temp = "";
        int count = 0;
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            temp = temp.concat(entry.getKey() + (count < map.entrySet().size() - 1 ? "?" : ""));
            ++count;
        }
        if (!temp.equals(stats.getSavedPlanetList()) || player.field_70173_aa % 100 == 0) {
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_DIMENSION_LIST, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{player.func_146103_bH().getName(), temp}), player);
            stats.setSavedPlanetList(temp);
        }
    }

    protected static void sendAirRemainingPacket(EntityPlayerMP player, GCPlayerStats stats) {
        float f1 = stats.getTankInSlot1().func_190926_b() ? 0.0f : (float)stats.getTankInSlot1().func_77958_k() / 90.0f;
        float f2 = stats.getTankInSlot2().func_190926_b() ? 0.0f : (float)stats.getTankInSlot2().func_77958_k() / 90.0f;
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_AIR_REMAINING, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{MathHelper.func_76141_d((float)((float)stats.getAirRemaining() / f1)), MathHelper.func_76141_d((float)((float)stats.getAirRemaining2() / f2)), player.func_146103_bH().getName()}), player);
    }

    protected void sendThermalLevelPacket(EntityPlayerMP player, GCPlayerStats stats) {
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_THERMAL_LEVEL, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{stats.getThermalLevel(), stats.isThermalLevelNormalising()}), player);
    }

    public static void sendGearUpdatePacket(EntityPlayerMP player, EnumModelPacketType packetType, EnumExtendedInventorySlot gearType) {
        GCPlayerHandler.sendGearUpdatePacket(player, packetType, gearType, -1);
    }

    public static void sendGearUpdatePacket(EntityPlayerMP player, EnumModelPacketType packetType, EnumExtendedInventorySlot gearType, int gearID) {
        MinecraftServer theServer = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (theServer != null && PlayerUtil.getPlayerForUsernameVanilla(theServer, player.func_146103_bH().getName()) != null) {
            GalacticraftCore.packetPipeline.sendToAllAround(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_GEAR_SLOT, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{player.func_146103_bH().getName(), packetType.ordinal(), gearType.ordinal(), gearID}), new NetworkRegistry.TargetPoint(GCCoreUtil.getDimensionID(player.field_70170_p), player.field_70165_t, player.field_70163_u, player.field_70161_v, 50.0));
        }
    }

    public void onPlayerUpdate(EntityPlayerMP player) {
        int tick = player.field_70173_aa - 1;
        GCPlayerStats stats = GCPlayerStats.get((Entity)player);
        if ((ConfigManagerCore.challengeMode || ConfigManagerCore.challengeSpawnHandling) && stats.getUnlockedSchematics().size() == 0) {
            if (stats.getStartDimension().length() > 0) {
                stats.setStartDimension("");
            } else {
                int dimID;
                WorldServer worldOld = (WorldServer)player.field_70170_p;
                try {
                    worldOld.func_184164_w().func_72695_c(player);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                worldOld.field_73010_i.remove(player);
                worldOld.func_72854_c();
                worldOld.field_72996_f.remove(player);
                worldOld.func_72847_b((Entity)player);
                worldOld.func_73039_n().func_72790_b((Entity)player);
                if (player.field_70175_ag && worldOld.func_72863_F().func_73149_a(player.field_70176_ah, player.field_70164_aj)) {
                    Chunk chunkOld = worldOld.func_72964_e(player.field_70176_ah, player.field_70164_aj);
                    chunkOld.func_76622_b((Entity)player);
                    chunkOld.func_76630_e();
                }
                WorldServer worldNew = WorldUtil.getStartWorld(worldOld);
                player.field_71093_bK = dimID = GCCoreUtil.getDimensionID((World)worldNew);
                GCLog.debug("DEBUG: Sending respawn packet to player for dim " + dimID);
                player.field_71135_a.func_147359_a((Packet)new SPacketRespawn(dimID, player.field_70170_p.func_175659_aa(), player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
                if (worldNew.field_73011_w instanceof WorldProviderSpaceStation) {
                    GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[0]), player);
                }
                worldNew.func_72838_d((Entity)player);
                player.func_70029_a((World)worldNew);
            }
            ITeleportType type = GalacticraftRegistry.getTeleportTypeForDimension(player.field_70170_p.field_73011_w.getClass());
            Vector3 spawnPos = type.getPlayerSpawnLocation((WorldServer)player.field_70170_p, player);
            ChunkPos pair = player.field_70170_p.func_72964_e(spawnPos.intX(), spawnPos.intZ()).func_76632_l();
            GCLog.debug("Loading first chunk in new dimension.");
            ((WorldServer)player.field_70170_p).func_72863_F().func_186028_c(pair.field_77276_a, pair.field_77275_b);
            player.func_70012_b(spawnPos.x, spawnPos.y, spawnPos.z, player.field_70177_z, player.field_70125_A);
            type.setupAdventureSpawn(player);
            type.onSpaceDimensionChanged(player.field_70170_p, player, false);
            player.setSpawnChunk(new BlockPos(spawnPos.intX(), spawnPos.intY(), spawnPos.intZ()), true, GCCoreUtil.getDimensionID(player.field_70170_p));
            stats.setNewAdventureSpawn(true);
        }
        boolean isInGCDimension = player.field_70170_p.field_73011_w instanceof IGalacticraftWorldProvider;
        if (tick >= 25) {
            if (ConfigManagerCore.enableSpaceRaceManagerPopup && !stats.hasOpenedSpaceRaceManager()) {
                SpaceRace race = SpaceRaceManager.getSpaceRaceFromPlayer(player.func_146103_bH().getName());
                if (race == null || race.teamName.equals("gui.space_race.unnamed")) {
                    GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_OPEN_SPACE_RACE_GUI, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[0]), player);
                }
                stats.setOpenedSpaceRaceManager(true);
            }
            if (!stats.hasSentFlags()) {
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_STATS, GCCoreUtil.getDimensionID(player.field_70170_p), stats.getMiscNetworkedStats()), player);
                stats.setSentFlags(true);
            }
        }
        if (stats.getCryogenicChamberCooldown() > 0) {
            stats.setCryogenicChamberCooldown(stats.getCryogenicChamberCooldown() - 1);
        }
        if (!player.field_70122_E && stats.isLastOnGround()) {
            stats.setTouchedGround(true);
        }
        if (stats.getTeleportCooldown() > 0) {
            stats.setTeleportCooldown(stats.getTeleportCooldown() - 1);
        }
        if (stats.getChatCooldown() > 0) {
            stats.setChatCooldown(stats.getChatCooldown() - 1);
        }
        if (stats.getOpenPlanetSelectionGuiCooldown() > 0) {
            stats.setOpenPlanetSelectionGuiCooldown(stats.getOpenPlanetSelectionGuiCooldown() - 1);
            if (stats.getOpenPlanetSelectionGuiCooldown() == 1 && !stats.hasOpenedPlanetSelectionGui()) {
                WorldUtil.toCelestialSelection(player, stats, stats.getSpaceshipTier());
                stats.setHasOpenedPlanetSelectionGui(true);
            }
        }
        if (stats.isUsingParachute()) {
            if (!stats.getLastParachuteInSlot().func_190926_b()) {
                player.field_70143_R = 0.0f;
            }
            if (player.field_70122_E) {
                GCPlayerHandler.setUsingParachute(player, stats, false);
            }
        }
        this.checkCurrentItem(player);
        if (stats.isUsingPlanetSelectionGui()) {
            this.sendPlanetList(player, stats);
        }
        if (stats.getDamageCounter() > 0) {
            stats.setDamageCounter(stats.getDamageCounter() - 1);
        }
        if (isInGCDimension) {
            if (tick % 30 == 0) {
                GCPlayerHandler.sendAirRemainingPacket(player, stats);
                this.sendThermalLevelPacket(player, stats);
            }
            if (player.func_184187_bx() instanceof EntityLanderBase) {
                stats.setInLander(true);
                stats.setJustLanded(false);
            } else {
                if (stats.isInLander()) {
                    stats.setJustLanded(true);
                }
                stats.setInLander(false);
            }
            if (player.field_70122_E && stats.hasJustLanded()) {
                stats.setJustLanded(false);
                if (player.getBedLocation(GCCoreUtil.getDimensionID(player.field_70170_p)) == null || stats.isNewAdventureSpawn()) {
                    int i = 30000000;
                    int j = Math.min(i, Math.max(-i, MathHelper.func_76128_c((double)(player.field_70165_t + 0.5))));
                    int k = Math.min(256, Math.max(0, MathHelper.func_76128_c((double)(player.field_70163_u + 1.5))));
                    int l = Math.min(i, Math.max(-i, MathHelper.func_76128_c((double)(player.field_70161_v + 0.5))));
                    BlockPos coords = new BlockPos(j, k, l);
                    player.setSpawnChunk(coords, true, GCCoreUtil.getDimensionID(player.field_70170_p));
                    stats.setNewAdventureSpawn(false);
                }
                GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_RESET_THIRD_PERSON, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[0]), player);
            }
            if (player.field_70170_p.field_73011_w instanceof WorldProviderSpaceStation || player.field_70170_p.field_73011_w instanceof IZeroGDimension || GalacticraftCore.isPlanetsLoaded && player.field_70170_p.field_73011_w instanceof WorldProviderAsteroids) {
                this.preventFlyingKicks(player);
                if (player.field_70170_p.field_73011_w instanceof WorldProviderSpaceStation && stats.isNewInOrbit()) {
                    ((WorldProviderSpaceStation)player.field_70170_p.field_73011_w).getSpinManager().sendPackets(player);
                    stats.setNewInOrbit(false);
                }
            } else {
                stats.setNewInOrbit(true);
            }
        } else {
            stats.setNewInOrbit(true);
        }
        GCPlayerHandler.checkGear(player, stats, false);
        if (stats.getChestSpawnCooldown() > 0) {
            stats.setChestSpawnCooldown(stats.getChestSpawnCooldown() - 1);
            if (stats.getChestSpawnCooldown() == 180 && stats.getChestSpawnVector() != null) {
                EntityParachest chest = new EntityParachest(player.field_70170_p, stats.getRocketStacks(), stats.getFuelLevel());
                chest.func_70107_b(stats.getChestSpawnVector().x, stats.getChestSpawnVector().y, stats.getChestSpawnVector().z);
                EnumDyeColor enumDyeColor = chest.color = stats.getParachuteInSlot().func_190926_b() ? EnumDyeColor.WHITE : ItemParaChute.getDyeEnumFromParachuteDamage(stats.getParachuteInSlot().func_77952_i());
                if (!player.field_70170_p.field_72995_K) {
                    player.field_70170_p.func_72838_d((Entity)chest);
                }
            }
        }
        if (stats.getLaunchAttempts() > 0 && player.func_184187_bx() == null) {
            stats.setLaunchAttempts(0);
        }
        this.checkThermalStatus(player, stats);
        this.checkOxygen(player, stats);
        this.checkShield(player, stats);
        if (isInGCDimension && (stats.isOxygenSetupValid() != stats.isLastOxygenSetupValid() || tick % 100 == 0)) {
            GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_UPDATE_OXYGEN_VALIDITY, player.field_70170_p.field_73011_w.getDimension(), new Object[]{stats.isOxygenSetupValid()}), player);
        }
        this.throwMeteors(player);
        this.updateSchematics(player, stats);
        if (tick % 250 == 0 && stats.getFrequencyModuleInSlot().func_190926_b() && !stats.hasReceivedSoundWarning() && isInGCDimension && player.field_70122_E && tick > 0 && ((IGalacticraftWorldProvider)player.field_70170_p.field_73011_w).getSoundVolReductionAmount() > 1.0f) {
            String[] string2 = GCCoreUtil.translate("gui.frequencymodule.warning1").split(" ");
            StringBuilder sb = new StringBuilder();
            for (String aString2 : string2) {
                sb.append(" ").append((Object)EnumColor.YELLOW).append(aString2);
            }
            player.func_145747_a((ITextComponent)new TextComponentString((Object)((Object)EnumColor.YELLOW) + GCCoreUtil.translate("gui.frequencymodule.warning0") + " " + (Object)((Object)EnumColor.AQUA) + GCItems.basicItem.func_77653_i(new ItemStack(GCItems.basicItem, 1, 19)) + sb.toString()));
            stats.setReceivedSoundWarning(true);
        }
        stats.setLastOxygenSetupValid(stats.isOxygenSetupValid());
        stats.setLastUnlockedSchematics(stats.getUnlockedSchematics());
        stats.setLastOnGround(player.field_70122_E);
    }

    public void preventFlyingKicks(EntityPlayerMP player) {
        player.field_70143_R = 0.0f;
        player.field_71135_a.field_147365_f = 0;
    }

    public static enum EnumModelPacketType {
        ADD,
        REMOVE;

    }

    public static class ThermalArmorEvent
    extends Event {
        public ArmorAddResult armorResult = ArmorAddResult.NOTHING;
        public final int armorIndex;
        public final ItemStack armorStack;

        public ThermalArmorEvent(int armorIndex, ItemStack armorStack) {
            this.armorIndex = armorIndex;
            this.armorStack = armorStack;
        }

        public void setArmorAddResult(ArmorAddResult result) {
            this.armorResult = result;
        }

        public static enum ArmorAddResult {
            ADD,
            REMOVE,
            NOTHING;

        }
    }
}

