/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.entities.player;

import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.api.recipe.ISchematicPage;
import micdoodle8.mods.galacticraft.api.recipe.SchematicRegistry;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockPanelLighting;
import micdoodle8.mods.galacticraft.core.command.CommandGCInv;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.inventory.InventoryExtended;
import micdoodle8.mods.galacticraft.core.tile.TileEntityPanelLight;
import micdoodle8.mods.galacticraft.core.util.ColorUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.tick.AsteroidsTickHandlerServer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;

public class StatsCapability
extends GCPlayerStats {
    public WeakReference<EntityPlayerMP> player;
    public InventoryExtended extendedInventory = new InventoryExtended();
    public int airRemaining;
    public int airRemaining2;
    public int thermalLevel;
    public boolean thermalLevelNormalising;
    public int damageCounter;
    public int spaceshipTier = 1;
    public NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    public int rocketType;
    public int fuelLevel;
    public Item rocketItem;
    public ItemStack launchpadStack;
    public int astroMinerCount = 0;
    private List<BlockVec3> activeAstroMinerChunks = new LinkedList<BlockVec3>();
    public boolean usingParachute;
    public ItemStack parachuteInSlot = ItemStack.field_190927_a;
    public ItemStack lastParachuteInSlot = ItemStack.field_190927_a;
    public ItemStack frequencyModuleInSlot = ItemStack.field_190927_a;
    public ItemStack lastFrequencyModuleInSlot = ItemStack.field_190927_a;
    public ItemStack maskInSlot = ItemStack.field_190927_a;
    public ItemStack lastMaskInSlot = ItemStack.field_190927_a;
    public ItemStack gearInSlot = ItemStack.field_190927_a;
    public ItemStack lastGearInSlot = ItemStack.field_190927_a;
    public ItemStack tankInSlot1 = ItemStack.field_190927_a;
    public ItemStack lastTankInSlot1 = ItemStack.field_190927_a;
    public ItemStack tankInSlot2 = ItemStack.field_190927_a;
    public ItemStack lastTankInSlot2 = ItemStack.field_190927_a;
    public ItemStack thermalHelmetInSlot = ItemStack.field_190927_a;
    public ItemStack lastThermalHelmetInSlot = ItemStack.field_190927_a;
    public ItemStack thermalChestplateInSlot = ItemStack.field_190927_a;
    public ItemStack lastThermalChestplateInSlot = ItemStack.field_190927_a;
    public ItemStack thermalLeggingsInSlot = ItemStack.field_190927_a;
    public ItemStack lastThermalLeggingsInSlot = ItemStack.field_190927_a;
    public ItemStack thermalBootsInSlot = ItemStack.field_190927_a;
    public ItemStack lastThermalBootsInSlot = ItemStack.field_190927_a;
    public ItemStack shieldControllerInSlot = ItemStack.field_190927_a;
    public ItemStack lastShieldControllerInSlot = ItemStack.field_190927_a;
    public int launchAttempts = 0;
    public int spaceRaceInviteTeamID;
    public boolean usingPlanetSelectionGui;
    public String savedPlanetList = "";
    public int openPlanetSelectionGuiCooldown;
    public boolean hasOpenedPlanetSelectionGui = false;
    public int chestSpawnCooldown;
    public Vector3 chestSpawnVector;
    public int teleportCooldown;
    public int chatCooldown;
    public double distanceSinceLastStep;
    public int lastStep;
    public double coordsTeleportedFromX;
    public double coordsTeleportedFromZ;
    public HashMap<Integer, Integer> spaceStationDimensionData = Maps.newHashMap();
    public boolean oxygenSetupValid;
    public boolean lastOxygenSetupValid;
    public boolean touchedGround;
    public boolean lastOnGround;
    public boolean inLander;
    public boolean justLanded;
    public List<ISchematicPage> unlockedSchematics = new LinkedList<ISchematicPage>();
    public List<ISchematicPage> lastUnlockedSchematics = new LinkedList<ISchematicPage>();
    public int cryogenicChamberCooldown;
    public boolean receivedSoundWarning;
    public boolean receivedBedWarning;
    public boolean openedSpaceRaceManager = false;
    public boolean sentFlags = false;
    public boolean newInOrbit = true;
    public boolean newAdventureSpawn;
    public int buildFlags = 0;
    public int incrementalDamage = 0;
    public String startDimension = "";
    public int glassColor1 = -1;
    public int glassColor2 = -1;
    public int glassColor3 = -1;
    private IBlockState[] panelLightingBases = new IBlockState[BlockPanelLighting.PANELTYPES_LENGTH];
    private int panelLightingColor = 0xF0F0E0;

    @Override
    public WeakReference<EntityPlayerMP> getPlayer() {
        return this.player;
    }

    @Override
    public void setPlayer(WeakReference<EntityPlayerMP> player) {
        this.player = player;
    }

    @Override
    public InventoryExtended getExtendedInventory() {
        return this.extendedInventory;
    }

    @Override
    public void setExtendedInventory(InventoryExtended extendedInventory) {
        this.extendedInventory = extendedInventory;
    }

    @Override
    public int getAirRemaining() {
        return this.airRemaining;
    }

    @Override
    public void setAirRemaining(int airRemaining) {
        this.airRemaining = airRemaining;
    }

    @Override
    public int getAirRemaining2() {
        return this.airRemaining2;
    }

    @Override
    public void setAirRemaining2(int airRemaining2) {
        this.airRemaining2 = airRemaining2;
    }

    @Override
    public int getThermalLevel() {
        return this.thermalLevel;
    }

    @Override
    public void setThermalLevel(int thermalLevel) {
        this.thermalLevel = thermalLevel;
    }

    @Override
    public boolean isThermalLevelNormalising() {
        return this.thermalLevelNormalising;
    }

    @Override
    public void setThermalLevelNormalising(boolean thermalLevelNormalising) {
        this.thermalLevelNormalising = thermalLevelNormalising;
    }

    @Override
    public int getDamageCounter() {
        return this.damageCounter;
    }

    @Override
    public void setDamageCounter(int damageCounter) {
        this.damageCounter = damageCounter;
    }

    @Override
    public int getSpaceshipTier() {
        return this.spaceshipTier;
    }

    @Override
    public void setSpaceshipTier(int spaceshipTier) {
        this.spaceshipTier = spaceshipTier;
    }

    @Override
    public NonNullList<ItemStack> getRocketStacks() {
        return this.stacks;
    }

    @Override
    public void setRocketStacks(NonNullList<ItemStack> rocketStacks) {
        this.stacks = rocketStacks;
    }

    @Override
    public int getRocketType() {
        return this.rocketType;
    }

    @Override
    public void setRocketType(int rocketType) {
        this.rocketType = rocketType;
    }

    @Override
    public int getFuelLevel() {
        return this.fuelLevel;
    }

    @Override
    public void setFuelLevel(int fuelLevel) {
        this.fuelLevel = fuelLevel;
    }

    @Override
    public Item getRocketItem() {
        return this.rocketItem;
    }

    @Override
    public void setRocketItem(Item rocketItem) {
        this.rocketItem = rocketItem;
    }

    @Override
    @Nullable
    public ItemStack getLaunchpadStack() {
        return this.launchpadStack;
    }

    @Override
    public void setLaunchpadStack(ItemStack launchpadStack) {
        this.launchpadStack = launchpadStack;
    }

    @Override
    public int getAstroMinerCount() {
        return this.astroMinerCount;
    }

    @Override
    public void setAstroMinerCount(int astroMinerCount) {
        this.astroMinerCount = astroMinerCount;
    }

    @Override
    public List<BlockVec3> getActiveAstroMinerChunks() {
        return this.activeAstroMinerChunks;
    }

    @Override
    public boolean isUsingParachute() {
        return this.usingParachute;
    }

    @Override
    public void setUsingParachute(boolean usingParachute) {
        this.usingParachute = usingParachute;
    }

    @Override
    public ItemStack getParachuteInSlot() {
        return this.parachuteInSlot;
    }

    @Override
    public void setParachuteInSlot(ItemStack parachuteInSlot) {
        this.parachuteInSlot = parachuteInSlot;
    }

    @Override
    public ItemStack getLastParachuteInSlot() {
        return this.lastParachuteInSlot;
    }

    @Override
    public void setLastParachuteInSlot(ItemStack lastParachuteInSlot) {
        this.lastParachuteInSlot = lastParachuteInSlot;
    }

    @Override
    public ItemStack getFrequencyModuleInSlot() {
        return this.frequencyModuleInSlot;
    }

    @Override
    public void setFrequencyModuleInSlot(ItemStack frequencyModuleInSlot) {
        this.frequencyModuleInSlot = frequencyModuleInSlot;
    }

    @Override
    public ItemStack getLastFrequencyModuleInSlot() {
        return this.lastFrequencyModuleInSlot;
    }

    @Override
    public void setLastFrequencyModuleInSlot(ItemStack lastFrequencyModuleInSlot) {
        this.lastFrequencyModuleInSlot = lastFrequencyModuleInSlot;
    }

    @Override
    public ItemStack getMaskInSlot() {
        return this.maskInSlot;
    }

    @Override
    public void setMaskInSlot(ItemStack maskInSlot) {
        this.maskInSlot = maskInSlot;
    }

    @Override
    public ItemStack getLastMaskInSlot() {
        return this.lastMaskInSlot;
    }

    @Override
    public void setLastMaskInSlot(ItemStack lastMaskInSlot) {
        this.lastMaskInSlot = lastMaskInSlot;
    }

    @Override
    public ItemStack getGearInSlot() {
        return this.gearInSlot;
    }

    @Override
    public void setGearInSlot(ItemStack gearInSlot) {
        this.gearInSlot = gearInSlot;
    }

    @Override
    public ItemStack getLastGearInSlot() {
        return this.lastGearInSlot;
    }

    @Override
    public void setLastGearInSlot(ItemStack lastGearInSlot) {
        this.lastGearInSlot = lastGearInSlot;
    }

    @Override
    public ItemStack getTankInSlot1() {
        return this.tankInSlot1;
    }

    @Override
    public void setTankInSlot1(ItemStack tankInSlot1) {
        this.tankInSlot1 = tankInSlot1;
    }

    @Override
    public ItemStack getLastTankInSlot1() {
        return this.lastTankInSlot1;
    }

    @Override
    public void setLastTankInSlot1(ItemStack lastTankInSlot1) {
        this.lastTankInSlot1 = lastTankInSlot1;
    }

    @Override
    public ItemStack getTankInSlot2() {
        return this.tankInSlot2;
    }

    @Override
    public void setTankInSlot2(ItemStack tankInSlot2) {
        this.tankInSlot2 = tankInSlot2;
    }

    @Override
    public ItemStack getLastTankInSlot2() {
        return this.lastTankInSlot2;
    }

    @Override
    public void setLastTankInSlot2(ItemStack lastTankInSlot2) {
        this.lastTankInSlot2 = lastTankInSlot2;
    }

    @Override
    public ItemStack getThermalHelmetInSlot() {
        return this.thermalHelmetInSlot;
    }

    @Override
    public void setThermalHelmetInSlot(ItemStack thermalHelmetInSlot) {
        this.thermalHelmetInSlot = thermalHelmetInSlot;
    }

    @Override
    public ItemStack getLastThermalHelmetInSlot() {
        return this.lastThermalHelmetInSlot;
    }

    @Override
    public void setLastThermalHelmetInSlot(ItemStack lastThermalHelmetInSlot) {
        this.lastThermalHelmetInSlot = lastThermalHelmetInSlot;
    }

    @Override
    public ItemStack getThermalChestplateInSlot() {
        return this.thermalChestplateInSlot;
    }

    @Override
    public void setThermalChestplateInSlot(ItemStack thermalChestplateInSlot) {
        this.thermalChestplateInSlot = thermalChestplateInSlot;
    }

    @Override
    public ItemStack getLastThermalChestplateInSlot() {
        return this.lastThermalChestplateInSlot;
    }

    @Override
    public void setLastThermalChestplateInSlot(ItemStack lastThermalChestplateInSlot) {
        this.lastThermalChestplateInSlot = lastThermalChestplateInSlot;
    }

    @Override
    public ItemStack getThermalLeggingsInSlot() {
        return this.thermalLeggingsInSlot;
    }

    @Override
    public void setThermalLeggingsInSlot(ItemStack thermalLeggingsInSlot) {
        this.thermalLeggingsInSlot = thermalLeggingsInSlot;
    }

    @Override
    public ItemStack getLastThermalLeggingsInSlot() {
        return this.lastThermalLeggingsInSlot;
    }

    @Override
    public void setLastThermalLeggingsInSlot(ItemStack lastThermalLeggingsInSlot) {
        this.lastThermalLeggingsInSlot = lastThermalLeggingsInSlot;
    }

    @Override
    public ItemStack getThermalBootsInSlot() {
        return this.thermalBootsInSlot;
    }

    @Override
    public void setThermalBootsInSlot(ItemStack thermalBootsInSlot) {
        this.thermalBootsInSlot = thermalBootsInSlot;
    }

    @Override
    public ItemStack getLastThermalBootsInSlot() {
        return this.lastThermalBootsInSlot;
    }

    @Override
    public void setLastThermalBootsInSlot(ItemStack lastThermalBootsInSlot) {
        this.lastThermalBootsInSlot = lastThermalBootsInSlot;
    }

    @Override
    public ItemStack getShieldControllerInSlot() {
        return this.shieldControllerInSlot;
    }

    @Override
    public void setShieldControllerInSlot(ItemStack shieldControllerInSlot) {
        this.shieldControllerInSlot = shieldControllerInSlot;
    }

    @Override
    public ItemStack getLastShieldControllerInSlot() {
        return this.lastShieldControllerInSlot;
    }

    @Override
    public void setLastShieldControllerInSlot(ItemStack lastShieldControllerInSlot) {
        this.lastShieldControllerInSlot = lastShieldControllerInSlot;
    }

    @Override
    public int getLaunchAttempts() {
        return this.launchAttempts;
    }

    @Override
    public void setLaunchAttempts(int launchAttempts) {
        this.launchAttempts = launchAttempts;
    }

    @Override
    public int getSpaceRaceInviteTeamID() {
        return this.spaceRaceInviteTeamID;
    }

    @Override
    public void setSpaceRaceInviteTeamID(int spaceRaceInviteTeamID) {
        this.spaceRaceInviteTeamID = spaceRaceInviteTeamID;
    }

    @Override
    public boolean isUsingPlanetSelectionGui() {
        return this.usingPlanetSelectionGui;
    }

    @Override
    public void setUsingPlanetSelectionGui(boolean usingPlanetSelectionGui) {
        this.usingPlanetSelectionGui = usingPlanetSelectionGui;
    }

    @Override
    public String getSavedPlanetList() {
        return this.savedPlanetList;
    }

    @Override
    public void setSavedPlanetList(String savedPlanetList) {
        this.savedPlanetList = savedPlanetList;
    }

    @Override
    public int getOpenPlanetSelectionGuiCooldown() {
        return this.openPlanetSelectionGuiCooldown;
    }

    @Override
    public void setOpenPlanetSelectionGuiCooldown(int openPlanetSelectionGuiCooldown) {
        this.openPlanetSelectionGuiCooldown = openPlanetSelectionGuiCooldown;
    }

    @Override
    public boolean hasOpenedPlanetSelectionGui() {
        return this.hasOpenedPlanetSelectionGui;
    }

    @Override
    public void setHasOpenedPlanetSelectionGui(boolean hasOpenedPlanetSelectionGui) {
        this.hasOpenedPlanetSelectionGui = hasOpenedPlanetSelectionGui;
    }

    @Override
    public int getChestSpawnCooldown() {
        return this.chestSpawnCooldown;
    }

    @Override
    public void setChestSpawnCooldown(int chestSpawnCooldown) {
        this.chestSpawnCooldown = chestSpawnCooldown;
    }

    @Override
    public Vector3 getChestSpawnVector() {
        return this.chestSpawnVector;
    }

    @Override
    public void setChestSpawnVector(Vector3 chestSpawnVector) {
        this.chestSpawnVector = chestSpawnVector;
    }

    @Override
    public int getTeleportCooldown() {
        return this.teleportCooldown;
    }

    @Override
    public void setTeleportCooldown(int teleportCooldown) {
        this.teleportCooldown = teleportCooldown;
    }

    @Override
    public int getChatCooldown() {
        return this.chatCooldown;
    }

    @Override
    public void setChatCooldown(int chatCooldown) {
        this.chatCooldown = chatCooldown;
    }

    @Override
    public double getDistanceSinceLastStep() {
        return this.distanceSinceLastStep;
    }

    @Override
    public void setDistanceSinceLastStep(double distanceSinceLastStep) {
        this.distanceSinceLastStep = distanceSinceLastStep;
    }

    @Override
    public int getLastStep() {
        return this.lastStep;
    }

    @Override
    public void setLastStep(int lastStep) {
        this.lastStep = lastStep;
    }

    @Override
    public double getCoordsTeleportedFromX() {
        return this.coordsTeleportedFromX;
    }

    @Override
    public void setCoordsTeleportedFromX(double coordsTeleportedFromX) {
        this.coordsTeleportedFromX = coordsTeleportedFromX;
    }

    @Override
    public double getCoordsTeleportedFromZ() {
        return this.coordsTeleportedFromZ;
    }

    @Override
    public void setCoordsTeleportedFromZ(double coordsTeleportedFromZ) {
        this.coordsTeleportedFromZ = coordsTeleportedFromZ;
    }

    @Override
    public HashMap<Integer, Integer> getSpaceStationDimensionData() {
        return this.spaceStationDimensionData;
    }

    @Override
    public void setSpaceStationDimensionData(HashMap<Integer, Integer> spaceStationDimensionData) {
        this.spaceStationDimensionData = spaceStationDimensionData;
    }

    @Override
    public boolean isOxygenSetupValid() {
        return this.oxygenSetupValid;
    }

    @Override
    public void setOxygenSetupValid(boolean oxygenSetupValid) {
        this.oxygenSetupValid = oxygenSetupValid;
    }

    @Override
    public boolean isLastOxygenSetupValid() {
        return this.lastOxygenSetupValid;
    }

    @Override
    public void setLastOxygenSetupValid(boolean lastOxygenSetupValid) {
        this.lastOxygenSetupValid = lastOxygenSetupValid;
    }

    @Override
    public boolean isTouchedGround() {
        return this.touchedGround;
    }

    @Override
    public void setTouchedGround(boolean touchedGround) {
        this.touchedGround = touchedGround;
    }

    @Override
    public boolean isLastOnGround() {
        return this.lastOnGround;
    }

    @Override
    public void setLastOnGround(boolean lastOnGround) {
        this.lastOnGround = lastOnGround;
    }

    @Override
    public boolean isInLander() {
        return this.inLander;
    }

    @Override
    public void setInLander(boolean inLander) {
        this.inLander = inLander;
    }

    @Override
    public boolean hasJustLanded() {
        return this.justLanded;
    }

    @Override
    public void setJustLanded(boolean justLanded) {
        this.justLanded = justLanded;
    }

    @Override
    public List<ISchematicPage> getUnlockedSchematics() {
        return this.unlockedSchematics;
    }

    @Override
    public void setUnlockedSchematics(List<ISchematicPage> unlockedSchematics) {
        this.unlockedSchematics = unlockedSchematics;
    }

    @Override
    public List<ISchematicPage> getLastUnlockedSchematics() {
        return this.lastUnlockedSchematics;
    }

    @Override
    public void setLastUnlockedSchematics(List<ISchematicPage> lastUnlockedSchematics) {
        this.lastUnlockedSchematics = lastUnlockedSchematics;
    }

    @Override
    public int getCryogenicChamberCooldown() {
        return this.cryogenicChamberCooldown;
    }

    @Override
    public void setCryogenicChamberCooldown(int cryogenicChamberCooldown) {
        this.cryogenicChamberCooldown = cryogenicChamberCooldown;
    }

    @Override
    public boolean hasReceivedSoundWarning() {
        return this.receivedSoundWarning;
    }

    @Override
    public void setReceivedSoundWarning(boolean receivedSoundWarning) {
        this.receivedSoundWarning = receivedSoundWarning;
    }

    @Override
    public boolean hasReceivedBedWarning() {
        return this.receivedBedWarning;
    }

    @Override
    public void setReceivedBedWarning(boolean receivedBedWarning) {
        this.receivedBedWarning = receivedBedWarning;
    }

    @Override
    public boolean hasOpenedSpaceRaceManager() {
        return this.openedSpaceRaceManager;
    }

    @Override
    public void setOpenedSpaceRaceManager(boolean openedSpaceRaceManager) {
        this.openedSpaceRaceManager = openedSpaceRaceManager;
    }

    @Override
    public boolean hasSentFlags() {
        return this.sentFlags;
    }

    @Override
    public void setSentFlags(boolean sentFlags) {
        this.sentFlags = sentFlags;
    }

    @Override
    public boolean isNewInOrbit() {
        return this.newInOrbit;
    }

    @Override
    public void setNewInOrbit(boolean newInOrbit) {
        this.newInOrbit = newInOrbit;
    }

    @Override
    public boolean isNewAdventureSpawn() {
        return this.newAdventureSpawn;
    }

    @Override
    public void setNewAdventureSpawn(boolean newAdventureSpawn) {
        this.newAdventureSpawn = newAdventureSpawn;
    }

    @Override
    public int getBuildFlags() {
        return this.buildFlags;
    }

    @Override
    public void setBuildFlags(int buildFlags) {
        this.buildFlags = buildFlags;
    }

    @Override
    public int getIncrementalDamage() {
        return this.incrementalDamage;
    }

    @Override
    public void setIncrementalDamage(int incrementalDamage) {
        this.incrementalDamage = incrementalDamage;
    }

    @Override
    public String getStartDimension() {
        return this.startDimension;
    }

    @Override
    public void setStartDimension(String startDimension) {
        this.startDimension = startDimension;
    }

    @Override
    public void saveNBTData(NBTTagCompound nbt) {
        nbt.func_74782_a("ExtendedInventoryGC", (NBTBase)this.extendedInventory.writeToNBT(new NBTTagList()));
        nbt.func_74768_a("playerAirRemaining", this.airRemaining);
        nbt.func_74768_a("damageCounter", this.damageCounter);
        nbt.func_74757_a("OxygenSetupValid", this.oxygenSetupValid);
        nbt.func_74757_a("usingParachute2", this.usingParachute);
        nbt.func_74757_a("usingPlanetSelectionGui", this.usingPlanetSelectionGui);
        nbt.func_74768_a("teleportCooldown", this.teleportCooldown);
        nbt.func_74780_a("coordsTeleportedFromX", this.coordsTeleportedFromX);
        nbt.func_74780_a("coordsTeleportedFromZ", this.coordsTeleportedFromZ);
        nbt.func_74778_a("startDimension", this.startDimension);
        nbt.func_74778_a("spaceStationDimensionInfo", WorldUtil.spaceStationDataToString(this.spaceStationDimensionData));
        nbt.func_74768_a("thermalLevel", this.thermalLevel);
        Collections.sort(this.unlockedSchematics);
        NBTTagList tagList = new NBTTagList();
        for (ISchematicPage page : this.unlockedSchematics) {
            if (page == null) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("UnlockedPage", page.getPageID());
            tagList.func_74742_a((NBTBase)nbttagcompound);
        }
        nbt.func_74782_a("Schematics", (NBTBase)tagList);
        nbt.func_74768_a("rocketStacksLength", this.stacks.size());
        nbt.func_74768_a("SpaceshipTier", this.spaceshipTier);
        nbt.func_74768_a("FuelLevel", this.fuelLevel);
        if (this.rocketItem != null) {
            ItemStack returnRocket = new ItemStack(this.rocketItem, 1, this.rocketType);
            nbt.func_74782_a("ReturnRocket", (NBTBase)returnRocket.func_77955_b(new NBTTagCompound()));
        }
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.stacks.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.stacks.get(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (!nbttaglist.func_82582_d()) {
            nbt.func_74782_a("RocketItems", (NBTBase)nbttaglist);
        }
        NBTTagCompound var4 = new NBTTagCompound();
        if (this.launchpadStack != null) {
            nbt.func_74782_a("LaunchpadStack", (NBTBase)this.launchpadStack.func_77955_b(var4));
        } else {
            nbt.func_74782_a("LaunchpadStack", (NBTBase)var4);
        }
        nbt.func_74768_a("CryogenicChamberCooldown", this.cryogenicChamberCooldown);
        nbt.func_74757_a("ReceivedSoundWarning", this.receivedSoundWarning);
        nbt.func_74757_a("ReceivedBedWarning", this.receivedBedWarning);
        nbt.func_74768_a("BuildFlags", this.buildFlags);
        nbt.func_74757_a("ShownSpaceRace", this.openedSpaceRaceManager);
        nbt.func_74768_a("AstroMinerCount", this.astroMinerCount);
        NBTTagList astroList = new NBTTagList();
        for (BlockVec3 data : this.activeAstroMinerChunks) {
            if (data == null) continue;
            astroList.func_74742_a((NBTBase)data.writeToNBT(new NBTTagCompound()));
        }
        nbt.func_74782_a("AstroData", (NBTBase)astroList);
        nbt.func_74768_a("GlassColor1", this.glassColor1);
        nbt.func_74768_a("GlassColor2", this.glassColor2);
        nbt.func_74768_a("GlassColor3", this.glassColor3);
        NBTTagList panelList = new NBTTagList();
        for (int i = 0; i < BlockPanelLighting.PANELTYPES_LENGTH; ++i) {
            NBTTagCompound stateNBT = new NBTTagCompound();
            IBlockState bs = this.panelLightingBases[i];
            if (bs != null) {
                TileEntityPanelLight.writeBlockState(stateNBT, bs);
            }
            panelList.func_74742_a((NBTBase)stateNBT);
        }
        nbt.func_74782_a("PanLi", (NBTBase)panelList);
        nbt.func_74768_a("PanCo", this.panelLightingColor);
    }

    @Override
    public void loadNBTData(NBTTagCompound nbt) {
        try {
            ItemStack[] saveinv;
            EntityPlayerMP p;
            this.airRemaining = nbt.func_74762_e("playerAirRemaining");
            this.damageCounter = nbt.func_74762_e("damageCounter");
            this.oxygenSetupValid = this.lastOxygenSetupValid = nbt.func_74767_n("OxygenSetupValid");
            this.thermalLevel = nbt.func_74762_e("thermalLevel");
            NBTTagList nbttaglist = nbt.func_150295_c("Inventory", 10);
            this.extendedInventory.readFromNBTOld(nbttaglist);
            if (nbt.func_74764_b("ExtendedInventoryGC")) {
                this.extendedInventory.readFromNBT(nbt.func_150295_c("ExtendedInventoryGC", 10));
            }
            if ((p = (EntityPlayerMP)this.player.get()) != null && (saveinv = CommandGCInv.getSaveData(p.func_146103_bH().getName().toLowerCase())) != null) {
                CommandGCInv.doLoad(p);
            }
            if (nbt.func_74764_b("SpaceshipTier")) {
                this.spaceshipTier = nbt.func_74762_e("SpaceshipTier");
            }
            if (nbt.func_74764_b("FuelLevel")) {
                this.fuelLevel = nbt.func_74762_e("FuelLevel");
            }
            if (nbt.func_74764_b("ReturnRocket")) {
                ItemStack returnRocket = new ItemStack(nbt.func_74775_l("ReturnRocket"));
                this.rocketItem = returnRocket.func_77973_b();
                this.rocketType = returnRocket.func_77952_i();
            }
            this.usingParachute = nbt.func_74767_n("usingParachute2");
            this.usingPlanetSelectionGui = nbt.func_74767_n("usingPlanetSelectionGui");
            this.teleportCooldown = nbt.func_74762_e("teleportCooldown");
            this.coordsTeleportedFromX = nbt.func_74769_h("coordsTeleportedFromX");
            this.coordsTeleportedFromZ = nbt.func_74769_h("coordsTeleportedFromZ");
            this.startDimension = nbt.func_74764_b("startDimension") ? nbt.func_74779_i("startDimension") : "";
            this.spaceStationDimensionData = nbt.func_74764_b("spaceStationDimensionID") ? WorldUtil.stringToSpaceStationData("0$" + nbt.func_74762_e("spaceStationDimensionID")) : WorldUtil.stringToSpaceStationData(nbt.func_74779_i("spaceStationDimensionInfo"));
            if (nbt.func_74767_n("usingPlanetSelectionGui")) {
                this.openPlanetSelectionGuiCooldown = 20;
            }
            if (nbt.func_74764_b("RocketItems") && nbt.func_74764_b("rocketStacksLength")) {
                int length = nbt.func_74762_e("rocketStacksLength");
                this.stacks = NonNullList.func_191197_a((int)length, (Object)ItemStack.field_190927_a);
                NBTTagList nbttaglist1 = nbt.func_150295_c("RocketItems", 10);
                for (int i = 0; i < nbttaglist1.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbttaglist1.func_150305_b(i);
                    int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
                    if (j < 0 || j >= this.stacks.size()) continue;
                    this.stacks.set(j, (Object)new ItemStack(nbttagcompound));
                }
            }
            this.unlockedSchematics = new ArrayList<ISchematicPage>();
            if (p != null) {
                for (int i = 0; i < nbt.func_150295_c("Schematics", 10).func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = nbt.func_150295_c("Schematics", 10).func_150305_b(i);
                    int j = nbttagcompound.func_74762_e("UnlockedPage");
                    SchematicRegistry.addUnlockedPage(p, SchematicRegistry.getMatchingRecipeForID(j));
                }
            }
            Collections.sort(this.unlockedSchematics);
            this.cryogenicChamberCooldown = nbt.func_74762_e("CryogenicChamberCooldown");
            if (nbt.func_74764_b("ReceivedSoundWarning")) {
                this.receivedSoundWarning = nbt.func_74767_n("ReceivedSoundWarning");
            }
            if (nbt.func_74764_b("ReceivedBedWarning")) {
                this.receivedBedWarning = nbt.func_74767_n("ReceivedBedWarning");
            }
            this.launchpadStack = nbt.func_74764_b("LaunchpadStack") ? new ItemStack(nbt.func_74775_l("LaunchpadStack")) : new ItemStack(GCBlocks.landingPad, 9, 0);
            if (nbt.func_74764_b("BuildFlags")) {
                this.buildFlags = nbt.func_74762_e("BuildFlags");
            }
            if (nbt.func_74764_b("ShownSpaceRace")) {
                this.openedSpaceRaceManager = nbt.func_74767_n("ShownSpaceRace");
            }
            if (nbt.func_74764_b("AstroMinerCount")) {
                this.astroMinerCount = nbt.func_74762_e("AstroMinerCount");
            }
            if (nbt.func_74764_b("AstroData")) {
                this.activeAstroMinerChunks.clear();
                NBTTagList astroList = nbt.func_150295_c("AstroData", 10);
                for (int i = 0; i < astroList.func_74745_c(); ++i) {
                    NBTTagCompound nbttagcompound = astroList.func_150305_b(i);
                    BlockVec3 data = BlockVec3.readFromNBT(nbttagcompound);
                    this.activeAstroMinerChunks.add(data);
                }
                if (GalacticraftCore.isPlanetsLoaded) {
                    AsteroidsTickHandlerServer.loadAstroChunkList(this.activeAstroMinerChunks);
                }
            }
            if (nbt.func_74764_b("GlassColor1")) {
                this.glassColor1 = nbt.func_74762_e("GlassColor1");
                this.glassColor2 = nbt.func_74762_e("GlassColor2");
                this.glassColor3 = nbt.func_74762_e("GlassColor3");
            }
            if (nbt.func_74764_b("PanLi")) {
                NBTTagList panels = nbt.func_150295_c("PanLi", 10);
                for (int i = 0; i < panels.func_74745_c() && i != BlockPanelLighting.PANELTYPES_LENGTH; ++i) {
                    NBTTagCompound stateNBT = panels.func_150305_b(i);
                    IBlockState bs = TileEntityPanelLight.readBlockState(stateNBT);
                    this.panelLightingBases[i] = bs.func_177230_c() == Blocks.field_150350_a ? null : bs;
                }
            }
            if (nbt.func_74764_b("PanCo")) {
                this.panelLightingColor = nbt.func_74762_e("PanCo");
            }
            GCLog.debug("Loading GC player data for " + ((EntityPlayerMP)this.player.get()).func_146103_bH().getName() + " : " + this.buildFlags);
            this.sentFlags = false;
        }
        catch (Exception e) {
            GCLog.severe("Found error in saved Galacticraft player data for " + ((EntityPlayerMP)this.player.get()).func_146103_bH().getName() + " - this should fix itself next relog.");
            e.printStackTrace();
        }
        GCLog.debug("Finished loading GC player data for " + ((EntityPlayerMP)this.player.get()).func_146103_bH().getName() + " : " + this.buildFlags);
    }

    @Override
    public void copyFrom(GCPlayerStats oldData, boolean keepInv) {
        if (keepInv) {
            this.extendedInventory.copyInventory(oldData.getExtendedInventory());
        }
        this.spaceStationDimensionData = oldData.getSpaceStationDimensionData();
        this.unlockedSchematics = oldData.getUnlockedSchematics();
        this.receivedSoundWarning = oldData.hasReceivedSoundWarning();
        this.receivedBedWarning = oldData.hasReceivedBedWarning();
        this.openedSpaceRaceManager = oldData.hasOpenedSpaceRaceManager();
        this.spaceRaceInviteTeamID = oldData.getSpaceRaceInviteTeamID();
        this.buildFlags = oldData.getBuildFlags();
        this.glassColor1 = oldData.getGlassColor1();
        this.glassColor2 = oldData.getGlassColor2();
        this.glassColor3 = oldData.getGlassColor3();
        this.panelLightingBases = oldData.getPanelLightingBases();
        this.panelLightingColor = oldData.getPanelLightingColor();
        this.astroMinerCount = oldData.getAstroMinerCount();
        this.activeAstroMinerChunks = oldData.getActiveAstroMinerChunks();
        this.sentFlags = false;
    }

    @Override
    public void setGlassColors(int color1, int color2, int color3) {
        boolean changes = false;
        if (this.glassColor1 != color1) {
            changes = true;
            this.glassColor1 = color1;
        }
        if (this.glassColor2 != color2) {
            changes = true;
            this.glassColor2 = color2;
        }
        if (this.glassColor3 != color3) {
            changes = true;
            this.glassColor3 = color3;
        }
        if (changes) {
            ColorUtil.sendUpdatedColorsToPlayer(this);
        }
    }

    @Override
    public int getGlassColor1() {
        return this.glassColor1;
    }

    @Override
    public int getGlassColor2() {
        return this.glassColor2;
    }

    @Override
    public int getGlassColor3() {
        return this.glassColor3;
    }

    @Override
    public IBlockState[] getPanelLightingBases() {
        return this.panelLightingBases;
    }

    @Override
    public int getPanelLightingColor() {
        return this.panelLightingColor;
    }

    @Override
    public void setPanelLightingColor(int color) {
        this.panelLightingColor = color;
    }

    @Override
    public Object[] getMiscNetworkedStats() {
        int length = 2 + BlockPanelLighting.PANELTYPES_LENGTH * 2;
        Object[] result = new Object[length];
        result[0] = this.getBuildFlags();
        BlockPanelLighting.getNetworkedData(result, this.panelLightingBases);
        result[length - 1] = this.panelLightingColor;
        return result;
    }
}

