/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import micdoodle8.mods.galacticraft.api.tile.ITileClientUpdates;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.network.IPacketReceiver;
import micdoodle8.mods.galacticraft.core.network.PacketDynamic;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.RedstoneUtil;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAir;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.monster.IMob;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityArclamp
extends TileEntity
implements ITickable,
ITileClientUpdates,
IPacketReceiver {
    private static final int LIGHTRANGE = 14;
    private int ticks = 0;
    private int sideRear = 0;
    public int facing = 0;
    private HashSet<BlockVec3> airToRestore = new HashSet();
    private static intBucket[] buckets;
    private static AtomicBoolean usingBuckets;
    private static int[] lightUpdateBlockList;
    private boolean isActive = false;
    private AxisAlignedBB thisAABB;
    private AxisAlignedBB renderAABB;
    private Vec3d thisPos;
    private int facingSide = 0;

    public void func_73660_a() {
        boolean initialLight = false;
        if (RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.func_174877_v())) {
            if (this.isActive) {
                this.isActive = false;
                this.revertAir();
                this.func_70296_d();
            }
        } else if (!this.isActive) {
            this.isActive = true;
            initialLight = true;
        }
        if (this.isActive) {
            List moblist;
            if (this.thisAABB == null) {
                initialLight = true;
                int side = this.func_145832_p();
                switch (side) {
                    case 0: {
                        this.sideRear = side;
                        this.facingSide = this.facing + 2;
                        break;
                    }
                    case 1: {
                        this.sideRear = side;
                        this.facingSide = this.facing + 2;
                        break;
                    }
                    case 2: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing <= 1) break;
                        this.facingSide = 7 - this.facing;
                        break;
                    }
                    case 3: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing <= 1) break;
                        this.facingSide += 2;
                        break;
                    }
                    case 4: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        break;
                    }
                    case 5: {
                        this.sideRear = side;
                        this.facingSide = this.facing;
                        if (this.facing <= 1) break;
                        this.facingSide = 5 - this.facing;
                        break;
                    }
                }
                this.thisAABB = this.getAABBforSideAndFacing();
            }
            if (initialLight || this.ticks % 100 == 0) {
                this.lightArea();
            }
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextInt(10) == 0 && !(moblist = this.field_145850_b.func_175674_a(null, this.thisAABB, IMob.field_82192_a)).isEmpty()) {
                Vec3d thisVec3 = new Vec3d((double)this.func_174877_v().func_177958_n(), (double)this.func_174877_v().func_177956_o(), (double)this.func_174877_v().func_177952_p());
                for (Entity entry : moblist) {
                    double distanceCurrent;
                    double distanceNew;
                    Vec3d vecNewTarget;
                    EntityCreature mob;
                    PathNavigate nav;
                    if (!(entry instanceof EntityCreature) || (nav = (mob = (EntityCreature)entry).func_70661_as()) == null || (vecNewTarget = RandomPositionGenerator.func_75461_b((EntityCreature)mob, (int)28, (int)11, (Vec3d)this.thisPos)) == null || !((distanceNew = vecNewTarget.func_72438_d(thisVec3)) > (distanceCurrent = thisVec3.func_72436_e(new Vec3d(mob.field_70165_t, mob.field_70163_u, mob.field_70161_v))))) continue;
                    Vec3d vecOldTarget = null;
                    if (nav.func_75505_d() != null && !nav.func_75505_d().func_75879_b()) {
                        vecOldTarget = nav.func_75505_d().func_75878_a((Entity)mob);
                    }
                    if (vecOldTarget != null && !(distanceCurrent > vecOldTarget.func_72436_e(thisVec3))) continue;
                    nav.func_75492_a(vecNewTarget.field_72450_a, vecNewTarget.field_72448_b, vecNewTarget.field_72449_c, 1.3);
                }
            }
        }
        ++this.ticks;
    }

    private AxisAlignedBB getAABBforSideAndFacing() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        int[] rangeForSide = new int[6];
        for (int i = 0; i < 6; ++i) {
            rangeForSide[i] = i == this.sideRear ? 2 : (i == (this.facingSide ^ 1) ? 4 : 25);
        }
        return new AxisAlignedBB((double)(x - rangeForSide[4]), (double)(y - rangeForSide[0]), (double)(z - rangeForSide[2]), (double)(x + rangeForSide[5]), (double)(y + rangeForSide[1]), (double)(z + rangeForSide[3]));
    }

    public void onLoad() {
        this.thisPos = new Vec3d((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5);
        this.ticks = 0;
        this.thisAABB = null;
        if (this.field_145850_b.field_72995_K) {
            this.clientOnLoad();
            GalacticraftCore.packetPipeline.sendToServer(new PacketDynamic(this));
        } else {
            this.isActive = true;
        }
    }

    public void func_145843_s() {
        this.revertAir();
        this.isActive = false;
        super.func_145843_s();
    }

    public void lightArea() {
        IBlockState iBlockState;
        IBlockState iBlockState2;
        if (usingBuckets.getAndSet(true)) {
            return;
        }
        Block air = Blocks.field_150350_a;
        Block breatheableAirID = GCBlocks.breatheableAir;
        IBlockState brightAir = GCBlocks.brightAir.func_176223_P();
        IBlockState brightBreatheableAir = GCBlocks.brightBreatheableAir.func_176223_P();
        boolean dirty = false;
        TileEntityArclamp.checkedClear();
        HashSet<BlockVec3> airToRevert = new HashSet<BlockVec3>();
        airToRevert.addAll(this.airToRestore);
        LinkedList<BlockVec3> airNew = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> currentLayer = new LinkedList<BlockVec3>();
        LinkedList<BlockVec3> nextLayer = new LinkedList<BlockVec3>();
        BlockVec3 thisvec = new BlockVec3(this);
        currentLayer.add(thisvec);
        World world = this.field_145850_b;
        int sideskip1 = this.sideRear;
        int sideskip2 = this.facingSide ^ 1;
        for (int i = 0; i < 6; ++i) {
            BlockVec3 onEitherSide;
            IBlockState iBlockState3;
            if (i == sideskip1 || i == sideskip2 || i == (sideskip1 ^ 1) || i == (sideskip2 ^ 1) || (iBlockState3 = (onEitherSide = thisvec.newVecSide(i)).getBlockStateSafe_noChunkLoad(world)).func_177230_c().func_149717_k(iBlockState3) >= 15) continue;
            currentLayer.add(onEitherSide);
        }
        BlockVec3 inFront = new BlockVec3(this);
        for (int i = 0; i < 4 && (iBlockState2 = (inFront = inFront.newVecSide(this.facingSide)).getBlockStateSafe_noChunkLoad(world)).func_177230_c().func_149717_k(iBlockState2) != 15 && (iBlockState = (inFront = inFront.newVecSide(sideskip1 ^ 1)).getBlockStateSafe_noChunkLoad(world)).func_177230_c().func_149717_k(iBlockState) < 15; ++i) {
            currentLayer.add(inFront);
        }
        inFront = new BlockVec3(this).newVecSide(this.facingSide);
        for (int count = 0; count < 14; ++count) {
            for (BlockVec3 vec : currentLayer) {
                if (count > 1) {
                    int offset = 0;
                    switch (this.facingSide) {
                        case 0: {
                            offset = inFront.y - vec.y;
                            break;
                        }
                        case 1: {
                            offset = vec.y - inFront.y;
                            break;
                        }
                        case 2: {
                            offset = inFront.z - vec.z;
                            break;
                        }
                        case 3: {
                            offset = vec.z - inFront.z;
                            break;
                        }
                        case 4: {
                            offset = inFront.x - vec.x;
                            break;
                        }
                        case 5: {
                            offset = vec.x - inFront.x;
                        }
                    }
                    int offset2 = 0;
                    switch (this.sideRear ^ 1) {
                        case 0: {
                            offset2 = inFront.y - vec.y;
                            break;
                        }
                        case 1: {
                            offset2 = vec.y - inFront.y;
                            break;
                        }
                        case 2: {
                            offset2 = inFront.z - vec.z;
                            break;
                        }
                        case 3: {
                            offset2 = vec.z - inFront.z;
                            break;
                        }
                        case 4: {
                            offset2 = inFront.x - vec.x;
                            break;
                        }
                        case 5: {
                            offset2 = vec.x - inFront.x;
                        }
                    }
                    if (offset2 - 2 > offset) {
                        offset = offset2 - 2;
                    }
                    if (Math.abs(vec.x - inFront.x) > offset + 2 || Math.abs(vec.y - inFront.y) > offset + 2 || Math.abs(vec.z - inFront.z) > offset + 2) continue;
                }
                int side = 0;
                int bits = vec.sideDoneBits;
                boolean doShine = false;
                do {
                    IBlockState bs;
                    Block b;
                    if ((bits & 1 << side) != 0) continue;
                    BlockVec3 sideVec = vec.newVecSide(side);
                    boolean toAdd = false;
                    if (!this.checkedContains(vec, side)) {
                        this.checkedAdd(sideVec);
                        toAdd = true;
                    }
                    if ((b = (bs = sideVec.getBlockStateSafe_noChunkLoad(world)).func_177230_c()) instanceof BlockAir) {
                        if (!toAdd || side == sideskip1 || side == sideskip2) continue;
                        nextLayer.add(sideVec);
                        continue;
                    }
                    doShine = true;
                    if (side == sideskip1 || side == sideskip2 || !toAdd || b == null || b.getLightOpacity(bs, (IBlockAccess)world, sideVec.toBlockPos()) != 0) continue;
                    nextLayer.add(sideVec);
                } while (++side < 6);
                if (!doShine) continue;
                airNew.add(vec);
                Block id = vec.getBlockStateSafe_noChunkLoad(world).func_177230_c();
                if (Blocks.field_150350_a == id) {
                    this.brightenAir(world, vec, brightAir);
                    dirty = true;
                    continue;
                }
                if (id != breatheableAirID) continue;
                this.brightenAir(world, vec, brightBreatheableAir);
                dirty = true;
            }
            if (nextLayer.size() == 0) break;
            currentLayer = nextLayer;
            nextLayer = new LinkedList();
        }
        if (dirty) {
            this.func_70296_d();
        }
        airToRevert.removeAll(airNew);
        for (Object e : airToRevert) {
            BlockVec3 vec;
            vec = (BlockVec3)e;
            this.setDarkerAir(vec);
            this.airToRestore.remove(vec);
        }
        usingBuckets.set(false);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.facing = nbt.func_74762_e("Facing");
        this.airToRestore.clear();
        NBTTagList airBlocks = nbt.func_150295_c("AirBlocks", 10);
        if (airBlocks.func_74745_c() > 0) {
            for (int j = airBlocks.func_74745_c() - 1; j >= 0; --j) {
                NBTTagCompound tag1 = airBlocks.func_150305_b(j);
                if (tag1 == null) continue;
                this.airToRestore.add(BlockVec3.readFromNBT(tag1));
            }
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Facing", this.facing);
        NBTTagList airBlocks = new NBTTagList();
        for (BlockVec3 vec : this.airToRestore) {
            NBTTagCompound tag = new NBTTagCompound();
            vec.writeToNBT(tag);
            airBlocks.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("AirBlocks", (NBTBase)airBlocks);
        return nbt;
    }

    public void facingChanged() {
        this.facing -= 2;
        if (this.facing < 0) {
            this.facing = 1 - this.facing;
        }
        this.updateAllInDimension();
        this.thisAABB = null;
        this.revertAir();
        this.func_70296_d();
        this.ticks = 91;
    }

    private void brightenAir(World world, BlockVec3 vec, IBlockState brighterAir) {
        world.func_180501_a(vec.toBlockPos(), brighterAir, this.field_145850_b.field_72995_K ? 2 : 0);
        this.airToRestore.add(vec);
    }

    private void setDarkerAir(BlockVec3 vec) {
        Block b = vec.getBlockState(this.field_145850_b).func_177230_c();
        BlockPos pos = vec.toBlockPos();
        if (b == GCBlocks.brightAir) {
            this.field_145850_b.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), this.field_145850_b.field_72995_K ? 2 : 0);
            this.checkLightFor(EnumSkyBlock.BLOCK, pos);
        } else if (b == GCBlocks.brightBreatheableAir) {
            this.field_145850_b.func_180501_a(pos, GCBlocks.breatheableAir.func_176223_P(), this.field_145850_b.field_72995_K ? 2 : 0);
            this.checkLightFor(EnumSkyBlock.BLOCK, pos);
        }
    }

    private void revertAir() {
        for (BlockVec3 vec : this.airToRestore) {
            this.setDarkerAir(vec);
        }
        this.airToRestore.clear();
        this.checkLightFor(EnumSkyBlock.BLOCK, this.field_174879_c);
    }

    public boolean checkLightFor(EnumSkyBlock lightType, BlockPos pos) {
        int savedLight;
        int range;
        int zz;
        int yy;
        int xx;
        int value;
        if (!this.field_145850_b.func_175648_a(pos, 17, false)) {
            return false;
        }
        int i = 0;
        int index = 0;
        int blockLight = this.field_145850_b.func_175642_b(lightType, pos);
        int rawLight = this.getRawLight(pos, lightType);
        int x = pos.func_177958_n() - 32;
        int y = pos.func_177956_o() - 32;
        int z = pos.func_177952_p() - 32;
        if (rawLight > blockLight) {
            TileEntityArclamp.lightUpdateBlockList[index++] = 133152;
        } else if (rawLight < blockLight) {
            TileEntityArclamp.lightUpdateBlockList[index++] = 0x20820 | blockLight << 18;
            while (i < index) {
                BlockPos blockpos;
                value = lightUpdateBlockList[i++];
                xx = (value & 0x3F) - x;
                yy = (value >> 6 & 0x3F) - y;
                zz = (value >> 12 & 0x3F) - z;
                int arraylight = value >> 18 & 0xF;
                if (arraylight <= 0 || this.field_145850_b.func_175642_b(lightType, blockpos = new BlockPos(xx, yy, zz)) != arraylight) continue;
                this.field_145850_b.func_175653_a(lightType, blockpos, 0);
                range = MathHelper.func_76130_a((int)(xx - x - 32)) + MathHelper.func_76130_a((int)(yy - y - 32)) + MathHelper.func_76130_a((int)(zz - z - 32));
                if (range >= 17) continue;
                for (BlockPos vec : GCCoreUtil.getPositionsAdjoining(xx, yy, zz)) {
                    savedLight = this.field_145850_b.func_175642_b(lightType, vec);
                    if (savedLight == 0) continue;
                    IBlockState bs = this.field_145850_b.func_180495_p(vec);
                    int opacity = bs.func_177230_c().getLightOpacity(bs, (IBlockAccess)this.field_145850_b, vec);
                    if (opacity <= 0) {
                        opacity = 1;
                    }
                    if (savedLight != arraylight - opacity || index >= lightUpdateBlockList.length) continue;
                    TileEntityArclamp.lightUpdateBlockList[index++] = vec.func_177958_n() - x | vec.func_177956_o() - y << 6 | vec.func_177952_p() - z << 12 | savedLight << 18;
                }
            }
            i = 0;
        }
        while (i < index) {
            value = lightUpdateBlockList[i++];
            xx = (value & 0x3F) + x;
            yy = (value >> 6 & 0x3F) + y;
            zz = (value >> 12 & 0x3F) + z;
            BlockPos blockpos1 = new BlockPos(xx, yy, zz);
            savedLight = this.field_145850_b.func_175642_b(lightType, blockpos1);
            int theRawLight = this.getRawLight(blockpos1, lightType);
            if (theRawLight == savedLight) continue;
            this.field_145850_b.func_175653_a(lightType, blockpos1, theRawLight);
            if (theRawLight <= savedLight || (range = MathHelper.func_76130_a((int)(xx - x - 32)) + MathHelper.func_76130_a((int)(yy - y - 32)) + MathHelper.func_76130_a((int)(zz - z - 32))) >= 17 || index >= lightUpdateBlockList.length - 6) continue;
            for (BlockPos vec : GCCoreUtil.getPositionsAdjoining(xx, yy, zz)) {
                if (this.field_145850_b.func_175642_b(lightType, vec) >= theRawLight) continue;
                TileEntityArclamp.lightUpdateBlockList[index++] = vec.func_177958_n() - x + ((vec.func_177952_p() - z << 6) + vec.func_177956_o() - y << 6);
            }
        }
        return true;
    }

    private int getRawLight(BlockPos pos, EnumSkyBlock lightType) {
        IBlockState bs = this.field_145850_b.func_180495_p(pos);
        Block block = bs.func_177230_c();
        int blockLight = block.getLightValue(bs, (IBlockAccess)this.field_145850_b, pos);
        int light = lightType == EnumSkyBlock.SKY ? 0 : blockLight;
        int opacity = block.getLightOpacity(bs, (IBlockAccess)this.field_145850_b, pos);
        if (opacity >= 15 && blockLight > 0) {
            opacity = 1;
        }
        if (opacity < 1) {
            opacity = 1;
        }
        if (opacity >= 15) {
            return 0;
        }
        if (light >= 14) {
            return light;
        }
        for (BlockPos blockpos : GCCoreUtil.getPositionsAdjoining(pos)) {
            int otherlight = this.field_145850_b.func_175642_b(lightType, blockpos) - opacity;
            if (otherlight <= light || (light = otherlight) < 14) continue;
            return light;
        }
        return light;
    }

    public boolean getEnabled() {
        return !RedstoneUtil.isBlockReceivingRedstone(this.field_145850_b, this.func_174877_v());
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return oldState.func_177230_c() != newSate.func_177230_c();
    }

    private void checkedAdd(BlockVec3 vec) {
        int dx = this.field_174879_c.func_177958_n() - vec.x;
        int dz = this.field_174879_c.func_177952_p() - vec.z;
        if (dx < -8191 || dx > 8192) {
            return;
        }
        if (dz < -8191 || dz > 8192) {
            return;
        }
        intBucket bucket = buckets[((dx & 0xF) << 4) + (dz & 0xF)];
        bucket.add(vec.y + ((dx & 0x3FF0) + ((dz & 0x3FF0) << 10) << 4));
    }

    private boolean checkedContains(BlockVec3 vec) {
        int dx = this.field_174879_c.func_177958_n() - vec.x;
        int dz = this.field_174879_c.func_177952_p() - vec.z;
        if (dx < -8191 || dx > 8192) {
            return true;
        }
        if (dz < -8191 || dz > 8192) {
            return true;
        }
        intBucket bucket = buckets[((dx & 0xF) << 4) + (dz & 0xF)];
        return bucket.contains(vec.y + ((dx & 0x3FF0) + ((dz & 0x3FF0) << 10) << 4));
    }

    private boolean checkedContains(BlockVec3 vec, int side) {
        int y = vec.y;
        int dx = this.field_174879_c.func_177958_n() - vec.x;
        int dz = this.field_174879_c.func_177952_p() - vec.z;
        switch (side) {
            case 0: {
                if (--y >= 0) break;
                return true;
            }
            case 1: {
                if (++y <= 255) break;
                return true;
            }
            case 2: {
                ++dz;
                break;
            }
            case 3: {
                --dz;
                break;
            }
            case 4: {
                ++dx;
                break;
            }
            case 5: {
                --dx;
            }
        }
        if (dx < -8191 || dx > 8192) {
            return true;
        }
        if (dz < -8191 || dz > 8192) {
            return true;
        }
        intBucket bucket = buckets[((dx & 0xF) << 4) + (dz & 0xF)];
        return bucket.contains(y + ((dx & 0x3FF0) + ((dz & 0x3FF0) << 10) << 4));
    }

    private static void checkedInit() {
        for (int i = 0; i < 256; ++i) {
            TileEntityArclamp.buckets[i] = new intBucket();
        }
    }

    private static void checkedClear() {
        for (int i = 0; i < 256; ++i) {
            buckets[i].clear();
        }
    }

    @Override
    public void buildDataPacket(int[] data) {
        data[0] = this.facing;
    }

    @Override
    public void updateClient(List<Object> data) {
        this.facing = (Integer)data.get(1);
        this.revertAir();
        this.thisAABB = null;
        this.ticks = 86;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        if (this.renderAABB == null) {
            this.renderAABB = new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
        }
        return this.renderAABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 262144.0;
    }

    @Override
    public void getNetworkedData(ArrayList<Object> sendData) {
        for (BlockVec3 vec : this.airToRestore) {
            sendData.add(vec);
        }
    }

    @Override
    public void decodePacketdata(ByteBuf buffer) {
        while (buffer.readableBytes() >= 12) {
            int x = buffer.readInt();
            int y = buffer.readInt();
            int z = buffer.readInt();
            this.airToRestore.add(new BlockVec3(x, y, z));
        }
    }

    static {
        usingBuckets = new AtomicBoolean();
        buckets = new intBucket[256];
        lightUpdateBlockList = new int[32768];
        TileEntityArclamp.checkedInit();
    }

    public static class intBucket {
        private int maxSize = 24;
        private int size = 0;
        private int[] table = new int[this.maxSize];

        public void add(int i) {
            if (this.contains(i)) {
                return;
            }
            if (this.size >= this.maxSize) {
                int[] newTable = new int[this.maxSize + this.maxSize];
                System.arraycopy(this.table, 0, newTable, 0, this.maxSize);
                this.table = newTable;
                this.maxSize += this.maxSize;
            }
            this.table[this.size] = i;
            ++this.size;
        }

        public boolean contains(int test) {
            for (int i = this.size - 1; i >= 0; --i) {
                if (this.table[i] != test) continue;
                return true;
            }
            return false;
        }

        public void clear() {
            this.size = 0;
        }

        public int size() {
            return this.size;
        }

        public int[] contents() {
            return this.table;
        }
    }
}

