/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.EnumSet;
import micdoodle8.mods.galacticraft.api.item.IItemOxygenSupply;
import micdoodle8.mods.galacticraft.core.blocks.BlockOxygenCompressor;
import micdoodle8.mods.galacticraft.core.energy.item.ItemElectricBase;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.items.ItemOxygenTank;
import micdoodle8.mods.galacticraft.core.tile.TileEntityOxygen;
import micdoodle8.mods.galacticraft.core.util.FluidUtil;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;

public class TileEntityOxygenCompressor
extends TileEntityOxygen
implements IInventoryDefaults,
ISidedInventory {
    private NonNullList<ItemStack> stacks = NonNullList.func_191197_a((int)3, (Object)ItemStack.field_190927_a);
    public static final int TANK_TRANSFER_SPEED = 2;
    private boolean usingEnergy = false;

    public TileEntityOxygenCompressor() {
        super(1200, 16);
        this.storage.setMaxExtract(15.0f);
    }

    @Override
    public void func_73660_a() {
        ItemStack oxygenItemStack;
        if (!this.field_145850_b.field_72995_K && (oxygenItemStack = this.func_70301_a(2)) != null && oxygenItemStack.func_77973_b() instanceof IItemOxygenSupply) {
            IItemOxygenSupply oxygenItem = (IItemOxygenSupply)oxygenItemStack.func_77973_b();
            int oxygenDraw = (int)Math.floor(Math.min((float)this.oxygenPerTick * 2.5f, (float)(this.getMaxOxygenStored() - this.getOxygenStored())));
            this.setOxygenStored(this.getOxygenStored() + oxygenItem.discharge(oxygenItemStack, oxygenDraw));
            if (this.getOxygenStored() > this.getMaxOxygenStored()) {
                this.setOxygenStored(this.getOxygenStored());
            }
        }
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            ItemStack tank0;
            this.usingEnergy = false;
            if (this.getOxygenStored() > 0 && this.hasEnoughEnergyToRun && (tank0 = (ItemStack)this.stacks.get(0)) != null && tank0.func_77973_b() instanceof ItemOxygenTank && tank0.func_77952_i() > 0) {
                tank0.func_77964_b(tank0.func_77952_i() - 2);
                this.setOxygenStored(this.getOxygenStored() - 2);
                this.usingEnergy = true;
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.stacks = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)nbt, this.stacks);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        ItemStackHelper.func_191282_a((NBTTagCompound)nbt, this.stacks);
        return nbt;
    }

    public int func_70302_i_() {
        return this.stacks.size();
    }

    public ItemStack func_70301_a(int var1) {
        return (ItemStack)this.stacks.get(var1);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.stacks, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack oldstack = ItemStackHelper.func_188383_a(this.stacks, (int)index);
        if (!oldstack.func_190926_b()) {
            this.func_70296_d();
        }
        return oldstack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.stacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public String func_70005_c_() {
        return GCCoreUtil.translate("container.oxygencompressor.name");
    }

    public int func_70297_j_() {
        return 1;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    public int[] func_180463_a(EnumFacing side) {
        return new int[]{0, 1, 2};
    }

    public boolean func_180462_a(int slotID, ItemStack itemstack, EnumFacing side) {
        if (this.func_94041_b(slotID, itemstack)) {
            switch (slotID) {
                case 0: {
                    return itemstack.func_77952_i() > 1;
                }
                case 1: {
                    return itemstack.func_77973_b() instanceof ItemElectricBase && ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) > 0.0f;
                }
                case 2: {
                    return itemstack.func_77952_i() < itemstack.func_77973_b().func_77612_l();
                }
            }
            return false;
        }
        return false;
    }

    public boolean func_180461_b(int slotID, ItemStack itemstack, EnumFacing side) {
        switch (slotID) {
            case 0: {
                return itemstack.func_77973_b() instanceof ItemOxygenTank && itemstack.func_77952_i() == 0;
            }
            case 1: {
                return itemstack.func_77973_b() instanceof ItemElectricBase && ((ItemElectricBase)itemstack.func_77973_b()).getElectricityStored(itemstack) <= 0.0f;
            }
            case 2: {
                return FluidUtil.isEmptyContainer(itemstack);
            }
        }
        return false;
    }

    public boolean func_94041_b(int slotID, ItemStack itemstack) {
        switch (slotID) {
            case 0: {
                return itemstack.func_77973_b() instanceof ItemOxygenTank;
            }
            case 1: {
                return ItemElectricBase.isElectricItem(itemstack.func_77973_b());
            }
            case 2: {
                return itemstack.func_77973_b() instanceof IItemOxygenSupply;
            }
        }
        return false;
    }

    @Override
    public boolean func_145818_k_() {
        return true;
    }

    @Override
    public boolean shouldUseEnergy() {
        return this.usingEnergy;
    }

    @Override
    public EnumFacing getFront() {
        return ((EnumFacing)this.field_145850_b.func_180495_p(this.func_174877_v()).func_177229_b((IProperty)BlockOxygenCompressor.FACING)).func_176746_e();
    }

    @Override
    public EnumFacing getElectricInputDirection() {
        return this.getFront();
    }

    @Override
    public ItemStack getBatteryInSlot() {
        return this.func_70301_a(1);
    }

    @Override
    public boolean shouldUseOxygen() {
        return false;
    }

    @Override
    public EnumSet<EnumFacing> getOxygenInputDirections() {
        return EnumSet.of(this.getElectricInputDirection().func_176734_d());
    }

    @Override
    public EnumSet<EnumFacing> getOxygenOutputDirections() {
        return EnumSet.noneOf(EnumFacing.class);
    }
}

