/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import micdoodle8.mods.galacticraft.core.GCFluids;
import micdoodle8.mods.galacticraft.core.GCItems;
import micdoodle8.mods.galacticraft.core.items.ItemBucketGC;
import micdoodle8.mods.galacticraft.core.items.ItemCanisterGeneric;
import micdoodle8.mods.galacticraft.planets.asteroids.items.AsteroidsItems;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FluidUtil {
    private static boolean oldFluidIDMethod = true;
    private static Class<?> fluidStackClass = null;
    private static Method getFluidMethod = null;
    private static Field fluidIdField = null;

    public static boolean isFuelContainerAny(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77973_b() == GCItems.fuelCanister && var4.func_77952_i() < var4.func_77958_k();
        }
        if (var4.func_77973_b() == GCItems.bucketFuel) {
            return true;
        }
        FluidStack liquid = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)var4);
        return liquid != null && FluidUtil.testFuel(FluidRegistry.getFluidName((FluidStack)liquid));
    }

    public static boolean testFuel(String name) {
        if (name.startsWith("fuel")) {
            return true;
        }
        if (name.contains("rocket") && name.contains("fuel")) {
            return true;
        }
        return name.equals("rc jet fuel");
    }

    public static boolean isFuel(FluidStack fluid) {
        return fluid != null && FluidUtil.testFuel(FluidRegistry.getFluidName((FluidStack)fluid));
    }

    public static boolean isFluidFuzzy(FluidStack fluid, String name) {
        return fluid != null && fluid.getFluid() != null && fluid.getFluid().getName().startsWith(name);
    }

    public static boolean isFluidStrict(FluidStack fluid, String name) {
        return fluid != null && fluid.getFluid() != null && fluid.getFluid().getName().equals(name);
    }

    public static int fillWithGCFuel(FluidTank tank, FluidStack liquid, boolean doFill) {
        if (liquid != null && FluidUtil.testFuel(FluidRegistry.getFluidName((FluidStack)liquid))) {
            FluidStack liquidInTank = tank.getFluid();
            if (liquidInTank == null) {
                return tank.fill(new FluidStack(GCFluids.fluidFuel, liquid.amount), doFill);
            }
            if (liquidInTank.amount < tank.getCapacity()) {
                return tank.fill(new FluidStack(liquidInTank, liquid.amount), doFill);
            }
        }
        return 0;
    }

    public static boolean isOilContainerAny(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77973_b() == GCItems.oilCanister && var4.func_77952_i() < var4.func_77958_k();
        }
        if (var4.func_77973_b() == GCItems.bucketOil) {
            return true;
        }
        FluidStack liquid = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)var4);
        return liquid != null && FluidRegistry.getFluidName((FluidStack)liquid).startsWith("oil");
    }

    public static boolean isMethaneContainerAny(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77973_b() == AsteroidsItems.methaneCanister && var4.func_77952_i() < var4.func_77958_k();
        }
        FluidStack stack = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)var4);
        return stack != null && stack.getFluid() != null && stack.getFluid().getName().toLowerCase().contains("methane");
    }

    public static boolean isFullContainer(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77952_i() == 1;
        }
        if (var4.func_77973_b() instanceof ItemBucketGC) {
            return true;
        }
        FluidStack liquid = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)var4);
        return liquid != null;
    }

    public static void tryFillContainer(FluidTank tank, FluidStack liquid, NonNullList<ItemStack> inventory, int slot, Item canisterType) {
        ItemStack slotItem = (ItemStack)inventory.get(slot);
        if (liquid.amount <= 0 || slotItem == null) {
            return;
        }
        if (slotItem.func_77973_b() instanceof ItemCanisterGeneric) {
            if (slotItem.func_190916_E() != 1 || slotItem.func_77973_b() != canisterType && slotItem.func_77952_i() != 1001) {
                return;
            }
            int used = Math.min(liquid.amount, slotItem.func_77952_i() - 1);
            if (used > 0) {
                inventory.set(slot, (Object)new ItemStack(canisterType, 1, slotItem.func_77952_i() - used));
                tank.drain(used, true);
            }
            return;
        }
        if (slotItem.func_190916_E() == 1) {
            int used;
            ItemBucketGC bucketGC;
            if (slotItem.func_77973_b() == Items.field_151133_ar && (bucketGC = ItemBucketGC.getBucketForFluid(liquid.getFluid())) != null) {
                inventory.set(slot, (Object)new ItemStack((Item)bucketGC));
                tank.drain(1000, true);
                return;
            }
            IFluidHandlerItem handler = net.minecraftforge.fluids.FluidUtil.getFluidHandler((ItemStack)((ItemStack)inventory.get(slot)));
            if (handler != null && (used = handler.fill(liquid, true)) > 0) {
                inventory.set(slot, (Object)handler.getContainer());
                tank.drain(used, true);
            }
        }
    }

    public static void tryFillContainerFuel(FluidTank tank, NonNullList<ItemStack> inventory, int slot) {
        String liquidname;
        FluidStack liquid;
        if (FluidUtil.isValidContainer((ItemStack)inventory.get(slot)) && (liquid = tank.getFluid()) != null && liquid.amount > 0 && (liquidname = liquid.getFluid().getName()).startsWith("fuel")) {
            FluidStack existingFluid;
            IFluidHandlerItem handler;
            ItemStack stack;
            Item item;
            if (!liquidname.equals(GCFluids.fluidFuel.getName())) {
                liquid = new FluidStack(GCFluids.fluidFuel, liquid.amount);
            }
            Item item2 = item = (stack = (ItemStack)inventory.get(slot)).func_190926_b() ? null : stack.func_77973_b();
            if (!(item instanceof ItemCanisterGeneric || item instanceof ItemBucketGC || (handler = net.minecraftforge.fluids.FluidUtil.getFluidHandler((ItemStack)stack)) == null || (existingFluid = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)stack)) == null || existingFluid.getFluid().getName().equals(GCFluids.fluidFuel.getName()))) {
                liquid = new FluidStack(existingFluid, liquid.amount);
            }
            FluidUtil.tryFillContainer(tank, liquid, inventory, slot, GCItems.fuelCanister);
        }
    }

    public static void loadFromContainer(FluidTank tank, Fluid desiredLiquid, NonNullList<ItemStack> stacks, int slot, int amountOffered) {
        ItemStack slotItem = (ItemStack)stacks.get(slot);
        if (slotItem.func_77973_b() instanceof ItemCanisterGeneric) {
            int used;
            int originalDamage = slotItem.func_77952_i();
            if (originalDamage + (used = tank.fill(new FluidStack(desiredLiquid, 1001 - originalDamage), true)) >= 1001) {
                stacks.set(slot, (Object)new ItemStack(GCItems.oilCanister, 1, 1001));
            } else {
                stacks.set(slot, (Object)new ItemStack(slotItem.func_77973_b(), 1, originalDamage + used));
            }
        } else if (slotItem.func_77973_b() instanceof ItemBucketGC && amountOffered == 1000) {
            ItemBucketGC bucket = (ItemBucketGC)slotItem.func_77973_b();
            if (FluidUtil.fluidsSame(bucket.accepts, desiredLiquid, true)) {
                tank.fill(new FluidStack(desiredLiquid, amountOffered), true);
                stacks.set(slot, (Object)new ItemStack(Items.field_151133_ar));
            }
        } else if ((tank.getFluid() == null || amountOffered <= tank.getCapacity() - tank.getFluid().amount) && FluidUtil.isFilledContainer(slotItem)) {
            int itemCount = slotItem.func_190916_E();
            if (FluidUtil.isBucket(slotItem)) {
                int used = tank.fill(new FluidStack(desiredLiquid, amountOffered), true);
                if (itemCount > 1) {
                    tank.fill(new FluidStack(desiredLiquid, (itemCount - 1) * 1000), true);
                }
                stacks.set(slot, (Object)new ItemStack(Items.field_151133_ar, itemCount));
                return;
            }
            if (itemCount == 1) {
                IFluidHandlerItem handlerItem = net.minecraftforge.fluids.FluidUtil.getFluidHandler((ItemStack)slotItem);
                if (handlerItem != null) {
                    int used = tank.fill(new FluidStack(desiredLiquid, amountOffered), false);
                    FluidStack given = handlerItem.drain(used, true);
                    if (given != null) {
                        tank.fill(new FluidStack(desiredLiquid, given.amount), true);
                        stacks.set(slot, (Object)handlerItem.getContainer());
                    }
                    return;
                }
                ItemStack emptyStack = FluidUtil.getUsedContainer(slotItem);
                tank.fill(new FluidStack(desiredLiquid, FluidUtil.getContainerCapacity(slotItem)), true);
                stacks.set(slot, (Object)emptyStack);
                return;
            }
        }
    }

    public static boolean isPartialContainer(ItemStack var4, Item canisterType) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77952_i() == 1001 || var4.func_77973_b() == canisterType && var4.func_77952_i() > 1;
        }
        IFluidHandlerItem handler = net.minecraftforge.fluids.FluidUtil.getFluidHandler((ItemStack)var4);
        FluidStack containedFluid = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)var4);
        if (handler != null) {
            if (containedFluid == null) {
                return true;
            }
            containedFluid = containedFluid.copy();
            containedFluid.amount = 1;
            if (handler.fill(containedFluid, false) > 0) {
                return true;
            }
        }
        return false;
    }

    public static boolean isEmptyContainerFor(ItemStack var4, FluidStack targetFluid) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            if (var4.func_77952_i() == 1001) {
                return true;
            }
            if (var4.func_77952_i() == 1) {
                return false;
            }
            return FluidUtil.fluidsSame(FluidUtil.getFluidContained(var4), targetFluid);
        }
        if (FluidUtil.isEmptyContainer(var4)) {
            return true;
        }
        return FluidUtil.fluidsSame(net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)var4), targetFluid);
    }

    public static int getContainerCapacity(ItemStack container) {
        if (container.func_77973_b() instanceof ItemCanisterGeneric) {
            return container.func_77952_i() - 1;
        }
        if (!container.func_190926_b()) {
            container = container.func_77946_l();
            container.func_190920_e(1);
            IFluidHandlerItem fluidHandler = net.minecraftforge.fluids.FluidUtil.getFluidHandler((ItemStack)container);
            if (fluidHandler != null) {
                FluidStack drain = fluidHandler.drain(Integer.MAX_VALUE, false);
                return drain == null ? 0 : drain.amount;
            }
        }
        return 0;
    }

    public static boolean fluidsSame(FluidStack fs1, FluidStack fs2) {
        if (fs1 == null || fs2 == null) {
            return false;
        }
        Fluid f1 = fs1.getFluid();
        Fluid f2 = fs2.getFluid();
        if (f1 == null || f2 == null || f1.getName() == null) {
            return false;
        }
        return f1.getName().equals(f2.getName());
    }

    public static boolean fluidsSame(Fluid f1, Fluid f2, boolean fuzzy) {
        if (f1 == null || f2 == null || f1.getName() == null) {
            return false;
        }
        if (fuzzy) {
            if (f1.getName().startsWith("fuel")) {
                return FluidUtil.testFuel(f2.getName());
            }
            if (f1.getName().startsWith("oil")) {
                return f2.getName().startsWith("oil");
            }
            if (f1.getName().startsWith("water")) {
                return f2.getName().startsWith("water");
            }
        }
        return f1.getName().equals(f2.getName());
    }

    public static boolean fluidsSame(Fluid f1, String name2, boolean fuzzy) {
        if (f1 == null || name2 == null || f1.getName() == null) {
            return false;
        }
        if (fuzzy) {
            if (name2.equals("fuel")) {
                return FluidUtil.testFuel(f1.getName());
            }
            return f1.getName().startsWith(name2);
        }
        return f1.getName().equals(name2);
    }

    public static boolean isEmptyContainer(ItemStack var4) {
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77952_i() == 1001;
        }
        if (var4.func_77973_b() == Items.field_151133_ar) {
            return true;
        }
        IFluidHandlerItem handler = net.minecraftforge.fluids.FluidUtil.getFluidHandler((ItemStack)var4);
        FluidStack containedFluid = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)var4);
        return handler != null && (containedFluid == null || containedFluid.amount == 0);
    }

    public static boolean isEmptyGasContainer(ItemStack var4) {
        return false;
    }

    public static boolean isFilledContainer(ItemStack var4) {
        if (net.minecraftforge.fluids.FluidUtil.getFluidHandler((ItemStack)var4) == null) {
            return false;
        }
        if (var4.func_77973_b() instanceof ItemCanisterGeneric) {
            return var4.func_77952_i() < 1001;
        }
        return net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)var4) != null;
    }

    public static boolean isWaterContainer(ItemStack var4) {
        FluidStack liquid = net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)var4);
        return liquid != null && liquid.getFluid() != null && liquid.getFluid().getName().equals("water");
    }

    public static FluidStack getFluidContained(ItemStack container) {
        if (container == null) {
            return null;
        }
        if (container.func_77973_b() instanceof ItemCanisterGeneric) {
            ItemCanisterGeneric canister = (ItemCanisterGeneric)container.func_77973_b();
            return canister.getFluid(container);
        }
        if (container.func_77973_b() instanceof ItemBucketGC) {
            return new FluidStack(((ItemBucketGC)container.func_77973_b()).accepts, 1000);
        }
        return net.minecraftforge.fluids.FluidUtil.getFluidContained((ItemStack)container);
    }

    public static boolean isValidContainer(ItemStack slotItem) {
        return slotItem != null && slotItem.func_190916_E() == 1 && (slotItem.func_77973_b() instanceof ItemCanisterGeneric || slotItem.func_77973_b() instanceof ItemBucketGC || net.minecraftforge.fluids.FluidUtil.getFluidHandler((ItemStack)slotItem) != null);
    }

    public static ItemStack getUsedContainer(ItemStack container) {
        if (FluidUtil.isBucket(container) && net.minecraftforge.fluids.FluidUtil.getFluidHandler((ItemStack)container) != null) {
            return new ItemStack(Items.field_151133_ar, container.func_190916_E());
        }
        container.func_190918_g(1);
        if (!container.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        return container;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean isInsideOfFluid(Entity entity, Fluid fluid) {
        int k;
        int j;
        double d0 = entity.field_70163_u + (double)entity.func_70047_e();
        int i = MathHelper.func_76128_c((double)entity.field_70165_t);
        BlockPos pos = new BlockPos(i, j = MathHelper.func_76141_d((float)MathHelper.func_76128_c((double)d0)), k = MathHelper.func_76128_c((double)entity.field_70161_v));
        Block block = entity.field_70170_p.func_180495_p(pos).func_177230_c();
        if (block != null && block instanceof IFluidBlock && ((IFluidBlock)block).getFluid() != null && ((IFluidBlock)block).getFluid().getName().equals(fluid.getName())) {
            double filled = ((IFluidBlock)block).getFilledPercentage(entity.field_70170_p, pos);
            if (filled < 0.0) {
                return d0 > (double)j + (1.0 - (filled *= -1.0));
            }
            return d0 < (double)j + filled;
        }
        return false;
    }

    public static boolean isBucket(ItemStack container) {
        if (container == null) {
            return false;
        }
        IFluidHandlerItem handlerItem = net.minecraftforge.fluids.FluidUtil.getFluidHandler((ItemStack)container);
        if (handlerItem != null) {
            if (container.func_77973_b() == Items.field_151133_ar) {
                return true;
            }
            if (handlerItem.getContainer().func_77973_b() == Items.field_151133_ar) {
                return true;
            }
        }
        return false;
    }

    @Nonnull
    public static FluidActionResult interactWithFluidHandler(@Nonnull ItemStack container, IFluidHandler fluidHandler, EntityPlayer player) {
        ItemStack result;
        if (container.func_190926_b() || fluidHandler == null || player == null) {
            return FluidActionResult.FAILURE;
        }
        if (container.func_77973_b() instanceof ItemCanisterGeneric) {
            ItemStack result2 = FluidUtil.tryEmptyCanister(container, fluidHandler);
            if ((result2 != ItemStack.field_190927_a || (result2 = FluidUtil.tryFillCanister(container, fluidHandler)) != ItemStack.field_190927_a) && player.field_71069_bz != null) {
                player.field_71069_bz.func_75142_b();
            }
            return new FluidActionResult(result2);
        }
        if (container.func_77973_b() == Items.field_151133_ar && (result = ItemBucketGC.fillBucketFrom(fluidHandler)) != null) {
            return new FluidActionResult(result);
        }
        InvWrapper playerInventory = new InvWrapper((IInventory)player.field_71071_by);
        FluidActionResult fillResult = net.minecraftforge.fluids.FluidUtil.tryFillContainerAndStow((ItemStack)container, (IFluidHandler)fluidHandler, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)player);
        if (fillResult.isSuccess()) {
            return fillResult;
        }
        return net.minecraftforge.fluids.FluidUtil.tryEmptyContainerAndStow((ItemStack)container, (IFluidHandler)fluidHandler, (IItemHandler)playerInventory, (int)Integer.MAX_VALUE, (EntityPlayer)player);
    }

    private static ItemStack tryFillCanister(ItemStack canister, IFluidHandler tank) {
        int currCapacity = canister.func_77952_i() - 1;
        if (currCapacity <= 0) {
            return ItemStack.field_190927_a;
        }
        FluidStack liquid = tank.drain(currCapacity, false);
        int transferred = ((ItemCanisterGeneric)canister.func_77973_b()).fill(canister, liquid, true);
        if (transferred > 0) {
            liquid = tank.drain(transferred, true);
            return canister;
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack tryEmptyCanister(ItemStack canister, IFluidHandler tank) {
        int currContents = 1001 - canister.func_77952_i();
        if (currContents <= 0) {
            return ItemStack.field_190927_a;
        }
        FluidStack liquid = ((ItemCanisterGeneric)canister.func_77973_b()).drain(canister, currContents, false);
        int transferred = tank.fill(liquid, true);
        if (transferred > 0) {
            ((ItemCanisterGeneric)canister.func_77973_b()).drain(canister, transferred, true);
            return canister;
        }
        return ItemStack.field_190927_a;
    }
}

