/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.annotation.Nullable;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.entities.EntityLanderBase;
import micdoodle8.mods.galacticraft.core.inventory.ContainerBuggy;
import micdoodle8.mods.galacticraft.core.inventory.ContainerParaChest;
import micdoodle8.mods.galacticraft.core.network.PacketSimple;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.Language;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.commons.io.Charsets;
import org.apache.commons.io.IOUtils;

public class GCCoreUtil {
    public static int nextID = 0;
    private static boolean deobfuscated;
    private static String lastLang;
    public static boolean langDisable;

    public static boolean isDeobfuscated() {
        return deobfuscated;
    }

    public static void openBuggyInv(EntityPlayerMP player, IInventory buggyInv, int type) {
        player.func_71117_bO();
        player.func_71128_l();
        int id = player.field_71139_cq;
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_OPEN_PARACHEST_GUI, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{id, 0, 0}), player);
        player.field_71070_bA = new ContainerBuggy((IInventory)player.field_71071_by, buggyInv, type, (EntityPlayer)player);
        player.field_71070_bA.field_75152_c = id;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
    }

    public static void openParachestInv(EntityPlayerMP player, EntityLanderBase landerInv) {
        player.func_71117_bO();
        player.func_71128_l();
        int windowId = player.field_71139_cq;
        GalacticraftCore.packetPipeline.sendTo(new PacketSimple(PacketSimple.EnumSimplePacket.C_OPEN_PARACHEST_GUI, GCCoreUtil.getDimensionID(player.field_70170_p), new Object[]{windowId, 1, landerInv.func_145782_y()}), player);
        player.field_71070_bA = new ContainerParaChest((IInventory)player.field_71071_by, landerInv, (EntityPlayer)player);
        player.field_71070_bA.field_75152_c = windowId;
        player.field_71070_bA.func_75132_a((IContainerListener)player);
    }

    public static int nextInternalID() {
        return ++nextID - 1;
    }

    public static void registerGalacticraftCreature(Class<? extends Entity> clazz, String name, int back, int fore) {
        GCCoreUtil.registerGalacticraftNonMobEntity(clazz, name, 80, 3, true);
        int nextEggID = GCCoreUtil.getNextValidID();
        if (nextEggID < 65536) {
            ResourceLocation resourcelocation = new ResourceLocation("galacticraftcore", name);
            EntityList.field_75627_a.put(resourcelocation, new EntityList.EntityEggInfo(resourcelocation, back, fore));
        }
    }

    public static int getNextValidID() {
        int eggID = 255;
        while (GameData.getEntityRegistry().getObjectById(++eggID) != null) {
        }
        return eggID;
    }

    public static void registerGalacticraftNonMobEntity(Class<? extends Entity> var0, String var1, int trackingDistance, int updateFreq, boolean sendVel) {
        ResourceLocation registryName = new ResourceLocation("galacticraftcore", var1);
        EntityRegistry.registerModEntity((ResourceLocation)registryName, var0, (String)var1, (int)GCCoreUtil.nextInternalID(), (Object)GalacticraftCore.instance, (int)trackingDistance, (int)updateFreq, (boolean)sendVel);
    }

    public static void registerGalacticraftItem(String key, Item item) {
        GalacticraftCore.itemList.put(key, new ItemStack(item));
    }

    public static void registerGalacticraftItem(String key, Item item, int metadata) {
        GalacticraftCore.itemList.put(key, new ItemStack(item, 1, metadata));
    }

    public static void registerGalacticraftItem(String key, ItemStack stack) {
        GalacticraftCore.itemList.put(key, stack);
    }

    public static void registerGalacticraftBlock(String key, Block block) {
        GalacticraftCore.blocksList.put(key, new ItemStack(block));
    }

    public static void registerGalacticraftBlock(String key, Block block, int metadata) {
        GalacticraftCore.blocksList.put(key, new ItemStack(block, 1, metadata));
    }

    public static void registerGalacticraftBlock(String key, ItemStack stack) {
        GalacticraftCore.blocksList.put(key, stack);
    }

    public static String translate(String key) {
        String result = I18n.func_74838_a((String)key);
        int comment = result.indexOf(35);
        String ret = comment > 0 ? result.substring(0, comment).trim() : result;
        for (int i = 0; i < key.length(); ++i) {
            Character c = Character.valueOf(key.charAt(i));
            if (!Character.isUpperCase(c.charValue())) continue;
            System.err.println(ret);
        }
        return ret;
    }

    public static List<String> translateWithSplit(String key) {
        String translated = GCCoreUtil.translate(key);
        int comment = translated.indexOf(35);
        translated = comment > 0 ? translated.substring(0, comment).trim() : translated;
        return Arrays.asList(translated.split("\\$"));
    }

    public static String translateWithFormat(String key, Object ... values) {
        String result = I18n.func_74837_a((String)key, (Object[])values);
        int comment = result.indexOf(35);
        String ret = comment > 0 ? result.substring(0, comment).trim() : result;
        for (int i = 0; i < key.length(); ++i) {
            Character c = Character.valueOf(key.charAt(i));
            if (!Character.isUpperCase(c.charValue())) continue;
            System.err.println(ret);
        }
        return ret;
    }

    public static void drawStringRightAligned(String string, int x, int y, int color, FontRenderer fontRendererObj) {
        fontRendererObj.func_78276_b(string, x - fontRendererObj.func_78256_a(string), y, color);
    }

    public static void drawStringCentered(String string, int x, int y, int color, FontRenderer fontRendererObj) {
        fontRendererObj.func_78276_b(string, x - fontRendererObj.func_78256_a(string) / 2, y, color);
    }

    public static String lowerCaseNoun(String string) {
        Language l = Minecraft.func_71410_x().func_135016_M().func_135041_c();
        if (l.func_135034_a().equals("de_DE")) {
            return string;
        }
        return GCCoreUtil.translate(string).toLowerCase();
    }

    @Nullable
    public static InputStream supplementEntityKeys(InputStream inputstream, String assetprefix) throws IOException {
        String line;
        ArrayList<String> langLines = new ArrayList<String>();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputstream));
        String supplemented = "entity." + assetprefix.toLowerCase() + ".";
        while ((line = br.readLine()) != null) {
            if ((line = line.trim()).isEmpty()) continue;
            langLines.add(line);
            if (!line.substring(0, 7).equals("entity.")) continue;
            langLines.add(supplemented + line.substring(7));
        }
        ByteArrayOutputStream outputstream = new ByteArrayOutputStream();
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)outputstream, Charsets.UTF_8.newEncoder()));
        for (String outLine : langLines) {
            writer.write(outLine + "\n");
        }
        writer.close();
        return new ByteArrayInputStream(outputstream.toByteArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void loadLanguage(String langIdentifier, String assetPrefix, File source) {
        block26: {
            ZipFile zip;
            InputStream stream;
            block25: {
                if (!lastLang.equals(langIdentifier)) {
                    langDisable = false;
                }
                if (langDisable) {
                    return;
                }
                String langFile = "assets/" + assetPrefix + "/lang/" + langIdentifier + ".lang";
                stream = null;
                zip = null;
                if (source.isDirectory() && ((Boolean)Launch.blackboard.get("fml.deobfuscatedEnvironment")).booleanValue()) {
                    stream = new FileInputStream(new File(source.toURI().resolve(langFile).getPath()));
                } else {
                    zip = new ZipFile(source);
                    ZipEntry entry = zip.getEntry(langFile);
                    if (entry == null) {
                        throw new FileNotFoundException();
                    }
                    stream = zip.getInputStream(entry);
                }
                LanguageMap.inject((InputStream)GCCoreUtil.supplementEntityKeys(stream, assetPrefix));
                if (stream == null) break block25;
                IOUtils.closeQuietly((InputStream)stream);
            }
            try {
                if (zip != null) {
                    zip.close();
                }
                break block26;
            }
            catch (IOException entry) {}
            break block26;
            catch (FileNotFoundException fnf) {
                langDisable = true;
                break block26;
            }
            catch (Exception exception) {
                if (stream != null) {
                    IOUtils.closeQuietly(stream);
                }
                try {
                    if (zip != null) {
                        zip.close();
                    }
                    break block26;
                }
                catch (IOException iOException) {}
                break block26;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (stream != null) {
                    IOUtils.closeQuietly(stream);
                }
                try {
                    if (zip != null) {
                        zip.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static int getDimensionID(World world) {
        return world.field_73011_w.getDimension();
    }

    public static int getDimensionID(WorldProvider provider) {
        return provider.getDimension();
    }

    public static int getDimensionID(TileEntity tileEntity) {
        return tileEntity.func_145831_w().field_73011_w.getDimension();
    }

    public static void sendToAllDimensions(PacketSimple.EnumSimplePacket packetType, Object[] data) {
        for (WorldServer world : FMLCommonHandler.instance().getMinecraftServerInstance().field_71305_c) {
            int id = GCCoreUtil.getDimensionID((World)world);
            GalacticraftCore.packetPipeline.sendToDimension(new PacketSimple(packetType, id, data), id);
        }
    }

    public static void sendToAllAround(PacketSimple packet, World world, int dimID, BlockPos pos, double radius) {
        double x = (double)pos.func_177958_n() + 0.5;
        double y = (double)pos.func_177956_o() + 0.5;
        double z = (double)pos.func_177952_p() + 0.5;
        double r2 = radius * radius;
        for (EntityPlayer playerMP : world.field_73010_i) {
            double dz;
            double dy;
            double dx;
            if (playerMP.field_71093_bK != dimID || !((dx = x - playerMP.field_70165_t) * dx + (dy = y - playerMP.field_70163_u) * dy + (dz = z - playerMP.field_70161_v) * dz < r2)) continue;
            GalacticraftCore.packetPipeline.sendTo(packet, (EntityPlayerMP)playerMP);
        }
    }

    public static Random getRandom(BlockPos pos) {
        long blockSeed = ((pos.func_177956_o() << 28) + pos.func_177958_n() + 30000000 << 28) + pos.func_177952_p() + 30000000;
        return new Random(blockSeed);
    }

    public static float getAngleForRelativePosition(double nearestX, double nearestZ) {
        return ((float)MathHelper.func_181159_b((double)nearestX, (double)(-nearestZ)) * 57.295776f + 360.0f) % 360.0f;
    }

    public static Side getEffectiveSide() {
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER || Thread.currentThread().getName().startsWith("Netty Epoll Server IO")) {
            return Side.SERVER;
        }
        return Side.CLIENT;
    }

    public static ItemStack getMatchingItemEitherHand(EntityPlayer player, Item item) {
        ItemStack stack = player.field_71071_by.func_70301_a(player.field_71071_by.field_70461_c);
        if (stack != null && stack.func_77973_b() == item) {
            return stack;
        }
        stack = (ItemStack)player.field_71071_by.field_184439_c.get(0);
        if (stack != null && stack.func_77973_b() == item) {
            return stack;
        }
        return null;
    }

    public static List<BlockPos> getPositionsAdjoining(BlockPos pos) {
        LinkedList<BlockPos> result = new LinkedList<BlockPos>();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        result.add(new BlockPos(x, y - 1, z));
        result.add(new BlockPos(x, y + 1, z));
        result.add(new BlockPos(x, y, z - 1));
        result.add(new BlockPos(x, y, z + 1));
        result.add(new BlockPos(x - 1, y, z));
        result.add(new BlockPos(x + 1, y, z));
        return result;
    }

    public static List<BlockPos> getPositionsAdjoining(int x, int y, int z) {
        LinkedList<BlockPos> result = new LinkedList<BlockPos>();
        result.add(new BlockPos(x, y - 1, z));
        result.add(new BlockPos(x, y + 1, z));
        result.add(new BlockPos(x, y, z - 1));
        result.add(new BlockPos(x, y, z + 1));
        result.add(new BlockPos(x - 1, y, z));
        result.add(new BlockPos(x + 1, y, z));
        return result;
    }

    public static void getPositionsAdjoining(BlockPos pos, List<BlockPos> result) {
        result.clear();
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        result.add(new BlockPos(x, y - 1, z));
        result.add(new BlockPos(x, y + 1, z));
        result.add(new BlockPos(x, y, z - 1));
        result.add(new BlockPos(x, y, z + 1));
        result.add(new BlockPos(x - 1, y, z));
        result.add(new BlockPos(x + 1, y, z));
    }

    static {
        lastLang = "";
        try {
            deobfuscated = Launch.classLoader.getClassBytes("net.minecraft.world.World") != null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

