/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.client;

import java.util.Random;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.Constants;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class SkyProviderAsteroids
extends IRenderHandler {
    private static final ResourceLocation overworldTexture = new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/celestialbodies/earth.png");
    private static final ResourceLocation galaxyTexture = new ResourceLocation("galacticraftplanets", "textures/gui/planets/galaxy.png");
    private static final ResourceLocation sunTexture = new ResourceLocation(Constants.ASSET_PREFIX, "textures/gui/planets/orbitalsun.png");
    public int starGLCallList = GLAllocation.func_74526_a((int)3);
    public int glSkyList;
    public int glSkyList2;
    private float sunSize;

    public SkyProviderAsteroids(IGalacticraftWorldProvider asteroidsProvider) {
        this.sunSize = 17.5f * asteroidsProvider.getSolarSize();
        GL11.glPushMatrix();
        GL11.glNewList((int)this.starGLCallList, (int)4864);
        this.renderStars();
        GL11.glEndList();
        GL11.glPopMatrix();
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = tessellator.func_178180_c();
        this.glSkyList = this.starGLCallList + 1;
        GL11.glNewList((int)this.glSkyList, (int)4864);
        int byte2 = 64;
        int i = 6;
        float f = 16.0f;
        for (int j = -384; j <= 384; j += 64) {
            for (int l = -384; l <= 384; l += 64) {
                worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
                worldRenderer.func_181662_b((double)(j + 0), (double)f, (double)(l + 0)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + 64), (double)f, (double)(l + 0)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + 64), (double)f, (double)(l + 64)).func_181675_d();
                worldRenderer.func_181662_b((double)(j + 0), (double)f, (double)(l + 64)).func_181675_d();
                tessellator.func_78381_a();
            }
        }
        GL11.glEndList();
        this.glSkyList2 = this.starGLCallList + 2;
        GL11.glNewList((int)this.glSkyList2, (int)4864);
        f = -16.0f;
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int k = -384; k <= 384; k += 64) {
            for (int i1 = -384; i1 <= 384; i1 += 64) {
                worldRenderer.func_181662_b((double)(k + 64), (double)f, (double)(i1 + 0)).func_181675_d();
                worldRenderer.func_181662_b((double)(k + 0), (double)f, (double)(i1 + 0)).func_181675_d();
                worldRenderer.func_181662_b((double)(k + 0), (double)f, (double)(i1 + 64)).func_181675_d();
                worldRenderer.func_181662_b((double)(k + 64), (double)f, (double)(i1 + 64)).func_181675_d();
            }
        }
        tessellator.func_78381_a();
        GL11.glEndList();
    }

    public void render(float partialTicks, WorldClient world, Minecraft mc) {
        Tessellator var23 = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = var23.func_178180_c();
        GL11.glDisable((int)3553);
        GL11.glDisable((int)32826);
        GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDepthMask((boolean)false);
        GL11.glEnable((int)2912);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glCallList((int)this.glSkyList);
        GL11.glDisable((int)2912);
        GL11.glDisable((int)3008);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        RenderHelper.func_74518_a();
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.7f, (float)0.7f, (float)0.7f, (float)0.7f);
        GL11.glCallList((int)this.starGLCallList);
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GL11.glRotatef((float)(world.func_72826_c(partialTicks) * 360.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float var12 = this.sunSize / 4.2f;
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        worldRenderer.func_181662_b((double)(-var12), 90.0, (double)(-var12)).func_181675_d();
        worldRenderer.func_181662_b((double)var12, 90.0, (double)(-var12)).func_181675_d();
        worldRenderer.func_181662_b((double)var12, 90.0, (double)var12).func_181675_d();
        worldRenderer.func_181662_b((double)(-var12), 90.0, (double)var12).func_181675_d();
        var23.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glBlendFunc((int)770, (int)1);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        var12 = this.sunSize / 1.2f;
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(sunTexture);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)(-var12), 90.0, (double)(-var12)).func_187315_a(0.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)var12, 90.0, (double)(-var12)).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)var12, 90.0, (double)var12).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)(-var12), 90.0, (double)var12).func_187315_a(0.0, 1.0).func_181675_d();
        var23.func_78381_a();
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        var12 = 0.5f;
        GL11.glScalef((float)0.6f, (float)0.6f, (float)0.6f);
        GL11.glRotatef((float)40.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glRotatef((float)200.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(overworldTexture);
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldRenderer.func_181662_b((double)(-var12), -100.0, (double)var12).func_187315_a(0.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)var12, -100.0, (double)var12).func_187315_a(1.0, 1.0).func_181675_d();
        worldRenderer.func_181662_b((double)var12, -100.0, (double)(-var12)).func_187315_a(1.0, 0.0).func_181675_d();
        worldRenderer.func_181662_b((double)(-var12), -100.0, (double)(-var12)).func_187315_a(0.0, 0.0).func_181675_d();
        var23.func_78381_a();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3008);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        double var25 = (double)mc.field_71439_g.func_180425_c().func_177956_o() - world.func_72919_O();
        GL11.glColor3f((float)0.2734375f, (float)0.2734375f, (float)0.2734375f);
        GL11.glEnable((int)3553);
        GL11.glDepthMask((boolean)true);
        GL11.glEnable((int)2903);
        GL11.glDisable((int)2912);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3042);
    }

    private void renderStars() {
        Random var1 = new Random(10842L);
        Tessellator var2 = Tessellator.func_178181_a();
        VertexBuffer worldRenderer = var2.func_178180_c();
        worldRenderer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
        for (int var3 = 0; var3 < (ConfigManagerCore.moreStars ? 35000 : 6000); ++var3) {
            double var4 = var1.nextFloat() * 2.0f - 1.0f;
            double var6 = var1.nextFloat() * 2.0f - 1.0f;
            double var8 = var1.nextFloat() * 2.0f - 1.0f;
            double var10 = 0.08f + var1.nextFloat() * 0.07f;
            double var12 = var4 * var4 + var6 * var6 + var8 * var8;
            if (!(var12 < 1.0) || !(var12 > 0.01)) continue;
            var12 = 1.0 / Math.sqrt(var12);
            double pX = (var4 *= var12) * (ConfigManagerCore.moreStars ? var1.nextDouble() * 75.0 + 65.0 : 80.0);
            double pY = (var6 *= var12) * (ConfigManagerCore.moreStars ? var1.nextDouble() * 75.0 + 65.0 : 80.0);
            double pZ = (var8 *= var12) * (ConfigManagerCore.moreStars ? var1.nextDouble() * 75.0 + 65.0 : 80.0);
            double var20 = Math.atan2(var4, var8);
            double var22 = Math.sin(var20);
            double var24 = Math.cos(var20);
            double var26 = Math.atan2(Math.sqrt(var4 * var4 + var8 * var8), var6);
            double var28 = Math.sin(var26);
            double var30 = Math.cos(var26);
            double var32 = var1.nextDouble() * Math.PI * 2.0;
            double var34 = Math.sin(var32);
            double var36 = Math.cos(var32);
            for (int i = 0; i < 4; ++i) {
                double i1 = (double)((i & 2) - 1) * var10;
                double i2 = (double)((i + 1 & 2) - 1) * var10;
                double var47 = i1 * var36 - i2 * var34;
                double var49 = i2 * var36 + i1 * var34;
                double var55 = -var47 * var30;
                double dX = var55 * var22 - var49 * var24;
                double dZ = var49 * var22 + var55 * var24;
                double dY = var47 * var28;
                worldRenderer.func_181662_b(pX + dX, pY + dY, pZ + dZ).func_181675_d();
            }
        }
        var2.func_78381_a();
    }

    private Vec3d getCustomSkyColor() {
        return new Vec3d(0.26796875, 0.1796875, 0.0);
    }

    public float getSkyBrightness(float par1) {
        float var2 = FMLClientHandler.instance().getClient().field_71441_e.func_72826_c(par1);
        float var3 = 1.0f - (MathHelper.func_76126_a((float)(var2 * ((float)Math.PI * 2))) * 2.0f + 0.25f);
        if (var3 < 0.0f) {
            var3 = 0.0f;
        }
        if (var3 > 1.0f) {
            var3 = 1.0f;
        }
        return var3 * var3 * 1.0f;
    }
}

