/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.client.render.tile;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class TileEntityMinerBaseRenderer
extends TileEntitySpecialRenderer<TileEntityMinerBase> {
    public static OBJModel minerBaseModel;
    public static OBJModel.OBJBakedModel minerBaseModelBaked;

    public IBakedModel getBakedModel() {
        if (minerBaseModelBaked == null) {
            try {
                minerBaseModel = (OBJModel)ModelLoaderRegistry.getModel((ResourceLocation)new ResourceLocation("galacticraftplanets", "minerbase0.obj"));
                minerBaseModel = (OBJModel)minerBaseModel.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
                minerBaseModel = (OBJModel)minerBaseModel.process(ImmutableMap.of((Object)"ambient", (Object)"false"));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            Function spriteFunction = location -> Minecraft.func_71410_x().func_147117_R().func_110572_b(location.toString());
            minerBaseModelBaked = (OBJModel.OBJBakedModel)minerBaseModel.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, spriteFunction);
        }
        return minerBaseModelBaked;
    }

    public void renderTileEntityAt(TileEntityMinerBase tile, double x, double y, double z, float partialTicks, int destroyStage) {
        if (!tile.isMaster) {
            return;
        }
        int i = tile.func_145831_w().func_175642_b(EnumSkyBlock.SKY, tile.func_174877_v().func_177984_a());
        int j = i % 65536;
        int k = i / 65536;
        float lightMapSaveX = OpenGlHelper.lastBrightnessX;
        float lightMapSaveY = OpenGlHelper.lastBrightnessY;
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)j / 1.0f), (float)((float)k / 1.0f));
        GL11.glPushMatrix();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glTranslatef((float)((float)x + 1.0f), (float)((float)y + 1.0f), (float)((float)z + 1.0f));
        GL11.glScalef((float)0.05f, (float)0.05f, (float)0.05f);
        switch (tile.facing) {
            case SOUTH: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case NORTH: {
                break;
            }
            case EAST: {
                GL11.glRotatef((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
        }
        RenderHelper.func_74518_a();
        this.func_147499_a(TextureMap.field_110575_b);
        Tessellator tessellator = Tessellator.func_178181_a();
        tessellator.func_178180_c().func_181668_a(7, DefaultVertexFormats.field_176600_a);
        GlStateManager.func_179109_b((float)(-tile.func_174877_v().func_177958_n()), (float)(-tile.func_174877_v().func_177956_o()), (float)(-tile.func_174877_v().func_177952_p()));
        Minecraft.func_71410_x().func_175602_ab().func_175019_b().func_178267_a((IBlockAccess)tile.func_145831_w(), this.getBakedModel(), tile.func_145831_w().func_180495_p(tile.func_174877_v()), tile.func_174877_v(), tessellator.func_178180_c(), false);
        tessellator.func_78381_a();
        RenderHelper.func_74519_b();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)lightMapSaveX, (float)lightMapSaveY);
        GL11.glPopMatrix();
    }
}

