/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.dimension;

import com.google.common.collect.Maps;
import java.util.Map;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.planets.asteroids.tick.AsteroidsTickHandlerServer;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityShortRangeTelepad;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.WorldSavedData;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class ShortRangeTelepadHandler
extends WorldSavedData {
    public static final String saveDataID = "ShortRangeTelepads";
    private static Map<Integer, TelepadEntry> tileMap = Maps.newHashMap();

    public ShortRangeTelepadHandler(String saveDataID) {
        super(saveDataID);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        NBTTagList tagList = nbt.func_150295_c("TelepadList", 10);
        tileMap.clear();
        for (int i = 0; i < tagList.func_74745_c(); ++i) {
            NBTTagCompound nbt2 = tagList.func_150305_b(i);
            int address = nbt2.func_74762_e("Address");
            int dimID = nbt2.func_74762_e("DimID");
            int posX = nbt2.func_74762_e("PosX");
            int posY = nbt2.func_74762_e("PosY");
            int posZ = nbt2.func_74762_e("PosZ");
            tileMap.put(address, new TelepadEntry(dimID, new BlockVec3(posX, posY, posZ)));
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<Integer, TelepadEntry> e : tileMap.entrySet()) {
            NBTTagCompound nbt2 = new NBTTagCompound();
            nbt2.func_74768_a("Address", e.getKey().intValue());
            nbt2.func_74768_a("DimID", e.getValue().dimensionID);
            nbt2.func_74768_a("PosX", e.getValue().position.x);
            nbt2.func_74768_a("PosY", e.getValue().position.y);
            nbt2.func_74768_a("PosZ", e.getValue().position.z);
            tagList.func_74742_a((NBTBase)nbt2);
        }
        nbt.func_74782_a("TelepadList", (NBTBase)tagList);
        return nbt;
    }

    public static void addShortRangeTelepad(TileEntityShortRangeTelepad telepad) {
        if (!telepad.func_145831_w().field_72995_K && telepad.addressValid) {
            TelepadEntry newEntry = new TelepadEntry(telepad.func_145831_w().field_73011_w.getDimension(), new BlockVec3((TileEntity)telepad));
            TelepadEntry previous = tileMap.put(telepad.address, newEntry);
            if (previous == null || !previous.equals(newEntry)) {
                AsteroidsTickHandlerServer.spaceRaceData.func_76186_a(true);
            }
        }
    }

    public static void removeShortRangeTeleporter(TileEntityShortRangeTelepad telepad) {
        if (!telepad.func_145831_w().field_72995_K && telepad.addressValid) {
            tileMap.remove(telepad.address);
            AsteroidsTickHandlerServer.spaceRaceData.func_76186_a(true);
        }
    }

    public static TelepadEntry getLocationFromAddress(int address) {
        return tileMap.get(address);
    }

    public static class TelepadEntry {
        public int dimensionID;
        public BlockVec3 position;

        public TelepadEntry(int dimID, BlockVec3 position) {
            this.dimensionID = dimID;
            this.position = position;
        }

        public int hashCode() {
            return new HashCodeBuilder().append(this.dimensionID).append(this.position.hashCode()).toHashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof TelepadEntry) {
                return new EqualsBuilder().append(((TelepadEntry)other).dimensionID, this.dimensionID).append((Object)((TelepadEntry)other).position, (Object)this.position).isEquals();
            }
            return false;
        }
    }
}

