/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.blocks.AsteroidBlocks;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.BaseConfiguration;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.BaseHangar;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.BasePlate;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.BaseRoom;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.BaseStart;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.Piece;
import micdoodle8.mods.galacticraft.planets.asteroids.world.gen.base.SizedPiece;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;
import net.minecraft.world.gen.structure.template.TemplateManager;

public class BaseDeck
extends SizedPiece {
    static final int ROOMSMALL = 6;
    static final int ROOMLARGE = 8;
    protected int roomsOnSide;
    protected int roomDepth;
    protected int largeRoomPosA;
    protected int largeRoomPosB;
    protected int deckTier;
    private ArrayList<BaseDeck> otherDecks = null;

    public BaseDeck() {
    }

    public BaseDeck(BaseConfiguration configuration, Random rand, int blockPosX, int blockPosY, int blockPosZ, int tier, EnumFacing dir) {
        super(configuration, configuration.getCorridorWidth() + 1, configuration.getRoomHeight() + 1, configuration.getCorridorLength(), dir);
        this.roomsOnSide = configuration.getRoomsNo();
        this.roomDepth = configuration.getRoomDepth() + (tier == 0 ? 1 : 0);
        this.deckTier = tier;
        this.func_186164_a(EnumFacing.NORTH);
        if (this.getDirection().func_176740_k() == EnumFacing.Axis.X) {
            int w = this.sizeX;
            this.sizeX = this.sizeZ;
            this.sizeZ = w;
        }
        int xMin = blockPosX - this.sizeX / 2;
        int zMin = blockPosZ - this.sizeZ / 2;
        this.field_74887_e = new StructureBoundingBox(xMin, blockPosY, zMin, xMin + this.sizeX, blockPosY + this.sizeY, zMin + this.sizeZ);
        if (this.roomsOnSide <= 1) {
            this.largeRoomPosA = 0;
            this.largeRoomPosB = 2;
        } else {
            this.largeRoomPosA = rand.nextInt(this.roomsOnSide - 1);
            this.largeRoomPosB = this.largeRoomPosA + 1 + rand.nextInt(this.roomsOnSide - this.largeRoomPosA - 1);
        }
        if (tier == 1) {
            this.createOtherDecks(configuration, rand, blockPosX, blockPosY, blockPosZ);
        }
        if ((tier & 4) == 4) {
            this.roomDepth -= 2;
            if (this.getDirection().func_176740_k() == EnumFacing.Axis.X) {
                this.sizeZ += 4;
            } else {
                this.sizeX += 4;
            }
            xMin = blockPosX - this.sizeX / 2;
            zMin = blockPosZ - this.sizeZ / 2;
            switch (this.getDirection()) {
                case NORTH: {
                    ++this.sizeZ;
                    break;
                }
                case SOUTH: {
                    --zMin;
                    ++this.sizeZ;
                    break;
                }
                case WEST: {
                    ++this.sizeX;
                    break;
                }
                default: {
                    --xMin;
                    ++this.sizeX;
                }
            }
            this.field_74887_e = new StructureBoundingBox(xMin, blockPosY, zMin, xMin + this.sizeX, blockPosY + this.sizeY, zMin + this.sizeZ);
        }
    }

    private void createOtherDecks(BaseConfiguration configuration, Random rand, int blockPosX, int blockPosY, int blockPosZ) {
        this.otherDecks = new ArrayList();
        if (this.configuration.isHangarDeck()) {
            this.otherDecks.add(new BaseDeck(configuration, rand, blockPosX, blockPosY + this.sizeY + 1, blockPosZ, 6, this.direction));
        } else {
            this.otherDecks.add(new BaseDeck(configuration, rand, blockPosX, blockPosY + this.sizeY, blockPosZ, 0, this.direction));
            this.otherDecks.add(new BaseDeck(configuration, rand, blockPosX, blockPosY + this.sizeY + this.sizeY, blockPosZ, 2, this.direction));
        }
    }

    @Override
    protected void func_143012_a(NBTTagCompound tagCompound) {
        super.func_143012_a(tagCompound);
        int details = this.deckTier + (this.largeRoomPosA << 4) + (this.largeRoomPosB << 8);
        tagCompound.func_74768_a("dD", details);
        if (this.otherDecks != null) {
            NBTTagList tagList = new NBTTagList();
            for (BaseDeck deck : this.otherDecks) {
                NBTTagCompound tag1 = new NBTTagCompound();
                deck.func_143012_a(tag1);
                tagList.func_74742_a((NBTBase)tag1);
            }
            tagCompound.func_74782_a("oD", (NBTBase)tagList);
        }
    }

    @Override
    protected void func_143011_b(NBTTagCompound tagCompound, TemplateManager manager) {
        super.func_143011_b(tagCompound, manager);
        try {
            int details = tagCompound.func_74762_e("dD");
            this.deckTier = details & 0xF;
            this.largeRoomPosB = details >> 8;
            this.largeRoomPosA = details >> 4 & 0xF;
            this.roomsOnSide = this.configuration.getRoomsNo();
            this.roomDepth = this.configuration.getRoomDepth() + (this.deckTier == 0 ? 1 : 0) - ((this.deckTier & 4) == 4 ? 3 : 0);
            if (tagCompound.func_74764_b("oD")) {
                NBTTagList tagList = tagCompound.func_150295_c("oD", 10);
                this.otherDecks = new ArrayList();
                for (int i = 0; i < tagList.func_74745_c(); ++i) {
                    NBTTagCompound tagAt = tagList.func_150305_b(i);
                    BaseDeck deck = new BaseDeck();
                    deck.func_143011_b(tagAt, manager);
                    this.otherDecks.add(deck);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Failed to read Abandoned Base configuration from NBT");
            System.err.println(tagCompound.toString());
        }
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox chunkBounds) {
        int leftX;
        int ceilingSpacer;
        IBlockState blockWall = this.configuration.getWallBlock();
        IBlockState blockGrid = AsteroidBlocks.blockWalkway.func_176223_P();
        Block blockStair = GCBlocks.moonStoneStairs;
        IBlockState blockAir = Blocks.field_150350_a.func_176223_P();
        boolean directionNS = this.getDirection().func_176740_k() == EnumFacing.Axis.Z;
        int ceilingDeco = ceilingSpacer = (directionNS ? this.sizeZ : this.sizeX) / this.roomsOnSide + 1;
        int startX = 0;
        int startZ = 0;
        int endX = this.sizeX;
        int endZ = this.sizeZ;
        int endY = this.sizeY;
        if (this.configuration.getDeckType() == EnumBaseType.AVIAN && !this.configuration.isHangarDeck()) {
            --endY;
        }
        for (int x = startX; x <= endX; ++x) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int y = 0; y <= endY; ++y) {
                    if (x == startX || x == endX || y == 0 || y == endY || z == startZ || z == endZ) {
                        int hangarOffset;
                        boolean skipCap = false;
                        if (this.configuration.isHangarDeck() && this.deckTier == 1 && (this.getDirection() == EnumFacing.NORTH && z == endZ || this.getDirection() == EnumFacing.SOUTH && z == startZ || this.getDirection() == EnumFacing.WEST && x == endX || this.getDirection() == EnumFacing.EAST && x == startX)) {
                            IBlockState blockLintel = GCBlocks.airLockFrame.func_176223_P();
                            IBlockState blockAirlock = GCBlocks.airLockFrame.func_176203_a(1);
                            if ((!directionNS && (z == startZ + 1 || z == endZ - 1) || directionNS && (x == startX + 1 || x == endX - 1)) && y < this.sizeY - 1) {
                                this.func_175811_a(worldIn, blockLintel, x, y, z, chunkBounds);
                            } else if (y >= endY - 1 || directionNS && (x == startX || x == endX) || !directionNS && (z == startZ || z == endZ)) {
                                this.func_175811_a(worldIn, blockWall, x, y, z, chunkBounds);
                            } else if (y == 0 || y == endY - 2) {
                                if (y == 0 && (!directionNS && z == (startZ + endZ) / 2 || directionNS && x == (startX + endX) / 2)) {
                                    this.func_175811_a(worldIn, blockAirlock, x, y, z, chunkBounds);
                                } else {
                                    this.func_175811_a(worldIn, blockLintel, x, y, z, chunkBounds);
                                }
                                skipCap = true;
                            } else {
                                this.func_175811_a(worldIn, blockAir, x, y, z, chunkBounds);
                            }
                        } else if ((y != 0 || (this.deckTier & 1) != 1) && (y != endY || (this.deckTier & 1) != 2) || (!directionNS || z != startZ && z != endZ) && (directionNS || x != startX && x != endX)) {
                            if (y == 0 && (this.deckTier & 1) == 1 && this.configuration.getDeckType() == EnumBaseType.HUMANOID && (directionNS && (x == startX + 2 + (this.configuration.isHangarDeck() ? 1 : 0) || x == startX + 4 + (this.configuration.isHangarDeck() ? 1 : 0)) || !directionNS && (z == startZ + 2 + (this.configuration.isHangarDeck() ? 1 : 0) || z == startZ + 4 + (this.configuration.isHangarDeck() ? 1 : 0)))) {
                                this.func_175811_a(worldIn, blockGrid, x, y, z, chunkBounds);
                            } else if (!this.configuration.isHangarDeck() && (this.getDirection() == EnumFacing.SOUTH && z == endZ || this.getDirection() == EnumFacing.NORTH && z == startZ || this.getDirection() == EnumFacing.EAST && x == endX || this.getDirection() == EnumFacing.WEST && x == startX)) {
                                int endW;
                                int startW;
                                int w;
                                IBlockState blockGlass;
                                IBlockState windowOrWall = blockWall;
                                switch (this.configuration.getDeckType()) {
                                    case AVIAN: {
                                        blockGlass = GCBlocks.spaceGlassTinVanilla.func_176223_P();
                                        break;
                                    }
                                    case TUNNELER: {
                                        blockGlass = GCBlocks.spaceGlassTinStrong.func_176223_P();
                                        break;
                                    }
                                    default: {
                                        blockGlass = GCBlocks.spaceGlassTinClear.func_176223_P();
                                    }
                                }
                                if (directionNS) {
                                    w = x;
                                    startW = startX;
                                    endW = endX;
                                } else {
                                    w = z;
                                    startW = startZ;
                                    endW = endZ;
                                }
                                if (this.configuration.getDeckType() == EnumBaseType.AVIAN) {
                                    if (y == 2 && w == startW + 2) {
                                        windowOrWall = blockGlass;
                                    }
                                } else {
                                    int edge;
                                    int n = edge = this.configuration.getDeckType() == EnumBaseType.TUNNELER ? 1 : 0;
                                    if ((y == 2 || y == 3) && w > startW + edge && w < endW - edge) {
                                        windowOrWall = blockGlass;
                                    }
                                }
                                this.func_175811_a(worldIn, windowOrWall, x, y, z, chunkBounds);
                            } else {
                                this.func_175811_a(worldIn, blockWall, x, y, z, chunkBounds);
                            }
                        }
                        int n = hangarOffset = this.configuration.isHangarDeck() ? 1 : 0;
                        if (y != 0 || (this.deckTier & 1) != 1 || this.configuration.getDeckType() != EnumBaseType.HUMANOID || (!directionNS || x < startX + 2 + hangarOffset || x > startX + 4 + hangarOffset) && (directionNS || z < startZ + 2 + hangarOffset || z > startZ + 4 + hangarOffset) || (!directionNS || z != startZ && z != endZ) && (directionNS || x != startX && x != endX) || skipCap) continue;
                        this.func_175811_a(worldIn, blockWall, x, y, z, chunkBounds);
                        continue;
                    }
                    if (this.configuration.getDeckType().ordinal() >= EnumBaseType.AVIAN.ordinal() && (y == 1 || y == endY - 1)) {
                        int top;
                        int n = top = y == 1 ? 0 : 4;
                        if (this.configuration.getDeckType() == EnumBaseType.TUNNELER) {
                            ++top;
                        }
                        if (directionNS) {
                            if (x == startX + 1) {
                                this.func_175811_a(worldIn, blockStair.func_176203_a(0 ^ top), x, y, z, chunkBounds);
                                continue;
                            }
                            if (x == endX - 1) {
                                this.func_175811_a(worldIn, blockStair.func_176203_a(1 ^ top), x, y, z, chunkBounds);
                                continue;
                            }
                            if (this.configuration.getDeckType() == EnumBaseType.AVIAN) {
                                if (z == ceilingDeco && top >= 4) {
                                    this.func_175811_a(worldIn, blockStair.func_176203_a(3 ^ top), x, y, z, chunkBounds);
                                    continue;
                                }
                                if (z == ceilingDeco + 1 && top >= 4) {
                                    this.func_175811_a(worldIn, blockStair.func_176203_a(2 ^ top), x, y, z, chunkBounds);
                                    if (x < endX - 2) continue;
                                    ceilingDeco += ceilingSpacer;
                                    continue;
                                }
                                this.func_175811_a(worldIn, blockAir, x, y, z, chunkBounds);
                                continue;
                            }
                            this.func_175811_a(worldIn, blockAir, x, y, z, chunkBounds);
                            continue;
                        }
                        if (z == startZ + 1) {
                            this.func_175811_a(worldIn, blockStair.func_176203_a(2 ^ top), x, y, z, chunkBounds);
                            continue;
                        }
                        if (z == endZ - 1) {
                            this.func_175811_a(worldIn, blockStair.func_176203_a(3 ^ top), x, y, z, chunkBounds);
                            continue;
                        }
                        if (this.configuration.getDeckType() == EnumBaseType.AVIAN) {
                            if (x == ceilingDeco && top == 4) {
                                this.func_175811_a(worldIn, blockStair.func_176203_a(1 ^ top), x, y, z, chunkBounds);
                                continue;
                            }
                            if (x == ceilingDeco + 1 && top == 4) {
                                this.func_175811_a(worldIn, blockStair.func_176203_a(top), x, y, z, chunkBounds);
                                if (z < endZ - 2) continue;
                                ceilingDeco += ceilingSpacer;
                                continue;
                            }
                            this.func_175811_a(worldIn, blockAir, x, y, z, chunkBounds);
                            continue;
                        }
                        this.func_175811_a(worldIn, blockAir, x, y, z, chunkBounds);
                        continue;
                    }
                    this.func_175811_a(worldIn, blockAir, x, y, z, chunkBounds);
                }
                if (endY == this.sizeY) continue;
                this.func_175811_a(worldIn, blockWall, x, this.sizeY, z, chunkBounds);
            }
        }
        int rightX = leftX = (this.deckTier & 4) == 4 && (this.direction == EnumFacing.SOUTH || this.direction == EnumFacing.EAST) ? 3 : 2;
        int leftZ = leftX;
        int rightZ = rightX;
        for (int i = 0; i < this.roomsOnSide; ++i) {
            int largeRoomOffset;
            boolean largeRoom = i == this.largeRoomPosA || i == this.largeRoomPosB;
            int roomsize = largeRoom ? 8 : 6;
            int n = largeRoomOffset = largeRoom ? 2 : 1;
            if (directionNS) {
                this.makeDoorway(worldIn, this.sizeX, leftZ + largeRoomOffset, directionNS, chunkBounds);
                this.makeDoorway(worldIn, 0, rightZ + largeRoomOffset, directionNS, chunkBounds);
                leftZ += roomsize;
                rightZ += roomsize;
                continue;
            }
            this.makeDoorway(worldIn, leftX + largeRoomOffset, this.sizeZ, directionNS, chunkBounds);
            this.makeDoorway(worldIn, rightX + largeRoomOffset, 0, directionNS, chunkBounds);
            leftX += roomsize;
            rightX += roomsize;
        }
        if (directionNS) {
            this.func_186164_a(this.direction);
        } else {
            this.func_186164_a(this.direction.func_176734_d());
        }
        if (this.configuration.isHangarDeck() && this.deckTier == 1) {
            int width = directionNS ? this.sizeX : this.sizeZ;
            this.func_175811_a(worldIn, blockAir, 0, this.sizeY, 1, chunkBounds);
            this.func_175811_a(worldIn, blockAir, 1, this.sizeY, 1, chunkBounds);
            this.func_175811_a(worldIn, blockAir, 1, this.sizeY - 1, 1, chunkBounds);
            this.func_175811_a(worldIn, blockAir, width - 1, this.sizeY - 1, 1, chunkBounds);
            this.func_175811_a(worldIn, blockAir, width - 1, this.sizeY, 1, chunkBounds);
            this.func_175811_a(worldIn, blockAir, width, this.sizeY, 1, chunkBounds);
        }
        if ((this.deckTier & 4) == 4) {
            IBlockState blockGlass;
            switch (this.configuration.getDeckType()) {
                case AVIAN: {
                    blockGlass = GCBlocks.spaceGlassTinVanilla.func_176223_P();
                    break;
                }
                case TUNNELER: {
                    blockGlass = GCBlocks.spaceGlassTinStrong.func_176223_P();
                    break;
                }
                default: {
                    blockGlass = GCBlocks.spaceGlassTinClear.func_176223_P();
                }
            }
            if (!directionNS) {
                int w = endX;
                endX = endZ;
                endZ = w;
            }
            for (int y = 1; y < 5; ++y) {
                for (int x = 2; x < endX - 1; ++x) {
                    this.func_175811_a(worldIn, blockGlass, x, y, endZ, chunkBounds);
                }
            }
            int facing = 0;
            switch (this.direction) {
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    facing = 2;
                    break;
                }
                case EAST: {
                    facing = 1;
                    break;
                }
                case WEST: {
                    facing = 3;
                }
            }
            IBlockState lever = GCBlocks.concealedDetector.func_176203_a(8 + facing + (this.configuration.getDeckType() == EnumBaseType.HUMANOID ? 0 : 4));
            this.func_175811_a(worldIn, lever, endX / 2 - 2, this.sizeY - 1, endZ, chunkBounds);
            this.func_175811_a(worldIn, lever, endX / 2 + 2, this.sizeY - 1, endZ, chunkBounds);
            lever = Blocks.field_150442_at.func_176203_a(3);
            this.func_175811_a(worldIn, lever, endX / 2 - 2, this.sizeY - 1, endZ - 1, chunkBounds);
            this.func_175811_a(worldIn, lever, endX / 2 + 2, this.sizeY - 1, endZ - 1, chunkBounds);
            this.func_175811_a(worldIn, GCBlocks.concealedRedstone.func_176203_a(15), endX / 2 - 2, this.sizeY, endZ, chunkBounds);
            this.func_175811_a(worldIn, GCBlocks.concealedRedstone.func_176203_a(15), endX / 2 + 2, this.sizeY, endZ, chunkBounds);
            this.func_175811_a(worldIn, blockAir, 2, 0, 1, chunkBounds);
            this.func_175811_a(worldIn, blockAir, 3, 0, 1, chunkBounds);
            this.func_175811_a(worldIn, blockAir, 11, 0, 1, chunkBounds);
            this.func_175811_a(worldIn, blockAir, 12, 0, 1, chunkBounds);
        }
        this.func_186164_a(EnumFacing.NORTH);
        return true;
    }

    public List<Piece> getRooms(int roomIndex, BaseStart startPiece, Random rand) {
        int blockZ;
        int blockX;
        int rightZ;
        ArrayList<Piece> rooms = new ArrayList<Piece>();
        boolean directionNS = this.getDirection().func_176740_k() == EnumFacing.Axis.Z;
        EnumFacing left = directionNS ? EnumFacing.WEST : EnumFacing.SOUTH;
        EnumFacing right = directionNS ? EnumFacing.EAST : EnumFacing.NORTH;
        int leftX = directionNS ? this.field_74887_e.field_78893_d + 1 : this.field_74887_e.field_78897_a;
        int leftZ = directionNS ? this.field_74887_e.field_78896_c : this.field_74887_e.field_78892_f + 1;
        int rightX = directionNS ? this.field_74887_e.field_78897_a - this.roomDepth - 1 : this.field_74887_e.field_78897_a;
        int n = rightZ = directionNS ? this.field_74887_e.field_78896_c : this.field_74887_e.field_78896_c - this.roomDepth - 1;
        if ((this.deckTier & 4) == 4 && this.direction == EnumFacing.SOUTH) {
            ++rightZ;
            ++leftZ;
        }
        if ((this.deckTier & 4) == 4 && this.direction == EnumFacing.EAST) {
            ++rightX;
            ++leftX;
        }
        for (int i = 0; i < this.roomsOnSide; ++i) {
            boolean largeRoom = i == this.largeRoomPosA || i == this.largeRoomPosB;
            int roomsize = largeRoom ? 8 : 6;
            rooms.add(this.getRoom(roomIndex++, left, leftX, leftZ, largeRoom, true, rand));
            rooms.add(this.getRoom(roomIndex++, right, rightX, rightZ, largeRoom, false, rand));
            if (directionNS) {
                leftZ += roomsize;
                rightZ += roomsize;
                continue;
            }
            leftX += roomsize;
            rightX += roomsize;
        }
        if (this.configuration.isHangarDeck() && (this.deckTier & 1) == 1) {
            blockX = 0;
            blockZ = 0;
            switch (this.direction) {
                case NORTH: {
                    blockX = this.field_74887_e.field_78897_a + (this.sizeX - 26) / 2;
                    blockZ = this.field_74887_e.field_78892_f + 1;
                    break;
                }
                case SOUTH: {
                    blockX = this.field_74887_e.field_78897_a + (this.sizeX - 26) / 2;
                    blockZ = this.field_74887_e.field_78896_c - 1 - 42;
                    break;
                }
                case WEST: {
                    blockX = this.field_74887_e.field_78893_d + 1;
                    blockZ = this.field_74887_e.field_78896_c + (this.sizeZ - 26) / 2;
                    break;
                }
                default: {
                    blockX = this.field_74887_e.field_78897_a - 1 - 42;
                    blockZ = this.field_74887_e.field_78896_c + (this.sizeZ - 26) / 2;
                }
            }
            rooms.add(new BaseHangar(this.configuration, rand, blockX, blockZ, this.direction.func_176734_d()));
        }
        if ((this.configuration.isHangarDeck() || this.configuration.getDeckType() == EnumBaseType.HUMANOID) && (this.deckTier & 1) == 1) {
            blockX = this.field_74887_e.field_78897_a;
            blockZ = this.field_74887_e.field_78896_c;
            int sX = this.sizeX;
            int sZ = this.sizeZ;
            switch (this.direction) {
                case NORTH: {
                    ++blockZ;
                    --sZ;
                    if (this.configuration.isHangarDeck()) break;
                    --sZ;
                    break;
                }
                case SOUTH: {
                    --sZ;
                    if (this.configuration.isHangarDeck()) break;
                    ++blockZ;
                    --sZ;
                    break;
                }
                case WEST: {
                    ++blockX;
                    --sX;
                    if (this.configuration.isHangarDeck()) break;
                    --sX;
                    break;
                }
                default: {
                    --sX;
                    if (this.configuration.isHangarDeck()) break;
                    ++blockX;
                    --sX;
                }
            }
            rooms.add(new BasePlate(this.configuration, blockX, this.field_74887_e.field_78895_b - 1, blockZ, sX, sZ, this.direction));
        }
        if (this.otherDecks != null) {
            for (BaseDeck deck : this.otherDecks) {
                rooms.add(deck);
                List<Piece> newRooms = deck.getRooms(roomIndex, startPiece, rand);
                rooms.addAll(newRooms);
                roomIndex += newRooms.size();
            }
        }
        return rooms;
    }

    protected void makeDoorway(World worldIn, int x, int z, boolean directionNS, StructureBoundingBox chunkBounds) {
        IBlockState blockLintel = GCBlocks.airLockFrame.func_176223_P();
        IBlockState blockAirlock = GCBlocks.airLockFrame.func_176203_a(1);
        Block blockStair = GCBlocks.moonStoneStairs;
        IBlockState blockAir = Blocks.field_150350_a.func_176223_P();
        int meta = directionNS ? 2 : 0;
        switch (this.configuration.getDeckType()) {
            case HUMANOID: {
                if (directionNS) {
                    --z;
                } else {
                    --x;
                }
                this.func_175811_a(worldIn, blockLintel, x, 1, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 2, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 3, z, chunkBounds);
                if (directionNS) {
                    ++z;
                } else {
                    ++x;
                }
                this.func_175811_a(worldIn, blockAir, x, 1, z, chunkBounds);
                this.func_175811_a(worldIn, blockAir, x, 2, z, chunkBounds);
                this.func_175811_a(worldIn, blockAirlock, x, 0, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 3, z, chunkBounds);
                if (directionNS) {
                    ++z;
                } else {
                    ++x;
                }
                this.func_175811_a(worldIn, blockLintel, x, 1, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 2, z, chunkBounds);
                this.func_175811_a(worldIn, blockLintel, x, 3, z, chunkBounds);
                break;
            }
            case AVIAN: {
                this.func_175811_a(worldIn, blockStair.func_176203_a(0 + meta), x, this.sizeY - 4, z, chunkBounds);
                this.func_175811_a(worldIn, blockAir, x, this.sizeY - 3, z, chunkBounds);
                this.func_175811_a(worldIn, blockStair.func_176203_a(4 + meta), x, this.sizeY - 2, z, chunkBounds);
                if (directionNS) {
                    ++z;
                } else {
                    ++x;
                }
                this.func_175811_a(worldIn, blockStair.func_176203_a(1 + meta), x, this.sizeY - 4, z, chunkBounds);
                this.func_175811_a(worldIn, blockAir, x, this.sizeY - 3, z, chunkBounds);
                this.func_175811_a(worldIn, blockStair.func_176203_a(5 + meta), x, this.sizeY - 2, z, chunkBounds);
                break;
            }
            case TUNNELER: {
                if (directionNS) {
                    --z;
                } else {
                    --x;
                }
                this.func_175811_a(worldIn, blockStair.func_176203_a(1 + meta), x, 2, z, chunkBounds);
                this.func_175811_a(worldIn, blockStair.func_176203_a(5 + meta), x, 3, z, chunkBounds);
                if (directionNS) {
                    ++z;
                } else {
                    ++x;
                }
                this.func_175811_a(worldIn, blockAir, x, 2, z, chunkBounds);
                this.func_175811_a(worldIn, blockAir, x, 3, z, chunkBounds);
                if (directionNS) {
                    ++z;
                } else {
                    ++x;
                }
                this.func_175811_a(worldIn, blockStair.func_176203_a(0 + meta), x, 2, z, chunkBounds);
                this.func_175811_a(worldIn, blockStair.func_176203_a(4 + meta), x, 3, z, chunkBounds);
                break;
            }
        }
    }

    protected Piece getRoom(int i, EnumFacing dir, int blockX, int blockZ, boolean large, boolean left, Random rand) {
        int sX;
        int sZ = sX = large ? 8 : 6;
        if (dir.func_176740_k() == EnumFacing.Axis.Z) {
            sZ = this.roomDepth;
        } else {
            sX = this.roomDepth;
        }
        int sY = this.sizeY;
        return new BaseRoom(this.configuration, rand, blockX, this.field_74887_e.field_78895_b, blockZ, sX, sY, sZ, dir, this.configuration.getRandomRoom(i), left ? i == 0 : i == this.roomsOnSide - 1, left ? i == this.roomsOnSide - 1 : i == 0, this.deckTier);
    }

    public static enum EnumBaseType {
        HUMANOID(5, 3, GCBlocks.basicBlock.func_176203_a(4)),
        AVIAN(4, 3, GCBlocks.blockMoon.func_176203_a(4)),
        TUNNELER(4, 4, GCBlocks.blockMoon.func_176203_a(4));

        public final int height;
        public final int width;
        public final IBlockState wall;

        private EnumBaseType(int height, int width, IBlockState wallBlock) {
            this.height = height;
            this.width = width;
            this.wall = wallBlock;
        }
    }
}

