/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars;

import com.google.common.collect.ImmutableList;
import java.util.List;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.api.world.IGalacticraftWorldProvider;
import micdoodle8.mods.galacticraft.core.client.CloudRenderer;
import micdoodle8.mods.galacticraft.core.client.render.tile.TileEntityBubbleProviderRenderer;
import micdoodle8.mods.galacticraft.core.util.ClientUtil;
import micdoodle8.mods.galacticraft.core.wrappers.ModelTransformWrapper;
import micdoodle8.mods.galacticraft.planets.IPlanetsModuleClient;
import micdoodle8.mods.galacticraft.planets.asteroids.client.render.item.ItemModelCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockBasicMars;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockCavernousVine;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.client.SkyProviderMars;
import micdoodle8.mods.galacticraft.planets.mars.client.fx.ParticleDrip;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiMethaneSynthesizer;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiSlimeling;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiSlimelingFeed;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiTerraformer;
import micdoodle8.mods.galacticraft.planets.mars.client.gui.GuiWaterElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderCreeperBoss;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderLandingBalloons;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderProjectileTNT;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderSlimeling;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderSludgeling;
import micdoodle8.mods.galacticraft.planets.mars.client.render.entity.RenderTier2Rocket;
import micdoodle8.mods.galacticraft.planets.mars.client.render.item.ItemModelRocketT2;
import micdoodle8.mods.galacticraft.planets.mars.client.render.tile.TileEntityTreasureChestRenderer;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCargoRocket;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityCreeperBoss;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityLandingBalloons;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityProjectileTNT;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntitySlimeling;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntitySludgeling;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntityTier2Rocket;
import micdoodle8.mods.galacticraft.planets.mars.items.ItemSchematicTier2;
import micdoodle8.mods.galacticraft.planets.mars.items.MarsItems;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityElectrolyzer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityGasLiquefier;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityMethaneSynthesizer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityTerraformer;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityTreasureChestMars;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MarsModuleClient
implements IPlanetsModuleClient {
    private static ModelResourceLocation sludgeLocation = new ModelResourceLocation("galacticraftplanets:sludge", "fluid");

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        this.addPlanetVariants("mars", "ore_copper_mars", "ore_tin_mars", "ore_desh_mars", "ore_iron_mars", "cobblestone", "mars_surface", "mars_middle", "dungeon_brick", "desh_block", "mars_stone");
        this.addPlanetVariants("cavern_vines", "vine_0", "vine_1", "vine_2");
        this.addPlanetVariants("item_basic_mars", "raw_desh", "desh_stick", "ingot_desh", "reinforced_plate_t2", "slimeling_cargo", "compressed_desh", "fluid_manip");
        this.addPlanetVariants("schematic", "schematic_rocket_t3", "schematic_rocket_cargo", "schematic_astro_miner");
        this.addPlanetVariants("slimeling_egg", "slimeling_egg_red", "slimeling_egg_blue", "slimeling_egg_yellow");
        this.addPlanetVariants("mars_machine", "terraformer", "cryogenic_chamber", "launch_controller");
        this.addPlanetVariants("mars_machine_t2", "gas_liquefier", "methane_synthesizer", "electrolyzer");
        MinecraftForge.EVENT_BUS.register((Object)this);
        RenderingRegistry.registerEntityRenderingHandler(EntitySludgeling.class, manager -> new RenderSludgeling(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntitySlimeling.class, manager -> new RenderSlimeling(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityCreeperBoss.class, manager -> new RenderCreeperBoss(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityProjectileTNT.class, manager -> new RenderProjectileTNT(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityCargoRocket.class, manager -> new RenderCargoRocket(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityLandingBalloons.class, manager -> new RenderLandingBalloons(manager));
        RenderingRegistry.registerEntityRenderingHandler(EntityTier2Rocket.class, manager -> new RenderTier2Rocket(manager));
    }

    private void addPlanetVariants(String name, String ... variants) {
        Item itemBlockVariants = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("galacticraftplanets", name));
        ResourceLocation[] variants0 = new ResourceLocation[variants.length];
        for (int i = 0; i < variants.length; ++i) {
            variants0[i] = new ResourceLocation("galacticraftplanets:" + variants[i]);
        }
        ModelBakery.registerItemVariants((Item)itemBlockVariants, (ResourceLocation[])variants0);
    }

    @Override
    public void registerVariants() {
        int i;
        Item sludge = Item.func_150898_a((Block)MarsBlocks.blockSludge);
        ModelBakery.registerItemVariants((Item)sludge, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation("galacticraftplanets:sludge")});
        ModelLoader.setCustomMeshDefinition((Item)sludge, stack -> sludgeLocation);
        ModelLoader.setCustomStateMapper((Block)MarsBlocks.blockSludge, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return sludgeLocation;
            }
        });
        ModelResourceLocation modelResourceLocation = new ModelResourceLocation("galacticraftplanets:rocket_t2", "inventory");
        for (i = 0; i < 5; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)MarsItems.rocketMars, (int)i, (ModelResourceLocation)modelResourceLocation);
        }
        modelResourceLocation = new ModelResourceLocation("galacticraftplanets:rocket_cargo", "inventory");
        for (i = 11; i < 15; ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)MarsItems.rocketMars, (int)i, (ModelResourceLocation)modelResourceLocation);
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new TickHandlerClient());
        MarsModuleClient.registerBlockRenderers();
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void loadTextures(TextureStitchEvent.Pre event) {
        this.registerTexture(event, "rocket_t2");
        this.registerTexture(event, "cargo_rocket");
        this.registerTexture(event, "landing_balloon");
    }

    private void registerTexture(TextureStitchEvent.Pre event, String texture) {
        event.getMap().func_174942_a(new ResourceLocation("galacticraftplanets:blocks/" + texture));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBakeEvent(ModelBakeEvent event) {
        this.replaceModelDefault(event, "rocket_t2", "rocket_t2.obj", (List<String>)ImmutableList.of((Object)"Rocket"), ItemModelRocketT2.class, (IModelState)TRSRTransformation.identity(), new String[0]);
        this.replaceModelDefault(event, "rocket_cargo", "cargo_rocket.obj", (List<String>)ImmutableList.of((Object)"Rocket"), ItemModelCargoRocket.class, (IModelState)TRSRTransformation.identity(), new String[0]);
    }

    private void replaceModelDefault(ModelBakeEvent event, String resLoc, String objLoc, List<String> visibleGroups, Class<? extends ModelTransformWrapper> clazz, IModelState parentState, String ... variants) {
        ClientUtil.replaceModel((String)"galacticraftplanets", (ModelBakeEvent)event, (String)resLoc, (String)objLoc, visibleGroups, clazz, (IModelState)parentState, (String[])variants);
    }

    @Override
    public void postInit(FMLPostInitializationEvent event) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTreasureChestMars.class, (TileEntitySpecialRenderer)new TileEntityTreasureChestRenderer());
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTerraformer.class, (TileEntitySpecialRenderer)new TileEntityBubbleProviderRenderer(0.25f, 1.0f, 0.25f));
        ItemSchematicTier2.registerTextures();
    }

    public static void registerBlockRenderers() {
        for (BlockBasicMars.EnumBlockBasic enumBlockBasic : BlockBasicMars.EnumBlockBasic.values()) {
            ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.marsBlock, (int)enumBlockBasic.getMeta(), (String)enumBlockBasic.func_176610_l());
        }
        for (Enum enum_ : BlockCavernousVine.EnumVineType.values()) {
            ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.vine, (int)((BlockCavernousVine.EnumVineType)enum_).getMeta(), (String)((BlockCavernousVine.EnumVineType)enum_).func_176610_l());
        }
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.rock, (int)0, (String)"slimeling_egg_red");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.rock, (int)1, (String)"slimeling_egg_blue");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.rock, (int)2, (String)"slimeling_egg_yellow");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.creeperEgg);
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.machine, (int)0, (String)"terraformer");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.machine, (int)4, (String)"cryogenic_chamber");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.machine, (int)8, (String)"launch_controller");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.machineT2, (int)0, (String)"gas_liquefier");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.machineT2, (int)4, (String)"methane_synthesizer");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.machineT2, (int)8, (String)"electrolyzer");
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.treasureChestTier2);
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.marsBricksStairs);
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.marsCobblestoneStairs);
        ClientUtil.registerBlockJson((String)"galacticraftplanets:", (Block)MarsBlocks.bossSpawner);
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)MarsItems.marsItemBasic, (int)0, (String)"raw_desh");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)MarsItems.marsItemBasic, (int)1, (String)"desh_stick");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)MarsItems.marsItemBasic, (int)2, (String)"ingot_desh");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)MarsItems.marsItemBasic, (int)3, (String)"reinforced_plate_t2");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)MarsItems.marsItemBasic, (int)4, (String)"slimeling_cargo");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)MarsItems.marsItemBasic, (int)5, (String)"compressed_desh");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)MarsItems.marsItemBasic, (int)6, (String)"fluid_manip");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)MarsItems.key, (int)0, (String)"key");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)MarsItems.schematic, (int)0, (String)"schematic_rocket_t3");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)MarsItems.schematic, (int)1, (String)"schematic_rocket_cargo");
        ClientUtil.registerItemJson((String)"galacticraftplanets:", (Item)MarsItems.schematic, (int)2, (String)"schematic_astro_miner");
    }

    @Override
    public Object getGuiElement(Side side, int ID, EntityPlayer player, World world, int x, int y, int z) {
        if (side == Side.CLIENT) {
            TileEntity tile = world.func_175625_s(new BlockPos(x, y, z));
            if (ID == 2) {
                if (tile instanceof TileEntityTerraformer) {
                    return new GuiTerraformer(player.field_71071_by, (TileEntityTerraformer)tile);
                }
                if (tile instanceof TileEntityLaunchController) {
                    return new GuiLaunchController(player.field_71071_by, (TileEntityLaunchController)tile);
                }
                if (tile instanceof TileEntityElectrolyzer) {
                    return new GuiWaterElectrolyzer(player.field_71071_by, (TileEntityElectrolyzer)tile);
                }
                if (tile instanceof TileEntityGasLiquefier) {
                    return new GuiGasLiquefier(player.field_71071_by, (TileEntityGasLiquefier)tile);
                }
                if (tile instanceof TileEntityMethaneSynthesizer) {
                    return new GuiMethaneSynthesizer(player.field_71071_by, (TileEntityMethaneSynthesizer)tile);
                }
            }
        }
        return null;
    }

    @Override
    public void spawnParticle(String particleID, Vector3 position, Vector3 motion, Object ... extraData) {
        Minecraft mc = FMLClientHandler.instance().getClient();
        if (mc != null && mc.func_175606_aa() != null && mc.field_71452_i != null) {
            double dPosX = mc.func_175606_aa().field_70165_t - position.x;
            double dPosY = mc.func_175606_aa().field_70163_u - position.y;
            double dPosZ = mc.func_175606_aa().field_70161_v - position.z;
            ParticleDrip particle = null;
            double maxDistSqrd = 64.0;
            if (dPosX * dPosX + dPosY * dPosY + dPosZ * dPosZ < 4096.0 && !particleID.equals("sludgeDrip") && particleID.equals("bacterialDrip")) {
                particle = new ParticleDrip((World)mc.field_71441_e, position.x, position.y, position.z);
            }
            if (particle != null) {
                mc.field_71452_i.func_78873_a(particle);
            }
        }
    }

    @Override
    public void getGuiIDs(List<Integer> idList) {
        idList.add(2);
    }

    public static void openSlimelingGui(EntitySlimeling slimeling, int gui) {
        switch (gui) {
            case 0: {
                FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiSlimeling(slimeling));
                break;
            }
            case 1: {
                FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiSlimelingFeed(slimeling));
            }
        }
    }

    public static class TickHandlerClient {
        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onClientTick(TickEvent.ClientTickEvent event) {
            Minecraft minecraft = FMLClientHandler.instance().getClient();
            WorldClient world = minecraft.field_71441_e;
            if (world != null && world.field_73011_w instanceof WorldProviderMars) {
                if (world.field_73011_w.getSkyRenderer() == null) {
                    world.field_73011_w.setSkyRenderer((IRenderHandler)new SkyProviderMars((IGalacticraftWorldProvider)world.field_73011_w));
                }
                if (world.field_73011_w.getCloudRenderer() == null) {
                    world.field_73011_w.setCloudRenderer((IRenderHandler)new CloudRenderer());
                }
            }
        }
    }
}

