/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars.tile;

import java.util.LinkedList;
import java.util.List;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.network.IPacket;
import micdoodle8.mods.galacticraft.core.tile.IMultiBlock;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.planets.mars.network.PacketSimpleMars;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Biomes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityCryogenicChamber
extends TileEntityMulti
implements IMultiBlock {
    public boolean isOccupied;
    private boolean initialised;

    public TileEntityCryogenicChamber() {
        super(null);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 3), (double)(this.func_174877_v().func_177952_p() + 2));
    }

    public boolean onActivated(EntityPlayer entityPlayer) {
        if (this.field_145850_b.field_72995_K) {
            return false;
        }
        EntityPlayer.SleepResult enumstatus = this.sleepInBedAt(entityPlayer, this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        switch (enumstatus) {
            case OK: {
                ((EntityPlayerMP)entityPlayer).field_71135_a.func_147364_a(entityPlayer.field_70165_t, entityPlayer.field_70163_u, entityPlayer.field_70161_v, entityPlayer.field_70177_z, entityPlayer.field_70125_A);
                GalacticraftCore.packetPipeline.sendTo((IPacket)new PacketSimpleMars(PacketSimpleMars.EnumSimplePacketMars.C_BEGIN_CRYOGENIC_SLEEP, GCCoreUtil.getDimensionID((World)entityPlayer.field_70170_p), new Object[]{this.func_174877_v()}), (EntityPlayerMP)entityPlayer);
                return true;
            }
            case NOT_POSSIBLE_NOW: {
                GCPlayerStats stats = GCPlayerStats.get((Entity)entityPlayer);
                entityPlayer.func_145747_a((ITextComponent)new TextComponentString(GCCoreUtil.translateWithFormat((String)"gui.cryogenic.chat.cant_use", (Object[])new Object[]{stats.getCryogenicChamberCooldown() / 20})));
                return false;
            }
        }
        return false;
    }

    public EntityPlayer.SleepResult sleepInBedAt(EntityPlayer entityPlayer, int par1, int par2, int par3) {
        if (!this.field_145850_b.field_72995_K) {
            if (entityPlayer.func_70608_bn() || !entityPlayer.func_70089_S()) {
                return EntityPlayer.SleepResult.OTHER_PROBLEM;
            }
            if (this.field_145850_b.func_180494_b(new BlockPos(par1, par2, par3)) == Biomes.field_76778_j) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_HERE;
            }
            GCPlayerStats stats = GCPlayerStats.get((Entity)entityPlayer);
            if (stats.getCryogenicChamberCooldown() > 0) {
                return EntityPlayer.SleepResult.NOT_POSSIBLE_NOW;
            }
        }
        if (entityPlayer.func_184218_aH()) {
            entityPlayer.func_184210_p();
        }
        entityPlayer.func_70107_b((double)((float)this.func_174877_v().func_177958_n() + 0.5f), (double)((float)this.func_174877_v().func_177956_o() + 1.9f), (double)((float)this.func_174877_v().func_177952_p() + 0.5f));
        entityPlayer.field_71083_bS = true;
        entityPlayer.field_71076_b = 0;
        entityPlayer.field_71081_bT = new BlockPos(this.func_174877_v().func_177958_n(), this.func_174877_v().func_177956_o(), this.func_174877_v().func_177952_p());
        entityPlayer.field_70181_x = 0.0;
        entityPlayer.field_70179_y = 0.0;
        entityPlayer.field_70159_w = 0.0;
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_72854_c();
        }
        return EntityPlayer.SleepResult.OK;
    }

    public void func_73660_a() {
        if (!this.initialised) {
            this.initialised = this.initialiseMultiTiles(this.func_174877_v(), this.field_145850_b);
        }
    }

    public void onCreate(World world, BlockPos placedPosition) {
        this.mainBlockPosition = placedPosition;
        this.func_70296_d();
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(placedPosition, positions);
        ((BlockMulti)GCBlocks.fakeBlock).makeFakeBlock(world, positions, placedPosition, this.getMultiType());
    }

    public BlockMulti.EnumBlockMultiType getMultiType() {
        return BlockMulti.EnumBlockMultiType.CRYO_CHAMBER;
    }

    public void getPositions(BlockPos placedPosition, List<BlockPos> positions) {
        int buildHeight = this.field_145850_b.func_72800_K() - 1;
        for (int y = 1; y < 3; ++y) {
            if (placedPosition.func_177956_o() + y > buildHeight) {
                return;
            }
            positions.add(new BlockPos(placedPosition.func_177958_n(), placedPosition.func_177956_o() + y, placedPosition.func_177952_p()));
        }
    }

    public void onDestroy(TileEntity callingBlock) {
        BlockPos thisBlock = this.func_174877_v();
        LinkedList<BlockPos> positions = new LinkedList<BlockPos>();
        this.getPositions(thisBlock, positions);
        for (BlockPos pos : positions) {
            IBlockState stateAt = this.field_145850_b.func_180495_p(pos);
            if (stateAt.func_177230_c() != GCBlocks.fakeBlock || (BlockMulti.EnumBlockMultiType)stateAt.func_177229_b((IProperty)BlockMulti.MULTI_TYPE) != BlockMulti.EnumBlockMultiType.CRYO_CHAMBER) continue;
            if (this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextDouble() < 0.1) {
                FMLClientHandler.instance().getClient().field_71452_i.func_180533_a(pos, this.field_145850_b.func_180495_p(pos));
            }
            this.field_145850_b.func_175655_b(pos, false);
        }
        this.field_145850_b.func_175655_b(thisBlock, true);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isOccupied = nbt.func_74767_n("IsChamberOccupied");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74757_a("IsChamberOccupied", this.isOccupied);
        return nbt;
    }
}

