/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon;

import java.lang.reflect.Constructor;
import java.util.Random;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.DungeonConfigurationVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.DungeonStartVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.PieceVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.RoomBossVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.RoomChestVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.RoomEmptyVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.RoomSpawnerVenus;
import micdoodle8.mods.galacticraft.planets.venus.world.gen.dungeon.SizedPieceVenus;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.StructureBoundingBox;

public class CorridorVenus
extends SizedPieceVenus {
    public CorridorVenus() {
    }

    public CorridorVenus(DungeonConfigurationVenus configuration, Random rand, int blockPosX, int blockPosZ, int sizeX, int sizeY, int sizeZ, EnumFacing direction) {
        super(configuration, sizeX, sizeY, sizeZ, direction);
        this.func_186164_a(EnumFacing.SOUTH);
        this.field_74887_e = new StructureBoundingBox(blockPosX, configuration.getYPosition(), blockPosZ, blockPosX + sizeX, configuration.getYPosition() + sizeY, blockPosZ + sizeZ);
    }

    public boolean func_74875_a(World worldIn, Random randomIn, StructureBoundingBox structureBoundingBoxIn) {
        for (int i = 0; i < this.field_74887_e.func_78883_b(); ++i) {
            for (int j = 0; j < this.field_74887_e.func_78882_c(); ++j) {
                for (int k = 0; k < this.field_74887_e.func_78880_d(); ++k) {
                    DungeonConfigurationVenus venusConfig;
                    if (j == 2 && this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (k + 1) % 4 == 0 && k != this.field_74887_e.func_78880_d() - 1) {
                        if (i == 0 || i == this.field_74887_e.func_78883_b() - 1) {
                            this.func_175811_a(worldIn, Blocks.field_150353_l.func_176223_P(), i, j, k, this.field_74887_e);
                            continue;
                        }
                        if (i == 1 || i == this.field_74887_e.func_78883_b() - 2) {
                            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), i, j, k, this.field_74887_e);
                            continue;
                        }
                        this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if (j == 2 && this.getDirection().func_176740_k() == EnumFacing.Axis.X && (i + 1) % 4 == 0 && i != this.field_74887_e.func_78883_b() - 1) {
                        if (k == 0 || k == this.field_74887_e.func_78880_d() - 1) {
                            this.func_175811_a(worldIn, Blocks.field_150353_l.func_176223_P(), i, j, k, this.field_74887_e);
                            continue;
                        }
                        if (k == 1 || k == this.field_74887_e.func_78880_d() - 2) {
                            this.func_175811_a(worldIn, Blocks.field_150411_aY.func_176223_P(), i, j, k, this.field_74887_e);
                            continue;
                        }
                        this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (i == 1 || i == this.field_74887_e.func_78883_b() - 2) || j == 0 || j == this.field_74887_e.func_78882_c() - 1 || this.getDirection().func_176740_k() == EnumFacing.Axis.X && (k == 1 || k == this.field_74887_e.func_78880_d() - 2)) {
                        venusConfig = this.configuration;
                        this.func_175811_a(worldIn, j == 0 || j == this.field_74887_e.func_78882_c() - 1 ? venusConfig.getBrickBlockFloor() : this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    if (this.getDirection().func_176740_k() == EnumFacing.Axis.Z && (i == 0 || i == this.field_74887_e.func_78883_b() - 1) || this.getDirection().func_176740_k() == EnumFacing.Axis.X && (k == 0 || k == this.field_74887_e.func_78880_d() - 1)) {
                        venusConfig = this.configuration;
                        this.func_175811_a(worldIn, j == 0 || j == this.field_74887_e.func_78882_c() - 1 ? venusConfig.getBrickBlockFloor() : this.configuration.getBrickBlock(), i, j, k, this.field_74887_e);
                        continue;
                    }
                    this.func_175811_a(worldIn, Blocks.field_150350_a.func_176223_P(), i, j, k, this.field_74887_e);
                }
            }
        }
        return true;
    }

    private <T extends SizedPieceVenus> T getRoom(Class<?> clazz, DungeonStartVenus startPiece, Random rand) {
        try {
            Constructor<?> c0 = clazz.getConstructor(DungeonConfigurationVenus.class, Random.class, Integer.TYPE, Integer.TYPE, EnumFacing.class);
            SizedPieceVenus dummy = (SizedPieceVenus)((Object)c0.newInstance(new Object[]{this.configuration, rand, 0, 0, this.getDirection().func_176734_d()}));
            StructureBoundingBox extension = this.getExtension(this.getDirection(), this.getDirection().func_176740_k() == EnumFacing.Axis.X ? dummy.getSizeX() : dummy.getSizeZ(), this.getDirection().func_176740_k() == EnumFacing.Axis.X ? dummy.getSizeZ() : dummy.getSizeX());
            if (startPiece.checkIntersection(extension)) {
                return null;
            }
            int sizeX = extension.field_78893_d - extension.field_78897_a;
            int sizeZ = extension.field_78892_f - extension.field_78896_c;
            int sizeY = dummy.getSizeY();
            int blockX = extension.field_78897_a;
            int blockZ = extension.field_78896_c;
            Constructor<?> c1 = clazz.getConstructor(DungeonConfigurationVenus.class, Random.class, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, EnumFacing.class);
            return (T)((Object)((SizedPieceVenus)((Object)c1.newInstance(new Object[]{this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d()}))));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public PieceVenus getNextPiece(DungeonStartVenus startPiece, Random rand) {
        if (startPiece.attachedComponents.size() > 2 && startPiece.attachedComponents.get(startPiece.attachedComponents.size() - 2) instanceof RoomBossVenus) {
            try {
                return this.getRoom(this.configuration.getTreasureRoom(), startPiece, rand);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            boolean bossRoom;
            int bossRoomChance = Math.max((int)(1.0 / Math.pow((double)startPiece.attachedComponents.size() / 55.0, 2.0)), 5);
            boolean bl = bossRoom = rand.nextInt(bossRoomChance) == 0;
            if (bossRoom) {
                try {
                    return this.getRoom(this.configuration.getBossRoom(), startPiece, rand);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else {
                PieceVenus lastPiece;
                StructureBoundingBox extension = this.getExtension(this.getDirection(), rand.nextInt(4) + 6, rand.nextInt(4) + 6);
                if (startPiece.checkIntersection(extension)) {
                    return null;
                }
                int sizeX = extension.field_78893_d - extension.field_78897_a;
                int sizeZ = extension.field_78892_f - extension.field_78896_c;
                int sizeY = this.configuration.getRoomHeight();
                int blockX = extension.field_78897_a;
                int blockZ = extension.field_78896_c;
                if (Math.abs(startPiece.func_74874_b().field_78892_f - this.field_74887_e.field_78896_c) > 200) {
                    return null;
                }
                if (Math.abs(startPiece.func_74874_b().field_78893_d - this.field_74887_e.field_78897_a) > 200) {
                    return null;
                }
                PieceVenus pieceVenus = lastPiece = startPiece.attachedComponents.size() <= 2 ? null : (PieceVenus)startPiece.attachedComponents.get(startPiece.attachedComponents.size() - 2);
                if (!(lastPiece instanceof RoomSpawnerVenus)) {
                    return new RoomSpawnerVenus(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
                }
                if (rand.nextInt(2) == 0) {
                    return new RoomEmptyVenus(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
                }
                return new RoomChestVenus(this.configuration, rand, blockX, blockZ, sizeX, sizeY, sizeZ, this.getDirection().func_176734_d());
            }
        }
        return null;
    }
}

