/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.profile;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.swing.SwingUtilities;
import net.minecraft.launcher.Launcher;
import net.minecraft.launcher.authentication.AuthenticationDatabase;
import net.minecraft.launcher.events.RefreshedProfilesListener;
import net.minecraft.launcher.profile.Profile;
import net.minecraft.launcher.updater.DateTypeAdapter;
import net.minecraft.launcher.updater.FileTypeAdapter;
import net.minecraft.launcher.updater.LowerCaseEnumTypeAdapterFactory;
import org.apache.commons.io.FileUtils;

public class ProfileManager {
    public static final String DEFAULT_PROFILE_NAME = "(Default)";
    private final Launcher launcher;
    private final JsonParser parser = new JsonParser();
    private final Gson gson;
    private final Map<String, Profile> profiles = new HashMap<String, Profile>();
    private final File profileFile;
    private final List<RefreshedProfilesListener> refreshedProfilesListeners = Collections.synchronizedList(new ArrayList());
    private String selectedProfile;
    private AuthenticationDatabase authDatabase;

    public ProfileManager(Launcher launcher) {
        this.launcher = launcher;
        this.profileFile = new File(launcher.getWorkingDirectory(), "launcher_profiles.json");
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapterFactory(new LowerCaseEnumTypeAdapterFactory());
        builder.registerTypeAdapter((Type)((Object)Date.class), new DateTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)File.class), new FileTypeAdapter());
        builder.registerTypeAdapter((Type)((Object)AuthenticationDatabase.class), new AuthenticationDatabase.Serializer());
        builder.setPrettyPrinting();
        this.gson = builder.create();
        this.authDatabase = new AuthenticationDatabase(new YggdrasilAuthenticationService(launcher.getProxy(), launcher.getClientToken().toString()));
    }

    public void saveProfiles() throws IOException {
        RawProfileList rawProfileList = new RawProfileList();
        rawProfileList.profiles = this.profiles;
        rawProfileList.selectedProfile = this.getSelectedProfile().getName();
        rawProfileList.clientToken = this.launcher.getClientToken();
        rawProfileList.authenticationDatabase = this.authDatabase;
        FileUtils.writeStringToFile(this.profileFile, this.gson.toJson(rawProfileList));
    }

    public boolean loadProfiles() throws IOException {
        this.profiles.clear();
        this.selectedProfile = null;
        if (this.profileFile.isFile()) {
            JsonObject object = this.parser.parse(FileUtils.readFileToString(this.profileFile)).getAsJsonObject();
            if (object.has("clientToken")) {
                this.launcher.setClientToken(this.gson.fromJson(object.get("clientToken"), UUID.class));
            }
            RawProfileList rawProfileList = this.gson.fromJson((JsonElement)object, RawProfileList.class);
            this.profiles.putAll(rawProfileList.profiles);
            this.selectedProfile = rawProfileList.selectedProfile;
            this.authDatabase = rawProfileList.authenticationDatabase;
            this.fireRefreshEvent();
            return true;
        }
        this.fireRefreshEvent();
        return false;
    }

    public void fireRefreshEvent() {
        final ArrayList<RefreshedProfilesListener> listeners = new ArrayList<RefreshedProfilesListener>(this.refreshedProfilesListeners);
        Iterator iterator = listeners.iterator();
        while (iterator.hasNext()) {
            RefreshedProfilesListener listener = (RefreshedProfilesListener)iterator.next();
            if (listener.shouldReceiveEventsInUIThread()) continue;
            listener.onProfilesRefreshed(this);
            iterator.remove();
        }
        if (!listeners.isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    for (RefreshedProfilesListener listener : listeners) {
                        listener.onProfilesRefreshed(ProfileManager.this);
                    }
                }
            });
        }
    }

    public Profile getSelectedProfile() {
        if (this.selectedProfile == null || !this.profiles.containsKey(this.selectedProfile)) {
            if (this.profiles.get(DEFAULT_PROFILE_NAME) != null) {
                this.selectedProfile = DEFAULT_PROFILE_NAME;
            } else if (this.profiles.size() > 0) {
                this.selectedProfile = this.profiles.values().iterator().next().getName();
            } else {
                this.selectedProfile = DEFAULT_PROFILE_NAME;
                this.profiles.put(DEFAULT_PROFILE_NAME, new Profile(this.selectedProfile));
            }
        }
        return this.profiles.get(this.selectedProfile);
    }

    public Map<String, Profile> getProfiles() {
        return this.profiles;
    }

    public Launcher getLauncher() {
        return this.launcher;
    }

    public void addRefreshedProfilesListener(RefreshedProfilesListener listener) {
        this.refreshedProfilesListeners.add(listener);
    }

    public void setSelectedProfile(String selectedProfile) {
        boolean update = !this.selectedProfile.equals(selectedProfile);
        this.selectedProfile = selectedProfile;
        if (update) {
            this.fireRefreshEvent();
        }
    }

    public AuthenticationDatabase getAuthDatabase() {
        return this.authDatabase;
    }

    public void trimAuthDatabase() {
        HashSet<String> uuids = new HashSet<String>(this.authDatabase.getknownUUIDs());
        for (Profile profile : this.profiles.values()) {
            uuids.remove(profile.getPlayerUUID());
        }
        for (String uuid : uuids) {
            this.authDatabase.removeUUID(uuid);
        }
    }

    private static class RawProfileList {
        public Map<String, Profile> profiles = new HashMap<String, Profile>();
        public String selectedProfile;
        public UUID clientToken = UUID.randomUUID();
        public AuthenticationDatabase authenticationDatabase = new AuthenticationDatabase(new YggdrasilAuthenticationService(Launcher.getInstance().getProxy(), Launcher.getInstance().getClientToken().toString()));

        private RawProfileList() {
        }
    }
}

