/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.version;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerDateModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.minecraft.launcher.ui.popups.version.VersionEditorPopup;
import net.minecraft.launcher.versions.ReleaseType;

public class VersionInfoPanel
extends JPanel {
    private final VersionEditorPopup editor;
    private final JTextField versionName = new JTextField();
    private final JSpinner releaseTime = new JSpinner(new SpinnerDateModel());
    private final JButton resetReleaseTime = new JButton("Now");
    private final JSpinner updateTime = new JSpinner(new SpinnerDateModel());
    private final JButton resetUpdateTime = new JButton("Now");
    private final JComboBox releaseType = new JComboBox();

    public VersionInfoPanel(VersionEditorPopup editor) {
        this.editor = editor;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Version Info"));
        this.createInterface();
        this.fillDefaultValues();
        this.addEventHandlers();
    }

    protected void createInterface() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 17;
        constraints.gridy = 0;
        this.add((Component)new JLabel("Version ID:"), constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.add((Component)this.versionName, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridy;
        JPanel releaseDatePanel = new JPanel();
        releaseDatePanel.setLayout(new BoxLayout(releaseDatePanel, 0));
        this.releaseTime.setEditor(new JSpinner.DateEditor(this.releaseTime, "yyyy-MM-dd HH:mm:ss z"));
        releaseDatePanel.add(this.releaseTime);
        releaseDatePanel.add(Box.createHorizontalStrut(5));
        releaseDatePanel.add(this.resetReleaseTime);
        this.add((Component)new JLabel("Release Date:"), constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.add((Component)releaseDatePanel, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridy;
        JPanel updateTimePanel = new JPanel();
        updateTimePanel.setLayout(new BoxLayout(updateTimePanel, 0));
        this.updateTime.setEditor(new JSpinner.DateEditor(this.updateTime, "yyyy-MM-dd HH:mm:ss z"));
        updateTimePanel.add(this.updateTime);
        updateTimePanel.add(Box.createHorizontalStrut(5));
        updateTimePanel.add(this.resetUpdateTime);
        this.add((Component)new JLabel("Last Updated:"), constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.add((Component)updateTimePanel, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridy;
        this.add((Component)new JLabel("Release Type:"), constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.add((Component)this.releaseType, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridy;
        for (ReleaseType type : ReleaseType.values()) {
            this.releaseType.addItem(type);
        }
    }

    protected void fillDefaultValues() {
        this.versionName.setText(this.editor.getVersion().getId());
        this.releaseTime.setValue(this.editor.getVersion().getReleaseTime());
        this.updateTime.setValue(this.editor.getVersion().getUpdatedTime());
        this.releaseType.setSelectedItem((Object)this.editor.getVersion().getType());
    }

    protected void addEventHandlers() {
        this.versionName.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                VersionInfoPanel.this.updateVersionName();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VersionInfoPanel.this.updateVersionName();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VersionInfoPanel.this.updateVersionName();
            }
        });
        this.releaseTime.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VersionInfoPanel.this.editor.getVersion().setReleaseTime((Date)VersionInfoPanel.this.releaseTime.getValue());
            }
        });
        this.resetReleaseTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionInfoPanel.this.releaseTime.setValue(new Date());
            }
        });
        this.updateTime.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                VersionInfoPanel.this.editor.getVersion().setUpdatedTime((Date)VersionInfoPanel.this.updateTime.getValue());
            }
        });
        this.resetUpdateTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                VersionInfoPanel.this.updateTime.setValue(new Date());
            }
        });
        this.releaseType.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                VersionInfoPanel.this.editor.getVersion().setType((ReleaseType)((Object)VersionInfoPanel.this.releaseType.getSelectedItem()));
            }
        });
    }

    private void updateVersionName() {
        if (this.versionName.getText().length() > 0) {
            // empty if block
        }
    }
}

