/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.launcher.ui.popups.version;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.minecraft.launcher.ui.popups.version.VersionEditorPopup;

public class VersionLaunchInfoPanel
extends JPanel {
    private final VersionEditorPopup editor;
    private final JTextField mainClass = new JTextField();
    private final JTextField processArguments = new JTextField(50);

    public VersionLaunchInfoPanel(VersionEditorPopup editor) {
        this.editor = editor;
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder("Launch Environment"));
        this.createInterface();
        this.fillDefaultValues();
        this.addEventHandlers();
    }

    protected void createInterface() {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = new Insets(2, 2, 2, 2);
        constraints.anchor = 17;
        constraints.gridy = 0;
        this.add((Component)new JLabel("Main Class:"), constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.add((Component)this.mainClass, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridy;
        this.add((Component)new JLabel("Process Arguments:"), constraints);
        constraints.fill = 2;
        constraints.weightx = 1.0;
        this.add((Component)this.processArguments, constraints);
        constraints.weightx = 0.0;
        constraints.fill = 0;
        ++constraints.gridy;
    }

    protected void fillDefaultValues() {
        this.mainClass.setText(this.editor.getVersion().getMainClass());
        this.processArguments.setText(this.editor.getVersion().getMinecraftArguments());
    }

    protected void addEventHandlers() {
        this.mainClass.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                VersionLaunchInfoPanel.this.updateMainClass();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VersionLaunchInfoPanel.this.updateMainClass();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VersionLaunchInfoPanel.this.updateMainClass();
            }
        });
        this.processArguments.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                VersionLaunchInfoPanel.this.updateProcessArguments();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                VersionLaunchInfoPanel.this.updateProcessArguments();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                VersionLaunchInfoPanel.this.updateProcessArguments();
            }
        });
    }

    private void updateMainClass() {
        if (this.mainClass.getText().length() > 0) {
            this.editor.getVersion().setMainClass(this.mainClass.getText());
        }
    }

    private void updateProcessArguments() {
        this.editor.getVersion().setMinecraftArguments(this.processArguments.getText());
    }
}

