--[[
Name: LibBabble-DigSites-3.0
Revision: $Rev: 9 $
Maintainers: Myrroddin
Website: http://www.wowace.com/addons/libbabble-digsites-3-0/
Dependencies: None
License: MIT
]]

local MAJOR_VERSION = "LibBabble-DigSites-3.0"
local MINOR_VERSION = 90000 + tonumber(("$Rev: 9 $"):match("%d+"))

if not LibStub then error(MAJOR_VERSION .. " requires LibStub.") end
local lib = LibStub("LibBabble-3.0"):New(MAJOR_VERSION, MINOR_VERSION)
if not lib then return end

local GAME_LOCALE = GetLocale()

lib:SetBaseTranslations (
	{
	["A library to help with localization of Archeology dig sites"] = "A library to help with localization of Archeology dig sites",
	["Abyssal Sands Fossil Ridge"] = "Abyssal Sands Fossil Ridge",
	["Aerie Peak Digsite"] = "Aerie Peak Digsite",
	["Agol'watha Digsite"] = "Agol'watha Digsite",
	["Akhenet Fields Digsite"] = "Akhenet Fields Digsite",
	["Altar of Quetz'lun Digsite"] = "Altar of Quetz'lun Digsite",
	["Altar of Sseratus Digsite"] = "Altar of Sseratus Digsite",
	["Altar of Zul Digsite"] = "Altar of Zul Digsite",
	["Ancestral Grounds Digsite"] = "Ancestral Grounds Digsite",
	["Andorhal Fossil Bank"] = "Andorhal Fossil Bank",
	["Arklon Ruins Digsite"] = "Arklon Ruins Digsite",
	["Bael Modan Digsite"] = "Bael Modan Digsite",
	["Bal'lal Ruins Digsite"] = "Bal'lal Ruins Digsite",
	["Baleheim Digsite"] = "Baleheim Digsite",
	["Balia'mah Digsite"] = "Balia'mah Digsite",
	["Bleeding Hollow Ruins Digsite"] = "Bleeding Hollow Ruins Digsite",
	["Boha'mu Ruins Digsite"] = "Boha'mu Ruins Digsite",
	["Bone Wastes Digsite"] = "Bone Wastes Digsite",
	["Bonechewer Ruins Digsite"] = "Bonechewer Ruins Digsite",
	["Broken Commons Digsite"] = "Broken Commons Digsite",
	["Broken Pillar Digsite"] = "Broken Pillar Digsite",
	["Brunnhildar Village Digsite"] = "Brunnhildar Village Digsite",
	["Burning Blade Digsite"] = "Burning Blade Digsite",
	["Coilskar Point Digsite"] = "Coilskar Point Digsite",
	["Constellas Digsite"] = "Constellas Digsite",
	["Cursed Landing Digsite"] = "Cursed Landing Digsite",
	["Darkmist Digsite"] = "Darkmist Digsite",
	["Dire Maul Digsite"] = "Dire Maul Digsite",
	["Dragonmaw Fortress"] = "Dragonmaw Fortress",
	["Drakil'Jin Ruins Digsite"] = "Drakil'Jin Ruins Digsite",
	["Dreadmaul Fossil Field"] = "Dreadmaul Fossil Field",
	["Dun Garok Digsite"] = "Dun Garok Digsite",
	["Dunemaul Fossil Ridge"] = "Dunemaul Fossil Ridge",
	["Dunwald Ruins Digsite"] = "Dunwald Ruins Digsite",
	["East Auchindoun Digsite"] = "East Auchindoun Digsite",
	["Eastern Ruins of Thaurissan"] = "Eastern Ruins of Thaurissan",
	["Eastern Zul'Kunda Digsite"] = "Eastern Zul'Kunda Digsite",
	["Eastern Zul'Mamwe Digsite"] = "Eastern Zul'Mamwe Digsite",
	["Eastmoon Ruins Digsite"] = "Eastmoon Ruins Digsite",
	["Eclipse Point Digsite"] = "Eclipse Point Digsite",
	["En'kilah Digsite"] = "En'kilah Digsite",
	["Ethel Rethor Digsite"] = "Ethel Rethor Digsite",
	["Felstone Fossil Field"] = "Felstone Fossil Field",
	["Fields of Blood Fossil Bank"] = "Fields of Blood Fossil Bank",
	["Forest Song Digsite"] = "Forest Song Digsite",
	["Frostwhisper Gorge Digsite"] = "Frostwhisper Gorge Digsite",
	["Gjalerbron Digsite"] = "Gjalerbron Digsite",
	["Gor'gaz Outpost Digsite"] = "Gor'gaz Outpost Digsite",
	["Grangol'var Village Digsite"] = "Grangol'var Village Digsite",
	["Greenwarden's Fossil Bank"] = "Greenwarden's Fossil Bank",
	["Grim Batol Digsite"] = "Grim Batol Digsite",
	["Grimesilt Digsite"] = "Grimesilt Digsite",
	["Grimsilt Digsite"] = "Grimsilt Digsite",
	["Grove of Aessina Digsite"] = "Grove of Aessina Digsite",
	["Gurubashi Arena Digsite"] = "Gurubashi Arena Digsite",
	["Halaa Digsite"] = "Halaa Digsite",
	["Halgrind Digsite"] = "Halgrind Digsite",
	["Hammertoe's Digsite"] = "Hammertoe's Digsite",
	["Hellfire Basin Digsite"] = "Hellfire Basin Digsite",
	["Hellfire Citadel Digsite"] = "Hellfire Citadel Digsite",
	["Humboldt Conflagration Digsite"] = "Humboldt Conflagration Digsite",
	["Illidari Point Digsite"] = "Illidari Point Digsite",
	["Infectis Scar Fossil Field"] = "Infectis Scar Fossil Field",
	["Ironband's Excavation Site"] = "Ironband's Excavation Site",
	["Ironbeard's Tomb"] = "Ironbeard's Tomb",
	["Ironwood Digsite"] = "Ironwood Digsite",
	["Jaedenar Digsite"] = "Jaedenar Digsite",
	["Jintha'Alor Lower City Digsite"] = "Jintha'Alor Lower City Digsite",
	["Jintha'Alor Upper City Digsite"] = "Jintha'Alor Upper City Digsite",
	["Jotunheim Digsite"] = "Jotunheim Digsite",
	["Keset Pass Digsite"] = "Keset Pass Digsite",
	["Khartut's Tomb Digsite"] = "Khartut's Tomb Digsite",
	["Kodo Graveyard"] = "Kodo Graveyard",
	["Kolramas Digsite"] = "Kolramas Digsite",
	["Lake Kel'Theril Digsite"] = "Lake Kel'Theril Digsite",
	["Lakeridge Highway Fossil Bank"] = "Lakeridge Highway Fossil Bank",
	["Laughing Skull Digsite"] = "Laughing Skull Digsite",
	["Lower Lakkari Tar Pits"] = "Lower Lakkari Tar Pits",
	["Mannoroc Coven Digsite"] = "Mannoroc Coven Digsite",
	["Marshlands Fossil Bank"] = "Marshlands Fossil Bank",
	["Misty Reed Fossil Bank"] = "Misty Reed Fossil Bank",
	["Moonrest Gardens Digsite"] = "Moonrest Gardens Digsite",
	["Morlos'Aran Digsite"] = "Morlos'Aran Digsite",
	["Nazj'vel Digsite"] = "Nazj'vel Digsite",
	["Neferset Digsite"] = "Neferset Digsite",
	["Nek'mani Wellspring Digsite"] = "Nek'mani Wellspring Digsite",
	["Nifflevar Digsite"] = "Nifflevar Digsite",
	["Nightmare Scar Digsite"] = "Nightmare Scar Digsite",
	["Njorndar Village Digsite"] = "Njorndar Village Digsite",
	["North Isildien Digsite"] = "North Isildien Digsite",
	["Northridge Fossil Field"] = "Northridge Fossil Field",
	["Obelisk of the Stars Digsite"] = "Obelisk of the Stars Digsite",
	["Oneiros Digsite"] = "Oneiros Digsite",
	["Orsis Digsite"] = "Orsis Digsite",
	["Owl Wing Thicket Digsite"] = "Owl Wing Thicket Digsite",
	["Pit of Fiends Digsite"] = "Pit of Fiends Digsite",
	["Pit of Narjun Digsite"] = "Pit of Narjun Digsite",
	["Plaguewood Digsite"] = "Plaguewood Digsite",
	["Pyrox Flats Digsite"] = "Pyrox Flats Digsite",
	["Quagmire Fossil Field"] = "Quagmire Fossil Field",
	["Quel'Lithien Lodge Digsite"] = "Quel'Lithien Lodge Digsite",
	["Ravenwind Digsite"] = "Ravenwind Digsite",
	["Red Reaches Fossil Bank"] = "Red Reaches Fossil Bank",
	["Riplash Ruins Digsite"] = "Riplash Ruins Digsite",
	["River Delta Digsite"] = "River Delta Digsite",
	["Ruins of Aboraz"] = "Ruins of Aboraz",
	["Ruins of Ahmtul Digsite"] = "Ruins of Ahmtul Digsite",
	["Ruins of Ammon Digsite"] = "Ruins of Ammon Digsite",
	["Ruins of Arkkoran"] = "Ruins of Arkkoran",
	["Ruins of Baa'ri Digsite"] = "Ruins of Baa'ri Digsite",
	["Ruins of Eldarath"] = "Ruins of Eldarath",
	["Ruins of Eldre'Thar"] = "Ruins of Eldre'Thar",
	["Ruins of Enkaat Digsite"] = "Ruins of Enkaat Digsite",
	["Ruins of Farahlon Digsite"] = "Ruins of Farahlon Digsite",
	["Ruins of Jubuwal"] = "Ruins of Jubuwal",
	["Ruins of Khintaset Digsite"] = "Ruins of Khintaset Digsite",
	["Ruins of Lar'donir Digsite"] = "Ruins of Lar'donir Digsite",
	["Ruins of Ordil'Aran"] = "Ruins of Ordil'Aran",
	["Ruins of Shandaral Digsite"] = "Ruins of Shandaral Digsite",
	["Ruins of Stardust"] = "Ruins of Stardust",
	["Sahket Wastes Digsite"] = "Sahket Wastes Digsite",
	["Sanctuary of Malorne Digsite"] = "Sanctuary of Malorne Digsite",
	["Sands of Nasam"] = "Sands of Nasam",
	["Sargeron Digsite"] = "Sargeron Digsite",
	["Savage Coast Raptor Fields"] = "Savage Coast Raptor Fields",
	["Schnottz's Landing"] = "Schnottz's Landing",
	["Scorched Plain Digsite"] = "Scorched Plain Digsite",
	["Scourgeholme Digsite"] = "Scourgeholme Digsite",
	["Screaming Reaches Fossil Field"] = "Screaming Reaches Fossil Field",
	["Sha'naar Digsite"] = "Sha'naar Digsite",
	["Shadra'Alor Digsite"] = "Shadra'Alor Digsite",
	["Shield Hill Digsite"] = "Shield Hill Digsite",
	["Shrine of Goldrinn Digsite"] = "Shrine of Goldrinn Digsite",
	["Sifreldar Village Digsite"] = "Sifreldar Village Digsite",
	["Skorn Digsite"] = "Skorn Digsite",
	["Slitherblade Shore Digsite"] = "Slitherblade Shore Digsite",
	["Solarsal Digsite"] = "Solarsal Digsite",
	["South Isildien Digsite"] = "South Isildien Digsite",
	["Southmoon Ruins Digsite"] = "Southmoon Ruins Digsite",
	["Southshore Fossil Field"] = "Southshore Fossil Field",
	["Southwind Village Digsite"] = "Southwind Village Digsite",
	["Steps of Fate Digsite"] = "Steps of Fate Digsite",
	["Stonetalon Peak"] = "Stonetalon Peak",
	["Sunken Temple Digsite"] = "Sunken Temple Digsite",
	["Sunspring Post Digsite"] = "Sunspring Post Digsite",
	["Talramas Digsite"] = "Talramas Digsite",
	["Temple of Uldum Digsite"] = "Temple of Uldum Digsite",
	["Terror Run Fossil Field"] = "Terror Run Fossil Field",
	["Terror Wing Fossil Field"] = "Terror Wing Fossil Field",
	["Terrorweb Tunnel Digsite"] = "Terrorweb Tunnel Digsite",
	["Thandol Span"] = "Thandol Span",
	["Thoradin's Wall"] = "Thoradin's Wall",
	["Thundermar Ruins Digsite"] = "Thundermar Ruins Digsite",
	["Tomb of the Watchers Digsite"] = "Tomb of the Watchers Digsite",
	["Tombs of the Precursors Digsite"] = "Tombs of the Precursors Digsite",
	["Tuurem Digsite"] = "Tuurem Digsite",
	["Twilight Grove Digsite"] = "Twilight Grove Digsite",
	["Twin Spire Ruins Digsite"] = "Twin Spire Ruins Digsite",
	["Uldaman Entrance Digsite"] = "Uldaman Entrance Digsite",
	["Unearthed Grounds"] = "Unearthed Grounds",
	["Upper Lakkari Tar Pits"] = "Upper Lakkari Tar Pits",
	["Valkyrion Digsite"] = "Valkyrion Digsite",
	["Valley of Bones"] = "Valley of Bones",
	["Violet Stand Digsite"] = "Violet Stand Digsite",
	["Voldrune Digsite"] = "Voldrune Digsite",
	["Vul'Gol Fossil Bank"] = "Vul'Gol Fossil Bank",
	["Warden's Cage Digsite"] = "Warden's Cage Digsite",
	["West Auchindoun Digsite"] = "West Auchindoun Digsite",
	["Western Ruins of Thaurissan"] = "Western Ruins of Thaurissan",
	["Western Zul'Kunda Digsite"] = "Western Zul'Kunda Digsite",
	["Western Zul'Mamwe Digsite"] = "Western Zul'Mamwe Digsite",
	["Whelgar's Excavation Site"] = "Whelgar's Excavation Site",
	["Witherbark Digsite"] = "Witherbark Digsite",
	["Wyrmbog Fossil Field"] = "Wyrmbog Fossil Field",
	["Wyrmskull Digsite"] = "Wyrmskull Digsite",
	["Ymirheim Digsite"] = "Ymirheim Digsite",
	["Zeth'Gor Digsite"] = "Zeth'Gor Digsite",
	["Ziata'jai Digsite"] = "Ziata'jai Digsite",
	["Zim'Rhuk Digsite"] = "Zim'Rhuk Digsite",
	["Zol'Heb Digsite"] = "Zol'Heb Digsite",
	["Zoram Strand Digsite"] = "Zoram Strand Digsite",
	["Zul'Farrak Digsite"] = "Zul'Farrak Digsite",
	["Zul'Mashar Digsite"] = "Zul'Mashar Digsite",
}


	-- create the default strings for development copy so it doesn't error
	--[===[@debug@
	{
	["A library to help with localization of Archeology dig sites"] = "A library to help with localization of Archeology dig sites",
	["Abyssal Sands Fossil Ridge"] = "Abyssal Sands Fossil Ridge",
	["Aerie Peak Digsite"] = "Aerie Peak Digsite",
	["Agol'watha Digsite"] = "Agol'watha Digsite",
	["Akhenet Fields Digsite"] = "Akhenet Fields Digsite",
	["Altar of Quetz'lun Digsite"] = "Altar of Quetz'lun Digsite",
	["Altar of Sseratus Digsite"] = "Altar of Sseratus Digsite",
	["Altar of Zul Digsite"] = "Altar of Zul Digsite",
	["Ancestral Grounds Digsite"] = "Ancestral Grounds Digsite",
	["Andorhal Fossil Bank"] = "Andorhal Fossil Bank",
	["Arklon Ruins Digsite"] = "Arklon Ruins Digsite",
	["Bael Modan Digsite"] = "Bael Modan Digsite",
	["Bal'lal Ruins Digsite"] = "Bal'lal Ruins Digsite",
	["Baleheim Digsite"] = "Baleheim Digsite",
	["Balia'mah Digsite"] = "Balia'mah Digsite",
	["Bleeding Hollow Ruins Digsite"] = "Bleeding Hollow Ruins Digsite",
	["Boha'mu Ruins Digsite"] = "Boha'mu Ruins Digsite",
	["Bone Wastes Digsite"] = "Bone Wastes Digsite",
	["Bonechewer Ruins Digsite"] = "Bonechewer Ruins Digsite",
	["Broken Commons Digsite"] = "Broken Commons Digsite",
	["Broken Pillar Digsite"] = "Broken Pillar Digsite",
	["Brunnhildar Village Digsite"] = "Brunnhildar Village Digsite",
	["Burning Blade Digsite"] = "Burning Blade Digsite",
	["Coilskar Point Digsite"] = "Coilskar Point Digsite",
	["Constellas Digsite"] = "Constellas Digsite",
	["Cursed Landing Digsite"] = "Cursed Landing Digsite",
	["Darkmist Digsite"] = "Darkmist Digsite",
	["Dire Maul Digsite"] = "Dire Maul Digsite",
	["Dragonmaw Fortress"] = "Dragonmaw Fortress",
	["Drakil'Jin Ruins Digsite"] = "Drakil'Jin Ruins Digsite",
	["Dreadmaul Fossil Field"] = "Dreadmaul Fossil Field",
	["Dun Garok Digsite"] = "Dun Garok Digsite",
	["Dunemaul Fossil Ridge"] = "Dunemaul Fossil Ridge",
	["Dunwald Ruins Digsite"] = "Dunwald Ruins Digsite",
	["East Auchindoun Digsite"] = "East Auchindoun Digsite",
	["Eastern Ruins of Thaurissan"] = "Eastern Ruins of Thaurissan",
	["Eastern Zul'Kunda Digsite"] = "Eastern Zul'Kunda Digsite",
	["Eastern Zul'Mamwe Digsite"] = "Eastern Zul'Mamwe Digsite",
	["Eastmoon Ruins Digsite"] = "Eastmoon Ruins Digsite",
	["Eclipse Point Digsite"] = "Eclipse Point Digsite",
	["En'kilah Digsite"] = "En'kilah Digsite",
	["Ethel Rethor Digsite"] = "Ethel Rethor Digsite",
	["Felstone Fossil Field"] = "Felstone Fossil Field",
	["Fields of Blood Fossil Bank"] = "Fields of Blood Fossil Bank",
	["Forest Song Digsite"] = "Forest Song Digsite",
	["Frostwhisper Gorge Digsite"] = "Frostwhisper Gorge Digsite",
	["Gjalerbron Digsite"] = "Gjalerbron Digsite",
	["Gor'gaz Outpost Digsite"] = "Gor'gaz Outpost Digsite",
	["Grangol'var Village Digsite"] = "Grangol'var Village Digsite",
	["Greenwarden's Fossil Bank"] = "Greenwarden's Fossil Bank",
	["Grim Batol Digsite"] = "Grim Batol Digsite",
	["Grimsilt Digsite"] = "Grimsilt Digsite",
	["Grimesilt Digsite"] = "Grimesilt Digsite",
	["Grove of Aessina Digsite"] = "Grove of Aessina Digsite",
	["Gurubashi Arena Digsite"] = "Gurubashi Arena Digsite",
	["Halaa Digsite"] = "Halaa Digsite",
	["Halgrind Digsite"] = "Halgrind Digsite",
	["Hammertoe's Digsite"] = "Hammertoe's Digsite",
	["Hellfire Basin Digsite"] = "Hellfire Basin Digsite",
	["Hellfire Citadel Digsite"] = "Hellfire Citadel Digsite",
	["Humboldt Conflagration Digsite"] = "Humboldt Conflagration Digsite",
	["Illidari Point Digsite"] = "Illidari Point Digsite",
	["Infectis Scar Fossil Field"] = "Infectis Scar Fossil Field",
	["Ironband's Excavation Site"] = "Ironband's Excavation Site",
	["Ironbeard's Tomb"] = "Ironbeard's Tomb",
	["Ironwood Digsite"] = "Ironwood Digsite",
	["Jaedenar Digsite"] = "Jaedenar Digsite",
	["Jintha'Alor Lower City Digsite"] = "Jintha'Alor Lower City Digsite",
	["Jintha'Alor Upper City Digsite"] = "Jintha'Alor Upper City Digsite",
	["Jotunheim Digsite"] = "Jotunheim Digsite",
	["Keset Pass Digsite"] = "Keset Pass Digsite",
	["Khartut's Tomb Digsite"] = "Khartut's Tomb Digsite",
	["Kodo Graveyard"] = "Kodo Graveyard",
	["Kolramas Digsite"] = "Kolramas Digsite",
	["Lake Kel'Theril Digsite"] = "Lake Kel'Theril Digsite",
	["Lakeridge Highway Fossil Bank"] = "Lakeridge Highway Fossil Bank",
	["Laughing Skull Digsite"] = "Laughing Skull Digsite",
	["Lower Lakkari Tar Pits"] = "Lower Lakkari Tar Pits",
	["Mannoroc Coven Digsite"] = "Mannoroc Coven Digsite",
	["Marshlands Fossil Bank"] = "Marshlands Fossil Bank",
	["Misty Reed Fossil Bank"] = "Misty Reed Fossil Bank",
	["Moonrest Gardens Digsite"] = "Moonrest Gardens Digsite",
	["Morlos'Aran Digsite"] = "Morlos'Aran Digsite",
	["Nazj'vel Digsite"] = "Nazj'vel Digsite",
	["Neferset Digsite"] = "Neferset Digsite",
	["Nek'mani Wellspring Digsite"] = "Nek'mani Wellspring Digsite",
	["Nifflevar Digsite"] = "Nifflevar Digsite",
	["Nightmare Scar Digsite"] = "Nightmare Scar Digsite",
	["Njorndar Village Digsite"] = "Njorndar Village Digsite",
	["North Isildien Digsite"] = "North Isildien Digsite",
	["Northridge Fossil Field"] = "Northridge Fossil Field",
	["Obelisk of the Stars Digsite"] = "Obelisk of the Stars Digsite",
	["Oneiros Digsite"] = "Oneiros Digsite",
	["Orsis Digsite"] = "Orsis Digsite",
	["Owl Wing Thicket Digsite"] = "Owl Wing Thicket Digsite",
	["Pit of Fiends Digsite"] = "Pit of Fiends Digsite",
	["Pit of Narjun Digsite"] = "Pit of Narjun Digsite",
	["Plaguewood Digsite"] = "Plaguewood Digsite",
	["Pyrox Flats Digsite"] = "Pyrox Flats Digsite",
	["Quagmire Fossil Field"] = "Quagmire Fossil Field",
	["Quel'Lithien Lodge Digsite"] = "Quel'Lithien Lodge Digsite",
	["Ravenwind Digsite"] = "Ravenwind Digsite",
	["Red Reaches Fossil Bank"] = "Red Reaches Fossil Bank",
	["Riplash Ruins Digsite"] = "Riplash Ruins Digsite",
	["River Delta Digsite"] = "River Delta Digsite",
	["Ruins of Aboraz"] = "Ruins of Aboraz",
	["Ruins of Ahmtul Digsite"] = "Ruins of Ahmtul Digsite",
	["Ruins of Ammon Digsite"] = "Ruins of Ammon Digsite",
	["Ruins of Arkkoran"] = "Ruins of Arkkoran",
	["Ruins of Baa'ri Digsite"] = "Ruins of Baa'ri Digsite",
	["Ruins of Eldarath"] = "Ruins of Eldarath",
	["Ruins of Eldre'Thar"] = "Ruins of Eldre'Thar",
	["Ruins of Enkaat Digsite"] = "Ruins of Enkaat Digsite",
	["Ruins of Farahlon Digsite"] = "Ruins of Farahlon Digsite",
	["Ruins of Jubuwal"] = "Ruins of Jubuwal",
	["Ruins of Khintaset Digsite"] = "Ruins of Khintaset Digsite",
	["Ruins of Lar'donir Digsite"] = "Ruins of Lar'donir Digsite",
	["Ruins of Ordil'Aran"] = "Ruins of Ordil'Aran",
	["Ruins of Shandaral Digsite"] = "Ruins of Shandaral Digsite",
	["Ruins of Stardust"] = "Ruins of Stardust",
	["Sahket Wastes Digsite"] = "Sahket Wastes Digsite",
	["Sanctuary of Malorne Digsite"] = "Sanctuary of Malorne Digsite",
	["Sands of Nasam"] = "Sands of Nasam",
	["Sargeron Digsite"] = "Sargeron Digsite",
	["Savage Coast Raptor Fields"] = "Savage Coast Raptor Fields",
	["Schnottz's Landing"] = "Schnottz's Landing",
	["Scorched Plain Digsite"] = "Scorched Plain Digsite",
	["Scourgeholme Digsite"] = "Scourgeholme Digsite",
	["Screaming Reaches Fossil Field"] = "Screaming Reaches Fossil Field",
	["Sha'naar Digsite"] = "Sha'naar Digsite",
	["Shadra'Alor Digsite"] = "Shadra'Alor Digsite",
	["Shield Hill Digsite"] = "Shield Hill Digsite",
	["Shrine of Goldrinn Digsite"] = "Shrine of Goldrinn Digsite",
	["Sifreldar Village Digsite"] = "Sifreldar Village Digsite",
	["Skorn Digsite"] = "Skorn Digsite",
	["Slitherblade Shore Digsite"] = "Slitherblade Shore Digsite",
	["Solarsal Digsite"] = "Solarsal Digsite",
	["South Isildien Digsite"] = "South Isildien Digsite",
	["Southmoon Ruins Digsite"] = "Southmoon Ruins Digsite",
	["Southshore Fossil Field"] = "Southshore Fossil Field",
	["Southwind Village Digsite"] = "Southwind Village Digsite",
	["Steps of Fate Digsite"] = "Steps of Fate Digsite",
	["Stonetalon Peak"] = "Stonetalon Peak",
	["Sunken Temple Digsite"] = "Sunken Temple Digsite",
	["Sunspring Post Digsite"] = "Sunspring Post Digsite",
	["Talramas Digsite"] = "Talramas Digsite",
	["Temple of Uldum Digsite"] = "Temple of Uldum Digsite",
	["Terror Run Fossil Field"] = "Terror Run Fossil Field",
	["Terror Wing Fossil Field"] = "Terror Wing Fossil Field",
	["Terrorweb Tunnel Digsite"] = "Terrorweb Tunnel Digsite",
	["Thandol Span"] = "Thandol Span",
	["Thoradin's Wall"] = "Thoradin's Wall",
	["Thundermar Ruins Digsite"] = "Thundermar Ruins Digsite",
	["Tomb of the Watchers Digsite"] = "Tomb of the Watchers Digsite",
	["Tombs of the Precursors Digsite"] = "Tombs of the Precursors Digsite",
	["Tuurem Digsite"] = "Tuurem Digsite",
	["Twilight Grove Digsite"] = "Twilight Grove Digsite",
	["Twin Spire Ruins Digsite"] = "Twin Spire Ruins Digsite",
	["Uldaman Entrance Digsite"] = "Uldaman Entrance Digsite",
	["Unearthed Grounds"] = "Unearthed Grounds",
	["Upper Lakkari Tar Pits"] = "Upper Lakkari Tar Pits",
	["Valkyrion Digsite"] = "Valkyrion Digsite",
	["Valley of Bones"] = "Valley of Bones",
	["Violet Stand Digsite"] = "Violet Stand Digsite",
	["Voldrune Digsite"] = "Voldrune Digsite",
	["Vul'Gol Fossil Bank"] = "Vul'Gol Fossil Bank",
	["Warden's Cage Digsite"] = "Warden's Cage Digsite",
	["West Auchindoun Digsite"] = "West Auchindoun Digsite",
	["Western Ruins of Thaurissan"] = "Western Ruins of Thaurissan",
	["Western Zul'Kunda Digsite"] = "Western Zul'Kunda Digsite",
	["Western Zul'Mamwe Digsite"] = "Western Zul'Mamwe Digsite",
	["Whelgar's Excavation Site"] = "Whelgar's Excavation Site",
	["Witherbark Digsite"] = "Witherbark Digsite",
	["Wyrmbog Fossil Field"] = "Wyrmbog Fossil Field",
	["Wyrmskull Digsite"] = "Wyrmskull Digsite",
	["Ymirheim Digsite"] = "Ymirheim Digsite",
	["Zeth'Gor Digsite"] = "Zeth'Gor Digsite",
	["Ziata'jai Digsite"] = "Ziata'jai Digsite",
	["Zim'Rhuk Digsite"] = "Zim'Rhuk Digsite",
	["Zol'Heb Digsite"] = "Zol'Heb Digsite",
	["Zoram Strand Digsite"] = "Zoram Strand Digsite",
	["Zul'Farrak Digsite"] = "Zul'Farrak Digsite",
	["Zul'Mashar Digsite"] = "Zul'Mashar Digsite",
	}
	--@end-debug@]===]
)

if GAME_LOCALE == "enUS" then
	lib:SetCurrentTranslations(true)

elseif GAME_LOCALE == "deDE" then
	lib:SetCurrentTranslations (
	{
	["A library to help with localization of Archeology dig sites"] = [=[Eine Bibliothek um bei der Lokalisierung von Archäologie Grabungsstätten zu helfen
]=], -- Needs review
	["Abyssal Sands Fossil Ridge"] = "Fossilienkamm der Ewigen Sande", -- Needs review
	["Aerie Peak Digsite"] = "Ausgrabungsstätte des Nistgipfels",
	["Agol'watha Digsite"] = "Ausgrabungsstätte von Agol'watha",
	["Akhenet Fields Digsite"] = "Ausgrabungsstätte der Felder von Akhenet",
	["Altar of Quetz'lun Digsite"] = "Ausgrabungsstätte am Altar von Quetz'lun",
	["Altar of Sseratus Digsite"] = "Ausgrabungsstätte am Altar von Sseratus",
	["Altar of Zul Digsite"] = "Ausgrabungsstätte am Altar von Zul", -- Needs review
	["Ancestral Grounds Digsite"] = "Ausgrabungsstätte des Ahnengrunds",
	["Andorhal Fossil Bank"] = "Fossilienbank von Andorhal", -- Needs review
	["Arklon Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Arklon",
	["Bael Modan Digsite"] = "Ausgrabungsstätte von Bael Modan",
	["Bal'lal Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Bal'lal", -- Needs review
	["Baleheim Digsite"] = "Ausgrabungsstätte Quälheim",
	["Balia'mah Digsite"] = "Ausgrabungsstätte von Balia'mah", -- Needs review
	["Bleeding Hollow Ruins Digsite"] = "Ausgrabungsstätte der Ruinen des Blutenden Auges",
	["Boha'mu Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Boha'mu",
	["Bone Wastes Digsite"] = "Ausgrabungsstätte der Knochenwüste",
	["Bonechewer Ruins Digsite"] = "Ausgrabungsstätte der Ruinen der Knochenmalmer",
	["Broken Commons Digsite"] = "Ausgrabungsstätte der Zerstörten Allmende",
	["Broken Pillar Digsite"] = "Ausgrabungsstätte der Zerbrochenen Säule",
	["Brunnhildar Village Digsite"] = "Ausgrabungsstätte von Brunnhildar",
	["Burning Blade Digsite"] = "Ausgrabungsstätte der Brennenden Klinge",
	["Coilskar Point Digsite"] = "Ausgrabungsstätte der Echsennarbe",
	["Constellas Digsite"] = "Ausgrabungsstätte von Constellas",
	["Cursed Landing Digsite"] = "Ausgrabungsstätte am Verfluchten Landeplatz",
	["Darkmist Digsite"] = "Ausgrabungsstätte bei Graunebel",
	["Dire Maul Digsite"] = "Ausgrabungsstätte des Düsterbruchs",
	["Dragonmaw Fortress"] = "Festung des Drachenmals",
	["Drakil'Jin Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Drakil'jin",
	["Dreadmaul Fossil Field"] = "Fossilienfeld am Schreckensfelsen", -- Needs review
	["Dun Garok Digsite"] = "Ausgrabungsstätte von Dun Garok", -- Needs review
	["Dunemaul Fossil Ridge"] = "Fossilienkamm der Dünenbrecher",
	["Dunwald Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Dunwald", -- Needs review
	["East Auchindoun Digsite"] = "Östliche Ausgrabungsstätte von Auchindoun",
	["Eastern Ruins of Thaurissan"] = "Östliche Ruinen von Thaurissan", -- Needs review
	["Eastern Zul'Kunda Digsite"] = "Östliche Ausgrabungsstätte von Zul'Kunda", -- Needs review
	["Eastern Zul'Mamwe Digsite"] = "Östliche Ausgrabungsstätte von Zul'Mamwe", -- Needs review
	["Eastmoon Ruins Digsite"] = "Ausgrabungsstätte der Ostmondruinen",
	["Eclipse Point Digsite"] = "Ausgrabungsstätte der Stätte der Mondfinsternis",
	["En'kilah Digsite"] = "Ausgrabungsstätte von En'kilah",
	["Ethel Rethor Digsite"] = "Ausgrabungsstätte von Ethel Rethor", -- Needs review
	["Felstone Fossil Field"] = "Teufelssteinfossilienfeld", -- Needs review
	["Fields of Blood Fossil Bank"] = "Fossilienbank der Felder des Blutes", -- Needs review
	["Forest Song Digsite"] = "Ausgrabungsstätte von Waldeslied", -- Needs review
	["Frostwhisper Gorge Digsite"] = "Ausgrabungsstätte der Frosthauchschlucht", -- Needs review
	["Gjalerbron Digsite"] = "Ausgrabungsstätte von Gjalerbron",
	["Gor'gaz Outpost Digsite"] = "Ausgrabungsstätte des Außenpostens von Gor'gaz",
	["Grangol'var Village Digsite"] = "Ausgrabungsstätte von Grangol'var",
	["Greenwarden's Fossil Bank"] = "Fossilienbank des Grünen Gürtels", -- Needs review
	["Grim Batol Digsite"] = "Ausgrabungsstätte von Grim Batol", -- Needs review
	["Grimesilt Digsite"] = "Grimmsilts Ausgrabungsstätte", -- Needs review
	["Grimsilt Digsite"] = "Grimsilt Digsite", -- Requires localization
	["Grove of Aessina Digsite"] = "Ausgrabungsstätte des Hains von Aessina", -- Needs review
	["Gurubashi Arena Digsite"] = "Ausgrabungsstätte an der Arena der Gurubashiarena", -- Needs review
	["Halaa Digsite"] = "Ausgrabungsstätte von Haala",
	["Halgrind Digsite"] = "Ausgrabungsstätte von Halgrind",
	["Hammertoe's Digsite"] = "Hammerzehs Grabungsstätte", -- Needs review
	["Hellfire Basin Digsite"] = "Ausgrabungsstätte des Höllenfeuerbecken",
	["Hellfire Citadel Digsite"] = "Ausgrabungsstätte der Höllenfeuerzitadelle",
	["Humboldt Conflagration Digsite"] = "Ausgrabungsstätte der Humboldtfeuersbrunst", -- Needs review
	["Illidari Point Digsite"] = "Ausgrabungsstätte der Stätte der Illidari",
	["Infectis Scar Fossil Field"] = "Fossilienfeld der Infektnarbe", -- Needs review
	["Ironband's Excavation Site"] = "Eisenbands Ausgrabungsstätte", -- Needs review
	["Ironbeard's Tomb"] = "Eisenbarts Grabmal", -- Needs review
	["Ironwood Digsite"] = "Ausgrabungsstätte des Eisenwaldes", -- Needs review
	["Jaedenar Digsite"] = "Ausgrabungsstätte von Jaedenar", -- Needs review
	["Jintha'Alor Lower City Digsite"] = "Ausgrabungsstätte des unteren Viertels von Jintha'Alor", -- Needs review
	["Jintha'Alor Upper City Digsite"] = "Ausgrabungsstätte des oberen Viertels von Jintha'Alor", -- Needs review
	["Jotunheim Digsite"] = "Ausgrabungsstätte von Jotunheim",
	["Keset Pass Digsite"] = "Ausgrabungsstätte am Kesetpass", -- Needs review
	["Khartut's Tomb Digsite"] = "Ausgrabungsstätte des Grabs des Khartut", -- Needs review
	["Kodo Graveyard"] = "Kodofriedhof", -- Needs review
	["Kolramas Digsite"] = "Ausgrabungsstätte von Kolramas",
	["Lake Kel'Theril Digsite"] = "Ausgrabungsstätte des Kel'Therilsees", -- Needs review
	["Lakeridge Highway Fossil Bank"] = "Fossilienbank am Uferpfad", -- Needs review
	["Laughing Skull Digsite"] = "Ausgrabungsstätte des Lachenden Schädels",
	["Lower Lakkari Tar Pits"] = "Untere Teergruben von Lakkari", -- Needs review
	["Mannoroc Coven Digsite"] = "Ausgrabungsstätte am Zirkel der Mannoroc", -- Needs review
	["Marshlands Fossil Bank"] = "Fossilienbank der Marschen", -- Needs review
	["Misty Reed Fossil Bank"] = "Fossilienbank am Nebelschilfstrand", -- Needs review
	["Moonrest Gardens Digsite"] = "Ausgrabungsstätte der Mondruhgärten",
	["Morlos'Aran Digsite"] = "Ausgrabungsstätte von Morlos'Aran", -- Needs review
	["Nazj'vel Digsite"] = "Ausgrabungsstätte von Nazj'vel", -- Needs review
	["Neferset Digsite"] = "Ausgrabungsstätte von Neferset", -- Needs review
	["Nek'mani Wellspring Digsite"] = "Ausgrabungsstätte am Nek'maniquellbrunnen", -- Needs review
	["Nifflevar Digsite"] = "Ausgrabungsstätte von Nifflevar",
	["Nightmare Scar Digsite"] = "Ausgrabungsstätte der Alptraumnarbe", -- Needs review
	["Njorndar Village Digsite"] = "Ausgrabungsstätte von Njorndar",
	["North Isildien Digsite"] = "Ausgrabungsstätte von Nordisildien", -- Needs review
	["Northridge Fossil Field"] = "Fossilienfeld am Nordkamm", -- Needs review
	["Obelisk of the Stars Digsite"] = "Ausgrabungsstätte am Obelisken der Sterne", -- Needs review
	["Oneiros Digsite"] = "Ausgrabungsstätte von Oneiros", -- Needs review
	["Orsis Digsite"] = "Ausgrabungsstätte von Orsis", -- Needs review
	["Owl Wing Thicket Digsite"] = "Ausgrabungsstätte des Eulenflügeldickichts", -- Needs review
	["Pit of Fiends Digsite"] = "Ausgrabungsstätte der Schreckensgrube", -- Needs review
	["Pit of Narjun Digsite"] = "Ausgrabungsstätte der Grube von Narjun",
	["Plaguewood Digsite"] = "Ausgrabungsstätte des Pestwaldes", -- Needs review
	["Pyrox Flats Digsite"] = "Ausgrabungsstätte der Pyroxebenen", -- Needs review
	["Quagmire Fossil Field"] = "Fossilienfeld im Morast", -- Needs review
	["Quel'Lithien Lodge Digsite"] = "Ausgrabungsstätte bei der Jagdhütte Quel'Lithien", -- Needs review
	["Ravenwind Digsite"] = "Ausgrabungsstätte von Rabenwind", -- Needs review
	["Red Reaches Fossil Bank"] = "Fossilienbank der Roten Weiten", -- Needs review
	["Riplash Ruins Digsite"] = "Ausgrabungsstätte der Ruinen der Peitschennarbe",
	["River Delta Digsite"] = "Ausgrabungsstätte am Flussdelta", -- Needs review
	["Ruins of Aboraz"] = "Ruinen von Aboraz", -- Needs review
	["Ruins of Ahmtul Digsite"] = "Ausgrabungsstätte der Ruinen von Ahmtul", -- Needs review
	["Ruins of Ammon Digsite"] = "Ausgrabungsstätte der Ruinen von Ammon", -- Needs review
	["Ruins of Arkkoran"] = "Ruinen von Arkkoran", -- Needs review
	["Ruins of Baa'ri Digsite"] = "Ausgrabungsstätte der Ruinen von Baa'ri",
	["Ruins of Eldarath"] = "Ruinen von Eldarath", -- Needs review
	["Ruins of Eldre'Thar"] = "Ruinen von Eldre'Thar", -- Needs review
	["Ruins of Enkaat Digsite"] = "Ausgrabungsstätte der Ruinen von Enkaat",
	["Ruins of Farahlon Digsite"] = "Ausgrabungsstätte der Ruinen von Farahlon",
	["Ruins of Jubuwal"] = "Ruinen von Jubuwal", -- Needs review
	["Ruins of Khintaset Digsite"] = "Ausgrabungsstätte der Ruinen von Khintaset", -- Needs review
	["Ruins of Lar'donir Digsite"] = "Ausgrabungsstätte der Ruinen von Lar'donir", -- Needs review
	["Ruins of Ordil'Aran"] = "Ruinen von Ordil'Aran", -- Needs review
	["Ruins of Shandaral Digsite"] = "Ausgrabungsstätte der Ruinen von Shandaral",
	["Ruins of Stardust"] = "Sternenstaubruinen", -- Needs review
	["Sahket Wastes Digsite"] = "Ausgrabungsstätte der Sahketwüste", -- Needs review
	["Sanctuary of Malorne Digsite"] = "Ausgrabungsstätte des Heiligtums von Malorne", -- Needs review
	["Sands of Nasam"] = "Sande von Nasam",
	["Sargeron Digsite"] = "Ausgrabungsstätte von Sargeron", -- Needs review
	["Savage Coast Raptor Fields"] = "Raptorfelder der Ungezähmten Küste", -- Needs review
	["Schnottz's Landing"] = "Grabungsstätte bei Schnottz' Landeplatz", -- Needs review
	["Scorched Plain Digsite"] = "Ausgrabungsstätte der Verbrannten Ebene", -- Needs review
	["Scourgeholme Digsite"] = "Ausgrabungsstätte von Geißelholme",
	["Screaming Reaches Fossil Field"] = "Fossilienfelder der Schreienden Weiten",
	["Sha'naar Digsite"] = "Ausgrabungsstätte von Sha'naar",
	["Shadra'Alor Digsite"] = "Ausgrabungsstätte von Shadra'Alor", -- Needs review
	["Shield Hill Digsite"] = "Ausgrabungsstätte des Schildhügels",
	["Shrine of Goldrinn Digsite"] = "Ausgrabungsstätte des Schrein von Goldrinn",
	["Sifreldar Village Digsite"] = "Ausgrabungsstätte von Sifreldar",
	["Skorn Digsite"] = "Ausgrabungsstätte von Skorn",
	["Slitherblade Shore Digsite"] = "Ausgrabungsstätte am Strand der Zackenkämme",
	["Solarsal Digsite"] = "Ausgrabungsstätte von Solarsal",
	["South Isildien Digsite"] = "Ausgrabungsstätte von Südisildien",
	["Southmoon Ruins Digsite"] = "Ausgrabungsstätte der Südmondruinen",
	["Southshore Fossil Field"] = "Fossilienfeld von Süderstade", -- Needs review
	["Southwind Village Digsite"] = "Ausgrabungsstätte des Südwindpostens",
	["Steps of Fate Digsite"] = "Ausgrabungsstätte der Schicksalsstiege",
	["Stonetalon Peak"] = "Steinkrallengipfel",
	["Sunken Temple Digsite"] = "Ausgrabungsstätte des Versunkenen Tempels", -- Needs review
	["Sunspring Post Digsite"] = "Ausgrabungsstätte des Sonnenwindpostens",
	["Talramas Digsite"] = "Ausgrabungsstätte von Talramas",
	["Temple of Uldum Digsite"] = "Ausgrabungsstätte des Tempels von Uldum",
	["Terror Run Fossil Field"] = "Fossilienfeld der Terrorflucht",
	["Terror Wing Fossil Field"] = "Fossilienfeld am Schreckenspfad", -- Needs review
	["Terrorweb Tunnel Digsite"] = "Ausgrabungsstätte des Schreckenstunnels", -- Needs review
	["Thandol Span"] = "Thandolübergang", -- Needs review
	["Thoradin's Wall"] = "Thoradinswall", -- Needs review
	["Thundermar Ruins Digsite"] = "Ausgrabungsstätte der Ruinen von Donnermar", -- Needs review
	["Tomb of the Watchers Digsite"] = "Ausgrabungsstätte am Grab der Behüter", -- Needs review
	["Tombs of the Precursors Digsite"] = "Ausgrabungsstätte der Gräber der Wegbereiter",
	["Tuurem Digsite"] = "Ausgrabungsstätte von Tuurem",
	["Twilight Grove Digsite"] = "Ausgrabungsstätte am Zwielichtshain", -- Needs review
	["Twin Spire Ruins Digsite"] = "Ausgrabungsstätte der Ruinen der Zwillingsspitze",
	["Uldaman Entrance Digsite"] = "Ausgrabungsstätte am Eingang nach Uldaman", -- Needs review
	["Unearthed Grounds"] = "Die Grabstätte",
	["Upper Lakkari Tar Pits"] = "Obere Teergruben von Lakkari",
	["Valkyrion Digsite"] = "Ausgrabungsstätte von Valkyrion",
	["Valley of Bones"] = "Tal der Knochen",
	["Violet Stand Digsite"] = "Ausgrabungsstätte der Violetten Wacht",
	["Voldrune Digsite"] = "Ausgrabungsstätte von Voldrune",
	["Vul'Gol Fossil Bank"] = "Fossilienbank von Vul'Gol", -- Needs review
	["Warden's Cage Digsite"] = "Ausgrabungsstätte des Kerkers des Wächters",
	["West Auchindoun Digsite"] = "Westliche Ausgrabungsstätte von Auchindoun",
	["Western Ruins of Thaurissan"] = "Westliche Ruinen von Thaurissan", -- Needs review
	["Western Zul'Kunda Digsite"] = "Westliche Ausgrabungsstätte von Zul'Kunda", -- Needs review
	["Western Zul'Mamwe Digsite"] = "Westliche Ausgrabungsstätte von Zul'Mamwe", -- Needs review
	["Whelgar's Excavation Site"] = "Whelgars Ausgrabungsstätte", -- Needs review
	["Witherbark Digsite"] = "Ausgrabungsstätte der Bleichborken", -- Needs review
	["Wyrmbog Fossil Field"] = "Fossilienfeld des Drachensumpfes",
	["Wyrmskull Digsite"] = "Ausgrabungsstätte von Wyrmskol",
	["Ymirheim Digsite"] = "Ausgrabungsstätte von Ymirheim",
	["Zeth'Gor Digsite"] = "Ausgrabungsstätte von Zeth'Gor",
	["Ziata'jai Digsite"] = "Ausgrabungsstätte von Ziata'jai", -- Needs review
	["Zim'Rhuk Digsite"] = "Ausgrabungsstätte von Zim'Rhuk",
	["Zol'Heb Digsite"] = "Ausgrabungsstätte von Zol'Heb",
	["Zoram Strand Digsite"] = "Ausgrabungsstätte am Zoramstrand",
	["Zul'Farrak Digsite"] = "Ausgrabungsstätte von Zul'Farrak",
	["Zul'Mashar Digsite"] = "Ausgrabungsstätte von Zul'Mashar", -- Needs review
}

)

elseif GAME_LOCALE == "frFR" then
	lib:SetCurrentTranslations (
	{
	["A library to help with localization of Archeology dig sites"] = "Une librairie pour aider à la traduction des sites de fouilles archéologiques",
	["Abyssal Sands Fossil Ridge"] = "Crête de fossiles du désert Abysséen",
	["Aerie Peak Digsite"] = "Site de fouilles de Nid-de-l'Aigle",
	["Agol'watha Digsite"] = "Site de fouilles d'Agol'watha",
	["Akhenet Fields Digsite"] = "Site de fouilles des champs d'Akhenet",
	["Altar of Quetz'lun Digsite"] = "Site de fouilles de l'autel de Quetz'lun",
	["Altar of Sseratus Digsite"] = "Site de fouilles de l'autel de Sseratus",
	["Altar of Zul Digsite"] = "Site de fouilles de l'autel de Zul",
	["Ancestral Grounds Digsite"] = "Site de fouilles des terres Ancestrales",
	["Andorhal Fossil Bank"] = "Banc de fossiles d'Andorhal",
	["Arklon Ruins Digsite"] = "Site de fouilles des ruines Arklon",
	["Bael Modan Digsite"] = "Site de fouilles de Bael Modan",
	["Bal'lal Ruins Digsite"] = "Site de fouilles des ruines de Bal'lal",
	["Baleheim Digsite"] = "Site de fouilles de Torvheim",
	["Balia'mah Digsite"] = "Site de fouilles de Balia'mah",
	["Bleeding Hollow Ruins Digsite"] = "Site de fouilles des ruines de l'Orbite sanglante",
	["Boha'mu Ruins Digsite"] = "Site de fouilles des ruines de Boha'mu",
	["Bone Wastes Digsite"] = "Site de fouilles du désert des Ossements",
	["Bonechewer Ruins Digsite"] = "Site de fouilles des ruines Mâche-les-os",
	["Broken Commons Digsite"] = "Site de fouilles des communs en ruine",
	["Broken Pillar Digsite"] = "Site de fouilles du pilier brisé",
	["Brunnhildar Village Digsite"] = "Site de fouilles de Brunnhildar",
	["Burning Blade Digsite"] = "Site de fouilles de la Lame ardente",
	["Coilskar Point Digsite"] = "Site de fouilles de la halte de Glissentaille",
	["Constellas Digsite"] = "Site de fouilles de Constellas",
	["Cursed Landing Digsite"] = "Site de fouilles de l'accostage Maudit",
	["Darkmist Digsite"] = "Site de fouilles de Sombrebrume",
	["Dire Maul Digsite"] = "Site de fouilles de Hache-Tripes",
	["Dragonmaw Fortress"] = "Forteresse Gueule-de-dragon",
	["Drakil'Jin Ruins Digsite"] = "Site de fouilles des ruines de Drakil'Jin",
	["Dreadmaul Fossil Field"] = "Champ de fossiles Cognepeur",
	["Dun Garok Digsite"] = "Site de fouilles de Dun Garok",
	["Dunemaul Fossil Ridge"] = "Crête de fossiles des Cognedunes",
	["Dunwald Ruins Digsite"] = "Site de fouilles des ruines de Dunwald",
	["East Auchindoun Digsite"] = "Site de fouilles d'Auchindoun est",
	["Eastern Ruins of Thaurissan"] = "Ruines est de Thaurissan",
	["Eastern Zul'Kunda Digsite"] = "Site de fouilles de Zul'Kunda est",
	["Eastern Zul'Mamwe Digsite"] = "Site de fouilles de Zul'Mamwe est",
	["Eastmoon Ruins Digsite"] = "Site de fouilles des ruines d'Estelune",
	["Eclipse Point Digsite"] = "Site de fouilles de la halte de l'Éclipse",
	["En'kilah Digsite"] = "Site de fouilles d'En'kilah",
	["Ethel Rethor Digsite"] = "Site de fouilles d'Ethel Rethor",
	["Felstone Fossil Field"] = "Champ de fossiles de Gangrepierre",
	["Fields of Blood Fossil Bank"] = "Banc de fossiles des champs du Sang",
	["Forest Song Digsite"] = "Site de fouilles de Chant des forêts",
	["Frostwhisper Gorge Digsite"] = "Site de fouilles du Blanc murmure",
	["Gjalerbron Digsite"] = "Site de fouilles de Gjalerbron",
	["Gor'gaz Outpost Digsite"] = "Site de fouilles de l'avant-poste de Gor'gaz",
	["Grangol'var Village Digsite"] = "Site de fouilles de Grangol'var",
	["Greenwarden's Fossil Bank"] = "Banc de fossiles du Gardien vert",
	["Grim Batol Digsite"] = "Site de fouilles de Grim Batol",
	["Grimesilt Digsite"] = "Site de fouilles de Crasseboue",
	["Grimsilt Digsite"] = "Grimsilt Digsite", -- Requires localization
	["Grove of Aessina Digsite"] = "Site de fouilles du bosquet d'Aessina",
	["Gurubashi Arena Digsite"] = "Site de fouilles de l'arène des Gurubashi",
	["Halaa Digsite"] = "Site de fouilles d'Halaa",
	["Halgrind Digsite"] = "Site de fouilles de Halegrince",
	["Hammertoe's Digsite"] = "Site de fouilles de Martèlorteil",
	["Hellfire Basin Digsite"] = "Site de fouilles du bassin des Flammes infernales",
	["Hellfire Citadel Digsite"] = "Site de fouilles de la citadelle Flammes infernales",
	["Humboldt Conflagration Digsite"] = "Site de fouilles de la déflagration de Humboldt",
	["Illidari Point Digsite"] = "Site de fouilles de la halte Illidari",
	["Infectis Scar Fossil Field"] = "Champ de fossiles de la Balafre infecte",
	["Ironband's Excavation Site"] = "Excavations de Baguefer",
	["Ironbeard's Tomb"] = "Tombe de Barbe-de-fer",
	["Ironwood Digsite"] = "Site de fouilles bois-de-fer",
	["Jaedenar Digsite"] = "Site de fouilles de Jaedenar",
	["Jintha'Alor Lower City Digsite"] = "Site de fouilles de la ville basse de Jinth'Alor",
	["Jintha'Alor Upper City Digsite"] = "Site de fouilles de la ville haute de Jinth'Alor",
	["Jotunheim Digsite"] = "Site de fouilles de Jotunheim",
	["Keset Pass Digsite"] = "Site de fouilles de la passe de Keset",
	["Khartut's Tomb Digsite"] = "Site de fouilles de la tombe de Khartut",
	["Kodo Graveyard"] = "Cimetière des Kodos",
	["Kolramas Digsite"] = "Site de fouilles de Kolramas",
	["Lake Kel'Theril Digsite"] = "Site de fouilles du lac Kel'Theril",
	["Lakeridge Highway Fossil Bank"] = "Banc de fossiles de la grand-route de la crête du Lac",
	["Laughing Skull Digsite"] = "Site de fouilles des ruines du Crâne ricanant",
	["Lower Lakkari Tar Pits"] = "Fosses de goudron de Lakkari inférieures",
	["Mannoroc Coven Digsite"] = "Site de fouilles du convent de Mannoroc",
	["Marshlands Fossil Bank"] = "Banc de fossiles de la Fondrière",
	["Misty Reed Fossil Bank"] = "Banc de fossiles de Brumejonc",
	["Moonrest Gardens Digsite"] = "Site de fouilles des jardins de Repos-de-Lune",
	["Morlos'Aran Digsite"] = "Site de fouilles de Morlos'Aran",
	["Nazj'vel Digsite"] = "Site de fouilles Nazj'vel",
	["Neferset Digsite"] = "Site de fouilles de Neferset",
	["Nek'mani Wellspring Digsite"] = "Site de fouilles de la fontaine des Nek'mani",
	["Nifflevar Digsite"] = "Site de fouilles de Nifflevar",
	["Nightmare Scar Digsite"] = "Site de fouilles de la balafre du Cauchemar",
	["Njorndar Village Digsite"] = "Site de fouilles de Njorndar",
	["North Isildien Digsite"] = "Site de fouilles d'Isildien nord",
	["Northridge Fossil Field"] = "Champ de fossiles de la crête du Nord",
	["Obelisk of the Stars Digsite"] = "Site de fouilles de l'obélisque des Étoiles",
	["Oneiros Digsite"] = "Site de fouilles d'Oneiros",
	["Orsis Digsite"] = "Site de fouilles d'Orsis",
	["Owl Wing Thicket Digsite"] = "Site de fouilles du fourré de l'Aile de la chouette",
	["Pit of Fiends Digsite"] = "Site de fouilles de la fosse aux Démons",
	["Pit of Narjun Digsite"] = "Site de fouilles de la fosse de Narjun",
	["Plaguewood Digsite"] = "Site de fouilles de Pestebois",
	["Pyrox Flats Digsite"] = "Site de fouilles de la plaine de Pyrox",
	["Quagmire Fossil Field"] = "Champ de fossiles du Bourbier",
	["Quel'Lithien Lodge Digsite"] = "Site de fouilles du gîte de Quel'Lithien",
	["Ravenwind Digsite"] = "Site de fouilles de Vent-du-Corbeau",
	["Red Reaches Fossil Bank"] = "Banc de fossiles des confins Rouges",
	["Riplash Ruins Digsite"] = "Site de fouilles des ruines des Courcinglants",
	["River Delta Digsite"] = "Site de fouilles du delta du fleuve",
	["Ruins of Aboraz"] = "Ruines d'Aboraz",
	["Ruins of Ahmtul Digsite"] = "Site de fouilles des ruines d'Ahmtul",
	["Ruins of Ammon Digsite"] = "Site de fouilles des ruines d'Ammon",
	["Ruins of Arkkoran"] = "Ruines d'Arkkoran",
	["Ruins of Baa'ri Digsite"] = "Site de fouilles des ruines de Baa'ri",
	["Ruins of Eldarath"] = "Ruines d'Eldarath",
	["Ruins of Eldre'Thar"] = "Ruines d'Eldre'Thar",
	["Ruins of Enkaat Digsite"] = "Site de fouilles des ruines d'Enkaat",
	["Ruins of Farahlon Digsite"] = "Site de fouilles des ruines de Farahlon",
	["Ruins of Jubuwal"] = "Ruines de Jubuwal",
	["Ruins of Khintaset Digsite"] = "Site de fouilles des ruines de Khintaset",
	["Ruins of Lar'donir Digsite"] = "Site de fouilles des ruines de Lar'donir",
	["Ruins of Ordil'Aran"] = "Ruines d'Ordil'Aran",
	["Ruins of Shandaral Digsite"] = "Site de fouilles des ruines de Shandaral",
	["Ruins of Stardust"] = "Ruines de Chimétoile",
	["Sahket Wastes Digsite"] = "Site de fouilles du désert de Sahket",
	["Sanctuary of Malorne Digsite"] = "Site de fouilles du sanctuaire de Malorne",
	["Sands of Nasam"] = "Sables de Nasam",
	["Sargeron Digsite"] = "Site de fouilles de Sargeron",
	["Savage Coast Raptor Fields"] = "Champs de raptors de la côte Sauvage",
	["Schnottz's Landing"] = "Accostage de Schnottz",
	["Scorched Plain Digsite"] = "Site de fouilles de la plaine Incendiée",
	["Scourgeholme Digsite"] = "Site de fouilles de Fléaulme",
	["Screaming Reaches Fossil Field"] = "Champ de fossile des confins Hurlants",
	["Sha'naar Digsite"] = "Site de fouilles de Sha'naar",
	["Shadra'Alor Digsite"] = "Site de fouilles de Shadra'Alor",
	["Shield Hill Digsite"] = "Site de fouilles de la colline du Bouclier",
	["Shrine of Goldrinn Digsite"] = "Site de fouilles du sanctuaire de Goldrinn",
	["Sifreldar Village Digsite"] = "Site de fouilles de Sifreldar",
	["Skorn Digsite"] = "Site de fouilles de Skorn",
	["Slitherblade Shore Digsite"] = "Site de fouilles du rivage des Ondulames",
	["Solarsal Digsite"] = "Site de fouilles de Solarsal",
	["South Isildien Digsite"] = "Site de fouilles d'Isildien sud",
	["Southmoon Ruins Digsite"] = "Site de fouilles des ruines de Sudelune",
	["Southshore Fossil Field"] = "Champ de fossiles d'Austrivage",
	["Southwind Village Digsite"] = "Site de fouilles de Sudevent",
	["Steps of Fate Digsite"] = "Site de fouilles des marches du Destin",
	["Stonetalon Peak"] = "Pic des Serres-Rocheuses",
	["Sunken Temple Digsite"] = "Site de fouilles du temple Englouti",
	["Sunspring Post Digsite"] = "Site de fouilles du poste de Berceau-de-l'Été",
	["Talramas Digsite"] = "Site de fouilles de Talramas",
	["Temple of Uldum Digsite"] = "Site de fouilles du temple d'Uldum",
	["Terror Run Fossil Field"] = "Champ de fossiles des coteaux de la Terreur",
	["Terror Wing Fossil Field"] = "Champ de fossiles de l'Aile de la terreur",
	["Terrorweb Tunnel Digsite"] = "Site de fouilles du tunnel de Tisse-terreur",
	["Thandol Span"] = "Viaduc de Thandol",
	["Thoradin's Wall"] = "Mur de Thoradin",
	["Thundermar Ruins Digsite"] = "Site de fouilles des ruines de Tonnemar",
	["Tomb of the Watchers Digsite"] = "Site de fouilles du tombeau des Gardiens",
	["Tombs of the Precursors Digsite"] = "Site de fouilles des tombes des Précurseurs",
	["Tuurem Digsite"] = "Site de fouilles de Tuurem",
	["Twilight Grove Digsite"] = "Site de fouilles du bosquet Crépusculaire",
	["Twin Spire Ruins Digsite"] = "Site de fouilles des ruines des Flèches jumelles",
	["Uldaman Entrance Digsite"] = "Site de fouilles de l'entrée d'Uldaman",
	["Unearthed Grounds"] = "Terres Exhumées",
	["Upper Lakkari Tar Pits"] = "Fosses de goudron de Lakkari supérieures",
	["Valkyrion Digsite"] = "Site de fouilles de Valkyrion",
	["Valley of Bones"] = "Vallée des Ossements",
	["Violet Stand Digsite"] = "Site de fouilles du séjour Pourpre",
	["Voldrune Digsite"] = "Site de fouilles de Voldrune",
	["Vul'Gol Fossil Bank"] = "Banc de fossiles de Vul'Gol",
	["Warden's Cage Digsite"] = "Site de fouilles de la Cage de la gardienne",
	["West Auchindoun Digsite"] = "Site de fouilles d'Auchindoun ouest",
	["Western Ruins of Thaurissan"] = "Ruines de Thaurissan ouest",
	["Western Zul'Kunda Digsite"] = "Site de fouilles de Zul'Kunda ouest",
	["Western Zul'Mamwe Digsite"] = "Site de fouilles de Zul'Mamwe ouest",
	["Whelgar's Excavation Site"] = "Excavations de Whelgar",
	["Witherbark Digsite"] = "Site de fouilles de Fanécorce",
	["Wyrmbog Fossil Field"] = "Champ de fossiles de Tourbière du Ver",
	["Wyrmskull Digsite"] = "Site de fouilles de Crâne-du-ver",
	["Ymirheim Digsite"] = "Site de fouilles d'Ymirheim",
	["Zeth'Gor Digsite"] = "Site de fouilles de Zeth'Gor",
	["Ziata'jai Digsite"] = "Site de fouilles de Ziata'jai",
	["Zim'Rhuk Digsite"] = "Site de fouilles de Zim'Rhuk",
	["Zol'Heb Digsite"] = "Site de fouilles de Zol'Heb",
	["Zoram Strand Digsite"] = "Site de fouilles de la grève de Zoram",
	["Zul'Farrak Digsite"] = "Site de fouilles de Zul'Farrak",
	["Zul'Mashar Digsite"] = "Site de fouilles de Zul'Mashar",
}

)

elseif GAME_LOCALE == "koKR" then
	lib:SetCurrentTranslations (
	{
	["A library to help with localization of Archeology dig sites"] = "도서관은 고고학의 발굴 사이트의 지방화에 도움이", -- Needs review
	["Abyssal Sands Fossil Ridge"] = "끝없는 사막 화석 마루",
	["Aerie Peak Digsite"] = "맹금의 봉우리 발굴현장",
	["Agol'watha Digsite"] = "아골와타 발굴현장",
	["Akhenet Fields Digsite"] = "아케네트 농장 발굴현장",
	["Altar of Quetz'lun Digsite"] = "쿠에츠룬의 제단 발굴현장",
	["Altar of Sseratus Digsite"] = "세라투스의 제단 발굴현장",
	["Altar of Zul Digsite"] = "줄의 제단 발굴현장",
	["Ancestral Grounds Digsite"] = "선조의 터 발굴현장",
	["Andorhal Fossil Bank"] = "안돌할 화석 강둑",
	["Arklon Ruins Digsite"] = "알클론 폐허 발굴현장",
	["Bael Modan Digsite"] = "바엘 모단 발굴현장",
	["Bal'lal Ruins Digsite"] = "발랄 폐허 발굴현장",
	["Baleheim Digsite"] = "베일하임 발굴현장",
	["Balia'mah Digsite"] = "발리아마 발굴현장",
	["Bleeding Hollow Ruins Digsite"] = "피눈물 폐허 발굴현장",
	["Boha'mu Ruins Digsite"] = "보하무 폐허 발굴현장",
	["Bone Wastes Digsite"] = "해골 무덤 발굴현장",
	["Bonechewer Ruins Digsite"] = "해골이빨 폐허 발굴현장",
	["Broken Commons Digsite"] = "파괴된 광장 발굴현장",
	["Broken Pillar Digsite"] = "무너진 기둥 발굴현장",
	["Brunnhildar Village Digsite"] = "브룬힐다르 마을 발굴현장",
	["Burning Blade Digsite"] = "불타는 칼날단 발굴현장",
	["Coilskar Point Digsite"] = "갈퀴흉터 거점 발굴현장",
	["Constellas Digsite"] = "콘스텔라스 발굴현장",
	["Cursed Landing Digsite"] = "저주받은 선착장 발굴현장",
	["Darkmist Digsite"] = "암흑안개 발굴현장",
	["Dire Maul Digsite"] = "혈투의 전장 발굴현장",
	["Dragonmaw Fortress"] = "용아귀 요새",
	["Drakil'Jin Ruins Digsite"] = "드라킬진 폐허 발굴현장", -- Needs review
	["Dreadmaul Fossil Field"] = "우레망치 화석 벌판",
	["Dun Garok Digsite"] = "던 가록 발굴현장",
	["Dunemaul Fossil Ridge"] = "모래망치 화석 마루",
	["Dunwald Ruins Digsite"] = "둔왈트 폐허 발굴현장",
	["East Auchindoun Digsite"] = "아킨둔 동부 발굴현장",
	["Eastern Ruins of Thaurissan"] = "타우릿산의 폐허 동부",
	["Eastern Zul'Kunda Digsite"] = "동부 줄쿤다 발굴현장",
	["Eastern Zul'Mamwe Digsite"] = "동부 줄맘웨 발굴현장",
	["Eastmoon Ruins Digsite"] = "동쪽 달 폐허 발굴현장",
	["Eclipse Point Digsite"] = "해그늘 주둔지 발굴현장",
	["En'kilah Digsite"] = "엔킬라 발굴현장",
	["Ethel Rethor Digsite"] = "에텔 레소르 발굴현장",
	["Felstone Fossil Field"] = "펠스톤 화석 벌판",
	["Fields of Blood Fossil Bank"] = "피의 들판 화석 강둑",
	["Forest Song Digsite"] = "숲의 노래 발굴현장",
	["Frostwhisper Gorge Digsite"] = "서리속삭임 골짜기 발굴현장",
	["Gjalerbron Digsite"] = "샬레르브론 발굴현장",
	["Gor'gaz Outpost Digsite"] = "고르가즈 전초기지 발굴현장",
	["Grangol'var Village Digsite"] = "그란골바르 마을 발굴현장",
	["Greenwarden's Fossil Bank"] = "신록수호자의 화석 강둑",
	["Grim Batol Digsite"] = "그림 바톨 발굴현장",
	["Grimesilt Digsite"] = "검댕가루 발굴현", -- Needs review
	["Grimsilt Digsite"] = "Grimsilt Digsite", -- Requires localization
	["Grove of Aessina Digsite"] = "아에시나의 숲 발굴현장",
	["Gurubashi Arena Digsite"] = "구루바시 투기장 발굴현장",
	["Halaa Digsite"] = "할라아 발굴현장",
	["Halgrind Digsite"] = "할그린드 발굴현장",
	["Hammertoe's Digsite"] = "해머토의 발굴현장",
	["Hellfire Basin Digsite"] = "지옥불 분지 발굴현장",
	["Hellfire Citadel Digsite"] = "지옥불 성채 발굴현장",
	["Humboldt Conflagration Digsite"] = "훔볼트 불자리 발굴현장",
	["Illidari Point Digsite"] = "일리다리 거점 발굴현장",
	["Infectis Scar Fossil Field"] = "오염의 흉터 화석 벌판",
	["Ironband's Excavation Site"] = "아이언밴드의 발굴현장",
	["Ironbeard's Tomb"] = "아이언비어드의 고분",
	["Ironwood Digsite"] = "강철나무 발굴현장",
	["Jaedenar Digsite"] = "제데나르 발굴현장",
	["Jintha'Alor Lower City Digsite"] = "진타알로 하층부 발굴현장",
	["Jintha'Alor Upper City Digsite"] = "진타알로 상층부 발굴현장",
	["Jotunheim Digsite"] = "요툰하임 발굴현장",
	["Keset Pass Digsite"] = "케세트 고개 발굴현장",
	["Khartut's Tomb Digsite"] = "카르투트의 무덤 발굴현장",
	["Kodo Graveyard"] = "코도 무덤",
	["Kolramas Digsite"] = "콜라마스 발굴현장",
	["Lake Kel'Theril Digsite"] = "켈테릴 호수 발굴현장",
	["Lakeridge Highway Fossil Bank"] = "호수마루 오솔길 화석 강둑",
	["Laughing Skull Digsite"] = "웃는 해골 발굴현장",
	["Lower Lakkari Tar Pits"] = "락카리 잿구덩이 하층",
	["Mannoroc Coven Digsite"] = "만노로크 소굴 발굴현장",
	["Marshlands Fossil Bank"] = "늪지대 화석 강둑",
	["Misty Reed Fossil Bank"] = "안개갈대 화석 강둑",
	["Moonrest Gardens Digsite"] = "달쉼터 정원 발굴현장",
	["Morlos'Aran Digsite"] = "모를로스아란 발굴현장",
	["Nazj'vel Digsite"] = "나즈벨 발굴현장",
	["Neferset Digsite"] = "네페르세트 발굴현장",
	["Nek'mani Wellspring Digsite"] = "네크마니 수원지 발굴현장",
	["Nifflevar Digsite"] = "니플바르 발굴현장",
	["Nightmare Scar Digsite"] = "악몽의 흉터 발굴현장",
	["Njorndar Village Digsite"] = "요른다르 마을 발굴현장",
	["North Isildien Digsite"] = "이실디엔 북부 발굴현장",
	["Northridge Fossil Field"] = "북마루 화석 벌판",
	["Obelisk of the Stars Digsite"] = "별의 방첨탑 발굴현장",
	["Oneiros Digsite"] = "오네이로스 발굴현장",
	["Orsis Digsite"] = "오르시스 발굴현장",
	["Owl Wing Thicket Digsite"] = "올빼미날개 숲 발굴현장",
	["Pit of Fiends Digsite"] = "악마의 구덩이 발굴현장",
	["Pit of Narjun Digsite"] = "나르준의 구덩이 발굴현장",
	["Plaguewood Digsite"] = "역병숲 발굴현장",
	["Pyrox Flats Digsite"] = "휘석 평원 발굴현장",
	["Quagmire Fossil Field"] = "먼지 수렁 화석 벌판",
	["Quel'Lithien Lodge Digsite"] = "쿠엘리시엔 오두막 발굴현장",
	["Ravenwind Digsite"] = "까마귀바람 발굴현장",
	["Red Reaches Fossil Bank"] = "붉은 굽이 화석 강둑",
	["Riplash Ruins Digsite"] = "채찍파도 폐허 발굴현장",
	["River Delta Digsite"] = "강 삼각주 발굴현장",
	["Ruins of Aboraz"] = "아보라즈의 폐허",
	["Ruins of Ahmtul Digsite"] = "암툴 폐허",
	["Ruins of Ammon Digsite"] = "암몬 폐허 발굴현장",
	["Ruins of Arkkoran"] = "아크코란의 폐허",
	["Ruins of Baa'ri Digsite"] = "바아리 폐허 발굴현장",
	["Ruins of Eldarath"] = "엘다라스 폐허",
	["Ruins of Eldre'Thar"] = "엘드레타르 폐허",
	["Ruins of Enkaat Digsite"] = "엔카트 폐허 발굴현장",
	["Ruins of Farahlon Digsite"] = "파랄론 폐허 발굴현장",
	["Ruins of Jubuwal"] = "주부왈의 폐허",
	["Ruins of Khintaset Digsite"] = "킨타세트 폐허 발굴현장",
	["Ruins of Lar'donir Digsite"] = "라르도니르 폐허 발굴현장",
	["Ruins of Ordil'Aran"] = "오르딜아란의 폐허",
	["Ruins of Shandaral Digsite"] = "샨다랄 폐허 발굴현장",
	["Ruins of Stardust"] = "별가루의 폐허",
	["Sahket Wastes Digsite"] = "사케트 황무지 발굴현장",
	["Sanctuary of Malorne Digsite"] = "말로른의 성역 발굴현장",
	["Sands of Nasam"] = "나삼의 갯벌",
	["Sargeron Digsite"] = "살게론 발굴현장",
	["Savage Coast Raptor Fields"] = "폭풍 해안 랩터 벌판",
	["Schnottz's Landing"] = "슈노츠 비행기지",
	["Scorched Plain Digsite"] = "불타버린 평원 발굴현장",
	["Scourgeholme Digsite"] = "스컬지홀름 발굴현장",
	["Screaming Reaches Fossil Field"] = "비명굽이 산마루 화석 벌판",
	["Sha'naar Digsite"] = "샤나르 발굴현장",
	["Shadra'Alor Digsite"] = "샤드라알로 발굴현장",
	["Shield Hill Digsite"] = "방패 언덕 발굴현장",
	["Shrine of Goldrinn Digsite"] = "골드린의 제단 발굴현장",
	["Sifreldar Village Digsite"] = "시프렐다르 마을 발굴현장",
	["Skorn Digsite"] = "스코른 발굴현장",
	["Slitherblade Shore Digsite"] = "뱀갈퀴 해안 발굴현장",
	["Solarsal Digsite"] = "솔라살 발굴현장",
	["South Isildien Digsite"] = "이실디엔 남부 발굴현장",
	["Southmoon Ruins Digsite"] = "남쪽 달 폐허 발굴현장",
	["Southshore Fossil Field"] = "남녘해안 화석 벌판",
	["Southwind Village Digsite"] = "마파람 마을 발굴현장",
	["Steps of Fate Digsite"] = "운명의 계단 발굴현장",
	["Stonetalon Peak"] = "돌발톱 봉우리",
	["Sunken Temple Digsite"] = "가라앉은 사원 발굴현장",
	["Sunspring Post Digsite"] = "태양여울 주둔지 발굴현장",
	["Talramas Digsite"] = "탈라마스 발굴현장",
	["Temple of Uldum Digsite"] = "울둠 사원 발굴현장",
	["Terror Run Fossil Field"] = "공포의 터 화석 벌판",
	["Terror Wing Fossil Field"] = "공포의 날개 화석 벌판",
	["Terrorweb Tunnel Digsite"] = "공포의 거미굴 발굴현장",
	["Thandol Span"] = "탄돌 교각",
	["Thoradin's Wall"] = "소라딘의 성벽",
	["Thundermar Ruins Digsite"] = "썬더마 폐허 발굴현장",
	["Tomb of the Watchers Digsite"] = "감시자의 무덤 발굴현장",
	["Tombs of the Precursors Digsite"] = "선도자의 무덤 발굴현장",
	["Tuurem Digsite"] = "투렘 발굴현장",
	["Twilight Grove Digsite"] = "황혼의 숲 발굴현장",
	["Twin Spire Ruins Digsite"] = "쌍둥이 첨탑 폐허 발굴현장",
	["Uldaman Entrance Digsite"] = "울다만 입구 발굴현장",
	["Unearthed Grounds"] = "발굴된 땅",
	["Upper Lakkari Tar Pits"] = "락카리 잿구덩이 상층",
	["Valkyrion Digsite"] = "발키리온 발굴현장",
	["Valley of Bones"] = "뼈의 골짜기",
	["Violet Stand Digsite"] = "보랏빛 단 발굴현장",
	["Voldrune Digsite"] = "볼드룬 발굴현장",
	["Vul'Gol Fossil Bank"] = "벌골 화석 강둑",
	["Warden's Cage Digsite"] = "감시자의 수용소 발굴현장",
	["West Auchindoun Digsite"] = "아킨둔 서부 발굴현장",
	["Western Ruins of Thaurissan"] = "타우릿산의 폐허 서부",
	["Western Zul'Kunda Digsite"] = "서부 줄쿤다 발굴현장",
	["Western Zul'Mamwe Digsite"] = "서부 줄맘웨 발굴현장",
	["Whelgar's Excavation Site"] = "웰가르의 발굴현장",
	["Witherbark Digsite"] = "마른나무껍질 발굴현장",
	["Wyrmbog Fossil Field"] = "용의 둥지 화석 벌판",
	["Wyrmskull Digsite"] = "고룡해골 발굴현장",
	["Ymirheim Digsite"] = "이미르하임 발굴현장",
	["Zeth'Gor Digsite"] = "제스고르 발굴현장",
	["Ziata'jai Digsite"] = "지아타자이 발굴현장",
	["Zim'Rhuk Digsite"] = "짐루크 발굴현장",
	["Zol'Heb Digsite"] = "졸헤브 발굴현장",
	["Zoram Strand Digsite"] = "조람 해안 발굴현장",
	["Zul'Farrak Digsite"] = "줄파락 발굴현장",
	["Zul'Mashar Digsite"] = "줄마샤르 발굴현장",
}

)

elseif GAME_LOCALE == "esES" or GAME_LOCALE == "esMX" then
	lib:SetCurrentTranslations (
	{
	["A library to help with localization of Archeology dig sites"] = "Una biblioteca para ayudar en la localización de los sitios de excavación Arqueológica",
	["Abyssal Sands Fossil Ridge"] = "Cresta de fósiles de las Arenas Abisales", -- Needs review
	["Aerie Peak Digsite"] = "Excavación de Pico Nidal", -- Needs review
	["Agol'watha Digsite"] = "Excavación de Agol'watha",
	["Akhenet Fields Digsite"] = "Excavación de los Campos de Akhenet",
	["Altar of Quetz'lun Digsite"] = "Excavación del Altar de Quetz'lun",
	["Altar of Sseratus Digsite"] = "Excavación del Altar de Sseratus",
	["Altar of Zul Digsite"] = "Excavación de El Altar de Zul", -- Needs review
	["Ancestral Grounds Digsite"] = "Excavación de las Tierras Ancestrales",
	["Andorhal Fossil Bank"] = "Banco de fósiles de Andorhal",
	["Arklon Ruins Digsite"] = "Excavación de las Ruinas Arklon",
	["Bael Modan Digsite"] = "Excavación de Bael Modan",
	["Bal'lal Ruins Digsite"] = "Excavación de la Ruina de Bal'lal",
	["Baleheim Digsite"] = "Excavación de Baleheim",
	["Balia'mah Digsite"] = "Excavación de Balia'mah",
	["Bleeding Hollow Ruins Digsite"] = "Excavación de las Ruinas Foso Sangrante",
	["Boha'mu Ruins Digsite"] = "Excavación de las Ruinas Boha'mu",
	["Bone Wastes Digsite"] = "Excavación de El Vertedero de Huesos",
	["Bonechewer Ruins Digsite"] = "Excavación de las Ruinas Mascahuesos",
	["Broken Commons Digsite"] = "Excavación de la Ágora",
	["Broken Pillar Digsite"] = "Excavación del Pilar Partido",
	["Brunnhildar Village Digsite"] = "Excavación del Poblado Brunnhildar",
	["Burning Blade Digsite"] = "Excavación de las Ruinas Filo Ardiente",
	["Coilskar Point Digsite"] = "Excavación del Alto Cicatriz Espiral",
	["Constellas Digsite"] = "Excavación de Constellas",
	["Cursed Landing Digsite"] = "Excavación de El Embarcadero Maldito",
	["Darkmist Digsite"] = "Excavación de Niebla Negra",
	["Dire Maul Digsite"] = "Excavación de La Masacre",
	["Dragonmaw Fortress"] = "Fortaleza Faucedraco",
	["Drakil'Jin Ruins Digsite"] = "Excavación de las Ruinas de Drakil'Jin", -- Needs review
	["Dreadmaul Fossil Field"] = "Campo de fósiles Machacamiedo",
	["Dun Garok Digsite"] = "Excavación de Dun Garok",
	["Dunemaul Fossil Ridge"] = "Cresta de fósiles de Machacaduna",
	["Dunwald Ruins Digsite"] = "Excavación de las Ruinas Montocre",
	["East Auchindoun Digsite"] = "Excavación de Auchindoun oriental",
	["Eastern Ruins of Thaurissan"] = "Ruinas de Thaurissan del Este",
	["Eastern Zul'Kunda Digsite"] = "Excavación de Zul'Kunda del Este",
	["Eastern Zul'Mamwe Digsite"] = "Excavación de Zul'Mamwe del Este",
	["Eastmoon Ruins Digsite"] = "Excavación de las Ruinas de Lunaeste",
	["Eclipse Point Digsite"] = "Excavación de Punta Eclipse",
	["En'kilah Digsite"] = "Excavación de En'kilah",
	["Ethel Rethor Digsite"] = "Excavación de Ethel Rethor",
	["Felstone Fossil Field"] = "Campo de fósiles Piedramácula",
	["Fields of Blood Fossil Bank"] = "Banco de fósiles de los Campos de Sangre",
	["Forest Song Digsite"] = "Excavación de la Canción del Bosque",
	["Frostwhisper Gorge Digsite"] = "Excavación del Cañón Levescarcha",
	["Gjalerbron Digsite"] = "Excavación de Gjalerbron",
	["Gor'gaz Outpost Digsite"] = "Excavación de la Avanzada Gor'gaz",
	["Grangol'var Village Digsite"] = "Excavación del Poblado Grangol'var",
	["Greenwarden's Fossil Bank"] = "Banco de fósiles del Guardaverde",
	["Grim Batol Digsite"] = "Excavación de Grim Batol",
	["Grimesilt Digsite"] = "Excavación de Limugre",
	["Grimsilt Digsite"] = "Grimsilt Digsite", -- Requires localization
	["Grove of Aessina Digsite"] = "Excavación de la Arboleda de Aessina",
	["Gurubashi Arena Digsite"] = "Excavación de la Arena Gurubashi",
	["Halaa Digsite"] = "Excavación de Halaa",
	["Halgrind Digsite"] = "Excavación de Haltorboll",
	["Hammertoe's Digsite"] = "Excavación de Piemartillo",
	["Hellfire Basin Digsite"] = "Excavación de la Cuenca del Fuego Infernal",
	["Hellfire Citadel Digsite"] = "Excavación de la Ciudadela del Fuego Infernal",
	["Humboldt Conflagration Digsite"] = "Excavación de la Conflagración de Humboldt",
	["Illidari Point Digsite"] = "Excavación del Alto Illidari",
	["Infectis Scar Fossil Field"] = "Campo de fósiles de La Cicatriz Purulenta",
	["Ironband's Excavation Site"] = "Excavación de Vetaferro",
	["Ironbeard's Tomb"] = "Tumba de Barbaférrea",
	["Ironwood Digsite"] = "Excavación de maderaférrea", -- Needs review
	["Jaedenar Digsite"] = "Excavación de Jaedenar",
	["Jintha'Alor Lower City Digsite"] = "Excavación de la parte baja de Jintha'Alor",
	["Jintha'Alor Upper City Digsite"] = "Excavación de la parte alta de Jintha'Alor",
	["Jotunheim Digsite"] = "Excavación de Jotunheim",
	["Keset Pass Digsite"] = "Excavación del Paso de Keset",
	["Khartut's Tomb Digsite"] = "Excavación de la Tumba de Khartut",
	["Kodo Graveyard"] = "Cementerio de Kodos",
	["Kolramas Digsite"] = "Excavación de Kolramas",
	["Lake Kel'Theril Digsite"] = "Excavación del Lago Kel'Theril",
	["Lakeridge Highway Fossil Bank"] = "Banco de fósiles del Camino del Lago",
	["Laughing Skull Digsite"] = "Excavación de las Ruinas Riecráneos",
	["Lower Lakkari Tar Pits"] = "Fosas de Alquitrán inferiores",
	["Mannoroc Coven Digsite"] = "Excavación del Aquelarre Mannoroc",
	["Marshlands Fossil Bank"] = "Banco de fósiles de Los Pantanales",
	["Misty Reed Fossil Bank"] = "Banco de fósiles de Juncobruma",
	["Moonrest Gardens Digsite"] = "Excavación de los Jardines Reposo Lunar",
	["Morlos'Aran Digsite"] = "Excavación de Morlos'Aran",
	["Nazj'vel Digsite"] = "Excavación de Nazj'vel",
	["Neferset Digsite"] = "Excavación de Neferset",
	["Nek'mani Wellspring Digsite"] = "Excavación del Manantial Nek'mani",
	["Nifflevar Digsite"] = "Excavación de Nifflevar",
	["Nightmare Scar Digsite"] = "Excavación del Paraje Pesadilla",
	["Njorndar Village Digsite"] = "Excavación del Poblado Njorndar",
	["North Isildien Digsite"] = "Excavación de Isildien norte",
	["Northridge Fossil Field"] = "Campo de fósiles Crestanorte",
	["Obelisk of the Stars Digsite"] = "Excavación del Obelisco de las Estrellas",
	["Oneiros Digsite"] = "Excavación de Oneiros",
	["Orsis Digsite"] = "Excavación de Orsis",
	["Owl Wing Thicket Digsite"] = "Excavación del Matorral del Ala del Búho",
	["Pit of Fiends Digsite"] = "Pit of Fiends Digsite", -- Requires localization
	["Pit of Narjun Digsite"] = "Excavación de El Foso de Narjun",
	["Plaguewood Digsite"] = "Excavación del Bosque de la Peste",
	["Pyrox Flats Digsite"] = "Excavación de Llanos de Pirox",
	["Quagmire Fossil Field"] = "Campo de fósiles de El Lodazal",
	["Quel'Lithien Lodge Digsite"] = "Excavación del Refugio Quel'Lithien",
	["Ravenwind Digsite"] = "Excavación de las Ruinas de Viento Azabache",
	["Red Reaches Fossil Bank"] = "Banco de fósiles de Las Costas Rojas",
	["Riplash Ruins Digsite"] = "Excavación de las Ruinas Tralladón",
	["River Delta Digsite"] = "Excavación del Delta", -- Needs review
	["Ruins of Aboraz"] = "Ruinas de Aboraz",
	["Ruins of Ahmtul Digsite"] = "Excavación de las Ruinas de Ahmtul",
	["Ruins of Ammon Digsite"] = "Excavación de las Ruinas de Ammon",
	["Ruins of Arkkoran"] = "Ruinas de Arkkoran",
	["Ruins of Baa'ri Digsite"] = "Excavación de las Ruinas de Baa'ri",
	["Ruins of Eldarath"] = "Ruinas de Eldarath",
	["Ruins of Eldre'Thar"] = "Ruinas de Eldre'thar",
	["Ruins of Enkaat Digsite"] = "Excavación de las Ruinas de Enkaat",
	["Ruins of Farahlon Digsite"] = "Excavación de las Ruinas de Farahlon",
	["Ruins of Jubuwal"] = "Ruinas de Jubuwal",
	["Ruins of Khintaset Digsite"] = "Excavación de las Ruinas de Khintaset",
	["Ruins of Lar'donir Digsite"] = "Excavación de las Ruinas de Lar'donir",
	["Ruins of Ordil'Aran"] = "Las Ruinas de Ordil'Aran",
	["Ruins of Shandaral Digsite"] = "Excavación de las Ruinas de Shandaral",
	["Ruins of Stardust"] = "Las Ruinas del Polvo Estelar",
	["Sahket Wastes Digsite"] = "Excavación de las Ruinas de Sahket",
	["Sanctuary of Malorne Digsite"] = "Excavación del Santuario de Malorne",
	["Sands of Nasam"] = "Arenas del Nasam", -- Needs review
	["Sargeron Digsite"] = "Excavación de Sargeron",
	["Savage Coast Raptor Fields"] = "Campos de raptores de La Costa Salvaje",
	["Schnottz's Landing"] = "Embarcadero de Schnottz",
	["Scorched Plain Digsite"] = "Excavación de La Llanura Agostada",
	["Scourgeholme Digsite"] = "Excavación de la Ciudad de la Plaga",
	["Screaming Reaches Fossil Field"] = "Campo de fósiles de la Cuenca de los Gritos",
	["Sha'naar Digsite"] = "Excavación de Sha'naar",
	["Shadra'Alor Digsite"] = "Excavación de Shadra'Alor",
	["Shield Hill Digsite"] = "Excavación de la Colina Escudo",
	["Shrine of Goldrinn Digsite"] = "Excavación del Santuario de Goldrinn",
	["Sifreldar Village Digsite"] = "Excavación del Poblado Sifreldar",
	["Skorn Digsite"] = "Excavación de Skorn",
	["Slitherblade Shore Digsite"] = "Excavación de la Costa Filozante",
	["Solarsal Digsite"] = "Excavación de Solarsal",
	["South Isildien Digsite"] = "Excavación de Isildien sur",
	["Southmoon Ruins Digsite"] = "Excavación de las Ruinas de Lunasur",
	["Southshore Fossil Field"] = "Campo de fósiles de Costasur",
	["Southwind Village Digsite"] = "Excavación de la Aldea del Viento del Sur",
	["Steps of Fate Digsite"] = "Excavación de Los Pasos del Sino",
	["Stonetalon Peak"] = "Cima del Espolón",
	["Sunken Temple Digsite"] = "Excavación del Templo Sumergido",
	["Sunspring Post Digsite"] = "Excavación del Puesto Primasol",
	["Talramas Digsite"] = "Excavación de Talramas",
	["Temple of Uldum Digsite"] = "Excavación del Templo de Uldum",
	["Terror Run Fossil Field"] = "Campo de fósiles del Camino del Terror",
	["Terror Wing Fossil Field"] = "Campo de fósiles del Ala del Terror",
	["Terrorweb Tunnel Digsite"] = "Excavación del Túnel Terroarácnido", -- Needs review
	["Thandol Span"] = "Puente Thandol",
	["Thoradin's Wall"] = "Muralla de Thoradin",
	["Thundermar Ruins Digsite"] = "Excavación de las Ruinas de Bramal",
	["Tomb of the Watchers Digsite"] = "Excavación de la Tumba de los Vigías",
	["Tombs of the Precursors Digsite"] = "Excavación de las Tumbas de los Precursores",
	["Tuurem Digsite"] = "Excavación de Tuurem",
	["Twilight Grove Digsite"] = "Excavación de la Arboleda del Crepúsculo",
	["Twin Spire Ruins Digsite"] = "Excavación de las Ruinas de las Agujas Gemelas",
	["Uldaman Entrance Digsite"] = "Excavación de la Entrada de Uldaman",
	["Unearthed Grounds"] = "Campos Desenterrados",
	["Upper Lakkari Tar Pits"] = "Fosas de Alquitrán superiores",
	["Valkyrion Digsite"] = "Excavación de Valkyrion",
	["Valley of Bones"] = "Valle de los Huesos",
	["Violet Stand Digsite"] = "Excavación de El Confín Violeta",
	["Voldrune Digsite"] = "Excavación de Runavold",
	["Vul'Gol Fossil Bank"] = "Banco de fósiles de Vul'Gol",
	["Warden's Cage Digsite"] = "Excavación de la Jaula de la Guardiana",
	["West Auchindoun Digsite"] = "Excavación de Auchindoun occidental",
	["Western Ruins of Thaurissan"] = "Ruinas de Thaurissan del Oeste",
	["Western Zul'Kunda Digsite"] = "Excavación de Zul'Kunda del Oeste",
	["Western Zul'Mamwe Digsite"] = "Excavación de Zul'Mamwe del Oeste",
	["Whelgar's Excavation Site"] = "Excavación de Whelgar",
	["Witherbark Digsite"] = "Excavación Secacorteza",
	["Wyrmbog Fossil Field"] = "Campo de fósiles de Ciénaga de Fuego",
	["Wyrmskull Digsite"] = "Excavación de Calavermis",
	["Ymirheim Digsite"] = "Excavación de Ymirheim",
	["Zeth'Gor Digsite"] = "Excavación de Zeth'Gor",
	["Ziata'jai Digsite"] = "Excavación de Ziata'jai",
	["Zim'Rhuk Digsite"] = "Excavación de Zim'Rhuk",
	["Zol'Heb Digsite"] = "Excavación de Zol'Heb",
	["Zoram Strand Digsite"] = "Excavación de La Ensenada de Zoram",
	["Zul'Farrak Digsite"] = "Excavación de Zul'Farrak",
	["Zul'Mashar Digsite"] = "Excavación de Zul'Mashar",
}

)

elseif GAME_LOCALE == "ruRU" then
	lib:SetCurrentTranslations (
	{
	["A library to help with localization of Archeology dig sites"] = "Вспомогательная библиотека локализаций археологических мест раскопок",
	["Abyssal Sands Fossil Ridge"] = "Безбрежные пески - окаменелости",
	["Aerie Peak Digsite"] = "Заоблачный пик - раскопки",
	["Agol'watha Digsite"] = "Агол'вата - раскопки",
	["Akhenet Fields Digsite"] = "Поля Акхенет - раскопки",
	["Altar of Quetz'lun Digsite"] = "Алтарь Кетц'лун - раскопки",
	["Altar of Sseratus Digsite"] = "Алтарь Шшератуса - раскопки",
	["Altar of Zul Digsite"] = "Алтарь Зула - раскопки",
	["Ancestral Grounds Digsite"] = "Земли Предков - раскопки",
	["Andorhal Fossil Bank"] = "Андорал - окаменелости",
	["Arklon Ruins Digsite"] = "Руины Арклон - раскопки",
	["Bael Modan Digsite"] = "Бейл Модан - раскопки",
	["Bal'lal Ruins Digsite"] = "Руины Бал'лал - раскопки",
	["Baleheim Digsite"] = "Гибльхейм - раскопки",
	["Balia'mah Digsite"] = "Балиа'ма - раскопки",
	["Bleeding Hollow Ruins Digsite"] = "Руины Кровавой Глазницы - раскопки",
	["Boha'mu Ruins Digsite"] = "Руины Боха'му - раскопки",
	["Bone Wastes Digsite"] = "Костяные пустоши - раскопки",
	["Bonechewer Ruins Digsite"] = "Руины Костеглодов - раскопки",
	["Broken Commons Digsite"] = "Разоренные земли - раскопки",
	["Broken Pillar Digsite"] = "Разбитая Колонна - раскопки",
	["Brunnhildar Village Digsite"] = "Деревня Бруннхильдар - раскопки",
	["Burning Blade Digsite"] = "Пылающий Клинок - раскопки",
	["Coilskar Point Digsite"] = "Лагерь Змеиных Колец - раскопки",
	["Constellas Digsite"] = "Констеллас - раскопки",
	["Cursed Landing Digsite"] = "Проклятый лагерь - раскопки",
	["Darkmist Digsite"] = "Мглистая пещера - раскопки",
	["Dire Maul Digsite"] = "Забытый Город - раскопки",
	["Dragonmaw Fortress"] = "Крепость Драконьей Пасти",
	["Drakil'Jin Ruins Digsite"] = "Руины Дракил'джин - раскопки",
	["Dreadmaul Fossil Field"] = "Молот Ужаса - окаменелости",
	["Dun Garok Digsite"] = "Дун Гарок - раскопки",
	["Dunemaul Fossil Ridge"] = "Песчаный Молот - окаменелости",
	["Dunwald Ruins Digsite"] = "Развалины Дунвальда - раскопки",
	["East Auchindoun Digsite"] = "Восточный Аукиндон - раскопки",
	["Eastern Ruins of Thaurissan"] = "Восточные руины Тауриссана",
	["Eastern Zul'Kunda Digsite"] = "Восточная Зул'Кунда - раскопки",
	["Eastern Zul'Mamwe Digsite"] = "Восточный Зул'Мамве - раскопки",
	["Eastmoon Ruins Digsite"] = "Руины Восточной Луны - раскопки",
	["Eclipse Point Digsite"] = "Лагерь Затмения - раскопки",
	["En'kilah Digsite"] = "Эн'кила - раскопки",
	["Ethel Rethor Digsite"] = "Этель-Ретор - раскопки",
	["Felstone Fossil Field"] = "Поле Джанис - окаменелости",
	["Fields of Blood Fossil Bank"] = "Кровавые поля - окаменелости",
	["Forest Song Digsite"] = "Лесная Песнь - раскопки",
	["Frostwhisper Gorge Digsite"] = "Теснина Ледяного Шепота - раскопки",
	["Gjalerbron Digsite"] = "Гьялерброн - раскопки",
	["Gor'gaz Outpost Digsite"] = "Форт Гор'газ - раскопки",
	["Grangol'var Village Digsite"] = "Деревня Грангол'вар - раскопки",
	["Greenwarden's Fossil Bank"] = "Роща Стража Природы - окаменелости",
	["Grim Batol Digsite"] = "Грим Батол - раскопки",
	["Grimesilt Digsite"] = "Гримсилт - раскопки",
	["Grimsilt Digsite"] = "Гримсилт - раскопки", -- Needs review
	["Grove of Aessina Digsite"] = "Роща Эссины - раскопки",
	["Gurubashi Arena Digsite"] = "Арена Гурубаши - раскопки",
	["Halaa Digsite"] = "Халаа - раскопки",
	["Halgrind Digsite"] = "Халгринд - раскопки",
	["Hammertoe's Digsite"] = "Карьер Тяжелоступа - раскопки",
	["Hellfire Basin Digsite"] = "Яма Адского Пламени - раскопки",
	["Hellfire Citadel Digsite"] = "Цитадель Адского Пламени - раскопки",
	["Humboldt Conflagration Digsite"] = "Пожарище Гумбольдта - раскопки",
	["Illidari Point Digsite"] = "Аванпост Иллидари - раскопки",
	["Infectis Scar Fossil Field"] = "Чумной овраг - окаменелости",
	["Ironband's Excavation Site"] = "Раскопки Сталекрута",
	["Ironbeard's Tomb"] = "Гробница Железноборода",
	["Ironwood Digsite"] = "Железнолесья - раскопки",
	["Jaedenar Digsite"] = "Джеденар - раскопки",
	["Jintha'Alor Lower City Digsite"] = "Джинта'Алор, Нижний Город - раскопки",
	["Jintha'Alor Upper City Digsite"] = "Джинта'Алор, Верхний Город - раскопки",
	["Jotunheim Digsite"] = "Йотунхейм - раскопки",
	["Keset Pass Digsite"] = "Тропа Кесета - раскопки",
	["Khartut's Tomb Digsite"] = "Гробница Хартута - раскопки",
	["Kodo Graveyard"] = "Кладбище кодо",
	["Kolramas Digsite"] = "Колрамас - раскопки",
	["Lake Kel'Theril Digsite"] = "Озеро Кел'Терил - раскопки",
	["Lakeridge Highway Fossil Bank"] = "Озерный тракт - окаменелости",
	["Laughing Skull Digsite"] = "Веселый Череп - раскопки",
	["Lower Lakkari Tar Pits"] = "Нижние Смоляные ямы Лаккари",
	["Mannoroc Coven Digsite"] = "Поле Маннорок - раскопки",
	["Marshlands Fossil Bank"] = "Топи - окаменелости",
	["Misty Reed Fossil Bank"] = "Тростниковый берег - окаменелости",
	["Moonrest Gardens Digsite"] = "Сады Лунного Покоя - раскопки",
	["Morlos'Aran Digsite"] = "Морлос'Аран - раскопки",
	["Nazj'vel Digsite"] = "Назж'вел - раскопки",
	["Neferset Digsite"] = "Неферсет - раскопки",
	["Nek'mani Wellspring Digsite"] = "Родник Нек'Мани - раскопки",
	["Nifflevar Digsite"] = "Ниффлвар - раскопки",
	["Nightmare Scar Digsite"] = "Ров Кошмаров - раскопки",
	["Njorndar Village Digsite"] = "Деревня Ньорндар - раскопки",
	["North Isildien Digsite"] = "Северный Исильдиэн - раскопки",
	["Northridge Fossil Field"] = "Северный Кряж - окаменелости",
	["Obelisk of the Stars Digsite"] = "Обелиск Звезд - раскопки",
	["Oneiros Digsite"] = "Онейрос - раскопки",
	["Orsis Digsite"] = "Орсис - раскопки",
	["Owl Wing Thicket Digsite"] = "Совиная чаща - раскопки",
	["Pit of Fiends Digsite"] = "Яма чудовищ - раскопки", -- Needs review
	["Pit of Narjun Digsite"] = "Провал Наржуна - раскопки",
	["Plaguewood Digsite"] = "Чумной лес - раскопки",
	["Pyrox Flats Digsite"] = "Пироксовые равнины - раскопки",
	["Quagmire Fossil Field"] = "Трясина - окаменелости",
	["Quel'Lithien Lodge Digsite"] = "Сторожка Кель'Литиен - раскопки",
	["Ravenwind Digsite"] = "Яростный Ветер - раскопки",
	["Red Reaches Fossil Bank"] = "Красные берега - окаменелости",
	["Riplash Ruins Digsite"] = "Руины Терзающего Бича - раскопки",
	["River Delta Digsite"] = "Дельта Вир'наала - раскопки",
	["Ruins of Aboraz"] = "Руины Абораза",
	["Ruins of Ahmtul Digsite"] = "Руины Атмула - раскопки",
	["Ruins of Ammon Digsite"] = "Руины Аммона - раскопки",
	["Ruins of Arkkoran"] = "Руины храма Арккоран",
	["Ruins of Baa'ri Digsite"] = "Руины Баа'ри - раскопки",
	["Ruins of Eldarath"] = "Руины Эльдарата",
	["Ruins of Eldre'Thar"] = "Руины Эльдре'тара",
	["Ruins of Enkaat Digsite"] = "Руины Энкаата - раскопки",
	["Ruins of Farahlon Digsite"] = "Руины Фаралона - раскопки",
	["Ruins of Jubuwal"] = "Руины Жубуваля",
	["Ruins of Khintaset Digsite"] = "Руины Кинтасета - раскопки",
	["Ruins of Lar'donir Digsite"] = "Руины Лар'донира - раскопки",
	["Ruins of Ordil'Aran"] = "Руины Ордил'Арана",
	["Ruins of Shandaral Digsite"] = "Руины Шандарала - раскопки",
	["Ruins of Stardust"] = "Руины Звездной Пыли",
	["Sahket Wastes Digsite"] = "Пустоши Сакет - раскопки",
	["Sanctuary of Malorne Digsite"] = "Святилище Малорна - раскопки",
	["Sands of Nasam"] = "Пески Назама", -- Needs review
	["Sargeron Digsite"] = "Саргерон - раскопки",
	["Savage Coast Raptor Fields"] = "Гибельный берег, поля ящеров",
	["Schnottz's Landing"] = "Лагерь Шнотца",
	["Scorched Plain Digsite"] = "Выжженная равнина - раскопки",
	["Scourgeholme Digsite"] = "Плетхольм - раскопки",
	["Screaming Reaches Fossil Field"] = "Вопящие плёсы - окаменелости",
	["Sha'naar Digsite"] = "Ша'наар - раскопки",
	["Shadra'Alor Digsite"] = "Шадра'Алор - раскопки",
	["Shield Hill Digsite"] = "Заградительный холм - раскопки",
	["Shrine of Goldrinn Digsite"] = "Святилище Голдринна - раскопки",
	["Sifreldar Village Digsite"] = "Деревня Сифрельдар - раскопки",
	["Skorn Digsite"] = "Скорн - раскопки",
	["Slitherblade Shore Digsite"] = "Берег Скользящего Плавника - раскопки",
	["Solarsal Digsite"] = "Соларсаль - раскопки",
	["South Isildien Digsite"] = "Южный Исильдиэн - раскопки",
	["Southmoon Ruins Digsite"] = "Руины Южной Луны - раскопки",
	["Southshore Fossil Field"] = "Южнобережье - окаменелости",
	["Southwind Village Digsite"] = "Деревня Южного Ветра - раскопки",
	["Steps of Fate Digsite"] = "Шаги Судьбы - раскопки",
	["Stonetalon Peak"] = "Пик Каменного Когтя",
	["Sunken Temple Digsite"] = "Затонувший храм - раскопки",
	["Sunspring Post Digsite"] = "Застава Солнечного Источника - раскопки",
	["Talramas Digsite"] = "Талрамас - раскопки",
	["Temple of Uldum Digsite"] = "Храм Ульдума - раскопки",
	["Terror Run Fossil Field"] = "Путь Ужаса - окаменелости",
	["Terror Wing Fossil Field"] = "Тропа Крылатого Ужаса - окаменелости",
	["Terrorweb Tunnel Digsite"] = "Туннель Ужаса - раскопки",
	["Thandol Span"] = "Мост Тандола",
	["Thoradin's Wall"] = "Стена Торадина",
	["Thundermar Ruins Digsite"] = "Руины Громтара - раскопки",
	["Tomb of the Watchers Digsite"] = "Гробница Стражей - раскопки",
	["Tombs of the Precursors Digsite"] = "Гробницы Предтеч - раскопки",
	["Tuurem Digsite"] = "Туурем - раскопки",
	["Twilight Grove Digsite"] = "Мглистая роща - раскопки",
	["Twin Spire Ruins Digsite"] = "Руины Двух Башен - раскопки",
	["Uldaman Entrance Digsite"] = "Вход в Ульдаман - раскопки",
	["Unearthed Grounds"] = "Место раскопок",
	["Upper Lakkari Tar Pits"] = "Верхние Смоляные ямы Лаккари",
	["Valkyrion Digsite"] = "Валькирион - раскопки",
	["Valley of Bones"] = "Долина Костей",
	["Violet Stand Digsite"] = "Аметистовая застава - раскопки",
	["Voldrune Digsite"] = "Волдрун - раскопки",
	["Vul'Gol Fossil Bank"] = "Вул'Гол - окаменелости",
	["Warden's Cage Digsite"] = "Клеть Стражницы - раскопки",
	["West Auchindoun Digsite"] = "Западный Аукиндон - раскопки",
	["Western Ruins of Thaurissan"] = "Западные руины Тауриссана",
	["Western Zul'Kunda Digsite"] = "Западная Зул'Кунда - раскопки",
	["Western Zul'Mamwe Digsite"] = "Западный Зул'Мамве - раскопки",
	["Whelgar's Excavation Site"] = "Раскопки Вельгара",
	["Witherbark Digsite"] = "Деревня Сухокожих - раскопки",
	["Wyrmbog Fossil Field"] = "Драконьи топи - окаменелости",
	["Wyrmskull Digsite"] = "Драконий Череп - раскопки",
	["Ymirheim Digsite"] = "Имирхейм - раскопки",
	["Zeth'Gor Digsite"] = "Зет'Гор - раскопки",
	["Ziata'jai Digsite"] = "Зиата'джаи - раскопки",
	["Zim'Rhuk Digsite"] = "Зим'Рук - раскопки",
	["Zol'Heb Digsite"] = "Зол'Хеб - раскопки",
	["Zoram Strand Digsite"] = "Зорамское взморье - раскопки",
	["Zul'Farrak Digsite"] = "Зул'Фаррак - раскопки",
	["Zul'Mashar Digsite"] = "Зул'Машар - раскопки",
}

)

elseif GAME_LOCALE == "zhCN" then
	lib:SetCurrentTranslations (
	{
	["A library to help with localization of Archeology dig sites"] = "一个用来帮助本地化考古学挖掘地点的数据库",
	["Abyssal Sands Fossil Ridge"] = "深沙化石岭",
	["Aerie Peak Digsite"] = "鹰巢山挖掘场",
	["Agol'watha Digsite"] = "亚戈瓦萨挖掘场",
	["Akhenet Fields Digsite"] = "埃卡赫莱平原挖掘场",
	["Altar of Quetz'lun Digsite"] = "奎丝鲁恩祭坛挖掘场",
	["Altar of Sseratus Digsite"] = "西莱图斯祭坛挖掘场",
	["Altar of Zul Digsite"] = "祖尔祭坛挖掘场",
	["Ancestral Grounds Digsite"] = "先祖之地挖掘场",
	["Andorhal Fossil Bank"] = "安多哈尔化石堆",
	["Arklon Ruins Digsite"] = "阿尔科隆废墟挖掘场",
	["Bael Modan Digsite"] = "巴尔莫丹挖掘场",
	["Bal'lal Ruins Digsite"] = "巴拉尔废墟挖掘场",
	["Baleheim Digsite"] = "拜尔海姆挖掘场",
	["Balia'mah Digsite"] = "巴里亚曼挖掘场",
	["Bleeding Hollow Ruins Digsite"] = "血环废墟挖掘场",
	["Boha'mu Ruins Digsite"] = "博哈姆废墟挖掘场",
	["Bone Wastes Digsite"] = "白骨荒野挖掘场",
	["Bonechewer Ruins Digsite"] = "噬骨废墟挖掘场",
	["Broken Commons Digsite"] = "平民区废墟挖掘场",
	["Broken Pillar Digsite"] = "破碎石柱挖掘场",
	["Brunnhildar Village Digsite"] = "布伦希尔达村挖掘场",
	["Burning Blade Digsite"] = "火刃挖掘场",
	["Coilskar Point Digsite"] = "库斯卡岗哨挖掘场",
	["Constellas Digsite"] = "克斯特拉斯挖掘场",
	["Cursed Landing Digsite"] = "被诅咒的登陆点挖掘场",
	["Darkmist Digsite"] = "黑雾挖掘场",
	["Dire Maul Digsite"] = "厄运之槌挖掘场",
	["Dragonmaw Fortress"] = "龙喉要塞",
	["Drakil'Jin Ruins Digsite"] = "达基尔金废墟挖掘场",
	["Dreadmaul Fossil Field"] = "巨槌化石场",
	["Dun Garok Digsite"] = "丹加洛克挖掘场",
	["Dunemaul Fossil Ridge"] = "砂槌化石岭",
	["Dunwald Ruins Digsite"] = "顿沃德废墟挖掘场",
	["East Auchindoun Digsite"] = "东奥金顿挖掘场",
	["Eastern Ruins of Thaurissan"] = "东索瑞森废墟",
	["Eastern Zul'Kunda Digsite"] = "东祖昆达挖掘场",
	["Eastern Zul'Mamwe Digsite"] = "东祖玛维挖掘场",
	["Eastmoon Ruins Digsite"] = "东月废墟挖掘场",
	["Eclipse Point Digsite"] = "日蚀岗哨挖掘场",
	["En'kilah Digsite"] = "恩其拉挖掘场",
	["Ethel Rethor Digsite"] = "艾瑟雷索挖掘场",
	["Felstone Fossil Field"] = "费尔斯通化石场",
	["Fields of Blood Fossil Bank"] = "鲜血旷野化石堆",
	["Forest Song Digsite"] = "林歌神殿挖掘场",
	["Frostwhisper Gorge Digsite"] = "霜语峡谷挖掘场",
	["Gjalerbron Digsite"] = "亚勒伯龙挖掘场",
	["Gor'gaz Outpost Digsite"] = "高加兹前哨挖掘场",
	["Grangol'var Village Digsite"] = "格兰戈瓦村挖掘场",
	["Greenwarden's Fossil Bank"] = "绿色守卫者化石堆",
	["Grim Batol Digsite"] = "格瑞姆巴托挖掘场",
	["Grimesilt Digsite"] = "煤渣挖掘场",
	["Grimsilt Digsite"] = "煤渣挖掘场",
	["Grove of Aessina Digsite"] = "艾森娜林地挖掘场",
	["Gurubashi Arena Digsite"] = "古拉巴什挖掘场",
	["Halaa Digsite"] = "哈兰挖掘场",
	["Halgrind Digsite"] = "哈尔格林德挖掘场",
	["Hammertoe's Digsite"] = "铁趾挖掘场",
	["Hellfire Basin Digsite"] = "地狱火盆地挖掘场",
	["Hellfire Citadel Digsite"] = "地狱火堡垒挖掘场",
	["Humboldt Conflagration Digsite"] = "洪堡焚烧峡谷挖掘场",
	["Illidari Point Digsite"] = "伊利达雷岗哨挖掘场",
	["Infectis Scar Fossil Field"] = "魔刃之痕化石场",
	["Ironband's Excavation Site"] = "铁环挖掘场",
	["Ironbeard's Tomb"] = "铁须之墓",
	["Ironwood Digsite"] = "铁木挖掘场",
	["Jaedenar Digsite"] = "加德纳尔挖掘场",
	["Jintha'Alor Lower City Digsite"] = "辛萨罗下层挖掘场",
	["Jintha'Alor Upper City Digsite"] = "辛萨罗上层挖掘场",
	["Jotunheim Digsite"] = "尤顿海姆挖掘场",
	["Keset Pass Digsite"] = "柯塞特小径挖掘场",
	["Khartut's Tomb Digsite"] = "卡塔图陵墓挖掘场",
	["Kodo Graveyard"] = "科多兽坟场",
	["Kolramas Digsite"] = "科尔拉玛斯挖掘场",
	["Lake Kel'Theril Digsite"] = "凯斯利尔湖挖掘场",
	["Lakeridge Highway Fossil Bank"] = "湖边大道化石堆",
	["Laughing Skull Digsite"] = "嘲颅挖掘场",
	["Lower Lakkari Tar Pits"] = "下层拉卡利油沼",
	["Mannoroc Coven Digsite"] = "玛诺洛克集会所挖掘场",
	["Marshlands Fossil Bank"] = "沼泽地化石堆",
	["Misty Reed Fossil Bank"] = "芦苇化石堆",
	["Moonrest Gardens Digsite"] = "眠月花园挖掘场",
	["Morlos'Aran Digsite"] = "摩罗萨兰挖掘场",
	["Nazj'vel Digsite"] = "纳兹维尔挖掘场",
	["Neferset Digsite"] = "尼斐塞特挖掘场",
	["Nek'mani Wellspring Digsite"] = "纳克迈尼圣泉挖掘场",
	["Nifflevar Digsite"] = "尼弗莱瓦挖掘场",
	["Nightmare Scar Digsite"] = "噩梦之痕挖掘场",
	["Njorndar Village Digsite"] = "约尔达村挖掘场",
	["North Isildien Digsite"] = "北伊斯迪尔挖掘场",
	["Northridge Fossil Field"] = "北山化石场",
	["Obelisk of the Stars Digsite"] = "群星方尖碑挖掘场",
	["Oneiros Digsite"] = "奥奈罗斯挖掘场",
	["Orsis Digsite"] = "奥西斯挖掘场",
	["Owl Wing Thicket Digsite"] = "枭翼树丛挖掘场",
	["Pit of Fiends Digsite"] = "邪魔之坑挖掘场",
	["Pit of Narjun Digsite"] = "纳尔苏深渊挖掘场",
	["Plaguewood Digsite"] = "病木林挖掘场",
	["Pyrox Flats Digsite"] = "漫火平原挖掘场",
	["Quagmire Fossil Field"] = "泥潭沼泽化石场",
	["Quel'Lithien Lodge Digsite"] = "奎尔林斯小屋挖掘场",
	["Ravenwind Digsite"] = "鸦风挖掘场",
	["Red Reaches Fossil Bank"] = "赤色海岸化石堆",
	["Riplash Ruins Digsite"] = "裂鞭废墟挖掘场",
	["River Delta Digsite"] = "三角洲挖掘场",
	["Ruins of Aboraz"] = "阿博拉兹废墟",
	["Ruins of Ahmtul Digsite"] = "阿胡图尔遗迹挖掘场",
	["Ruins of Ammon Digsite"] = "阿蒙遗迹挖掘场",
	["Ruins of Arkkoran"] = "亚考兰神殿废墟",
	["Ruins of Baa'ri Digsite"] = "巴尔里废墟挖掘场",
	["Ruins of Eldarath"] = "埃达拉斯废墟",
	["Ruins of Eldre'Thar"] = "埃德雷萨废墟",
	["Ruins of Enkaat Digsite"] = "恩卡特废墟挖掘场",
	["Ruins of Farahlon Digsite"] = "法兰伦废墟挖掘场",
	["Ruins of Jubuwal"] = "朱布瓦尔废墟",
	["Ruins of Khintaset Digsite"] = "辛塔希特遗迹挖掘场",
	["Ruins of Lar'donir Digsite"] = "拉多尼尔遗迹挖掘场",
	["Ruins of Ordil'Aran"] = "奥迪拉兰废墟",
	["Ruins of Shandaral Digsite"] = "杉达拉废墟挖掘场",
	["Ruins of Stardust"] = "星尘废墟",
	["Sahket Wastes Digsite"] = "沙赫柯特荒原挖掘场",
	["Sanctuary of Malorne Digsite"] = "玛洛恩庇护所挖掘场",
	["Sands of Nasam"] = "纳萨姆沙地挖掘场",
	["Sargeron Digsite"] = "萨格隆挖掘场",
	["Savage Coast Raptor Fields"] = "野人海岸迅猛龙遗址",
	["Schnottz's Landing"] = "司克诺兹登陆点挖掘场",
	["Scorched Plain Digsite"] = "焦痕平原挖掘场",
	["Scourgeholme Digsite"] = "天灾城挖掘场",
	["Screaming Reaches Fossil Field"] = "尖啸河滩化石场",
	["Sha'naar Digsite"] = "沙纳尔挖掘场",
	["Shadra'Alor Digsite"] = "沙德拉洛挖掘场",
	["Shield Hill Digsite"] = "盾牌岭挖掘场",
	["Shrine of Goldrinn Digsite"] = "戈德林圣殿挖掘场",
	["Sifreldar Village Digsite"] = "希弗列尔达村挖掘场",
	["Skorn Digsite"] = "斯克恩挖掘场",
	["Slitherblade Shore Digsite"] = "滑刃海岸挖掘场",
	["Solarsal Digsite"] = "索兰萨尔挖掘场",
	["South Isildien Digsite"] = "南伊斯迪尔挖掘场",
	["Southmoon Ruins Digsite"] = "南月废墟挖掘场",
	["Southshore Fossil Field"] = "南海镇化石场",
	["Southwind Village Digsite"] = "南风村挖掘场",
	["Steps of Fate Digsite"] = "天命阶梯挖掘场",
	["Stonetalon Peak"] = "石爪峰",
	["Sunken Temple Digsite"] = "沉没的神庙挖掘场",
	["Sunspring Post Digsite"] = "日泉岗哨挖掘场",
	["Talramas Digsite"] = "塔尔拉玛斯挖掘场",
	["Temple of Uldum Digsite"] = "奥丹姆神殿挖掘场",
	["Terror Run Fossil Field"] = "恐惧小道化石场",
	["Terror Wing Fossil Field"] = "龙翼小径化石场",
	["Terrorweb Tunnel Digsite"] = "恶蛛隧道挖掘场",
	["Thandol Span"] = "萨多尔大桥",
	["Thoradin's Wall"] = "索拉丁之墙",
	["Thundermar Ruins Digsite"] = "桑德玛尔废墟挖掘场",
	["Tomb of the Watchers Digsite"] = "观察者陵墓挖掘场",
	["Tombs of the Precursors Digsite"] = "先贤陵墓挖掘场",
	["Tuurem Digsite"] = "图雷姆挖掘场",
	["Twilight Grove Digsite"] = "黎明森林挖掘场",
	["Twin Spire Ruins Digsite"] = "双塔废墟挖掘场",
	["Uldaman Entrance Digsite"] = "奥达曼入口挖掘场",
	["Unearthed Grounds"] = "不毛之地",
	["Upper Lakkari Tar Pits"] = "上层拉卡利油沼",
	["Valkyrion Digsite"] = "瓦基里安挖掘场",
	["Valley of Bones"] = "白骨之谷",
	["Violet Stand Digsite"] = "紫罗兰哨站挖掘场",
	["Voldrune Digsite"] = "沃德伦挖掘场",
	["Vul'Gol Fossil Bank"] = "沃古尔化石堆",
	["Warden's Cage Digsite"] = "守望者牢笼挖掘场",
	["West Auchindoun Digsite"] = "西奥金顿挖掘场",
	["Western Ruins of Thaurissan"] = "西索瑞森废墟",
	["Western Zul'Kunda Digsite"] = "西祖昆达挖掘场",
	["Western Zul'Mamwe Digsite"] = "西祖玛维挖掘场",
	["Whelgar's Excavation Site"] = "维尔加挖掘场",
	["Witherbark Digsite"] = "枯木挖掘场",
	["Wyrmbog Fossil Field"] = "巨龙沼泽化石场",
	["Wyrmskull Digsite"] = "龙颅挖掘场",
	["Ymirheim Digsite"] = "伊米海姆挖掘场",
	["Zeth'Gor Digsite"] = "塞斯高挖掘场",
	["Ziata'jai Digsite"] = "赞塔加挖掘场",
	["Zim'Rhuk Digsite"] = "希姆鲁克挖掘场",
	["Zol'Heb Digsite"] = "佐尔赫布挖掘场",
	["Zoram Strand Digsite"] = "佐拉姆海岸挖掘场",
	["Zul'Farrak Digsite"] = "祖尔法拉克挖掘场",
	["Zul'Mashar Digsite"] = "祖玛沙尔挖掘场",
}

)

elseif GAME_LOCALE == "zhTW" then
	lib:SetCurrentTranslations (
	{
	["A library to help with localization of Archeology dig sites"] = "一個用來幫助本地化考古學挖掘地點的資料庫",
	["Abyssal Sands Fossil Ridge"] = "深沙平原古山脊",
	["Aerie Peak Digsite"] = "鷹巢山挖掘場",
	["Agol'watha Digsite"] = "亞戈瓦薩挖掘場",
	["Akhenet Fields Digsite"] = "雅奇涅特原野挖掘場",
	["Altar of Quetz'lun Digsite"] = "奎茲倫祭壇挖掘場",
	["Altar of Sseratus Digsite"] = "司瑟拉圖斯祭壇挖掘場",
	["Altar of Zul Digsite"] = "祖爾祭壇挖掘場",
	["Ancestral Grounds Digsite"] = "先祖之地挖掘場",
	["Andorhal Fossil Bank"] = "安多哈爾古河岸",
	["Arklon Ruins Digsite"] = "阿克隆廢墟挖掘場",
	["Bael Modan Digsite"] = "巴爾莫丹挖掘場",
	["Bal'lal Ruins Digsite"] = "巴拉爾廢墟挖掘場",
	["Baleheim Digsite"] = "貝爾海姆挖掘場",
	["Balia'mah Digsite"] = "巴里亞曼挖掘場",
	["Bleeding Hollow Ruins Digsite"] = "血之谷廢墟挖掘場",
	["Boha'mu Ruins Digsite"] = "波哈姆廢墟挖掘場",
	["Bone Wastes Digsite"] = "白骨荒野挖掘場",
	["Bonechewer Ruins Digsite"] = "噬骨者廢墟挖掘場",
	["Broken Commons Digsite"] = "平民區廢墟挖掘場",
	["Broken Pillar Digsite"] = "破碎石柱挖掘場",
	["Brunnhildar Village Digsite"] = "布倫希爾達村挖掘場",
	["Burning Blade Digsite"] = "燃刃挖掘場",
	["Coilskar Point Digsite"] = "考斯卡崗哨挖掘場",
	["Constellas Digsite"] = "克斯特拉斯挖掘場",
	["Cursed Landing Digsite"] = "詛咒臺地挖掘場",
	["Darkmist Digsite"] = "暗霧挖掘場",
	["Dire Maul Digsite"] = "厄運之槌挖掘場",
	["Dragonmaw Fortress"] = "龍喉堡壘",
	["Drakil'Jin Ruins Digsite"] = "德拉齊金遺跡挖掘場",
	["Dreadmaul Fossil Field"] = "巨槌古原野",
	["Dun Garok Digsite"] = "丹加洛克挖掘場",
	["Dunemaul Fossil Ridge"] = "砂槌古山脊",
	["Dunwald Ruins Digsite"] = "登瓦德廢墟挖掘場",
	["East Auchindoun Digsite"] = "奧齊頓東部挖掘場",
	["Eastern Ruins of Thaurissan"] = "索瑞森東部廢墟",
	["Eastern Zul'Kunda Digsite"] = "祖昆達東部挖掘場",
	["Eastern Zul'Mamwe Digsite"] = "祖瑪維東部挖掘場",
	["Eastmoon Ruins Digsite"] = "東月廢墟挖掘場",
	["Eclipse Point Digsite"] = "日蝕崗哨挖掘場",
	["En'kilah Digsite"] = "恩吉拉挖掘場",
	["Ethel Rethor Digsite"] = "艾瑟雷索挖掘場",
	["Felstone Fossil Field"] = "費爾斯通古原野",
	["Fields of Blood Fossil Bank"] = "鮮血草原古河岸",
	["Forest Song Digsite"] = "林歌神殿挖掘場",
	["Frostwhisper Gorge Digsite"] = "霜語峽谷挖掘場",
	["Gjalerbron Digsite"] = "夏勒布隆挖掘場",
	["Gor'gaz Outpost Digsite"] = "葛卡茲哨站挖掘場",
	["Grangol'var Village Digsite"] = "葛蘭戈瓦村挖掘場",
	["Greenwarden's Fossil Bank"] = "綠意守望者之林古河岸",
	["Grim Batol Digsite"] = "格瑞姆巴托挖掘場",
	["Grimesilt Digsite"] = "煤渣挖掘場",
	["Grimsilt Digsite"] = "煤渣挖掘場", -- Needs review
	["Grove of Aessina Digsite"] = "艾森娜之林挖掘場",
	["Gurubashi Arena Digsite"] = "古拉巴什競技場挖掘場",
	["Halaa Digsite"] = "哈剌挖掘場",
	["Halgrind Digsite"] = "霍葛萊挖掘場",
	["Hammertoe's Digsite"] = "鐵趾挖掘場",
	["Hellfire Basin Digsite"] = "地獄火盆地挖掘場",
	["Hellfire Citadel Digsite"] = "地獄火堡壘挖掘場",
	["Humboldt Conflagration Digsite"] = "杭伯特焚焰地挖掘場",
	["Illidari Point Digsite"] = "伊利達瑞崗哨挖掘場",
	["Infectis Scar Fossil Field"] = "魔刃之痕古原野",
	["Ironband's Excavation Site"] = "鐵環挖掘場",
	["Ironbeard's Tomb"] = "鐵鬚之墓",
	["Ironwood Digsite"] = "鐵木挖掘場",
	["Jaedenar Digsite"] = "加德納爾挖掘場",
	["Jintha'Alor Lower City Digsite"] = "辛薩羅城下層挖掘場",
	["Jintha'Alor Upper City Digsite"] = "辛薩羅城上層挖掘場",
	["Jotunheim Digsite"] = "卓頓海姆挖掘場",
	["Keset Pass Digsite"] = "奇瑟小徑挖掘場",
	["Khartut's Tomb Digsite"] = "卡爾吐特之墓挖掘場",
	["Kodo Graveyard"] = "科多獸墳場",
	["Kolramas Digsite"] = "科爾拉瑪斯挖掘場",
	["Lake Kel'Theril Digsite"] = "凱斯利爾湖挖掘場",
	["Lakeridge Highway Fossil Bank"] = "湖邊大道古河岸",
	["Laughing Skull Digsite"] = "獰笑骷髏挖掘場",
	["Lower Lakkari Tar Pits"] = "拉卡利油沼低地",
	["Mannoroc Coven Digsite"] = "瑪諾洛克集會所挖掘場",
	["Marshlands Fossil Bank"] = "沼澤地古河岸",
	["Misty Reed Fossil Bank"] = "蘆葦古河岸",
	["Moonrest Gardens Digsite"] = "月眠花園挖掘場",
	["Morlos'Aran Digsite"] = "莫洛亞藍挖掘場",
	["Nazj'vel Digsite"] = "納傑韋爾挖掘場",
	["Neferset Digsite"] = "奈斐賽特挖掘場",
	["Nek'mani Wellspring Digsite"] = "納克邁尼聖泉挖掘場",
	["Nifflevar Digsite"] = "尼弗瓦挖掘場",
	["Nightmare Scar Digsite"] = "惡夢之痕挖掘場",
	["Njorndar Village Digsite"] = "尼約達村挖掘場",
	["North Isildien Digsite"] = "伊斯迪爾北部挖掘場",
	["Northridge Fossil Field"] = "北山古化石原野",
	["Obelisk of the Stars Digsite"] = "眾星方尖碑挖掘場",
	["Oneiros Digsite"] = "奧奈羅斯挖掘場",
	["Orsis Digsite"] = "奧爾希斯挖掘場",
	["Owl Wing Thicket Digsite"] = "梟翼樹叢挖掘場",
	["Pit of Fiends Digsite"] = "魔鬼之淵挖掘場",
	["Pit of Narjun Digsite"] = "那金之淵挖掘場",
	["Plaguewood Digsite"] = "病木林挖掘場",
	["Pyrox Flats Digsite"] = "派洛克斯平原挖掘場",
	["Quagmire Fossil Field"] = "泥潭沼澤古原野",
	["Quel'Lithien Lodge Digsite"] = "奎爾林斯小屋挖掘場",
	["Ravenwind Digsite"] = "鴉風挖掘場",
	["Red Reaches Fossil Bank"] = "紅色海岸古河岸",
	["Riplash Ruins Digsite"] = "裂鞭遺跡挖掘場",
	["River Delta Digsite"] = "三角洲挖掘場",
	["Ruins of Aboraz"] = "阿博拉茲廢墟",
	["Ruins of Ahmtul Digsite"] = "阿姆圖爾廢墟挖掘場",
	["Ruins of Ammon Digsite"] = "亞蒙廢墟挖掘場",
	["Ruins of Arkkoran"] = "亞考蘭廢墟",
	["Ruins of Baa'ri Digsite"] = "巴瑞廢墟挖掘場",
	["Ruins of Eldarath"] = "埃達拉斯廢墟",
	["Ruins of Eldre'Thar"] = "艾爾德雷薩廢墟",
	["Ruins of Enkaat Digsite"] = "安卡特廢墟挖掘場",
	["Ruins of Farahlon Digsite"] = "法拉隆廢墟挖掘場",
	["Ruins of Jubuwal"] = "朱布瓦爾廢墟",
	["Ruins of Khintaset Digsite"] = "克因塔賽廢墟挖掘場",
	["Ruins of Lar'donir Digsite"] = "拉多尼爾廢墟挖掘場",
	["Ruins of Ordil'Aran"] = "奧迪拉蘭廢墟",
	["Ruins of Shandaral Digsite"] = "珊達拉遺跡挖掘場",
	["Ruins of Stardust"] = "星塵廢墟",
	["Sahket Wastes Digsite"] = "薩克特荒原挖掘場",
	["Sanctuary of Malorne Digsite"] = "瑪洛尼聖地挖掘場",
	["Sands of Nasam"] = "納森沙地",
	["Sargeron Digsite"] = "薩格隆挖掘場",
	["Savage Coast Raptor Fields"] = "野人海岸迅猛龍平原",
	["Schnottz's Landing"] = "舒諾茲營地",
	["Scorched Plain Digsite"] = "烈焰平原挖掘場",
	["Scourgeholme Digsite"] = "天譴岸地挖掘場",
	["Screaming Reaches Fossil Field"] = "尖嘯河岸古原野",
	["Sha'naar Digsite"] = "夏納挖掘場",
	["Shadra'Alor Digsite"] = "沙德拉洛挖掘場",
	["Shield Hill Digsite"] = "盾丘挖掘場",
	["Shrine of Goldrinn Digsite"] = "戈德林聖壇挖掘場",
	["Sifreldar Village Digsite"] = "希弗爾達村挖掘場",
	["Skorn Digsite"] = "斯考恩挖掘場",
	["Slitherblade Shore Digsite"] = "滑刃水濱挖掘場",
	["Solarsal Digsite"] = "索蘭薩爾挖掘場",
	["South Isildien Digsite"] = "伊斯迪爾南部挖掘場",
	["Southmoon Ruins Digsite"] = "南月廢墟挖掘場",
	["Southshore Fossil Field"] = "南海鎮古原野",
	["Southwind Village Digsite"] = "南風村挖掘場",
	["Steps of Fate Digsite"] = "天命之階挖掘場",
	["Stonetalon Peak"] = "石爪峰",
	["Sunken Temple Digsite"] = "沉沒的神廟挖掘場",
	["Sunspring Post Digsite"] = "日春崗哨挖掘場",
	["Talramas Digsite"] = "塔爾拉瑪斯挖掘場",
	["Temple of Uldum Digsite"] = "奧丹姆神廟挖掘場",
	["Terror Run Fossil Field"] = "恐懼小道古原野",
	["Terror Wing Fossil Field"] = "龍翼小徑古原野",
	["Terrorweb Tunnel Digsite"] = "惡蛛隧道挖掘場",
	["Thandol Span"] = "薩多爾大橋",
	["Thoradin's Wall"] = "索拉丁之牆",
	["Thundermar Ruins Digsite"] = "桑德瑪遺跡挖掘場",
	["Tomb of the Watchers Digsite"] = "看守者之墓挖掘場",
	["Tombs of the Precursors Digsite"] = "先驅者之墓挖掘場",
	["Tuurem Digsite"] = "杜瑞挖掘場",
	["Twilight Grove Digsite"] = "暮光森林挖掘場",
	["Twin Spire Ruins Digsite"] = "雙塔廢墟挖掘場",
	["Uldaman Entrance Digsite"] = "奧達曼挖掘場",
	["Unearthed Grounds"] = "掘出的遺址",
	["Upper Lakkari Tar Pits"] = "拉卡利油沼高原",
	["Valkyrion Digsite"] = "華爾基倫挖掘場",
	["Valley of Bones"] = "白骨之谷",
	["Violet Stand Digsite"] = "紫羅蘭看臺挖掘場",
	["Voldrune Digsite"] = "沃德盧恩挖掘場",
	["Vul'Gol Fossil Bank"] = "沃古爾古河岸",
	["Warden's Cage Digsite"] = "典獄官監牢挖掘場",
	["West Auchindoun Digsite"] = "奧齊頓西部挖掘場",
	["Western Ruins of Thaurissan"] = "索瑞森西部廢墟",
	["Western Zul'Kunda Digsite"] = "祖昆達西部挖掘場",
	["Western Zul'Mamwe Digsite"] = "祖瑪維西部挖掘場",
	["Whelgar's Excavation Site"] = "維爾加挖掘場",
	["Witherbark Digsite"] = "枯木挖掘場",
	["Wyrmbog Fossil Field"] = "巨龍泥沼古原野",
	["Wyrmskull Digsite"] = "龍顱挖掘場",
	["Ymirheim Digsite"] = "依米海姆挖掘場",
	["Zeth'Gor Digsite"] = "薩斯葛爾挖掘場",
	["Ziata'jai Digsite"] = "贊塔加挖掘場",
	["Zim'Rhuk Digsite"] = "辛茹克挖掘場",
	["Zol'Heb Digsite"] = "佐爾希伯挖掘場",
	["Zoram Strand Digsite"] = "佐拉姆海岸挖掘場",
	["Zul'Farrak Digsite"] = "祖爾法拉克挖掘場",
	["Zul'Mashar Digsite"] = "祖爾瑪夏挖掘場",
}

)

else
	error(("%s: Locale %q not supported"):format(MAJOR_VERSION, GAME_LOCALE))
end
