
BetterOutbox = LibStub("AceAddon-3.0"):NewAddon("BetterOutbox", "AceEvent-3.0")

local db
local defaults = {
	profile = {
		alts = {},
		lastRecipient = {}
	}
}
local alts
local realmName = GetRealmName()
local playerName = UnitName("player")
local englishFaction, localizedFaction = UnitFactionGroup("player")

local gformat = MONEY.." (%d"..GOLD_AMOUNT_SYMBOL.." %d"..SILVER_AMOUNT_SYMBOL.." %d"..COPPER_AMOUNT_SYMBOL..")"
local sformat = MONEY.." (%d"..SILVER_AMOUNT_SYMBOL.." %d"..COPPER_AMOUNT_SYMBOL..")"
local cformat = MONEY.." (%d"..COPPER_AMOUNT_SYMBOL..")"

local gpattern = "^"..MONEY.." %(%d+"..GOLD_AMOUNT_SYMBOL.." %d+"..SILVER_AMOUNT_SYMBOL.." %d+"..COPPER_AMOUNT_SYMBOL.."%)$"
local spattern = "^"..MONEY.." %(%d+"..SILVER_AMOUNT_SYMBOL.." %d+"..COPPER_AMOUNT_SYMBOL.."%)$"
local cpattern = "^"..MONEY.." %(%d+"..COPPER_AMOUNT_SYMBOL.."%)$"

local function MoneyString( money )
	if not money or money <= 0 then return "" end
	local gold = abs(money / 10000)
	local silver = abs(mod(money / 100, 100))
	local copper = abs(mod(money, 100))
	if money >= 10000 then
		return string.format( gformat, gold, silver, copper)
	elseif money >= 100 then
		return string.format( sformat, silver, copper)
	else 
		return string.format( cformat, copper )
	end
end

local function CheckMoney()
	local subject = SendMailSubjectEditBox:GetText()
	if subject == "" or subject:find(gpattern) or subject:find(spattern) or subject:find(cpattern) then
		local money = MoneyInputFrame_GetCopper(SendMailMoney)
		SendMailSubjectEditBox:SetText( MoneyString(money) )
	end
end


local function NameCompletion( f, t )
	local text = f:GetText()
	local textlen = strlen(text)
	
	local num, name
	
	-- First check registered alts
	for name, v in pairs( alts ) do
		if name and text and strfind(strupper(name), strupper(text), 1, 1) == 1 then
			f:SetText(name)
			if f:IsInIMECompositionMode() then
				f:HighlightText(textlen - strlen(t), -1)
			else
				f:HighlightText(textlen, -1)
			end
			return
		end
	end
	
	-- Check Friends
	num = GetNumFriends() or 0
	if num > 0 then
		for i=1, num do
			name = GetFriendInfo(i)
			if name and text and strfind(strupper(name), strupper(text), 1, 1) == 1  then
				f:SetText(name)
				if f:IsInIMECompositionMode() then
					f:HighlightText(textlen - strlen(t), -1)
				else
					f:HighlightText(textlen, -1)
				end
				return
			end
		end
	end	
	-- Check Guild
	num = GetNumGuildMembers(true) or 0-- true to include offline members
	if num > 0 then
		for i=1, num do
			name = GetGuildRosterInfo(i)
			if name and text and strfind(strupper(name), strupper(text), 1, 1) == 1 then
				f:SetText(name)
				if f:IsInIMECompositionMode() then
					f:HighlightText(textlen - strlen(t), -1)
				else
					f:HighlightText(textlen, -1)
				end
				return
			end
		end
	end	
end

local function SendMailHook(...)
	BetterOutbox.lastRecipient = SendMailNameEditBox:GetText()
	db.lastRecipient[playerName.." - "..realmName] = BetterOutbox.lastRecipient
	BetterOutbox.oldSendMailFrame_SendMail(...)
end


function BetterOutbox:OnInitialize()
	self.db = LibStub("AceDB-3.0"):New("BetterOutboxDB", defaults, "Default")
	db = self.db.profile
	-- register this char as an alt
	if not db.alts[realmName.."::"..englishFaction] then
		db.alts[realmName.."::"..englishFaction] = {}
	end
	alts = db.alts[realmName.."::"..englishFaction]
	alts[playerName] = true
	
	self.lastRecipient = db.lastRecipient[playerName.." - "..realmName]
end

function BetterOutbox:OnEnable()
	
	self:RegisterEvent("MAIL_SEND_SUCCESS")
	self:RegisterEvent("MAIL_SHOW", "MAIL_SEND_SUCCESS")

	self.oldOnChar = SendMailNameEditBox:GetScript("onChar")
	self.oldOnCharComposition = SendMailNameEditBox:GetScript("onCharComposition")
	
	SendMailNameEditBox:SetScript( "onChar", function(f, ...) NameCompletion(f) end)
	SendMailNameEditBox:SetScript( "onCharComposition", function(f, ...) if not f:IsInIMECompositionMode() then NameCompletion(f) end end )
	
	self.oldOnValueChangedFunc = SendMailMoney.onValueChangedFunc
	SendMailMoney.onValueChangedFunc = CheckMoney
	
	self.oldSendMailFrame_SendMail = SendMailFrame_SendMail
	SendMailFrame_SendMail = SendMailHook
	
	self:MAIL_SEND_SUCCESS()
end

function BetterOutbox:MAIL_SEND_SUCCESS()
	if self.lastRecipient then
		SendMailNameEditBox:SetText(self.lastRecipient)
		SendMailNameEditBox:HighlightText()
		SendMailNameEditBox:SetFocus()
	end
end


