local mod	= DBM:NewMod(332, "DBM-DragonSoul", nil, 187)
local L		= mod:GetLocalizedStrings()

mod:SetRevision(("$Revision: 6914 $"):sub(12, -3))
mod:SetCreatureID(56598)--56427 is Boss, but engage trigger needs the ship which is 56598
mod:SetModelID(39399)
mod:SetZone()
mod:SetUsedIcons(7, 8)

mod:RegisterCombat("combat")
mod:SetMinCombatTime(20)

mod:RegisterEventsInCombat(
	"SPELL_CAST_START",
	"SPELL_CAST_SUCCESS",
	"SPELL_AURA_APPLIED",
	"SPELL_AURA_APPLIED_DOSE",
	"SPELL_AURA_REMOVED",
	"SPELL_SUMMON",
	"SPELL_DAMAGE",
	"SPELL_MISSED",
	"RAID_BOSS_EMOTE",
	"CHAT_MSG_RAID_BOSS_EMOTE",
	"UNIT_DIED"
--	"UNIT_SPELLCAST_SUCCEEDED"
)

local warnHarpoon					= mod:NewTargetAnnounce(108038, 2)
local warnTwilightOnslaught			= mod:NewCountAnnounce(108862, 4)
local warnPhase2					= mod:NewPhaseAnnounce(2, 3)
local warnRoar						= mod:NewSpellAnnounce(109228, 2)
local warnTwilightFlames			= mod:NewSpellAnnounce(108051, 3)
local warnShockwave					= mod:NewTargetAnnounce(108046, 4)
local warnSunder					= mod:NewStackAnnounce(108043, 3, nil, mod:IsTank() or mod:IsHealer())
local warnConsumingShroud			= mod:NewTargetAnnounce(110214, 3)
local warnTwilightBreath   = mod:NewSpellAnnounce(110212, 4)

local specWarnHarpoon				= mod:NewSpecialWarningTarget(108038, false)
local specWarnTwilightOnslaught		= mod:NewSpecialWarningSpell(107588, nil, nil, nil, true)
local specWarnShockwaveNear			= mod:NewSpecialWarningClose(108046)
local specWarnShockwave				= mod:NewSpecialWarningMove(108046)
local specWarnTwilightFlames		= mod:NewSpecialWarningMove(108076)
local yellShockwave					= mod:NewYell(108046)
local specWarnSunder				= mod:NewSpecialWarningStack(108043, mod:IsTank() or mod:IsHealer(), 3)
local specWarnTwilightBreath   = mod:NewSpecialWarningSpell(110212)

local timerCombatStart				= mod:NewTimer(20.5, "TimerCombatStart", 2457)
local timerHumanAdds   = mod:NewTimer(23, "TimerHumanAddsCD", 61131)
local timerTwilightOnslaughtCD		= mod:NewNextCountTimer(35, 107588)
local timerSapperCD					= mod:NewTimer(40, "TimerSapper", 107752)
local timerDeckFireCD				= mod:NewCDTimer(20, 110095)--Not the best log, so not sure if this is accurate or actually based on other variables.
local timerRoarCD					= mod:NewCDTimer(19, 109228)--19~22 variables
local timerTwilightFlamesCD			= mod:NewNextTimer(8, 108051)
local timerShockwaveCD				= mod:NewCDTimer(23, 108046)
local timerSunder					= mod:NewTargetTimer(30, 108043, nil, false)
--local timerBladeRush					= mod:NewCDTimer(15, 107594)
local timerConsumingShroud					= mod:NewCDTimer(31, 110214)
local timerTwilightBreath					= mod:NewCDTimer(20, 110212)

local berserkTimer					= mod:NewBerserkTimer(250)

local sndWOP	= mod:NewSound(nil, "SoundWOP", true)

mod:AddBoolOption("SetIconOnShockwave", true)

local phase2Started = false
local lastFlames = 0
local addcount = 0
local slaughtcount = 0

function mod:ShockwaveTarget()
	local targetname = self:GetBossTarget(56427)
	if not targetname then return end
	warnShockwave:Show(targetname)
	if self.Options.SetIconOnShockwave then
		self:SetIcon(targetname, 8, 3)
	end	
	if targetname == UnitName("player") then
		specWarnShockwave:Show()
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\runaway.mp3")
		yellShockwave:Yell()
	else
		local uId = DBM:GetRaidUnitId(targetname)
		if uId then
			local x, y = GetPlayerMapPosition(uId)
			if x == 0 and y == 0 then
				SetMapToCurrentZone()
				x, y = GetPlayerMapPosition(uId)
			end
			local inRange = DBM.RangeCheck:GetDistance("player", x, y)
			if inRange and inRange < 6 then--Might be able to tune range?
				specWarnShockwaveNear:Show(targetname)
				sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\runaway.mp3")
			else
				sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\watchwave.mp3")
			end
		end
	end
end

function mod:repeatHumanAdds()
	addcount = addcount + 1
	if addcount < 3 then
		timerHumanAdds:Start(62)
		self:ScheduleMethod(62, "repeatHumanAdds")
	end
end

function mod:OnCombatStart(delay)
	phase2Started = false
	lastFlames = 0
	addcount = 0
	slaughtcount = 0
	timerCombatStart:Start(-delay)
	timerHumanAdds:Start(24-delay)
	self:ScheduleMethod(24-delay, "repeatHumanAdds")
	if not self:IsDifficulty("lfr25") then
		timerSapperCD:Start(69-delay)
	end
	if self:IsDifficulty("heroic10", "heroic25") then
		timerTwilightOnslaughtCD:Start(48-delay, 1)--Not sure if variation is cause it was heroic or cause the first one is not consistent
		timerDeckFireCD:Start(60-delay)--Consistent?
	else
		timerTwilightOnslaughtCD:Start(48-delay, 1)
	end
end

function mod:SPELL_CAST_START(args)
	if args:IsSpellID(107588) then
		slaughtcount = slaughtcount + 1
		warnTwilightOnslaught:Show(slaughtcount)
		specWarnTwilightOnslaught:Show()
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\stackpurple.mp3")
		timerTwilightOnslaughtCD:Start(35, slaughtcount+1)
	elseif args:IsSpellID(108046) then
		self:ScheduleMethod(0.2, "ShockwaveTarget")
		timerShockwaveCD:Start()
	elseif args:IsSpellID(110212) then		
		warnTwilightBreath:Show()
		specWarnTwilightBreath:Show()
		timerTwilightBreath:Start()
	end
end

function mod:SPELL_CAST_SUCCESS(args)
	if args:IsSpellID(108044, 109228, 109229, 109230) then -- 108044 is 10 man / 109228 lfr. other drycoded.
		warnRoar:Show()
		timerRoarCD:Start()
	end
end

function mod:SPELL_AURA_APPLIED(args)
	if args:IsSpellID(108043) then
		warnSunder:Show(args.destName, args.amount or 1)
		timerSunder:Start(args.destName)
		if (args.amount or 0) >= 3 then
			specWarnSunder:Show(args.amount)
		end
	elseif args:IsSpellID(108038) then
		warnHarpoon:Show(args.destName)
		specWarnHarpoon:Show(args.destName)
	--"<2059.6> [CLEU] SPELL_AURA_APPLIED#false#0xF150DFAC0000253E#Skyfire Cannon#2584#0#0xF150DFAC0000253E#Skyfire Cannon#2584#0#108040#Artillery Barrage#5#BUFF", -- [61321]
	--"<2067.7> [CAST_SUCCEEDED] Goriona:Possible Target<nil>:target:Eject Passenger 1::0:60603", -- [61429]
	--"<2069.5> [MONSTER_YELL] CHAT_MSG_MONSTER_YELL#Looks like I'm doing this myself. Good!#Warmaster Blackhorn###Goriona##0#0##0#564##0#false", -- [61454]
	elseif args:IsSpellID(108040) and not phase2Started then--Goriona is being shot by the ships Artillery Barrage (phase 2 trigger)
		phase2Started = true
		timerTwilightOnslaughtCD:Cancel()
		timerSapperCD:Cancel()
		timerDeckFireCD:Cancel()--This continue into phase 2 or do we cancel it?
		warnPhase2:Show()
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\ptwo.mp3")
		timerCombatStart:Start(8)--Shorter now on live? 5-6 seems about right now. Lets try 5.
		timerRoarCD:Start(22)
		timerTwilightFlamesCD:Start(22)
		timerShockwaveCD:Start()--23-26 second variation
		if not self:IsDifficulty("lfr25") then--Assumed, but i find it unlikely a 4 min berserk timer will be active on LFR
			berserkTimer:Start()
		end
	elseif args:IsSpellID(110214) then
		warnConsumingShroud:Show(args.destName)
		timerConsumingShroud:Start()
	end
end		
mod.SPELL_AURA_APPLIED_DOSE = mod.SPELL_AURA_APPLIED

function mod:SPELL_AURA_REMOVED(args)
	if args:IsSpellID(108043) then
		if self:IsTank() or self:IsHealer() then
			sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\changemt.mp3")
		end
	end
end

function mod:SPELL_SUMMON(args)
	if args:IsSpellID(108051, 109216, 109217, 109218) then
		warnTwilightFlames:Show()
		timerTwilightFlamesCD:Start()
	end
end

function mod:SPELL_DAMAGE(args)
	if args:IsSpellID(108076, 109222, 109223, 109224) then
		if args:IsPlayer() and GetTime() - lastFlames > 3  then
			specWarnTwilightFlames:Show()
			sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\runaway.mp3")
			lastFlames = GetTime()
		end
	end
end
mod.SPELL_MISSED = mod.SPELL_DAMAGE

function mod:RAID_BOSS_EMOTE(msg)
	if msg == L.SapperEmote or msg:find(L.SapperEmote) then
		if not phase2Started then
			timerSapperCD:Start()
		end
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\goblinappear.mp3")
	elseif msg:find(L.DeckFire) then
		timerDeckFireCD:Start()
	end
end

function mod:CHAT_MSG_RAID_BOSS_EMOTE(msg)
	if msg == L.GorionaLeave or msg:find(L.GorionaLeave) then
		timerTwilightFlamesCD:Cancel()
	end
end

function mod:UNIT_DIED(args)
	local cid = self:GetCIDFromGUID(args.destGUID)
	if cid == 56427 then
		DBM:EndCombat(self)
--	elseif cid == 56854 or cid == 56848 then
--		timerBladeRush:Cancel(args.sourceGUID)
	end
end

--function mod:UNIT_SPELLCAST_SUCCEEDED(uId, spellName, _, _, spellID)
--	if spellName == GetSpellInfo(107594) then--Blade Rush
--		timerBladeRush:Start(uId)
--	end
--end