local mod	= DBM:NewMod(317, "DBM-DragonSoul", nil, 187)
local L		= mod:GetLocalizedStrings()

mod:SetRevision(("$Revision: 6905 $"):sub(12, -3))
mod:SetCreatureID(55689)
mod:SetModelID(39318)
mod:SetZone()
mod:SetUsedIcons(1, 2, 3, 4, 5, 6, 7, 8)

mod:RegisterCombat("combat")

mod:RegisterEventsInCombat(
	"SPELL_CAST_SUCCESS",
	"SPELL_AURA_APPLIED",
	"SPELL_AURA_APPLIED_DOSE",
	"SPELL_AURA_REMOVED",
	"SPELL_CAST_START"
)

local warnTempest			= mod:NewCastAnnounce(109552, 4)
local warnLightningStorm	= mod:NewSpellAnnounce(105465, 4)
local warnAssault			= mod:NewSpellAnnounce(107851, 4, nil, mod:IsHealer() or mod:IsTank())
local warnShatteringIce		= mod:NewTargetAnnounce(105289, 3, nil, false)--3 second cast, give a healer a heads up of who's about to be kicked in the face.
local warnFrostTombCast		= mod:NewAnnounce("warnFrostTombCast", 4, 104448)--Can't use a generic, cause it's an 8 second cast even though it says 1second in tooltip.
local warnFrostTomb			= mod:NewTargetAnnounce(104451, 4)
local warnIceLance			= mod:NewTargetAnnounce(105297, 3)
local warnFrostflake		= mod:NewTargetAnnounce(109325, 3)	-- verify with logs
local warnStormPillars		= mod:NewSpellAnnounce(109557, 3)	-- verify with logs

local specWarnFrostTombCast	= mod:NewSpecialWarningSpell(104451, nil, nil, nil, true)
local specWarnTempest		= mod:NewSpecialWarning("specWarnFrozenPhase")
local specWarnLightingStorm	= mod:NewSpecialWarning("specWarnLightningPhase")
local specWarnAssault		= mod:NewSpecialWarningSpell(107851, mod:IsTank())
local specWarnWatery		= mod:NewSpecialWarningMove(110317)
local specWarnFrostflake		= mod:NewSpecialWarningYou(109325)
local specWarnIceLance			= mod:NewSpecialWarningStack(107062, true, 4)
local yellFrostflake					= mod:NewYell(109325)

local timerFrostTomb		= mod:NewCastTimer(8, 104448)
local timerFrostTombCD		= mod:NewNextTimer(20, 104451)
local timerIceLance			= mod:NewBuffActiveTimer(15, 105269)
local timerIceLanceCD		= mod:NewNextTimer(30, 105269)
local timerSpecialCD		= mod:NewTimer(30, "TimerSpecial", "Interface\\Icons\\Spell_Nature_WispSplode")
local timerTempestCD		= mod:NewNextTimer(62, 105256)
local timerLightningStormCD	= mod:NewNextTimer(62, 105465)
local timerIceWave			= mod:NewNextTimer(10, 105314)
local timerFeedback			= mod:NewBuffActiveTimer(15, 108934)
local timerAssaultCD		= mod:NewCDTimer(15, 107851, nil, mod:IsTank())
local timerShatteringIceCD  = mod:NewCDTimer(10, 105289, nil, mod:IsHealer())

--local soundFrostTomb		= mod:NewSound(104451)--Needed?
local berserkTimer				= mod:NewBerserkTimer(480)	-- according to Icy-Veins

local sndWOP	= mod:NewSound(nil, "SoundWOP", true)

--mod:AddBoolOption("RangeFrame")--Ice lance spreading. May make it more dynamic later but for now i need to see the fight in realtime before i can do any more guessing off mailed in combat logs.
mod:AddBoolOption("SetIconOnFrostTomb", true)
mod:AddBoolOption("SetIconOnLance", true)
mod:AddBoolOption("AnnounceFrostTombIcons", false)

local lanceTargets = {}
local tombTargets = {}
local tombIconTargets = {}
--local playerTombed = false
local lanceIcon = 8
local igotlance = false

function mod:ShatteredIceTarget()
	local targetname = self:GetBossTarget(55689)
	if not targetname then return end
	warnShatteringIce:Show(targetname)
	timerShatteringIceCD:Start()
end

function mod:OnCombatStart(delay)
	table.wipe(lanceTargets)
	table.wipe(tombIconTargets)
	table.wipe(tombTargets)
	lanceIcon = 8
	igotlance = false
	timerAssaultCD:Start(4-delay)
	timerIceLanceCD:Start(12-delay)
--	timerFrostTombCD:Start(16-delay)--No longer cast on engage? most recent log she only casts it after specials now and not after pull
	timerSpecialCD:Start(30-delay)
	berserkTimer:Start(-delay)
--	if self.Options.RangeFrame then
--		DBM.RangeCheck:Show(3)
--	end
end

function mod:OnCombatEnd()
--	if self.Options.RangeFrame then
--		DBM.RangeCheck:Hide()
--	end
end

local function warnLanceTargets()
	warnIceLance:Show(table.concat(lanceTargets, "<, >"))
	timerIceLance:Start()
	timerIceLanceCD:Start()
	table.wipe(lanceTargets)
	lanceIcon = 8
end

local function ClearTombTargets()
	table.wipe(tombIconTargets)
end

local function ClearLanceOnMe()
	igotlance = false
end

do
	local function sort_by_group(v1, v2)
		return DBM:GetRaidSubgroup(UnitName(v1)) < DBM:GetRaidSubgroup(UnitName(v2))
	end
	function mod:SetTombIcons()
		if DBM:GetRaidRank() > 0 then
			table.sort(tombIconTargets, sort_by_group)
			local tombIcons = 1
			for i, v in ipairs(tombIconTargets) do
				if self.Options.AnnounceFrostTombIcons and IsRaidLeader() then
					SendChatMessage(L.TombIconSet:format(tombIcons, UnitName(v)), "RAID")
				end
				self:SetIcon(UnitName(v), tombIcons)
				tombIcons = tombIcons + 1
			end
			self:Schedule(8, ClearTombTargets)
		end
	end
end

local function warnTombTargets()
	warnFrostTomb:Show(table.concat(tombTargets, "<, >"))
	specWarnFrostTombCast:Show()
	if not mod:IsHealer() then
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\killicetomb.mp3")
	end
	table.wipe(tombTargets)
end

function mod:SPELL_CAST_SUCCESS(args)
	if args:IsSpellID(105297) then
		lanceTargets[#lanceTargets + 1] = args.sourceName
		if args.sourceName == UnitName("player") then
			igotlance = true
			self:Schedule(20, ClearLanceOnMe)
		end
		if self.Options.SetIconOnLance then
			self:SetIcon(args.sourceName, lanceIcon, 18)
			lanceIcon = lanceIcon - 1
		end		
		self:Unschedule(warnLanceTargets)
		if (self:IsDifficulty("normal10", "heroic10", "lfr25") and #lanceTargets >= 3) then
			warnLanceTargets()
		else
			self:Schedule(0.5, warnLanceTargets)
		end
	elseif args:IsSpellID(109557, 109541) then
		warnStormPillars:Show()
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\stormpillar.mp3")
	end
end	

function mod:SPELL_AURA_APPLIED(args)
	if args:IsSpellID(104451) then--104451 25 man normal confirmed.
		tombTargets[#tombTargets + 1] = args.destName
		if self.Options.SetIconOnFrostTomb then
			table.insert(tombIconTargets, DBM:GetRaidUnitId(args.destName))
			self:UnscheduleMethod("SetTombIcons")
			--know 25 normal is 5, the rest are just guessed based on similar mechanic off Sindragosa
			if (self:IsDifficulty("normal25") and #tombIconTargets >= 5) or (self:IsDifficulty("heroic25") and #tombIconTargets >= 6) or (self:IsDifficulty("normal10", "heroic10") and #tombIconTargets >= 2) then
				self:SetTombIcons()--Sort and fire as early as possible once we have all targets.
			else
				if self:LatencyCheck() then--Icon sorting is still sensitive and should not be done by laggy members that don't have all targets.
					self:ScheduleMethod(0.3, "SetTombIcons")
				end
			end
		end
		self:Unschedule(warnTombTargets)
		if (self:IsDifficulty("normal25") and #tombTargets >= 5) or (self:IsDifficulty("heroic25") and #tombTargets >= 6) or (self:IsDifficulty("normal10", "heroic10") and #tombTargets >= 2) then
			warnTombTargets()
		else
			self:Schedule(0.3, warnTombTargets)
		end
	elseif args:IsSpellID(107851, 110898, 110899, 110900) then--107851 10/25 man normal confirmed. 110900 is lfr25 difficulty.
		warnAssault:Show()
		specWarnAssault:Show()
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\"..GetLocale().."\\focusattack.mp3")
		timerAssaultCD:Start()
		if self:IsTank() or self:IsHealer() then
			sndWOP:Schedule(12, "Interface\\AddOns\\DBM-Core\\extrasounds\\countthree.mp3")
			sndWOP:Schedule(13, "Interface\\AddOns\\DBM-Core\\extrasounds\\counttwo.mp3")
			sndWOP:Schedule(14, "Interface\\AddOns\\DBM-Core\\extrasounds\\countone.mp3")
		end
	elseif args:IsSpellID(110317) then
		if args:IsPlayer() then
			specWarnWatery:Show()
		end
	elseif args:IsSpellID(109325) then
		warnFrostflake:Show(args.destName)
		if args:IsPlayer() then
			specWarnFrostflake:Show()
			sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\frostflake.mp3")
			yellFrostflake:Yell()
		end
	end
end

function mod:SPELL_AURA_APPLIED_DOSE(args)
	if args:IsSpellID(107062) and args:IsPlayer() then
		if (args.amount or 0) == 4 or (args.amount or 0) == 6 or (args.amount or 0) == 8 or (args.amount or 0) == 10 then
			specWarnIceLance:Show(args.amount or 1)
			if not igotlance then
				sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\awayline.mp3")
			else
				SendChatMessage(L.YellIceLance, "SAY")		
			end
		end
	end
end

function mod:SPELL_AURA_REMOVED(args)
	if args:IsSpellID(104451) and self.Options.SetIconOnFrostTomb then--104451 10/25 man normal confirmed.
		self:SetIcon(args.destName, 0)
	elseif args:IsSpellID(105256, 109552, 109553, 109554) then--Tempest
		timerIceLanceCD:Start(12)
		timerFeedback:Start()
		if not self:IsDifficulty("lfr25") then--Not used in LFR?
			timerFrostTombCD:Start()
		end
		timerAssaultCD:Start()
		if self:IsTank() or self:IsHealer() then
			sndWOP:Schedule(12, "Interface\\AddOns\\DBM-Core\\extrasounds\\countthree.mp3")
			sndWOP:Schedule(13, "Interface\\AddOns\\DBM-Core\\extrasounds\\counttwo.mp3")
			sndWOP:Schedule(14, "Interface\\AddOns\\DBM-Core\\extrasounds\\countone.mp3")
		end
		timerLightningStormCD:Start()
--		if self.Options.RangeFrame then
--			DBM.RangeCheck:Show(3)
--		end
	elseif args:IsSpellID(105409, 109560, 109561, 109562) then--Water Shield
		timerIceLanceCD:Start(12)
		timerFeedback:Start()
		if not self:IsDifficulty("lfr25") then--Not used in LFR?
			timerFrostTombCD:Start()
		end
		timerAssaultCD:Start()
		if self:IsTank() or self:IsHealer() then
			sndWOP:Schedule(12, "Interface\\AddOns\\DBM-Core\\extrasounds\\countthree.mp3")
			sndWOP:Schedule(13, "Interface\\AddOns\\DBM-Core\\extrasounds\\counttwo.mp3")
			sndWOP:Schedule(14, "Interface\\AddOns\\DBM-Core\\extrasounds\\countone.mp3")
		end
		timerTempestCD:Start()
--		if self.Options.RangeFrame then
--			DBM.RangeCheck:Show(3)
--		end
	end
end

function mod:SPELL_CAST_START(args)
	if args:IsSpellID(104448) then
		warnFrostTombCast:Show(args.spellName)
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\icetombsoon.mp3")
		timerFrostTomb:Start()
	elseif args:IsSpellID(105256, 109552, 109553, 109554) then--109552 25man normal confirmed, rest wowhead drycodes
		timerAssaultCD:Cancel()
		timerIceLanceCD:Cancel()
		timerShatteringIceCD:Cancel()
		if self:IsTank() or self:IsHealer() then
			sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\countthree.mp3")
			sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\counttwo.mp3")
			sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\countone.mp3")
		end
		warnTempest:Show()
		specWarnTempest:Show()
		timerIceWave:Start()
--		if self.Options.RangeFrame then
--			DBM.RangeCheck:Hide()
--		end
	elseif args:IsSpellID(105409, 109560, 109561, 109562) then--Water Shield
		timerAssaultCD:Cancel()
		timerIceLanceCD:Cancel()
		timerShatteringIceCD:Cancel()
		if self:IsTank() or self:IsHealer() then
			sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\countthree.mp3")
			sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\counttwo.mp3")
			sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\countone.mp3")
		end
		warnLightningStorm:Show()
		specWarnLightingStorm:Show()
--		if self.Options.RangeFrame then
--			DBM.RangeCheck:Hide()
--		end
	elseif args:IsSpellID(105289, 108567, 110888) then--105289 10/25 man normal confirmed.
		self:ScheduleMethod(0.2, "ShatteredIceTarget")
	end
end

