local mod	= DBM:NewMod(333, "DBM-DragonSoul", nil, 187)
local L		= mod:GetLocalizedStrings()

mod:SetRevision(("$Revision: 6915 $"):sub(12, -3))
mod:SetCreatureID(56173)
mod:SetModelID(40087)
mod:SetZone()
mod:SetUsedIcons()

mod:RegisterCombat("yell", L.Pull)
mod:SetMinCombatTime(20)

mod:RegisterEventsInCombat(
	"SPELL_CAST_START",
	"SPELL_CAST_SUCCESS",
	"SPELL_AURA_APPLIED",
	"SPELL_AURA_APPLIED_DOSE",
	"SPELL_AURA_REMOVED",
	"UNIT_DIED",
	"UNIT_SPELLCAST_SUCCEEDED"
)

local warnImpale				= mod:NewStackAnnounce(106400, 3, nil, mod:IsTank() or mod:IsHealer())
local warnElementiumBolt		= mod:NewSpellAnnounce(105651, 4)
local warnTentacle				= mod:NewSpellAnnounce(105551, 3)
local warnHemorrhage			= mod:NewSpellAnnounce(105863, 3)
local warnCataclysm				= mod:NewCastAnnounce(106523, 4)
local warnPhase2				= mod:NewPhaseAnnounce(2, 3)
local warnFragments				= mod:NewSpellAnnounce("ej4115", 4, 106708)--This needs a custom spell icon, EJ doesn't have icons for entires that are mobs
local warnTerror				= mod:NewSpellAnnounce(106765, 4)--This needs a fitting spell icon, trigger spell only has a gear.
local warnShrapnel				= mod:NewTargetAnnounce(109598, 3)

local specWarnImpale			= mod:NewSpecialWarningYou(106400)
local specWarnImpaleOther		= mod:NewSpecialWarningTarget(106400, mod:IsTank() or mod:IsHealer())
local specWarnElementiumBolt	= mod:NewSpecialWarningSpell(105651, nil, nil, nil, true)
local specWarnTentacle			= mod:NewSpecialWarning("SpecWarnTentacle", mod:IsDps())--Maybe add healer to defaults too?
local specWarnHemorrhage		= mod:NewSpecialWarningSpell(105863, mod:IsDps())
local specWarnFragments			= mod:NewSpecialWarningSpell("ej4115", nil, nil, nil, true)
local specWarnTerror			= mod:NewSpecialWarningSpell(106765, nil, nil, nil, true)
local specWarnShrapnel			= mod:NewSpecialWarningYou(109598)

local timerImpale				= mod:NewTargetTimer(49.5, 106400, nil, false)
local timerImpaleCD				= mod:NewCDTimer(35, 109633, nil, mod:IsTank() or mod:IsHealer())
local timerElementiumBlast		= mod:NewCastTimer(8, 109600)--8 variation depending on where it's actually going to land. Use the min time on variance to make sure healer Cds aren't up late.
local timerElementiumBoltCD		= mod:NewNextTimer(56, 105651)
local timerHemorrhageCD			= mod:NewCDTimer(100.5, 105863)--Also the earliest observed. Also we use the UNIT event, not emote .3 seconds after it.
local timerCataclysm			= mod:NewCastTimer(60, 106523)
local timerCataclysmCD			= mod:NewCDTimer(130.5, 106523)--130.5-131.5 variations observed in several guilds logs. But DBM always uses the earliest time for a CD, not the average or upper threshold.
local timerFragmentsCD			= mod:NewNextTimer(90, "ej4115", nil, nil, nil, 106708)--Gear icon for now til i find something more suitable
local timerTerrorCD				= mod:NewNextTimer(90, 106765)
local timerMutantCD		= mod:NewTimer(11, "TimerMutant", 109454)
local timerShrapnel				= mod:NewCastTimer(6, 109598)
local timerCrushCD	 = mod:NewNextTimer(7, 106382)

local berserkTimer				= mod:NewBerserkTimer(900)

local sndWOP	= mod:NewSound(nil, "SoundWOP", true)

local firstAspect = true
local engageCount = 0
local phase2 = false
local shrapnelTargets = {}

local function warnShrapnelTargets()
	warnShrapnel:Show(table.concat(shrapnelTargets, "<, >"))
	table.wipe(shrapnelTargets)
end

function mod:OnCombatStart(delay)
	firstAspect = true
	engageCount = 0
	phase2 = false
	table.wipe(shrapnelTargets)
	berserkTimer:Start(-delay)
end

function mod:OnCombatEnd()
end

function mod:SPELL_CAST_START(args)
	if args:IsSpellID(107018) then
		if firstAspect then--The abilities all come 15seconds earlier for first one only
			firstAspect = false
			timerImpaleCD:Start(22)
			timerElementiumBoltCD:Start(40)
			timerHemorrhageCD:Start(85.5)
			timerCataclysmCD:Start(115.5)
			timerMutantCD:Start(11)
			sndWOP:Schedule(11, "Interface\\AddOns\\DBM-Core\\extrasounds\\mutant.mp3")
		else
			timerImpaleCD:Start(28)
			timerElementiumBoltCD:Start()
			timerHemorrhageCD:Start()
			timerCataclysmCD:Start()
			timerMutantCD:Start(17)
			sndWOP:Schedule(17, "Interface\\AddOns\\DBM-Core\\extrasounds\\mutant.mp3")
		end	
	elseif args:IsSpellID(106523, 110042, 110043, 110044) then
		timerCataclysmCD:Cancel()--Just in case it comes early from another minor change like firstAspect change which wasn't on PTR, don't want to confuse peope with two cata bars.
		warnCataclysm:Show()
		timerCataclysm:Start()
	end
end

function mod:SPELL_CAST_SUCCESS(args)
	if args:IsSpellID(105651) then
		warnElementiumBolt:Show()
		specWarnElementiumBolt:Show()
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\boltappear.mp3")
		if not UnitBuff("player", GetSpellInfo(109624)) and not UnitIsDeadOrGhost("player") then--Check for Nozdormu's Presence
			timerElementiumBlast:Start()--Not up, explosion in 10 seconds
			sndWOP:Schedule(4, "Interface\\AddOns\\DBM-Core\\extrasounds\\boomrun.mp3")
			sndWOP:Schedule(5.5, "Interface\\AddOns\\DBM-Core\\extrasounds\\countthree.mp3")
			sndWOP:Schedule(6.5, "Interface\\AddOns\\DBM-Core\\extrasounds\\counttwo.mp3")
			sndWOP:Schedule(7.5, "Interface\\AddOns\\DBM-Core\\extrasounds\\countone.mp3")
		else	
			timerElementiumBlast:Start(18)--Slowed by Nozdormu, explosion in 20 seconds
			sndWOP:Schedule(15.5, "Interface\\AddOns\\DBM-Core\\extrasounds\\countthree.mp3")
			sndWOP:Schedule(16.5, "Interface\\AddOns\\DBM-Core\\extrasounds\\counttwo.mp3")
			sndWOP:Schedule(17.5, "Interface\\AddOns\\DBM-Core\\extrasounds\\countone.mp3")
		end
	elseif args:IsSpellID(110063) and phase2 and self:IsInCombat() then--Astral Recall. Thrall teleports off back platform back to front on defeat.
		DBM:EndCombat(self)
	end
end

function mod:SPELL_AURA_APPLIED(args)
	if args:IsSpellID(106400) then
		warnImpale:Show(args.destName, args.amount or 1)
		timerImpale:Start(args.destName)
		timerImpaleCD:Start()
		if args:IsPlayer() then
			specWarnImpale:Show()
			if UnitBuff("player", GetSpellInfo(109642)) and not UnitIsDeadOrGhost("player") then--Check for Ysera's Presence
				sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\clickshield.mp3")
			else
				sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\watchimpale.mp3")
			end
		else
			specWarnImpaleOther:Show(args.destName)
			sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\watchimpale.mp3")
		end
	elseif args:IsSpellID(106794, 110139, 110140, 110141) then
		shrapnelTargets[#shrapnelTargets + 1] = args.destName
		self:Unschedule(warnShrapnelTargets)
		if args:IsPlayer() then
			specWarnShrapnel:Show()
			timerShrapnel:Start()
			sndWOP:Schedule(1.5, "Interface\\AddOns\\DBM-Core\\extrasounds\\clickshield.mp3")
			sndWOP:Schedule(3, "Interface\\AddOns\\DBM-Core\\extrasounds\\countthree.mp3")
			sndWOP:Schedule(4, "Interface\\AddOns\\DBM-Core\\extrasounds\\counttwo.mp3")
			sndWOP:Schedule(5, "Interface\\AddOns\\DBM-Core\\extrasounds\\countone.mp3")
		end
		if (self:IsDifficulty("normal10") and #shrapnelTargets >= 3) then -- confirmed only in 10man normal
			warnShrapnelTargets()
		else
			self:Schedule(0.3, warnShrapnelTargets)
		end
	end
end		
mod.SPELL_AURA_APPLIED_DOSE = mod.SPELL_AURA_APPLIED


function mod:SPELL_AURA_REMOVED(args)
	if args:IsSpellID(106444, 109631, 109632, 109633) then
		timerImpale:Cancel(args.destName)
	end
end

function mod:UNIT_DIED(args)
	local cid = self:GetCIDFromGUID(args.destGUID)
	if cid == 56167 or cid == 56168 or cid == 56846 then--Wings and Arms. Why only 3 IDs? 1 missing?
		timerElementiumBoltCD:Cancel()
		timerHemorrhageCD:Cancel()--Does this one cancel in event you super overgear this and stomp his ass this fast?
		timerCataclysm:Cancel()
		timerCataclysmCD:Cancel()
--	elseif cid == 56262 then--Elementium Bolt/Meteor
--		timerElementiumBlast:Cancel()--Cancel blast if it dies before hitting ground.
--		sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\countthree.mp3")
--		sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\counttwo.mp3")
--		sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\countone.mp3")
	elseif cid == 56471 then--Mutated Corruption
		timerImpaleCD:Cancel()
	end
end

function mod:UNIT_SPELLCAST_SUCCEEDED(uId, spellName, _, _, spellID)
	if uId == "boss1" or uId == "boss2" then
		if spellName == GetSpellInfo(105853) then
			warnHemorrhage:Show()
			specWarnHemorrhage:Show()
			sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\aeblood.mp3")
		elseif spellName == GetSpellInfo(105551) then--Spawn Blistering Tentacles
			if not UnitBuff("player", GetSpellInfo(109573)) and not UnitIsDeadOrGhost("player") then--Check for Alexstrasza's Presence
				warnTentacle:Show()
				specWarnTentacle:Show()--It's not up so give special warning for these Tentacles.
				sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\blisterling.mp3")
			end
		elseif spellName == GetSpellInfo(106708) and not phase2 then--Slump (Phase 2 start), sometimes it's double warned. bliz bug??
			phase2 = true 
			warnPhase2:Show()
			timerFragmentsCD:Start(11)
			timerTerrorCD:Start(36)
		elseif spellName == GetSpellInfo(106775) then--Summon Impaling Tentacle
			warnFragments:Show()
			specWarnFragments:Show()
			timerFragmentsCD:Start()
		elseif spellName == GetSpellInfo(106765) then--Summon Elementium Terror (Big angry add)
			warnTerror:Show()
			specWarnTerror:Show()
			timerTerrorCD:Start()
		elseif spellID == 106382 then--Crush
			timerCrushCD:Start()
		end
	elseif spellName == GetSpellInfo(110663) then--Elementium Bolt died
		self:SendSync("BoltDied")
	end
end

function mod:OnSync(msg)
	if msg == "BoltDied" then
		timerElementiumBlast:Cancel()--Cancel blast if it dies before hitting ground.
		sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\countthree.mp3")
		sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\counttwo.mp3")
		sndWOP:Cancel("Interface\\AddOns\\DBM-Core\\extrasounds\\countone.mp3")
	end
end