local mod	= DBM:NewMod(324, "DBM-DragonSoul", nil, 187)
local L		= mod:GetLocalizedStrings()

mod:SetRevision(("$Revision: 6924 $"):sub(12, -3))
mod:SetCreatureID(55308)
mod:SetModelID(39138)
mod:SetZone()
mod:SetUsedIcons(6, 7, 8)

mod:RegisterCombat("combat")

mod:RegisterEventsInCombat(
	"SPELL_CAST_SUCCESS",
	"SPELL_AURA_APPLIED",
	"SPELL_AURA_APPLIED_DOSE",
	"SPELL_AURA_REMOVED",
	"UNIT_SPELLCAST_SUCCEEDED",
	"CHAT_MSG_MONSTER_YELL"
)

local warnVoidofUnmaking		= mod:NewSpellAnnounce(103571, 4, 103527)
local warnVoidDiffusion			= mod:NewStackAnnounce(106836, 2)
local warnFocusedAnger			= mod:NewStackAnnounce(104543, 3, nil, false)
local warnPsychicDrain			= mod:NewSpellAnnounce(104322, 4)
local warnShadows				= mod:NewSpellAnnounce(103434, 3)

local specWarnVoidofUnmaking	= mod:NewSpecialWarningSpell(103571, nil, nil, nil, true)
local specWarnBlackBlood		= mod:NewSpecialWarningSpell(104378, nil, nil, nil, true)
local specWarnPsychicDrain		= mod:NewSpecialWarningSpell(104322, false)
local specWarnShadows			= mod:NewSpecialWarningYou(103434)

local timerVoidofUnmakingCD		= mod:NewCDTimer(90, 103571, nil, nil, nil, 103527)
local timerPsychicDrainCD		= mod:NewCDTimer(20, 104322)--Every 20-25 seconds, variates.
local timerShadowsCD			= mod:NewCDTimer(25, 103434, nil, false)--Every 25-30, variates
local timerBlackBlood			= mod:NewBuffActiveTimer(30, 104378)
local timerphasetwobegin		= mod:NewTimer(71, "timerPhaseTwo", "Interface\\Icons\\Spell_Nature_WispSplode")

local berserkTimer				= mod:NewBerserkTimer(360)

local sndWOP	= mod:NewSound(nil, "SoundWOP", true)

mod:AddBoolOption("RangeFrame", true)--For heroic shadows, with debuff filtering.
mod:AddBoolOption("NoFilterRangeFrame", false)--For those that want the range frame to simply work as it used to, always show everyone.
mod:AddBoolOption("DisruptingShadowsIcons", true)

local shadowsTargets	= {}
local shadowIcon = 8
local firstPsychicDrain = true
local lastvoid = 0

local function warnShadowsTargets()
	warnShadows:Show(table.concat(shadowsTargets, "<, >"))
	timerShadowsCD:Start()
	if mod:IsHealer() then
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\dispelnow.mp3")
	end
	table.wipe(shadowsTargets)
	shadowIcon = 8
end

local shadowsDebuffFilter
do
	shadowsDebuffFilter = function(uId)
		return UnitDebuff(uId, (GetSpellInfo(103434)))
	end
end

function mod:updateRangeFrame()
	if not self:IsDifficulty("heroic10", "heroic25") then return end--Not needed on normal or LFR
	if self.Options.NoFilterRangeFrame or UnitDebuff("player", GetSpellInfo(103434)) then
		DBM.RangeCheck:Show(10, nil)--Show everyone.
	else
		DBM.RangeCheck:Show(10, shadowsDebuffFilter)--Show only people who have debuff.
	end
end

local function blackBloodEnds()
	timerShadowsCD:Start(6)
	if mod:IsDifficulty("lfr25") then
		timerphasetwobegin:Start()
	end
	if GetTime() - lastvoid > 90 then
		timerVoidofUnmakingCD:Start(6)
	end
end

function mod:OnCombatStart(delay)
	shadowIcon = 8
	firstPsychicDrain = true
	lastvoid = 0
	table.wipe(shadowsTargets)
	timerVoidofUnmakingCD:Start(6-delay)
	timerPsychicDrainCD:Start(16-delay)
	timerShadowsCD:Start(-delay)
	self:updateRangeFrame()
	if not self:IsDifficulty("lfr25") then--Can confirm what others saw, LFR definitely doesn't have a 6 min berserk. It's either much longer or not there.
		berserkTimer:Start(-delay)
	else
		timerphasetwobegin:Start()
	end
end

function mod:OnCombatEnd()
	if self.Options.RangeFrame then
		DBM.RangeCheck:Hide()
	end
end

function mod:SPELL_CAST_SUCCESS(args)
--	if args:IsSpellID(104378, 110322) then--104378 confirmed 10 man normal, 110322 confirmed 25 man normal
--		timerPsychicDrainCD:Cancel()
--		timerShadowsCD:Cancel()
--		if self:IsDifficulty("lfr25") then
--			timerphasetwobegin:Cancel()
--		end
--		specWarnBlackBlood:Show()
--		if self:IsDifficulty("heroic10", "heroic25") then
--			timerBlackBlood:Start(40)
--			self:Schedule(40, blackBloodEnds)--More accurate way then tracking spell aura removed of black blood. Players dying in the phase were falsely triggering the phase ending early.
--		else
--			timerBlackBlood:Start()
--			self:Schedule(30, blackBloodEnds)--More accurate way then tracking spell aura removed of black blood. Players dying in the phase were falsely triggering the phase ending early.			
--		end
	if args:IsSpellID(104322, 104606, 104607, 104608) then--104378 confirmed 10 man normal
		warnPsychicDrain:Show()
		specWarnPsychicDrain:Show()
		timerPsychicDrainCD:Start()
	end
end	

function mod:SPELL_AURA_APPLIED(args)
	if args:IsSpellID(104543, 109409, 109410, 109411) then--104543 confirmed 10 man normal
		warnFocusedAnger:Show(args.destName, args.amount or 1)
	elseif args:IsSpellID(106836) then--106836 confirmed 10/25 man normal, do NOT add 103527 to this, that's a seperate spellid for when BOSS is affected by diffusion, this warning is counting the ball stacks.
		warnVoidDiffusion:Show(args.destName, args.amount or 1)
	elseif args:IsSpellID(103434, 104599, 104600, 104601) then--103434 confirmed 10 man normal.
		shadowsTargets[#shadowsTargets + 1] = args.destName
		if self.Options.DisruptingShadowsIcons then
			self:SetIcon(args.destName, shadowIcon)
			shadowIcon = shadowIcon - 1
		end
		if args:IsPlayer() and self:IsDifficulty("heroic10", "heroic25") then
			specWarnShadows:Show()
			sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\runout.mp3")
			self:updateRangeFrame()
		end
		self:Unschedule(warnShadowsTargets)
		if (self:IsDifficulty("normal10", "heroic10") and #shadowsTargets >= 3) then--Don't know the rest yet, will tweak as they are discovered
			warnShadowsTargets()
		else
			self:Schedule(0.3, warnShadowsTargets)
		end
	end
end		
mod.SPELL_AURA_APPLIED_DOSE = mod.SPELL_AURA_APPLIED

function mod:SPELL_AURA_REMOVED(args)
	if args:IsSpellID(103434, 104599, 104600, 104601) then
		if self.Options.DisruptingShadowsIcons then
			self:SetIcon(args.destName, 0)
		end
		self:updateRangeFrame()
	end
end	

function mod:UNIT_SPELLCAST_SUCCEEDED(uId, spellName, _, _, spellID)
	if uId ~= "boss1" then return end--Anti spam to ignore all other args (like target/focus/mouseover)
	--Void of the unmaking cast, do not use spellname because we want to ignore events using spellid 103627 which fires when the sphere dispurses on the boss.
	if spellID == 103571 and not self:IsDifficulty("lfr25") then--This spellid is same in 10/25 and raid finder, and assuming also same in heroic. No reason to use spellname, or other IDs.
		warnVoidofUnmaking:Show()
		specWarnVoidofUnmaking:Show()
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\"..GetLocale().."\\ballappear.mp3")
		timerVoidofUnmakingCD:Start()
		if not firstPsychicDrain then
			timerPsychicDrainCD:Start(8)
		end
		firstPsychicDrain = false
		lastvoid = GetTime()
	elseif spellID == 109413 then
		timerPsychicDrainCD:Cancel()
		timerShadowsCD:Cancel()
		if self:IsDifficulty("lfr25") then
			timerphasetwobegin:Cancel()
		end
		specWarnBlackBlood:Show()
		if self:IsDifficulty("heroic10", "heroic25") then
			timerBlackBlood:Start(41)
			self:Schedule(41, blackBloodEnds)--More accurate way then tracking spell aura removed of black blood. Players dying in the phase were falsely triggering the phase ending early.
		else
			timerBlackBlood:Start(31)
			self:Schedule(31, blackBloodEnds)--More accurate way then tracking spell aura removed of black blood. Players dying in the phase were falsely triggering the phase ending early.			
		end		
	end
end

function mod:CHAT_MSG_MONSTER_YELL(msg)
	if (msg == L.voidYell or msg:find(L.voidYell)) and self:IsDifficulty("lfr25") then
		warnVoidofUnmaking:Show()
		specWarnVoidofUnmaking:Show()
		sndWOP:Play("Interface\\AddOns\\DBM-Core\\extrasounds\\"..GetLocale().."\\ballappear.mp3")
		timerVoidofUnmakingCD:Start()
		if not firstPsychicDrain then
			timerPsychicDrainCD:Start(8)
		end
		firstPsychicDrain = false
		lastvoid = GetTime()
	end
end