local E, L, DF = unpack(select(2, ...)); --Engine

DF["clickset"] = {
	["type1"] = "NONE",
	["shiftztype1"]	= "NONE",
	["ctrlztype1"]	= "NONE",
	["altztype1"]	= "NONE",
	["altzctrlztype1"]	= "NONE",
	["type2"]		= "NONE",
	["shiftztype2"]	= "NONE",
	["ctrlztype2"]	= "NONE",
	["altztype2"]	= "NONE",
	["altzctrlztype2"]	= "NONE",
	["type3"]		= "NONE",
	["shiftztype3"]	= "NONE",
	["ctrlztype3"]	= "NONE",
	["altztype3"]	= "NONE",
	["altzctrlztype3"]	= "NONE",	
	["shiftztype4"]	= "NONE",
	["ctrlztype4"]	= "NONE",
	["altztype4"]	= "NONE",
	["altzctrlztype4"]	= "NONE",
	["type4"] = "NONE",
	["shiftztype5"]	= "NONE",
	["ctrlztype5"]	= "NONE",
	["altztype5"]	= "NONE",
	["altzctrlztype5"]	= "NONE",
	["type5"] = "NONE",
	["enable"] = true,
	["clicksetlist"] = {},
	["defaultlistloaded"] = false,
}

DF["euiscript"] = {
	["bossnotes"] = true,
	["castby"] = true,
	["chatmod"] = true,
	["drag"] = true,
	["ilevel"] = true,
	["openall"] = true,
	["recipients"] = true,
	["sr"] = true,
	["statreport"] = true,
	["talent"] = true,
	["tradetabs"] = true,
	["dispel"] = false,
	["raidcheck"] = true,
	["hovertip"] = true,
	["idq"] = false,
	["raidcd"] = true,
		["raidcd_width"] = 208,
		["raidcd_height"] = 20,
		["raidcd_maxbars"] = 10,
		["raidcd_direction"] = "down",
	["classcd"] = true,
		["classcd_width"] = 130,
		["classcd_height"] = 20,
		["classcd_maxbars"] = 5,
		["classcd_direction"] = "up",
	["wildmushroom"] = true,
		["wildmushroom_width"] = 208,
		["wildmushroom_height"] = 20,
		["wildmushroom_direction"] = "down",
	["mapfull"] = true,
	["chatbar"] = true,
	["mapmove"] = true,
	["combatnoti"] = true,
		["combatnoti_leaving"] = "LEAVING COMBAT",
		["combatnoti_entering"] = "ENTERING COMBAT",
	["wgtimenoti"] = true,
	["chatemote"] = true,
	["autogreed"] = false,
	["buffreminder"] = true,
	["autoacceptinv"] = true,
	["autoinvenable"] = true,
	["ainvkeyword"] = "eui",
	["errorenable"] = true,
}

DF["chatfilter"] = {
	["Enabled"] = true,
	["ScanOurself"] = false, --Scan ourself. // 是否扫描自己的聊天信息
	["ScanFriend"] = false, --Scan friends. // 是否扫描好友的聊天信息
	["ScanTeam"] = false, --Scan raid/party members. // 是否扫描队友的聊天信息
	["ScanGuild"] = false, --Scan guildies. // 是否扫描公会成员的聊天信息
		
	["noprofanityFilter"] = false, --Disable the profanityFilter. // 关闭语言过滤器
	["nojoinleaveChannel"] = false, --Disable the alert joinleaveChannel. // 关闭进出频道提示
		
	["MergeTalentSpec"] = true, --Merge the messages:"You have learned/unlearned..." // 当切换天赋后合并显示“你学会了/忘却了法术…”
	["FilterPetTalentSpec"] = false, --Filter the messages:"Your pet has learned/unlearned..." // 不显示“你的宠物学会了/忘却了…”
		
	["MergeAchievement"] = true, --Merge the messages:"...has earned the achievement..." // 合并显示获得成就
	["MergeManufacturing"] = true, --Merge the messages:"You has created..." // 合并显示“你制造了…”
		
	["FilterAuctionMSG"] = false, --Filter the messages:"Auction created/cancelled."// 过滤“已开始拍卖/拍卖取消.”
	["FilterDuelMSG"] = false, --Filter the messages:"... has defeated/fled from ... in a duel." // 过滤“...在决斗中战胜了...”
		
	["FilterAdvertising"] = true, --Filter the advertising messages. // 过滤广告信息
	["AllowMatchs"] = 2, --How many words can be allowd to use. // 允许的关键字配对个数
		
	["FilterMultiLine"] = true, --Filter the multiple messages. // 过滤多行信息
	["AllowLines"] = 3, --How many lines can be allowd. // 允许的最大行数
	
	["FilterRepeat"] = true, --Filter the repeat messages. // 过滤重复聊天信息
	["RepeatAlike"] = 60, --Set the similarity between the messages. // 设定重复信息相似度
	["RepeatInterval"] = 60, --Set the interval between the messages. // 设定重复信息间隔时间
	["RepeatMaxCache"] = 200, --Set the max cache from the messages. // 设定最多缓存多少条消息
}

if(GetLocale()=="zhCN") then
	DF["euiscript"].combatnoti_entering = "进入战斗状态"
	DF["euiscript"].combatnoti_leaving = "离开战斗状态"
elseif (GetLocale()=="zhTW") then
	DF["euiscript"].combatnoti_entering = "進入戰鬥狀態"
	DF["euiscript"].combatnoti_leaving = "離開戰鬥狀態"
elseif (GetLocale()=="enUS") then
	DF["euiscript"].combatnoti_entering = "ENTERING COMBAT"
	DF["euiscript"].combatnoti_leaving = "LEAVING COMBAT"
end

DF["filter"] = {
	["enable"] = false,
	["classcolor"] = true,
	["barheight"] = 16,
	["pbarwidth"] = 260,
	["tbarwidth"] = 200,	
	["cdsize"] = 30,
	["piconsize"] = 30,
	["ticonsize"] = 36,
	["ficonsize"] = 24,
	["pbarwidth"] = 260,
	["tbarwidth"] = 200,
	
	["pbuffbar"] = true,
		["pbuffbardirection"] = "UP",
		["pbuffbarinterval"] = 5,
	["pbufficon"] = true,
		["pbufficondirection"] = "RIGHT",
		["pbufficoninterval"] = 3,
	["pdebufficon"] = true,
		["pdebufficondirection"] = "RIGHT",
		["pdebufficoninterval"] = 3,
	["pcdicon"] = true,
		["pcdicondirection"] = "RIGHT",
		["pcdiconinterval"] = 3,
	["tbufficon"] = true,
		["tbufficondirection"] = "LEFT",
		["tbufficoninterval"] = 3,
	["tdebufficon"] = true,
		["tdebufficondirection"] = "LEFT",
		["tdebufficoninterval"] = 2,
	["tdebuffbar"] = true,
		["tdebuffbardirection"] = "UP",
		["tdebuffbarinterval"] = 5,
	["fbufficon"] = true,
		["fbufficondirection"] = "RIGHT",
		["fbufficoninterval"] = 3,
	["fdebufficon"] = true,
		["fdebufficondirection"] = "RIGHT",
		["fdebufficoninterval"] = 3,
	
	["pbuffbarlist"] = {},
	["pbufficonlist"] = {},
	["pdebufficonlist"] = {},
	["pcdiconlist"] = {},

	["tbufficonlist"] = {},
	["tdebufficonlist"] = {},
	["tdebuffbarlist"] = {},

	["fbufficonlist"] = {},
	["fdebufficonlist"] = {},
	["defaultlistloaded"] = false,
}

if GetLocale()=="zhCN" then
	DF["core"].font = "默认"
	DF["core"].dmgfont = "伤害数字"
elseif GetLocale() == "zhTW" then
	DF["core"].font = "預設"
	DF["core"].dmgfont = "傷害數字"
end	

DF["actionbar"].euiabstyle = "None"

DF["core"].panelWidth = 360

DF["skins"].minimapbuttons = {
	['enable'] = true,
}
DF["skins"].atlasloot = {
	['enable'] = true,
}
DF["skins"].auctionator ={
	['enable'] = true,
}
DF["skins"].easymail = {
	['enable'] = true,
}

DF['chat'].embedright = "None"
DF['chat'].embedcombat = false
DF['chat'].leftpanelWidth = 360
DF['chat'].leftpanelHeight = 180
DF['chat'].rightpanelWidth = 360
DF['chat'].rightpanelHeight = 180


DF["unitframe"].healcomm = true
DF["unitframe"].number = "K"

DF["unitframe"].mainSpec = 'Primary'
DF["unitframe"].offSpec = 'Primary'
DF["unitframe"].layouts.Secondary.positions = nil;

DF["unitframe"].layouts.Primary.player.portrait.enable = true
DF["unitframe"].layouts.Primary.player.portrait.overlay = true
DF["unitframe"].layouts.Primary.player.power.width = 'fill'
DF["unitframe"].layouts.Primary.target.power.width = 'fill'
DF["unitframe"].layouts.Primary.targettarget.power.width = 'fill'
DF["unitframe"].layouts.Primary.player.castbar.color = { r = .78,g = .67,b = .35 }
DF["unitframe"].layouts.Primary.target.castbar.color = { r = .78,g = .67,b = .35 }
DF["unitframe"].layouts.Primary.target.portrait.enable = true
DF["unitframe"].layouts.Primary.target.portrait.overlay = true
DF["unitframe"].layouts.Primary.raid625.width = 70
DF["unitframe"].layouts.Primary.raid625.height = 44
DF["unitframe"].layouts.Primary.raid625.power.width = 'fill'
DF["unitframe"].layouts.Primary.raid625.showParty = false
DF["unitframe"].layouts.Primary.raid2640.width = 70
DF["unitframe"].layouts.Primary.raid2640.height = 44
DF["unitframe"].layouts.Primary.raid2640.power.width = 'fill'

DF["unitframe"].layouts.Secondary.player.portrait.enable = true
DF["unitframe"].layouts.Secondary.player.portrait.overlay = true
DF["unitframe"].layouts.Secondary.player.power.width = 'spaced'
DF["unitframe"].layouts.Secondary.target.power.width = 'spaced'
DF["unitframe"].layouts.Secondary.targettarget.power.width = 'spaced'
DF["unitframe"].layouts.Secondary.player.castbar.color = { r = .78,g = .67,b = .35 }
DF["unitframe"].layouts.Secondary.target.castbar.color = { r = .78,g = .67,b = .35 }
DF["unitframe"].layouts.Secondary.target.portrait.enable = true
DF["unitframe"].layouts.Secondary.target.portrait.overlay = true
DF["unitframe"].layouts.Secondary.raid625.width = 70
DF["unitframe"].layouts.Secondary.raid625.height = 44
DF["unitframe"].layouts.Secondary.raid625.power.width = 'spaced'
DF["unitframe"].layouts.Secondary.raid625.showParty = false
DF["unitframe"].layouts.Secondary.raid2640.width = 70
DF["unitframe"].layouts.Secondary.raid2640.height = 44
DF["unitframe"].layouts.Secondary.raid2640.power.width = 'spaced'


E.ClickSets_Sets = {
	PRIEST = { --牧师
			["shift-type1"]	= 139,--"恢復",
			["ctrl-type1"]	= 527,--"驅散魔法",
			["alt-type1"]	= 2061,--"快速治療",
			["alt-ctrl-type1"]	= 2006,--"復活術",
			["type2"]		= 17,--"真言術:盾",
			["shift-type2"]	= 33076,--"癒合禱言",
			["ctrl-type2"]	= 528,--"驅除疾病", 
			["alt-type2"]	= 2060,--"強效治療術",
			["alt-ctrl-type2"]	= 32546,--"束縛治療",
			["type3"]		= 34861,--"治療之環",
			["shift-type3"] = 2050, --治疗术
			["alt-type3"] = 1706, --漂浮术
			["ctrl-type3"] = 21562,--耐
			["type4"] = 596, --治疗祷言
			["shift-type4"] = 47758, -- 苦修
			["ctrl-type4"] = 73325, -- 信仰飞跃	
			["type5"] = 48153, -- 守护之魂
			["shift-type5"] = 88625, -- 圣言术
			["ctrl-type5"] = 33206,--痛苦压制
	},
	
	DRUID = { --XD
			["shift-type1"]	= 774,--"回春術",
			["ctrl-type1"]	= 2782,--"净化腐蚀",
			["alt-type1"]	= 8936,--"癒合",
			["alt-ctrl-type1"]	= 50769,--"復活",
			["type2"]		= 48438,--"野性成长",
			["shift-type2"]	= 18562,--"迅捷治愈",
			["ctrl-type2"]	= 88423, -- 自然治愈
			["alt-type2"]	= 50464,--"滋補術",
			["alt-ctrl-type2"] = 1126, -- 野性印记
			["type3"]		= 33763,--"生命之花",
			["shift-type3"] = 5185,--治疗之触
			["ctrl-type3"] = 20484,--复生
			["alt-type3"] = 29166, --激活
	},
	SHAMAN = { --SM
			["alt-type1"]	= 8004,		--"治疗之拥",
			["shift-type1"]	= 974,		--"大地之盾",
			["ctrl-type1"]	= 1064,		--"治疗链",
			["alt-ctrl-type1"]	= 2008,	--"先祖之魂",
			["type2"]		= 61295,	--"激流",
			["alt-type2"]	= 331,		--"治疗波",
			["shift-type2"]	= 77472,	--"强效治疗波",
			["ctrl-type2"]	= 51886,	--"净化灵魂",
			["type3"]		= 1064,		--"治疗链",
			["shift-type3"] = 546, --水上漂
			["alt-type3"] = 131, --水下游
	},

	PALADIN = { --QS
			["shift-type1"]	= 635,--"聖光術",
			["alt-type1"]	= 19750,--"聖光閃現",
			["ctrl-type1"]	= 53563,--"圣光信标",
			["alt-ctrl-type1"]	= 7328,--"救贖",
		["type2"]		= 20473,--"神聖震擊",
			["shift-type2"]	= 82326,--"Divine Light",
			["ctrl-type2"]	= 4987,--"淨化術",
			["alt-type2"]	= 85673,--"Word of Glory",
			["alt-ctrl-type2"]	= 633,--"聖療術",
		["type3"]		= 31789,--正義防護
			["alt-type3"]	= 20217,--王者
			["shift-type3"]	= 20911,--庇護
			["ctrl-type3"]	= 19740,--力量
			["alt-ctrl-type3"] = 31789, -- 正义防御
		["type4"] = 1022, --保护之手
			["alt-type4"] = 1044, -- 自由之手
			["shift-type4"] = 1038, -- 拯救之手
			["ctrl-type4"] = 6940, -- 牺牲之手
	},

	WARRIOR = { --ZS
			["ctrl-type1"]	= 50720,--"戒備守護",
			["type2"]		= 3411,--"阻擾",
	},

	MAGE = { --FS
			["alt-type1"]	= 1459,--"秘法智力",
			["ctrl-type1"]	= 54646,--"专注",
			["type2"]		= 475,--"解除詛咒",
			["shift-type2"]	= 130,--"缓落",
	},

	WARLOCK = { --SS
			["alt-type1"]	= 80398,--"黑暗意图",
			["type2"]		= 5697,--"魔息",
	},

	HUNTER = { --LR
			["type2"]		= 34477,--"誤導",
			["shift-type2"] = 136, --治疗宠物
	},
	
	ROGUE = { --DZ
			["type2"]		= 57933,--"偷天換日",
	},
	
	DEATHKNIGHT = {
			["shift-type1"] = 61999, --战复
			["type2"] = 47541, --死缠
			["type3"] = 49016, -- 邪恶狂乱（邪恶天赋)
	},
}

local class = select(2, UnitClass("player"))

for k, v in pairs(E.ClickSets_Sets[class]) do
	if GetSpellInfo(v) then DF["clickset"][string.gsub(k,"-","z")] = GetSpellInfo(v) end
end

E.build = GetAddOnMetadata("EuiScript", "Version")