--[[
	Project.: oUF_ClickSet
	File....: oUF_ClickSet.lua
	Version.: 40300
	Rev Date: 2011/11/14
	Authors.: Ljxx.net
]] 

--[[
	Code Example:
	 .ClickSet = SpellList
	
	SpellList Example:
		SpellList = {
			["altztype1"]	= 1459,
			["ctrlztype1"]	= 54646,
			["type2"]		= 475,
			["shiftztype2"]	= 130,
			["type3"] = "#*/cast spellname", --macro must begin with '#*'
		}
		-- string.gsub(key, 'z', '-')
	SpellList["type2"] = "NONE"  -- will not apple attribute
]]

local _, ns = ...
local oUF = ns.oUF or oUF
if not oUF then return end
 
local function Update(object, event, unit)
	if object.unit ~= unit or InCombatLockdown() then return end
	local key_tmp
	for key, value in pairs(object.ClickSet) do
		key_tmp = string.gsub(key,"z","-")
		if value ~= "NONE" and key ~= "enable" and type(value) == "string" then
			if string.sub(value, 1, 2) ~= "#*" then
				object:SetAttribute(key_tmp, 'spell')
				object:SetAttribute(string.gsub(key_tmp,"type",'spell'), value)
			else
				object:SetAttribute(key_tmp, 'macro')
				object:SetAttribute('macrotext', string.sub(value, 3))
			end
		elseif value == "NONE" then
			object:SetAttribute(key_tmp, nil)
		end
	end
	key_tmp = nil
end
 
local function Enable(object)
	if object.ClickSet == nil then return end
	if type(object.ClickSet) ~= 'table' then
		print('object.ClickSetList is nil or not is a table')
		return
	end
	-- make sure aura scanning is active for this object
	object:RegisterEvent("PLAYER_REGEN_ENABLED", Update)
	
	if not InCombatLockdown() then
		local key_tmp
		for key, value in pairs(object.ClickSet) do
			key_tmp = string.gsub(key,"z","-")
			if value ~= "NONE" and key ~= "enable" and type(value) == "string" then
				if string.sub(value, 1, 2) ~= "#*" then
					object:SetAttribute(key_tmp, 'spell')
					object:SetAttribute(string.gsub(key_tmp,"type",'spell'), value)
				else
					object:SetAttribute(key_tmp, 'macro')
					object:SetAttribute('macrotext', string.sub(value, 3))
				end
			end
		end
		key_tmp = nil
	end
	
	return true
end
 
local function Disable(object)
	if object.ClickSet then
		object:UnregisterEvent("PLAYER_REGEN_ENABLED", Update)
	end
end
 
oUF:AddElement('ClickSet', Update, Enable, Disable)
 
for i, frame in ipairs(oUF.objects) do Enable(frame) end