local E, L, DF = unpack(select(2, ...)); --Engine
local AS = E:NewModule('AddonSkins', 'AceTimer-3.0', 'AceHook-3.0', 'AceEvent-3.0')

AS.addonsToLoad = {}

function AS:ADDON_LOADED(event, addon)
	if not AS.addonsToLoad[addon] then return end
	for addonName, loadFunc in pairs(self.addonsToLoad) do
		if IsAddOnLoaded(addonName) then
			loadFunc();
			self.addonsToLoad[addonName] = nil;
		end
	end
end

function AS:RegisterAddonSkin(name, loadFunc, loadNow)
	if loadNow or IsAddOnLoaded(name) then
		loadFunc()
		self.addonsToLoad[name] = nil;		
	else
		self.addonsToLoad[name] = loadFunc;
	end
end

function AS:Initialize()
	for addon, loadFunc in pairs(self.addonsToLoad) do
		if IsAddOnLoaded(addon) then
			loadFunc();
			self.addonsToLoad[addon] = nil;
		end
	end
end
AS:RegisterEvent('ADDON_LOADED')

E:RegisterModule(AS:GetName())