local E, L, DF = unpack(select(2, ...)); --Engine
local AS = E:GetModule('AddonSkins')

E.Options.args.addonskins = {
	type = "group",
	name = L["Addon Skins"],
	childGroups = "select",
	args = {
		intro = {
			order = 1,
			type = "description",
			name = L["ADDONSKINS_DESC"],
		},	
		bigwigs = {
			order = 2,
			type = 'group',
			name = 'BigWigs',
			get = function(info) return E.db.addonskins.bigwigs[ info[#info] ] end,
			set = function(info, value) E.db.addonskins.bigwigs[ info[#info] ] = value; end,
			args = {
				enable = {
					name = L['Enable'],
					type = 'toggle',
					order = 1,
					get = function(info) return E.db.addonskins.bigwigs[ info[#info] ] end,
					set = function(info, value) E.db.addonskins.bigwigs[ info[#info] ] = value; StaticPopup_Show("CONFIG_RL") end,					
				},
				spacing = {
					name = L['Spacing'],
					desc = L['The spacing in between bars.'],
					type = 'range',
					order = 2,
					min = 0, max = 25, step = 1,
				},
			},
		},
	},
}